/*
 * Decompiled with CFR 0.152.
 */
package net.mackenziemolloy.shopguiplus.sellgui.utility.sirblobman;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class HexColorUtility {
    private static final Map<Character, Pattern> KNOWN_PATTERN_MAP = new ConcurrentHashMap<Character, Pattern>();

    @NotNull
    public static String replaceHexColors(char colorChar, @NotNull String string) {
        Pattern pattern = HexColorUtility.getReplaceAllRgbPattern(colorChar);
        Matcher matcher = pattern.matcher(string);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            if (matcher.group(1) != null) {
                matcher.appendReplacement(buffer, colorChar + "#$2");
                continue;
            }
            try {
                String hexCodeString = matcher.group(2);
                String hexCode = HexColorUtility.parseHexColor(hexCodeString);
                matcher.appendReplacement(buffer, hexCode);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private static Pattern getReplaceAllRgbPattern(char colorChar) {
        if (KNOWN_PATTERN_MAP.containsKey(Character.valueOf(colorChar))) {
            return KNOWN_PATTERN_MAP.get(Character.valueOf(colorChar));
        }
        String colorCharString = Character.toString(colorChar);
        String colorCharPattern = Pattern.quote(colorCharString);
        String patternString = "(" + colorCharPattern + ")?" + colorCharPattern + "#([0-9a-fA-F]{6})";
        Pattern pattern = Pattern.compile(patternString);
        KNOWN_PATTERN_MAP.put(Character.valueOf(colorChar), pattern);
        return pattern;
    }

    @NotNull
    private static String parseHexColor(@NotNull String string) throws NumberFormatException {
        char[] charArray;
        if (string.startsWith("#")) {
            string = string.substring(1);
        }
        if (string.length() != 6) {
            throw new NumberFormatException("Invalid hex length!");
        }
        int colorInt = Integer.decode("#" + string);
        if (colorInt < 0 || colorInt > 0xFFFFFF) {
            throw new NumberFormatException("Invalid hex color value!");
        }
        StringBuilder assembled = new StringBuilder();
        assembled.append('\u00a7');
        assembled.append("x");
        for (char character : charArray = string.toCharArray()) {
            assembled.append('\u00a7');
            assembled.append(character);
        }
        return assembled.toString();
    }

    public static String purgeAllColor(String input) {
        String noMinecraftColorCodes = input.replaceAll("[&\u00c2\u00a7][0-9a-fA-FkKlLnNoOrR]", "");
        String noHexColorCodes = noMinecraftColorCodes.replaceAll("[&\u00c2\u00a7]#([0-9a-fA-F]){6}", "");
        return noHexColorCodes;
    }
}

