/*
 * Decompiled with CFR 0.152.
 */
package net.mackenziemolloy.shopguiplus.sellgui.utility;

import java.text.DecimalFormat;
import java.util.Locale;
import net.brcdev.shopgui.ShopGuiPlusApi;
import net.brcdev.shopgui.economy.EconomyManager;
import net.brcdev.shopgui.economy.EconomyType;
import net.brcdev.shopgui.provider.economy.EconomyProvider;
import net.mackenziemolloy.shopguiplus.sellgui.SellGUI;
import net.mackenziemolloy.shopguiplus.sellgui.utility.CommentedConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class ShopHandler {
    @NotNull
    public static EconomyType getEconomyType(ItemStack material) {
        EconomyType economyType = ShopGuiPlusApi.getItemStackShop((ItemStack)material).getEconomyType();
        if (economyType != null) {
            return economyType;
        }
        EconomyManager economyManager = ShopGuiPlusApi.getPlugin().getEconomyManager();
        EconomyProvider defaultEconomyProvider = economyManager.getDefaultEconomyProvider();
        if (defaultEconomyProvider != null) {
            String defaultEconomyTypeName = defaultEconomyProvider.getName().toUpperCase(Locale.US);
            try {
                return EconomyType.valueOf((String)defaultEconomyTypeName);
            }
            catch (IllegalArgumentException ex) {
                return EconomyType.CUSTOM;
            }
        }
        return EconomyType.CUSTOM;
    }

    public static Double getItemSellPrice(ItemStack material, Player player) {
        return ShopGuiPlusApi.getItemStackPriceSell((Player)player, (ItemStack)material);
    }

    public static String getFormattedPrice(Double priceToFormat, EconomyType economyType) {
        SellGUI plugin = (SellGUI)JavaPlugin.getPlugin(SellGUI.class);
        CommentedConfiguration configuration = plugin.getConfiguration();
        String priceToReturn = priceToFormat.toString();
        if (configuration.getBoolean("options.rounded_pricing")) {
            DecimalFormat formatToApplyRaw = new DecimalFormat("0.00");
            priceToReturn = formatToApplyRaw.format(priceToFormat);
        }
        if (configuration.getBoolean("options.remove_trailing_zeros") && Double.valueOf(priceToReturn.split("\\.")[1]) == 0.0) {
            priceToReturn = priceToReturn.split("\\.")[0];
        }
        return priceToReturn;
    }

    public static String getFormattedNumber(Double numberToFormat) {
        SellGUI plugin = (SellGUI)JavaPlugin.getPlugin(SellGUI.class);
        CommentedConfiguration configuration = plugin.getConfiguration();
        String numberToReturn = numberToFormat.toString();
        if (configuration.getBoolean("options.rounded_pricing")) {
            DecimalFormat formatToApply = new DecimalFormat("#,##0.00");
            numberToReturn = formatToApply.format(numberToFormat);
        }
        if (configuration.getBoolean("options.remove_trailing_zeros") && numberToReturn.split("\\.")[1] != null && Double.valueOf(numberToReturn.split("\\.")[1]) == 0.0) {
            numberToReturn = numberToReturn.split("\\.")[0];
        }
        return numberToReturn;
    }
}

