/*
 * Decompiled with CFR 0.152.
 */
package net.mackenziemolloy.shopguiplus.sellgui.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.brcdev.shopgui.ShopGuiPlugin;
import net.brcdev.shopgui.ShopGuiPlusApi;
import net.brcdev.shopgui.economy.EconomyType;
import net.brcdev.shopgui.event.ShopPostTransactionEvent;
import net.brcdev.shopgui.provider.economy.EconomyProvider;
import net.brcdev.shopgui.shop.ShopManager;
import net.brcdev.shopgui.shop.ShopTransactionResult;
import net.brcdev.shopgui.shop.item.ShopItem;
import net.mackenziemolloy.shopguiplus.sellgui.SellGUI;
import net.mackenziemolloy.shopguiplus.sellgui.guis.Gui;
import net.mackenziemolloy.shopguiplus.sellgui.guis.GuiItem;
import net.mackenziemolloy.shopguiplus.sellgui.objects.ShopItemPriceValue;
import net.mackenziemolloy.shopguiplus.sellgui.utility.CommentedConfiguration;
import net.mackenziemolloy.shopguiplus.sellgui.utility.Hastebin;
import net.mackenziemolloy.shopguiplus.sellgui.utility.PlayerHandler;
import net.mackenziemolloy.shopguiplus.sellgui.utility.ShopHandler;
import net.mackenziemolloy.shopguiplus.sellgui.utility.sirblobman.HexColorUtility;
import net.mackenziemolloy.shopguiplus.sellgui.utility.sirblobman.MessageUtility;
import net.mackenziemolloy.shopguiplus.sellgui.utility.sirblobman.VersionUtility;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.apache.commons.lang3.text.WordUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.Nullable;

public final class CommandSellGUI
implements TabExecutor {
    private final SellGUI plugin;

    public CommandSellGUI(SellGUI plugin) {
        this.plugin = Objects.requireNonNull(plugin, "plugin must not be null!");
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 1) {
            List<String> valueSet = Arrays.asList("rl", "reload", "debug", "dump");
            return (List)StringUtil.copyPartialMatches((String)args[0], valueSet, new ArrayList());
        }
        return Collections.emptyList();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String sub;
        if (!this.plugin.compatible) {
            String message = MessageUtility.color("&7\n&7\n&a&lUPDATE REQUIRED \n&7\n&7Unfortunately &fSellGUI &7will not work until you update &cShopGUIPlus&7 to version &c1.78.0&7 or above.\n&7\n&eDownload: https://spigotmc.org/resources/6515/\n&7\n&7");
            sender.sendMessage(message);
            return false;
        }
        if (args.length == 0) {
            return this.commandBase(sender);
        }
        switch (sub = args[0].toLowerCase(Locale.US)) {
            case "rl": 
            case "reload": {
                return this.commandReload(sender);
            }
            case "debug": 
            case "dump": {
                return this.commandDebug(sender);
            }
        }
        return false;
    }

    public void register() {
        PluginCommand pluginCommand = this.plugin.getCommand("sellgui");
        if (pluginCommand != null) {
            pluginCommand.setExecutor((CommandExecutor)this);
            pluginCommand.setTabCompleter((TabCompleter)this);
        }
    }

    private boolean commandReload(CommandSender sender) {
        if (!sender.hasPermission("sellgui.reload")) {
            this.sendMessage(sender, "no_permission");
            return true;
        }
        CompletableFuture.runAsync(this.plugin::generateFiles).whenComplete((success, error) -> {
            if (error != null) {
                sender.sendMessage(ChatColor.RED + "An error occurred, please check the server console.");
                error.printStackTrace();
                return;
            }
            this.sendMessage(sender, "reloaded_config");
            if (sender instanceof Player) {
                Player player = (Player)sender;
                PlayerHandler.playSound(player, "success");
            }
        });
        return true;
    }

    private boolean commandDebug(CommandSender sender) {
        if (sender instanceof Player && ((Player)sender).getUniqueId().toString().equals("6b23291c-495b-478d-9055-d0d151206bff")) {
            String pluginVersion = this.plugin.getDescription().getVersion();
            sender.sendMessage(String.format(Locale.US, "This server is running SellGUI made by Mackenzie Molloy#1821 v%s", pluginVersion));
        }
        if (!sender.hasPermission("sellgui.dump")) {
            this.sendMessage(sender, "no_permission");
            return true;
        }
        CommentedConfiguration configuration = this.plugin.getConfiguration();
        PluginManager pluginManager = Bukkit.getPluginManager();
        Plugin[] pluginArray = pluginManager.getPlugins();
        ArrayList<String> pluginInfoList = new ArrayList<String>();
        for (Plugin plugin : pluginArray) {
            String pluginName = plugin.getName();
            String pluginVersion = plugin.getDescription().getVersion();
            String pluginAuthorList = String.join((CharSequence)", ", plugin.getDescription().getAuthors());
            String pluginInfo = String.format(Locale.US, "- %s v%s by %s", pluginName, pluginVersion, pluginAuthorList);
            pluginInfoList.add(pluginInfo);
        }
        String pasteRaw = "| System Information\n\n- OS Type: " + System.getProperty("os.name") + "\n- OS Version: " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")\n- Processor: " + System.getenv("PROCESSOR_IDENTIFIER") + "\n\n| Server Information\n\n- Version: " + Bukkit.getBukkitVersion() + "\n- Online Mode: " + Bukkit.getOnlineMode() + "\n- Memory Usage: " + this.getMemoryUsage() + "\n\n| Plugins\n" + String.join((CharSequence)"\n", pluginInfoList) + "\n\n| Plugin Configuration\n\n" + configuration.saveToString();
        try {
            String pasteUrl = new Hastebin().post(pasteRaw, true);
            String pastedDumpMsg = ChatColor.translateAlternateColorCodes((char)'&', (String)"&c[ShopGUIPlus-SellGUI] Successfully dumped server information here: %s.");
            String message = String.format(Locale.US, pastedDumpMsg, pasteUrl);
            Bukkit.getConsoleSender().sendMessage(message);
            sender.sendMessage(message);
            if (sender instanceof Player) {
                Player player = (Player)sender;
                PlayerHandler.playSound(player, "success");
            }
        }
        catch (IOException ex) {
            sender.sendMessage(ChatColor.RED + "An error occurred, please check the console:");
            ex.printStackTrace();
        }
        return true;
    }

    private boolean commandBase(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "Only players can execute this command.");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("sellgui.use")) {
            this.sendMessage((CommandSender)player, "no_permission");
            return true;
        }
        if (!this.checkGameMode(player)) {
            return true;
        }
        CommentedConfiguration configuration = this.plugin.getConfiguration();
        int guiSize = configuration.getInt("options.rows");
        if (guiSize > 6 || guiSize < 1) {
            guiSize = 6;
        }
        String sellGuiTitle = this.getMessage("sellgui_title", null);
        Gui gui = new Gui(guiSize, sellGuiTitle, Collections.emptySet());
        PlayerHandler.playSound(player, "open");
        HashSet<Integer> ignoredSlotSet = new HashSet<Integer>();
        this.setDecorationItems((ConfigurationSection)configuration, gui, ignoredSlotSet);
        gui.setCloseGuiAction(event -> {
            BukkitScheduler scheduler = Bukkit.getScheduler();
            scheduler.runTask((Plugin)this.plugin, () -> this.onGuiClose(player, (InventoryCloseEvent)event, (Set<Integer>)ignoredSlotSet));
        });
        gui.open((HumanEntity)player);
        return true;
    }

    private boolean checkGameMode(Player player) {
        GameMode gameMode;
        String gameModeName;
        ShopGuiPlugin shopGui = ShopGuiPlusApi.getPlugin();
        FileConfiguration configuration = shopGui.getConfigMain().getConfig();
        List disabledGameModeList = configuration.getStringList("disableShopsInGamemodes");
        if (disabledGameModeList.contains(gameModeName = (gameMode = player.getGameMode()).name())) {
            String gameModeFormatted = WordUtils.capitalize(gameModeName);
            this.sendMessage((CommandSender)player, "gamemode_not_allowed", message -> message.replace("{gamemode}", gameModeFormatted));
            return false;
        }
        return true;
    }

    private void setDecorationItems(ConfigurationSection configuration, Gui gui, Set<Integer> ignoredSlotSet) {
        ConfigurationSection sectionDecorations = configuration.getConfigurationSection("options.decorations");
        if (sectionDecorations != null) {
            Set sectionDecorationsKeys = sectionDecorations.getKeys(false);
            for (String key : sectionDecorationsKeys) {
                Material material;
                ConfigurationSection section = sectionDecorations.getConfigurationSection(key);
                if (section == null) continue;
                String materialName = section.getString("item.material");
                if (materialName == null || (material = Material.matchMaterial((String)materialName)) == null || !section.isInt("slot") || section.getInt("slot") > gui.getRows() * 9 - 1 || section.getInt("slot") < 0) {
                    Logger logger = this.plugin.getLogger();
                    logger.warning("Failed to load decoration item with id '" + key + "'.");
                    continue;
                }
                ItemStack item = new ItemStack(material);
                int damage = section.getInt("item.damage", 0);
                if (damage != 0) {
                    this.setItemDamage(item, damage);
                }
                int quantity = section.getInt("item.quantity", 1);
                item.setAmount(quantity);
                ItemMeta itemMeta = item.getItemMeta();
                if (itemMeta != null) {
                    int customModelData;
                    List<String> loreList;
                    String displayName = section.getString("item.name");
                    if (displayName != null) {
                        displayName = MessageUtility.color(displayName);
                        itemMeta.setDisplayName(displayName);
                    }
                    if (!(loreList = section.getStringList("item.lore")).isEmpty()) {
                        loreList = MessageUtility.colorList((Iterable<String>)loreList);
                        itemMeta.setLore(loreList);
                    }
                    if ((customModelData = section.getInt("item.customModelData")) != 0) {
                        itemMeta.setCustomModelData(Integer.valueOf(customModelData));
                    }
                    item.setItemMeta(itemMeta);
                }
                List consoleCommandList = section.getStringList("commandsOnClickConsole");
                List playerCommandList = section.getStringList("commandsOnClick");
                GuiItem guiItem = new GuiItem(item, e -> {
                    e.setCancelled(true);
                    HumanEntity human = e.getWhoClicked();
                    String humanName = human.getName();
                    ConsoleCommandSender console = Bukkit.getConsoleSender();
                    for (String consoleCommand : consoleCommandList) {
                        Bukkit.dispatchCommand((CommandSender)console, (String)consoleCommand.replace("%PLAYER%", humanName));
                    }
                    for (String playerCommand : playerCommandList) {
                        Bukkit.dispatchCommand((CommandSender)human, (String)playerCommand.replace("%PLAYER%", humanName));
                    }
                    if (section.getBoolean("item.sellinventory")) {
                        human.closeInventory();
                        this.commandBase((CommandSender)Bukkit.getPlayer((String)humanName));
                    }
                });
                int slot = section.getInt("slot");
                gui.setItem(slot, guiItem);
                ignoredSlotSet.add(slot);
            }
        }
    }

    private String getMessage(String path, @Nullable Function<String, String> replacer) {
        CommentedConfiguration configuration = this.plugin.getConfiguration();
        String message = configuration.getString("messages." + path);
        if (message == null || message.isEmpty()) {
            return "";
        }
        if (replacer != null) {
            message = replacer.apply(message);
        }
        return HexColorUtility.replaceHexColors('&', MessageUtility.color(message));
    }

    private TextComponent getTextComponentMessage(String path, @Nullable Function<String, String> replacer) {
        String message = this.getMessage(path, replacer);
        if (message.isEmpty()) {
            return new TextComponent("");
        }
        return new TextComponent(TextComponent.fromLegacyText((String)message));
    }

    private void sendMessage(CommandSender sender, String path) {
        this.sendMessage(sender, path, null);
    }

    private void sendMessage(CommandSender sender, String path, @Nullable Function<String, String> replacer) {
        String message = this.getMessage(path, replacer);
        if (message.isEmpty()) {
            return;
        }
        if (sender instanceof Player) {
            TextComponent textComponent = new TextComponent(TextComponent.fromLegacyText((String)message));
            ((Player)sender).spigot().sendMessage((BaseComponent)textComponent);
        } else {
            sender.sendMessage(message);
        }
    }

    private String getMemoryUsage() {
        Runtime runtime = Runtime.getRuntime();
        long totalMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        long maxMemory = runtime.maxMemory();
        long usedMemory = totalMemory - freeMemory;
        long usedMemoryMB = usedMemory / 0x100000L;
        long maxMemoryMB = maxMemory / 0x100000L;
        return String.format(Locale.US, "%s / %s MiB", usedMemoryMB, maxMemoryMB);
    }

    private void setItemDamage(ItemStack item, int damage) {
        int minorVersion = VersionUtility.getMinorVersion();
        if (minorVersion < 13) {
            short durability = (short)damage;
            item.setDurability(durability);
            return;
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta instanceof Damageable) {
            ((Damageable)itemMeta).setDamage(damage);
            item.setItemMeta(itemMeta);
        }
    }

    private void onGuiClose(Player player, InventoryCloseEvent event, Set<Integer> ignoredSlotSet) {
        int minorVersion = VersionUtility.getMinorVersion();
        CommentedConfiguration configuration = this.plugin.getConfiguration();
        HashMap<ItemStack, ShopItemPriceValue> itemStackSellPriceCache = new HashMap<ItemStack, ShopItemPriceValue>();
        HashMap<ItemStack, Map> soldMap2 = new HashMap<ItemStack, Map>();
        EnumMap<EconomyType, Double> moneyMap = new EnumMap<EconomyType, Double>(EconomyType.class);
        double totalPrice = 0.0;
        int itemAmount = 0;
        boolean[] excessItems = new boolean[]{false};
        boolean itemsPlacedInGui = false;
        Inventory inventory = event.getInventory();
        for (int a = 0; a < inventory.getSize(); ++a) {
            ItemStack i = inventory.getItem(a);
            if (i == null || ignoredSlotSet.contains(a)) continue;
            ItemStack itemStack = new ItemStack(i);
            itemStack.setAmount(1);
            itemsPlacedInGui = true;
            if (itemStackSellPriceCache.getOrDefault(itemStack, new ShopItemPriceValue(null, 0.0)).getSellPrice() > 0.0 || ShopHandler.getItemSellPrice(i, player) > 0.0) {
                itemAmount += i.getAmount();
                short materialDamage = i.getDurability();
                int amount = i.getAmount();
                double itemSellPrice = itemStackSellPriceCache.containsKey(itemStack) ? ((ShopItemPriceValue)itemStackSellPriceCache.get(itemStack)).getSellPrice() * (double)amount : ShopHandler.getItemSellPrice(i, player);
                totalPrice += itemSellPrice;
                EconomyType itemEconomyType = ShopHandler.getEconomyType(i);
                ItemStack SingleItemStack = new ItemStack(i);
                SingleItemStack.setAmount(1);
                itemStackSellPriceCache.putIfAbsent(SingleItemStack, new ShopItemPriceValue(itemEconomyType, itemSellPrice / (double)amount));
                Map totalSold = soldMap2.getOrDefault(SingleItemStack, new HashMap());
                int totalSoldCount = totalSold.getOrDefault(materialDamage, 0);
                int amountSold = totalSoldCount + amount;
                totalSold.put(materialDamage, amountSold);
                soldMap2.put(SingleItemStack, totalSold);
                double totalSold2 = moneyMap.getOrDefault(itemEconomyType, 0.0);
                double amountSold2 = totalSold2 + itemSellPrice;
                moneyMap.put(itemEconomyType, amountSold2);
                try {
                    ShopTransactionResult shopTransactionResult = (ShopTransactionResult)Class.forName("net.brcdev.shopgui.shop.ShopTransactionResult").getDeclaredConstructor(ShopManager.ShopAction.class, ShopTransactionResult.ShopTransactionResultType.class, ShopItem.class, Player.class, Integer.TYPE, Double.TYPE).newInstance(ShopManager.ShopAction.SELL, ShopTransactionResult.ShopTransactionResultType.SUCCESS, ShopGuiPlusApi.getItemStackShopItem((ItemStack)i), player, amount, itemSellPrice);
                    ShopPostTransactionEvent shopPostTransactionEvent = (ShopPostTransactionEvent)Class.forName("net.brcdev.shopgui.event.ShopPostTransactionEvent").getDeclaredConstructor(ShopTransactionResult.class).newInstance(shopTransactionResult);
                    Runnable task = () -> Bukkit.getPluginManager().callEvent((Event)shopPostTransactionEvent);
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, task);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            HashMap fallenItems = event.getPlayer().getInventory().addItem(new ItemStack[]{i});
            Runnable task = () -> {
                World world = player.getWorld();
                Location location = player.getLocation().add(0.0, 0.5, 0.0);
                fallenItems.values().forEach(item -> {
                    world.dropItemNaturally(location, item);
                    excessItems[0] = true;
                });
            };
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, task);
        }
        if (excessItems[0]) {
            this.sendMessage((CommandSender)player, "inventory_full");
        }
        if (totalPrice > 0.0) {
            PlayerHandler.playSound((Player)event.getPlayer(), "success");
            StringBuilder formattedPricing = new StringBuilder();
            for (Map.Entry entry : moneyMap.entrySet()) {
                EconomyProvider economyProvider = ShopGuiPlusApi.getPlugin().getEconomyManager().getEconomyProvider((EconomyType)entry.getKey());
                economyProvider.deposit(player, ((Double)entry.getValue()).doubleValue());
                formattedPricing.append(economyProvider.getCurrencyPrefix()).append(ShopHandler.getFormattedNumber((Double)entry.getValue())).append(economyProvider.getCurrencySuffix()).append(", ");
            }
            if (formattedPricing.toString().endsWith(", ")) {
                formattedPricing = new StringBuilder(formattedPricing.substring(0, formattedPricing.length() - 2));
            }
            ArrayList<String> receiptList = new ArrayList<String>();
            StringBuilder stringBuilder = new StringBuilder();
            if (configuration.getInt("options.receipt_type") == 1 || configuration.getString("messages.items_sold").contains("{list}")) {
                for (Map.Entry entry : soldMap2.entrySet()) {
                    for (Map.Entry damageEntry : ((Map)entry.getValue()).entrySet()) {
                        String displayName;
                        ItemStack materialItemStack = (ItemStack)entry.getKey();
                        double profits = ShopHandler.getItemSellPrice(materialItemStack, player) * (double)((Integer)damageEntry.getValue()).intValue();
                        String profitsFormatted = ShopGuiPlusApi.getPlugin().getEconomyManager().getEconomyProvider(ShopHandler.getEconomyType(materialItemStack)).getCurrencyPrefix() + ShopHandler.getFormattedNumber(profits) + ShopGuiPlusApi.getPlugin().getEconomyManager().getEconomyProvider(ShopHandler.getEconomyType(materialItemStack)).getCurrencySuffix();
                        String itemNameFormatted = WordUtils.capitalize(materialItemStack.getType().name().replace("AETHER_LEGACY_", "").replace("LOST_AETHER_", "").replace("_", " ").toLowerCase());
                        ItemMeta itemMeta = materialItemStack.getItemMeta();
                        if (itemMeta != null && itemMeta.hasDisplayName() && !(displayName = itemMeta.getDisplayName()).isEmpty()) {
                            itemNameFormatted = materialItemStack.getItemMeta().getDisplayName();
                        }
                        if (minorVersion <= 12 && !configuration.getBoolean("options.show_item_damage")) {
                            itemNameFormatted = itemNameFormatted + ":" + damageEntry.getKey();
                        }
                        String finalItemNameFormatted = itemNameFormatted;
                        String itemLine = this.getMessage("receipt_item_layout", message -> message.replace("{amount}", String.valueOf(damageEntry.getValue())).replace("{item}", finalItemNameFormatted).replace("{price}", profitsFormatted));
                        receiptList.add(itemLine);
                        stringBuilder.append(itemNameFormatted).append(", ");
                    }
                }
            }
            String itemAmountFormatted = ShopHandler.getFormattedNumber(Double.valueOf(itemAmount));
            if (configuration.getInt("options.receipt_type") == 1) {
                int finalItemAmount = itemAmount;
                StringBuilder finalFormattedPricing1 = formattedPricing;
                TextComponent itemsSoldComponent = this.getTextComponentMessage("items_sold", message -> message.replace("{earning}", finalFormattedPricing1).replace("{receipt}", "").replace("{list}", itemList.substring(0, itemList.length() - 2)).replace("{amount}", String.valueOf(finalItemAmount)));
                itemsSoldComponent.addExtra(" ");
                String receiptHoverMessage = this.getMessage("receipt_title", null) + ChatColor.RESET + receiptList.stream().collect(Collectors.joining("\n")) + ChatColor.RESET;
                TextComponent receiptNameComponent = this.getTextComponentMessage("receipt_text", null);
                BaseComponent[] hoverEventComponents = new BaseComponent[]{new TextComponent(receiptHoverMessage)};
                HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, hoverEventComponents);
                receiptNameComponent.setHoverEvent(hoverEvent);
                player.spigot().sendMessage(new BaseComponent[]{itemsSoldComponent, receiptNameComponent});
            } else {
                StringBuilder finalFormattedPricing = formattedPricing;
                this.sendMessage((CommandSender)player, "items_sold", message -> message.replace("{earning}", finalFormattedPricing).replace("{receipt}", "").replace("{list}", itemList.substring(0, itemList.length() - 2)).replace("{amount}", itemAmountFormatted));
            }
            this.plugin.fileLogger.info(player.getName() + " (" + player.getUniqueId() + ") sold: {" + HexColorUtility.purgeAllColor(receiptList.stream().collect(Collectors.joining(", "))) + "}");
            if (configuration.getBoolean("options.sell_titles")) {
                this.sendSellTitles(player, formattedPricing, itemAmountFormatted);
            }
            if (configuration.getBoolean("options.action_bar_msgs") && minorVersion >= 8) {
                this.sendActionBar(player, formattedPricing, itemAmountFormatted);
            }
        } else {
            PlayerHandler.playSound(player, "failed");
            this.sendMessage((CommandSender)player, itemsPlacedInGui ? "no_items_sold" : "no_items_in_gui");
        }
    }

    private void sendSellTitles(Player player, CharSequence price, String amount) {
        Function<String, String> replacer = message -> message.replace("{earning}", price).replace("{amount}", amount);
        String title = this.getMessage("sell_title", replacer);
        String subtitle = this.getMessage("sell_subtitle", replacer);
        player.sendTitle(title, subtitle);
    }

    private void sendActionBar(Player player, CharSequence price, String amount) {
        Function<String, String> replacer = message -> message.replace("{earning}", price).replace("{amount}", amount);
        TextComponent message2 = this.getTextComponentMessage("action_bar_items_sold", replacer);
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)message2);
    }
}

