/*
 * Decompiled with CFR 0.152.
 */
package net.mackenziemolloy.shopguiplus.sellgui;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.mackenziemolloy.shopguiplus.sellgui.bstats.bukkit.Metrics;
import net.mackenziemolloy.shopguiplus.sellgui.command.CommandSellGUI;
import net.mackenziemolloy.shopguiplus.sellgui.utility.CommentedConfiguration;
import net.mackenziemolloy.shopguiplus.sellgui.utility.FileUtils;
import net.mackenziemolloy.shopguiplus.sellgui.utility.LogFormatter;
import net.mackenziemolloy.shopguiplus.sellgui.utility.UpdateChecker;
import net.mackenziemolloy.shopguiplus.sellgui.utility.sirblobman.VersionUtility;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;

public final class SellGUI
extends JavaPlugin {
    private CommentedConfiguration configuration = new CommentedConfiguration();
    private static SellGUI instance;
    public Logger fileLogger;
    private FileHandler handler;
    private String version = null;
    public boolean compatible = false;

    public void onEnable() {
        instance = this;
        new CommandSellGUI(this).register();
        Logger logger = this.getLogger();
        this.checkCompatibility();
        this.version = VersionUtility.getNetMinecraftServerVersion();
        logger.info("Your server is running version '" + this.version + "'.");
        this.generateFiles();
        this.setupMetrics();
        this.setupUpdates();
        this.fileLogger = Logger.getLogger("SellGUIFileLogger");
        this.initLogger();
        logger.info("*-*");
        logger.info("ShopGUIPlus SellGUI");
        logger.info("Made by Mackenzie Molloy");
        logger.info("*-*");
    }

    public void checkCompatibility() {
        try {
            Class.forName("net.brcdev.shopgui.shop.item.ShopItem");
            this.compatible = true;
        }
        catch (ReflectiveOperationException ex) {
            this.compatible = false;
        }
    }

    public void initLogger() {
        File log = FileUtils.loadFile("transaction.log");
        FileHandler handler = null;
        try {
            handler = new FileHandler(log.getAbsolutePath(), true);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        handler.setFormatter(new LogFormatter());
        this.handler = handler;
        this.fileLogger.addHandler(handler);
        this.fileLogger.setUseParentHandlers(false);
    }

    public CommentedConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getVersion() {
        return this.version;
    }

    private void setupMetrics() {
        new Metrics(this, 9356);
    }

    private void setupUpdates() {
        PluginDescriptionFile description = this.getDescription();
        String localVersion = description.getVersion();
        String pluginPrefix = description.getPrefix();
        UpdateChecker updateChecker = new UpdateChecker(this, 85170);
        updateChecker.getVersion(updateVersion -> {
            ConsoleCommandSender console = Bukkit.getConsoleSender();
            if (localVersion.contains("dev")) {
                String message = ChatColor.DARK_RED + "[" + pluginPrefix + "] You are running a DEVELOPMENT build. This may contain bugs.";
                console.sendMessage(message);
                return;
            }
            if (localVersion.equalsIgnoreCase((String)updateVersion)) {
                String message = ChatColor.GREEN + "[" + pluginPrefix + "] You are running the LATEST release.";
                console.sendMessage(message);
                return;
            }
            String message = ChatColor.DARK_RED + "[" + pluginPrefix + "] There is a new update available. Please update ASAP. Download: https://www.spigotmc.org/resources/85170/";
            console.sendMessage(message);
        });
    }

    public void generateFiles() {
        this.saveDefaultConfig();
        File pluginFolder = this.getDataFolder();
        File configFile = new File(pluginFolder, "config.yml");
        try {
            this.configuration.load(configFile);
            InputStream jarConfig = this.getResource("config.yml");
            this.configuration.syncWithConfig(configFile, jarConfig, "stupid_option");
        }
        catch (IOException | InvalidConfigurationException ex) {
            Logger logger = this.getLogger();
            logger.log(Level.SEVERE, "Failed to load the 'config.yml' file due to an error:", ex);
        }
    }

    public static SellGUI getInstance() {
        return instance;
    }
}

