package com.darkstar.scuba;

import java.util.ArrayList;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

/*It would be nice if you could add a bubble effect when in water.
Also would be nice, if added, to be optional toggled in config or over a command. (with permission) ;)*/


public class Scuba extends JavaPlugin implements Listener {
	
	public void onEnable() {
		Bukkit.getServer().getPluginManager().registerEvents(this, this);
		saveDefaultConfig();
		recipes();
	}


	public void recipes() {
		Server server = this.getServer();
		ItemStack ScubaHelmet = new ItemStack(Material.getMaterial(getConfig().getString("helmetItem").toUpperCase()));
		ItemMeta ScubaHelmetMeta = ScubaHelmet.getItemMeta();
		ScubaHelmetMeta.setDisplayName("Scuba Helmet");
		ArrayList<String> ScubaHelmetLore = new ArrayList<String>();
		ScubaHelmetLore.add(ChatColor.GRAY + "Breathe underwater for a little longer");
		ScubaHelmetMeta.setLore(ScubaHelmetLore);
		ScubaHelmet.setItemMeta(ScubaHelmetMeta);
		ScubaHelmet.addUnsafeEnchantment(Enchantment.OXYGEN, 2);
		ShapedRecipe ScubaHelmetRecipe = new ShapedRecipe(new NamespacedKey(this, "ScubaHelmet"), ScubaHelmet);
		ScubaHelmetRecipe.shape("OTO","PHP","   ");
		ScubaHelmetRecipe.setIngredient('T', Material.getMaterial(getConfig().getString("helmetItem").toUpperCase()));
		ScubaHelmetRecipe.setIngredient('P', Material.GLASS_PANE);
		ScubaHelmetRecipe.setIngredient('O', Material.OBSIDIAN);
		ScubaHelmetRecipe.setIngredient('H', Material.HEART_OF_THE_SEA);
		server.addRecipe(ScubaHelmetRecipe);

		ItemStack ScubaTank = new ItemStack(Material.getMaterial(getConfig().getString("tankItem").toUpperCase()));
		ItemMeta ScubaTankMeta = ScubaTank.getItemMeta();
		ScubaTankMeta.setDisplayName("Scuba Tank");
		ArrayList<String> ScubaTankLore = new ArrayList<String>();
		ScubaTankLore.add(ChatColor.GRAY + "Breathe underwater indefinitely");
		ScubaTankLore.add(ChatColor.GRAY + "Requires a scuba helmet");
		ScubaTankMeta.setLore(ScubaTankLore);
		ScubaTank.setItemMeta(ScubaTankMeta);
		ShapedRecipe ScubaTankRecipe = new ShapedRecipe(new NamespacedKey(this, "ScubaTank"), ScubaTank);
		ScubaTankRecipe.shape("O O","HLH","OCO");
		ScubaTankRecipe.setIngredient('L', Material.getMaterial(getConfig().getString("tankItem").toUpperCase()));
		ScubaTankRecipe.setIngredient('C', Material.CHEST);
		ScubaTankRecipe.setIngredient('O', Material.OBSIDIAN);
		ScubaTankRecipe.setIngredient('H', Material.HEART_OF_THE_SEA);
		server.addRecipe(ScubaTankRecipe);

		ItemStack Flippers = new ItemStack(Material.getMaterial(getConfig().getString("flippersItem").toUpperCase()));
		ItemMeta FlippersMeta = Flippers.getItemMeta();
		FlippersMeta.setDisplayName("Flippers");
		ArrayList<String> FlippersLore = new ArrayList<String>();
		FlippersLore.add(ChatColor.GRAY + "Swim faster under water");
		FlippersMeta.setLore(FlippersLore);
		Flippers.setItemMeta(FlippersMeta);
		ShapedRecipe FlippersRecipe = new ShapedRecipe(new NamespacedKey(this, "Flippers"), Flippers);
		FlippersRecipe.shape("KLK","S S","   ");
		FlippersRecipe.setIngredient('L', Material.getMaterial(getConfig().getString("flippersItem").toUpperCase()));
		FlippersRecipe.setIngredient('K', Material.DRIED_KELP);
		FlippersRecipe.setIngredient('S', Material.PRISMARINE_SHARD);
		server.addRecipe(FlippersRecipe);

	}

	@EventHandler
	public void playerMoveEvent(PlayerMoveEvent e) {
		Player p = e.getPlayer();
		if(p.getEyeLocation().getBlock().getType().equals(Material.WATER)) {

			//scuba tank requires scuba helmet check + disable breathing bubbles
			if(p != null && p.getInventory() != null && p.getInventory().getHelmet() != null && p.getInventory().getHelmet().hasItemMeta() && p.getInventory().getHelmet().getItemMeta().hasDisplayName() &&
					p.getInventory().getChestplate() != null && p.getInventory().getChestplate().hasItemMeta() && p.getInventory().getChestplate().getItemMeta().hasDisplayName() ) {
				if(p.getInventory().getHelmet().getItemMeta().getDisplayName().equals("Scuba Helmet") && 
						p.getInventory().getChestplate().getItemMeta().getDisplayName().equals("Scuba Tank") ) {
					//new PotionEffect(PotionEffectType.WATER_BREATHING, 20, 0).apply(e.getPlayer());//update every 20 ticks, water breathing 0 amplifier
					p.setRemainingAir(-1);
				}
			}
			//flippers speed increase
			if(p != null && p.getInventory() != null && p.getInventory().getBoots() != null && p.getInventory().getBoots().hasItemMeta() && p.getInventory().getBoots().getItemMeta().hasDisplayName() ) {
				if(p.getInventory().getBoots().getItemMeta().getDisplayName().equals("Flippers")) {
					if(p.isSprinting()) {
						Vector dir = p.getLocation().getDirection().normalize().multiply(0.4D);
						Vector vec = new Vector(dir.getX(), dir.getY(), dir.getZ());
						p.setVelocity(vec);
					}
				}
			}
			//bubble effect while in water
			
		}
	}

	@EventHandler
	public void preventDrowning(EntityDamageEvent e) {
		if (e.getEntity() instanceof Player) {
			Player p = (Player) e.getEntity();

			if(p != null && p.getInventory() != null && p.getInventory().getHelmet() != null && p.getInventory().getHelmet().hasItemMeta() && p.getInventory().getHelmet().getItemMeta().hasDisplayName() &&
					p.getInventory().getChestplate() != null && p.getInventory().getChestplate().hasItemMeta() && p.getInventory().getChestplate().getItemMeta().hasDisplayName() ) {

				if(p.getInventory().getHelmet().getItemMeta().getDisplayName().equals("Scuba Helmet") && 
						p.getInventory().getChestplate().getItemMeta().getDisplayName().equals("Scuba Tank") ) {

					//prevent drowning caused by player standing still (not triggering move event)
					if(e.getCause() == EntityDamageEvent.DamageCause.DROWNING) {
						e.setCancelled(true);
					}
				}
			}
		}
	}

	@EventHandler
	public void infiniteDurability(EntityDamageByEntityEvent e){
		Entity p = e.getEntity();
		if (p instanceof Player) {
			PlayerInventory i = ((HumanEntity) p).getInventory();
			for(ItemStack item : i.getArmorContents()){
				if(item != null && 
						(item.getItemMeta().getDisplayName().equals("Scuba Helmet") || 
								item.getItemMeta().getDisplayName().equals("Scuba Tank") ||
								item.getItemMeta().getDisplayName().equals("Flippers")) ){
					item.setDurability((short)-1);
				}
			}
		}
	}

	public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
		if (cmd.getName().equalsIgnoreCase("scuba") && args.length == 1) {
			if(args[0].equalsIgnoreCase("reload") && sender.hasPermission("scuba.reload")) {
				reloadConfig();
				sender.sendMessage(ChatColor.GREEN + "[Scuba] Config reloaded!");
			}
			if(args[0].equalsIgnoreCase("bubbles") && sender.hasPermission("scuba.bubbles")) {
				boolean bubbles = false;
				sender.sendMessage(ChatColor.GREEN + "[Scuba] Bubbles toggled!");
			}
		}
		return false;
	}
}

