/*
 * Decompiled with CFR 0.152.
 */
package me.staartvin.scrollteleportation.teleporthandler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.staartvin.scrollteleportation.ScrollTeleportation;
import me.staartvin.scrollteleportation.files.LanguageString;
import me.staartvin.scrollteleportation.storage.Scroll;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class TeleportHandler {
    public HashMap<String, Integer> taskID = new HashMap();
    List<String> readyToBeTeleported = new ArrayList<String>();
    private ScrollTeleportation plugin;

    public TeleportHandler(ScrollTeleportation instance) {
        this.plugin = instance;
    }

    public boolean isReady(String playerName) {
        return this.readyToBeTeleported.contains(playerName);
    }

    public void setReady(String playerName, Boolean status) {
        if (status.booleanValue()) {
            if (!this.readyToBeTeleported.contains(playerName)) {
                this.readyToBeTeleported.add(playerName);
            }
        } else {
            this.readyToBeTeleported.remove(playerName);
        }
    }

    public void teleport(Player player, Location destination, ItemStack item) {
        if (this.plugin.getTeleportHandler().isReady(player.getName())) {
            player.teleport(destination);
            this.plugin.getTeleportHandler().setReady(player.getName(), false);
            player.sendMessage(this.plugin.getMainConfig().getTranslatableMessage(LanguageString.COMMENCING_TELEPORT));
            this.decreaseUse(item, player);
            if (player.hasPermission("scrollteleportation.potioneffectbypass")) {
                return;
            }
            this.plugin.getScrollStorage().getScrollByItemStack(item).ifPresent(scroll -> {
                scroll.applyEffects(player);
                if (scroll.getEffects().size() > 0) {
                    player.sendMessage(this.plugin.getMainConfig().getTranslatableMessage(LanguageString.POTION_EFFECTS_APPLIED));
                }
            });
        }
    }

    public void decreaseUse(ItemStack item, Player player) {
        if (player.hasPermission("scrollteleportation.usesbypass")) {
            return;
        }
        if (!Scroll.hasPersistentData(item, Scroll.KEY_TOTAL_USES, PersistentDataType.INTEGER)) {
            return;
        }
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, Scroll.KEY_TOTAL_USES);
        int currentUses = (Integer)item.getItemMeta().getPersistentDataContainer().get(key, PersistentDataType.INTEGER);
        ItemMeta im = item.getItemMeta();
        if (currentUses == Scroll.SCROLL_USES_INFINITE) {
            return;
        }
        if (currentUses == 1 || currentUses == 0) {
            if (item.getAmount() != 1) {
                item.setAmount(item.getAmount() - 1);
                Scroll scroll = this.plugin.getScrollStorage().getScrollByItemStack(item).orElse(null);
                currentUses = scroll == null ? 1 : scroll.getUses() + 1;
            } else {
                player.getInventory().remove(item);
                return;
            }
        }
        im.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)(--currentUses));
        String uses = ChatColor.GREEN + "Uses: " + currentUses;
        List lore = im.getLore();
        lore.set(lore.size() - 1, uses);
        im.setLore(lore);
        item.setItemMeta(im);
    }
}

