/*
 * Decompiled with CFR 0.152.
 */
package me.staartvin.scrollteleportation.storage;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.staartvin.scrollteleportation.ScrollTeleportation;
import me.staartvin.scrollteleportation.files.MainConfig;
import me.staartvin.scrollteleportation.storage.Scroll;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ScrollStorage {
    private ScrollTeleportation plugin;
    private List<Scroll> loadedScrolls = new ArrayList<Scroll>();

    public ScrollStorage(ScrollTeleportation instance) {
        this.plugin = instance;
    }

    public void addLoadedScroll(Scroll scroll) {
        if (this.loadedScrolls.contains(scroll)) {
            this.loadedScrolls.add(scroll);
        }
    }

    public void removeLoadedScroll(String scrollName) {
        this.loadedScrolls.removeIf(scroll -> scroll.getDisplayName().equalsIgnoreCase(scrollName) || scroll.getInternalName().equalsIgnoreCase(scrollName));
    }

    public Optional<Scroll> getLoadedScroll(String scrollName) {
        return this.loadedScrolls.stream().filter(scroll -> scroll.getInternalName().equalsIgnoreCase(scrollName) || scroll.getDisplayName().equalsIgnoreCase(scrollName)).findFirst();
    }

    public boolean loadScrollsFromConfig() {
        this.loadedScrolls.clear();
        MainConfig mainConfig = this.plugin.getMainConfig();
        for (String internalScrollName : mainConfig.getScrollsInConfig()) {
            Scroll scroll = new Scroll(internalScrollName);
            scroll.setDisplayName(mainConfig.getScrollDisplayName(internalScrollName));
            scroll.setDescriptionLore(mainConfig.getLoreStrings(internalScrollName));
            scroll.setCancelOnMove(mainConfig.doCancelOnMove(internalScrollName));
            scroll.setDestinationHidden(mainConfig.isDestinationHidden(internalScrollName));
            scroll.setEffects(mainConfig.getEffects(internalScrollName));
            scroll.setTeleportDelay(mainConfig.getDelay(internalScrollName));
            scroll.setUses(mainConfig.getTotalUses(internalScrollName));
            scroll.setDestination(mainConfig.getScrollDestination(internalScrollName));
            scroll.setMaterial(mainConfig.getScrollMaterial());
            this.loadedScrolls.add(scroll);
        }
        return true;
    }

    public void giveScrollToPlayer(Player player, String scrollName) {
        Scroll scroll = this.getLoadedScroll(scrollName).orElse(null);
        if (scroll == null) {
            return;
        }
        player.getInventory().addItem(new ItemStack[]{scroll.getItemStack()});
    }

    public Optional<Scroll> getScrollByItemStack(ItemStack stack) {
        if (!Scroll.hasPersistentData(stack, Scroll.KEY_INTERNAL_NAME, PersistentDataType.STRING)) {
            return Optional.empty();
        }
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, Scroll.KEY_INTERNAL_NAME);
        String internalScrollName = (String)stack.getItemMeta().getPersistentDataContainer().get(key, PersistentDataType.STRING);
        return this.getLoadedScroll(internalScrollName);
    }

    public List<Scroll> getLoadedScrolls() {
        return this.loadedScrolls;
    }
}

