/*
 * Decompiled with CFR 0.152.
 */
package me.staartvin.scrollteleportation.storage;

import com.sun.istack.internal.NotNull;
import java.util.List;
import java.util.Random;
import me.staartvin.scrollteleportation.exceptions.DestinationInvalidException;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;

public class ScrollDestination {
    @NotNull
    private DestinationType destinationType = null;
    private Location location = null;
    private int rangeRadius = 5;
    private String locationString = null;

    public static ScrollDestination createFromLocationString(String locationString) throws DestinationInvalidException {
        ScrollDestination destination = new ScrollDestination();
        if (!(locationString = locationString.toLowerCase()).contains(",")) {
            if (locationString.contains("random")) {
                destination.setDestinationType(DestinationType.RANDOM);
            } else {
                destination.setDestinationType(DestinationType.FIXED_NAME);
                destination.setupFixedNameLocation(locationString);
            }
        } else if (locationString.contains("random_radius")) {
            destination.setDestinationType(DestinationType.RANDOM_IN_RANGE);
            destination.setupRandomRadiusLocation(locationString);
        } else {
            destination.setDestinationType(DestinationType.FIXED_LOCATION);
            destination.setupFixedLocation(locationString);
        }
        destination.locationString = locationString.trim();
        return destination;
    }

    private static String locationToString(Location location) {
        return location.getBlockX() + ", " + location.getBlockY() + ", " + location.getBlockZ() + " on world " + location.getWorld().getName();
    }

    public Location getLocation() throws DestinationInvalidException {
        if (this.destinationType == DestinationType.FIXED_LOCATION) {
            return this.location;
        }
        if (this.destinationType == DestinationType.RANDOM) {
            return this.getRandomLocation();
        }
        if (this.destinationType == DestinationType.RANDOM_IN_RANGE) {
            return this.getRandomLocationWithRadius();
        }
        if (this.destinationType == DestinationType.FIXED_NAME) {
            return this.getFixedNameLocation();
        }
        return null;
    }

    public String getLocationDescription() {
        if (this.destinationType == DestinationType.FIXED_LOCATION) {
            return this.getFixedLocationString();
        }
        if (this.destinationType == DestinationType.RANDOM) {
            return this.getRandomLocationString();
        }
        if (this.destinationType == DestinationType.RANDOM_IN_RANGE) {
            return this.getRandomRadiusLocationString();
        }
        if (this.destinationType == DestinationType.FIXED_NAME) {
            return this.getFixedNameLocationString();
        }
        return "unknown";
    }

    public DestinationType getDestinationType() {
        return this.destinationType;
    }

    public void setDestinationType(DestinationType destinationType) {
        this.destinationType = destinationType;
    }

    private void setupRandomRadiusLocation(String locationString) throws DestinationInvalidException {
        if (!locationString.contains("point")) {
            throw new DestinationInvalidException("No point given for '" + this.location + "'!");
        }
        if (!locationString.contains("radius")) {
            throw new DestinationInvalidException("No radius given for '" + this.location + "'!");
        }
        String info = locationString.replaceAll(".*\\(|\\).*", "");
        String[] args = info.split(" ");
        if (args.length != 2) {
            throw new DestinationInvalidException("Not all arguments were given for '" + locationString + "'!");
        }
        String point = args[0].contains("point") ? args[0].replace("point=", "") : args[1].replace("point=", "");
        String radiusString = args[0].contains("radius") ? args[0].replace("radius=", "") : args[1].replace("radius=", "");
        String[] pointInfo = point.split(",");
        this.rangeRadius = Integer.parseInt(radiusString);
        if (pointInfo.length != 4) {
            throw new DestinationInvalidException("Not all arguments were given in '" + point + "' for '" + locationString + "'!");
        }
        if (Bukkit.getServer().getWorld(pointInfo[0]) == null) {
            throw new DestinationInvalidException("World '" + pointInfo[0] + "' in '" + locationString + "' does not exist!");
        }
        World world = Bukkit.getServer().getWorld(pointInfo[0]);
        this.location = new Location(world, (double)Integer.parseInt(pointInfo[1]), (double)Integer.parseInt(pointInfo[2]), (double)Integer.parseInt(pointInfo[3]));
    }

    private void setupFixedLocation(String locationString) throws DestinationInvalidException {
        String[] args = locationString.split(",");
        if (args.length != 4) {
            throw new DestinationInvalidException("More or less than 4 arguments defined for '" + locationString + "'!");
        }
        String worldName = args[0].trim();
        String x = args[1].trim();
        String y = args[2].trim();
        String z = args[3].trim();
        World realWorld = Bukkit.getServer().getWorld(worldName);
        if (realWorld == null) {
            throw new DestinationInvalidException("Unknown world '" + worldName + "' defined in '" + locationString + "'!");
        }
        this.location = new Location(realWorld, (double)Integer.parseInt(x), (double)Integer.parseInt(y), (double)Integer.parseInt(z));
    }

    private void setupFixedNameLocation(String locationString) throws DestinationInvalidException {
        if (locationString == null) {
            throw new DestinationInvalidException("There is no name specified for the destination!");
        }
        if (locationString.contains("spawn")) {
            String[] params = locationString.split(" ");
            if (params.length < 2) {
                throw new DestinationInvalidException("The destination name '" + locationString + "' did not specify a world!");
            }
            String worldName = params[1];
            World world = Bukkit.getWorld((String)worldName);
            if (world == null) {
                throw new DestinationInvalidException("World '" + worldName + "' does not exist!");
            }
            this.location = world.getSpawnLocation();
            return;
        }
        throw new DestinationInvalidException("Fixed name '" + locationString + "' unknown!");
    }

    private Location getFixedNameLocation() throws DestinationInvalidException {
        return this.location;
    }

    private Location getRandomLocation() throws DestinationInvalidException {
        World world;
        double random = Math.random();
        boolean above = false;
        above = random > 0.45;
        int x = this.getRandomNumberRange(1, 10000);
        int y = this.getRandomNumberRange(1, 250);
        int z = this.getRandomNumberRange(1, 10000);
        if (!above) {
            x -= x * 2;
            z -= z * 2;
        }
        boolean worldSpecified = false;
        String[] params = this.locationString.split(" ");
        if (params.length > 1) {
            worldSpecified = true;
        }
        if (worldSpecified) {
            String worldName = params[1];
            world = Bukkit.getWorld((String)worldName);
            if (world == null) {
                throw new DestinationInvalidException("World '" + worldName + "' does not exist!");
            }
        } else {
            List worlds = Bukkit.getServer().getWorlds();
            int randomWorld = this.getRandomNumberRange(0, worlds.size() - 1);
            world = (World)worlds.get(randomWorld);
        }
        return new Location(world, (double)x, (double)y, (double)z);
    }

    private int getRandomNumberRange(int min, int max) {
        return new Random().nextInt(max - min + 1) + min;
    }

    private Location getRandomLocationWithRadius() {
        int xLowest = this.location.getBlockX() - this.rangeRadius;
        int xBiggest = this.location.getBlockX() + this.rangeRadius;
        int xDifference = xBiggest - xLowest;
        int zLowest = this.location.getBlockZ() - this.rangeRadius;
        int zBiggest = this.location.getBlockZ() + this.rangeRadius;
        int zDifference = zBiggest - zLowest;
        int xOffSet = this.getRandomNumberRange(0, xDifference - 1);
        int yOffSet = this.getRandomNumberRange(1, 250);
        int zOffSet = this.getRandomNumberRange(0, zDifference - 1);
        int x = xLowest + xOffSet;
        int y = yOffSet;
        int z = zLowest + zOffSet;
        return new Location(this.location.getWorld(), (double)x, (double)y, (double)z);
    }

    private Location secureLocation(Location oldLocation) {
        World world = oldLocation.getWorld();
        int x = oldLocation.getBlockX();
        int y = oldLocation.getBlockY();
        int z = oldLocation.getBlockZ();
        Block blockOnY = world.getBlockAt(x, y, z);
        Block blockOnY2 = world.getBlockAt(x, y + 1, z);
        Block blockOnY3 = world.getBlockAt(x, y - 1, z);
        Location safeLocation = null;
        if (!blockOnY.getType().equals((Object)Material.AIR) || !blockOnY2.getType().equals((Object)Material.AIR) || blockOnY3.getType().equals((Object)Material.AIR)) {
            int safeY = oldLocation.getWorld().getHighestBlockYAt(x, z);
            safeLocation = new Location(world, (double)x, (double)safeY, (double)z);
        } else {
            safeLocation = oldLocation;
        }
        return safeLocation;
    }

    private String getFixedNameLocationString() {
        return ScrollDestination.locationToString(this.location);
    }

    private String getFixedLocationString() {
        if (this.locationString.contains("spawn")) {
            return "spawn";
        }
        return "a named location";
    }

    private String getRandomLocationString() {
        return "a random location";
    }

    private String getRandomRadiusLocationString() {
        return "within " + this.rangeRadius + " meters around " + ScrollDestination.locationToString(this.location);
    }

    public static enum DestinationType {
        FIXED_LOCATION,
        RANDOM,
        RANDOM_IN_RANGE,
        FIXED_NAME;

    }
}

