/*
 * Decompiled with CFR 0.152.
 */
package me.staartvin.scrollteleportation.storage;

import com.sun.istack.internal.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.staartvin.scrollteleportation.ScrollTeleportation;
import me.staartvin.scrollteleportation.storage.ScrollDestination;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;

public class Scroll {
    public static String KEY_INTERNAL_NAME = "internalName";
    public static String KEY_TOTAL_USES = "totalUses";
    public static int SCROLL_USES_INFINITE = -1;
    @NotNull
    private String internalName;
    @NotNull
    private String displayName;
    private List<String> descriptionLore = new ArrayList<String>();
    private boolean destinationHidden = false;
    private boolean cancelOnMove = true;
    private int teleportDelay = 5;
    private int uses = 1;
    private List<PotionEffect> effects = new ArrayList<PotionEffect>();
    private ScrollDestination destination;
    private Material material = Material.PAPER;

    public Scroll(String internalName) {
        this.setInternalName(internalName);
    }

    public String getInternalName() {
        return this.internalName;
    }

    public void setInternalName(String internalName) {
        this.internalName = internalName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public List<String> getDescriptionLore() {
        return this.descriptionLore;
    }

    public void setDescriptionLore(List<String> lore) {
        this.descriptionLore = lore;
    }

    public boolean isDestinationHidden() {
        return this.destinationHidden;
    }

    public void setDestinationHidden(boolean destinationHidden) {
        this.destinationHidden = destinationHidden;
    }

    public boolean isCancelledOnMove() {
        return this.cancelOnMove;
    }

    public void setCancelOnMove(boolean cancelOnMove) {
        this.cancelOnMove = cancelOnMove;
    }

    public int getTeleportDelay() {
        return this.teleportDelay;
    }

    public void setTeleportDelay(int teleportDelay) {
        this.teleportDelay = teleportDelay;
    }

    public int getUses() {
        return this.uses;
    }

    public void setUses(int uses) {
        this.uses = uses;
    }

    public List<PotionEffect> getEffects() {
        return this.effects;
    }

    public void setEffects(List<PotionEffect> effects) {
        this.effects = effects;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Scroll scroll = (Scroll)o;
        return this.displayName.equals(scroll.displayName);
    }

    public int hashCode() {
        return Objects.hash(this.displayName);
    }

    public ScrollDestination getDestination() {
        return this.destination;
    }

    public void setDestination(ScrollDestination destination) {
        this.destination = destination;
    }

    public ItemStack getItemStack() {
        ItemStack item = new ItemStack(this.getMaterial(), 1);
        ItemMeta im = item.getItemMeta();
        im.setDisplayName(ChatColor.GOLD + this.getDisplayName());
        String destination = null;
        destination = this.isDestinationHidden() ? "Destination: Unknown" : "Destination: " + this.getDestination().getLocationDescription();
        ArrayList<String> lores = new ArrayList<String>(this.descriptionLore);
        lores.add(ChatColor.GREEN + destination);
        lores.add(ChatColor.GREEN + "Uses: " + (this.getUses() < 0 ? "infinite" : Integer.valueOf(this.getUses())));
        im.setLore(lores);
        NamespacedKey internalNameKey = new NamespacedKey(Objects.requireNonNull(Bukkit.getPluginManager().getPlugin("ScrollTeleportation")), KEY_INTERNAL_NAME);
        NamespacedKey totalUsesKey = new NamespacedKey(Objects.requireNonNull(Bukkit.getPluginManager().getPlugin("ScrollTeleportation")), KEY_TOTAL_USES);
        im.getPersistentDataContainer().set(internalNameKey, PersistentDataType.STRING, (Object)this.getInternalName());
        im.getPersistentDataContainer().set(totalUsesKey, PersistentDataType.INTEGER, (Object)this.getUses());
        item.setItemMeta(im);
        return item;
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public void applyEffects(Player player) {
        player.addPotionEffects(this.effects);
    }

    public static boolean hasPersistentData(ItemStack stack, String keyString, PersistentDataType dataType) {
        ScrollTeleportation plugin = (ScrollTeleportation)Bukkit.getPluginManager().getPlugin("ScrollTeleportation");
        if (stack == null) {
            return false;
        }
        if (stack.getType() != plugin.getMainConfig().getScrollMaterial()) {
            return false;
        }
        if (!stack.hasItemMeta()) {
            return false;
        }
        if (stack.getItemMeta() == null) {
            return false;
        }
        NamespacedKey key = new NamespacedKey((Plugin)plugin, keyString);
        return stack.getItemMeta().getPersistentDataContainer().has(key, dataType);
    }
}

