/*
 * Decompiled with CFR 0.152.
 */
package me.staartvin.scrollteleportation.listeners;

import me.staartvin.scrollteleportation.ScrollTeleportation;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;

public class PlayerMoveListener
implements Listener {
    private ScrollTeleportation plugin;

    public PlayerMoveListener(ScrollTeleportation instance) {
        this.plugin = instance;
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (event.getFrom().getBlockX() == event.getTo().getBlockX() && event.getFrom().getBlockY() == event.getTo().getBlockY() && event.getFrom().getBlockZ() == event.getTo().getBlockZ()) {
            return;
        }
        if (this.plugin.getTeleportHandler().isReady(player.getName())) {
            if (player.hasPermission("scrollteleportation.walkbypass")) {
                return;
            }
            String scroll = this.plugin.getMainConfig().getScroll(this.plugin.fixName(player.getItemInHand().getItemMeta().getDisplayName()));
            if (!this.plugin.getMainConfig().doCancelOnMove(scroll)) {
                return;
            }
            this.plugin.getTeleportHandler().setReady(player.getName(), false);
            if (this.plugin.getTeleportHandler().taskID.get(player.getName()) != null) {
                this.plugin.getServer().getScheduler().cancelTask(this.plugin.getTeleportHandler().taskID.get(player.getName()).intValue());
                this.plugin.getTeleportHandler().taskID.put(player.getName(), null);
            }
            player.sendMessage(ChatColor.RED + "Teleportation is cancelled because you moved.");
        }
    }
}

