/*
 * Decompiled with CFR 0.152.
 */
package me.staartvin.scrollteleportation.listeners;

import java.util.Arrays;
import java.util.List;
import me.staartvin.scrollteleportation.ScrollTeleportation;
import me.staartvin.scrollteleportation.exceptions.DestinationInvalidException;
import me.staartvin.scrollteleportation.files.LanguageString;
import me.staartvin.scrollteleportation.storage.Scroll;
import me.staartvin.scrollteleportation.tasks.TeleportRunnable;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class ActivateScrollListener
implements Listener {
    private ScrollTeleportation plugin;
    private List<Material> ignoredBlocks;

    public ActivateScrollListener(ScrollTeleportation instance) {
        this.plugin = instance;
        this.ignoredBlocks = Arrays.asList(Material.DISPENSER, Material.CHEST, Material.ENDER_CHEST, Material.TRAPPED_CHEST, Material.DROPPER, Material.FURNACE, Material.CRAFTING_TABLE, Material.MINECART, Material.CAULDRON, Material.DARK_OAK_DOOR, Material.ACACIA_DOOR, Material.BIRCH_DOOR, Material.JUNGLE_DOOR, Material.ACACIA_TRAPDOOR, Material.SPRUCE_DOOR, Material.DARK_OAK_DOOR);
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (event.getHand() == EquipmentSlot.OFF_HAND) {
            return;
        }
        if (this.plugin.getTeleportHandler().isReady(player.getName())) {
            Material clickedBlock;
            if (player.hasPermission("scrollteleportation.walkbypass")) {
                return;
            }
            if (event.getAction() == Action.RIGHT_CLICK_BLOCK && ((clickedBlock = event.getClickedBlock().getType()) == Material.CHEST || clickedBlock == Material.ENDER_CHEST || clickedBlock == Material.TRAPPED_CHEST)) {
                return;
            }
            this.plugin.getTeleportHandler().setReady(player.getName(), false);
            if (this.plugin.getTeleportHandler().taskID.get(player.getName()) != null) {
                this.plugin.getServer().getScheduler().cancelTask(this.plugin.getTeleportHandler().taskID.get(player.getName()).intValue());
                this.plugin.getTeleportHandler().taskID.put(player.getName(), null);
            }
            player.sendMessage(ChatColor.RED + "Teleportation is cancelled because you interacted.");
            return;
        }
        if (event.getAction().equals((Object)Action.RIGHT_CLICK_AIR) || event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
                Material clickedBlock = event.getClickedBlock().getType();
            }
            if (item == null) {
                return;
            }
            if (!item.getType().equals((Object)this.plugin.getMainConfig().getScrollMaterial())) {
                return;
            }
            if (!item.hasItemMeta()) {
                return;
            }
            ItemMeta im = item.getItemMeta();
            if (!im.hasDisplayName()) {
                return;
            }
            im.setDisplayName(this.plugin.fixName(im.getDisplayName()));
            if (this.plugin.getMainConfig().getScroll(im.getDisplayName()) == null) {
                return;
            }
            Scroll scroll = this.plugin.getScrollStorage().getLoadedScroll(im.getDisplayName()).orElse(null);
            if (scroll == null) {
                return;
            }
            if (!player.hasPermission("scrollteleportation.teleport")) {
                player.sendMessage(this.plugin.getMainConfig().getTranslatableMessage(LanguageString.NOT_ALLOWED_TO_USE_SCROLL));
                return;
            }
            Location destination = null;
            try {
                destination = scroll.getDestination().getLocation();
            }
            catch (DestinationInvalidException e) {
                e.printStackTrace();
            }
            if (destination == null) {
                player.sendMessage(ChatColor.RED + "Destination could not be found!");
                return;
            }
            int delay = scroll.getTeleportDelay();
            if (!player.hasPermission("scrollteleportation.delaybypass")) {
                player.sendMessage(this.plugin.getMainConfig().getTranslatableMessage(LanguageString.TELEPORTING_IN_TIME).replace("%time%", delay + ""));
            }
            this.plugin.getTeleportHandler().setReady(player.getName(), true);
            if (scroll.isCancelledOnMove() && !player.hasPermission("scrollteleportation.walkbypass")) {
                player.sendMessage(this.plugin.getMainConfig().getTranslatableMessage(LanguageString.MOVEMENT_WARNING));
            }
            if (!player.hasPermission("scrollteleportation.delaybypass")) {
                BukkitTask task = this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, (Runnable)new TeleportRunnable(this.plugin, destination, item, player), (long)(delay * 20));
                this.plugin.getTeleportHandler().taskID.put(player.getName(), task.getTaskId());
            } else {
                this.plugin.getTeleportHandler().teleport(player, destination, item);
            }
        }
    }
}

