/*
 * Decompiled with CFR 0.152.
 */
package me.staartvin.scrollteleportation.files;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import me.staartvin.scrollteleportation.ScrollTeleportation;
import me.staartvin.scrollteleportation.exceptions.DestinationInvalidException;
import me.staartvin.scrollteleportation.files.LanguageString;
import me.staartvin.scrollteleportation.storage.Scroll;
import me.staartvin.scrollteleportation.storage.ScrollDestination;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class MainConfig {
    private ScrollTeleportation plugin;
    private FileConfiguration config;

    public MainConfig(ScrollTeleportation instance) {
        this.plugin = instance;
    }

    public void loadConfiguration() {
        this.config = this.plugin.getConfig();
        this.config.options().header("Scroll Teleportation v" + this.plugin.getDescription().getVersion() + " Config\n\nThe name of scroll should be unique. ST uses this to identify the scroll.\nYou can add as many lores as you like. To get a blank line, just type '' as lore line..\nDestination is the destination a player will be teleported to.\nWhen 'destination hidden' is true, the scroll will show 'unknown' as destination\nDelay is time (in seconds) before a player is teleported.\nWhen 'cancel on move' is true, the teleportation of a scroll will be cancelled on move.\nUses is the amount of uses a scroll have before it becomes thin air. To create scrolls with infinite uses, just set it to -1.\nEffects are effects that are played when the scroll is used. (The number is the duration in seconds)\nThis is a list of effects you can use: http://jd.bukkit.org/rb/doxygen/d3/d70/classorg_1_1bukkit_1_1potion_1_1PotionEffectType.html\n\nDestinations can be defined in multiple ways:\n\t1. Fixed point (eg: 'world,x,y,z')\n\t2. Random point (eg: 'random world')\n\t\tThis takes a world to get random coordinates on. If you leave the world out, a random world will be selected\n \t\tBe careful with this one. This can cause lag as it will try to teleport a player to unloaded chunks.\n\t3. Random point with radius (eg: 'random_radius(point=world,x,y,z radius=1000)')\n\t\tThis will put a player in a random location within a radius of the point\n\t4. Fixed name (eg: 'spawn world')\n\t\tworld is the world that you want the spawn of");
        for (LanguageString string : LanguageString.values()) {
            this.config.addDefault("Messages." + string.getConfigPath(), (Object)string.getDefaultString());
        }
        this.config.addDefault("Scroll.scrollMaterial", (Object)"PAPER");
        this.config.addDefault("Scroll.load-chunk-on-teleport", (Object)false);
        this.config.addDefault("Scrolls.ExampleScroll.name", (Object)"Scroll of Mysteriousness");
        this.config.addDefault("Scrolls.ExampleScroll.lores", Arrays.asList("&3This mighty and rare scroll", "&3will teleport you to", "&3a place never visited by humans.", "", "&7Rare scroll, Unknown location", ""));
        this.config.addDefault("Scrolls.ExampleScroll.destination", (Object)"world, 100, 100, 100");
        this.config.addDefault("Scrolls.ExampleScroll.destination hidden", (Object)false);
        this.config.addDefault("Scrolls.ExampleScroll.delay", (Object)5);
        this.config.addDefault("Scrolls.ExampleScroll.cancel on move", (Object)true);
        this.config.addDefault("Scrolls.ExampleScroll.uses", (Object)1);
        this.config.addDefault("Scrolls.ExampleScroll.effects", Arrays.asList("BLINDNESS 10", "POISON 2"));
        this.config.addDefault("Scrolls.Scroll_of_unforeseen_travel.name", (Object)"Scroll of Unforeseen Travel");
        this.config.addDefault("Scrolls.Scroll_of_unforeseen_travel.lores", Arrays.asList("&3This scroll is a one of its kind", "&3and is very rare. It will allow", "&3you to travel to an unpredictable", "&3destination.", "", "&7Very rare scroll, Unpredictable destination"));
        this.config.addDefault("Scrolls.Scroll_of_unforeseen_travel.destination", (Object)"random_radius(point=world,1,1,1 radius=4000)");
        this.config.addDefault("Scrolls.Scroll_of_unforeseen_travel.destination hidden", (Object)true);
        this.config.addDefault("Scrolls.Scroll_of_unforeseen_travel.delay", (Object)5);
        this.config.addDefault("Scrolls.Scroll_of_unforeseen_travel.cancel on move", (Object)true);
        this.config.addDefault("Scrolls.Scroll_of_unforeseen_travel.uses", (Object)5);
        this.config.addDefault("Scrolls.Scroll_of_unforeseen_travel.effects", Arrays.asList("CONFUSION 10"));
        this.config.options().copyDefaults(true);
        this.plugin.saveConfig();
    }

    public String getTranslatableMessage(LanguageString message) {
        return this.addColourCode(this.config.getString(message.getConfigPath(), message.getDefaultString()));
    }

    public String getScroll(String scrollName) {
        Set scrolls = this.config.getConfigurationSection("Scrolls").getKeys(false);
        for (String scroll : scrolls) {
            if (!this.getScrollDisplayName(scroll).equalsIgnoreCase(scrollName)) continue;
            return scroll;
        }
        return null;
    }

    public String getScrollDisplayName(String scroll) {
        return this.addColourCode(this.config.getString("Scrolls." + scroll + ".name"));
    }

    public int getDelay(String scroll) {
        return this.config.getInt("Scrolls." + scroll + ".delay");
    }

    public List<String> getLoreStrings(String scroll) {
        ArrayList lores = new ArrayList();
        return this.config.getStringList("Scrolls." + scroll + ".lores").stream().map(text -> ChatColor.translateAlternateColorCodes((char)'&', (String)text)).collect(Collectors.toList());
    }

    public boolean isDestinationHidden(String scroll) {
        return this.config.getBoolean("Scrolls." + scroll + ".destination hidden");
    }

    public boolean doCancelOnMove(String scroll) {
        return this.config.getBoolean("Scrolls." + scroll + ".cancel on move");
    }

    public ScrollDestination getScrollDestination(String scroll) {
        String destination = this.config.getString("Scrolls." + scroll + ".destination", "random");
        try {
            return ScrollDestination.createFromLocationString(destination);
        }
        catch (DestinationInvalidException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getTotalUses(String scroll) {
        int uses = this.config.getInt("Scrolls." + scroll + ".uses", 1);
        if (uses < 0) {
            return Scroll.SCROLL_USES_INFINITE;
        }
        return uses;
    }

    public void reload() {
        this.plugin.reloadConfig();
        this.loadConfiguration();
    }

    public Material getScrollMaterial() {
        return Material.getMaterial((String)Objects.requireNonNull(this.config.getString("Scroll.scrollMaterial", "PAPER")));
    }

    public List<PotionEffect> getEffects(String scroll) {
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        this.config.getStringList("Scrolls." + scroll + ".effects").forEach(effectString -> {
            String[] args = effectString.split(" ");
            if (args.length != 2) {
                this.plugin.getLogger().severe("Missing duration argument for '" + effectString + "'!");
                return;
            }
            String realEffect = args[0].trim();
            int duration = 1;
            try {
                duration = Integer.parseInt(args[1].trim());
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Invalid duration for '" + realEffect + "'!");
                return;
            }
            PotionEffectType potionEffect = PotionEffectType.getByName((String)realEffect.toUpperCase().replace(" ", "_"));
            if (potionEffect == null) {
                this.plugin.getLogger().severe("PotionEffect '" + realEffect + "' is not a valid effect!");
                return;
            }
            effects.add(new PotionEffect(potionEffect, duration * 20, 1));
        });
        return effects;
    }

    public boolean createNewScroll(String scroll, String scrollName, Location destination, int delay, int uses) {
        if (this.config.getString("Scrolls." + scroll + ".name") != null) {
            return false;
        }
        this.setName(scroll, scrollName);
        this.setDestination(scroll, destination);
        this.setDelay(scroll, delay);
        this.setDestinationHidden(scroll, false);
        this.setCancelOnMove(scroll, true);
        this.setUses(scroll, uses);
        this.config.set("Scrolls." + scroll + ".effects", Arrays.asList(new Object[0]));
        this.config.set("Scrolls." + scroll + ".lores.lore1", (Object)"&3This mighty and rare scroll");
        this.config.set("Scrolls." + scroll + ".lores.lore2", (Object)"&3will teleport you");
        this.config.set("Scrolls." + scroll + ".lores.lore3", (Object)"");
        this.config.set("Scrolls." + scroll + ".lores.lore4", (Object)"");
        this.plugin.saveConfig();
        return true;
    }

    public void setName(String scroll, String name) {
        this.config.set("Scrolls." + scroll + ".name", (Object)name);
        this.plugin.saveConfig();
    }

    public void setDelay(String scroll, int delay) {
        this.config.set("Scrolls." + scroll + ".delay", (Object)delay);
        this.plugin.saveConfig();
    }

    public void setUses(String scroll, int uses) {
        this.config.set("Scrolls." + scroll + ".uses", (Object)uses);
        this.plugin.saveConfig();
    }

    public void setDestinationHidden(String scroll, boolean status) {
        this.config.set("Scrolls." + scroll + ".destination hidden", (Object)status);
        this.plugin.saveConfig();
    }

    public void setCancelOnMove(String scroll, boolean status) {
        this.config.set("Scrolls." + scroll + ".cancel on move", (Object)status);
        this.plugin.saveConfig();
    }

    public void setDestination(String scroll, Location location) {
        this.config.set("Scrolls." + scroll + ".destination", (Object)(location.getWorld().getName() + ", " + location.getBlockX() + ", " + location.getBlockY() + ", " + location.getBlockZ()));
        this.plugin.saveConfig();
    }

    public String addColourCode(String oldString) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)oldString);
    }

    public Set<String> getScrollsInConfig() {
        return this.config.getConfigurationSection("Scrolls").getKeys(false);
    }

    public boolean doLoadChunk() {
        return this.config.getBoolean("Scroll.load-chunk-on-teleport");
    }
}

