/*
 * Decompiled with CFR 0.152.
 */
package me.staartvin.scrollteleportation.commands;

import java.util.List;
import java.util.stream.Collectors;
import me.staartvin.scrollteleportation.ScrollTeleportation;
import me.staartvin.scrollteleportation.storage.Scroll;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class GiveCommand
implements CommandExecutor,
TabCompleter {
    private ScrollTeleportation plugin;

    public GiveCommand(ScrollTeleportation instance) {
        this.plugin = instance;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args[0].equalsIgnoreCase("give")) {
            if (!sender.hasPermission("scrollteleportation.give")) {
                sender.sendMessage(ChatColor.RED + "You are not allowed to give scrolls");
                return true;
            }
            if (args.length < 2) {
                sender.sendMessage(ChatColor.RED + "Incorrect command usage!");
                sender.sendMessage(ChatColor.YELLOW + "Usage: /scroll give <scroll> (name)");
                return true;
            }
            Player target = null;
            Scroll scroll = this.plugin.getScrollStorage().getLoadedScroll(args[1]).orElse(null);
            if (scroll == null) {
                sender.sendMessage(ChatColor.RED + "No scroll found with that name.");
                return true;
            }
            if (args.length == 2) {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(ChatColor.RED + "You are not a player!");
                    return true;
                }
                target = (Player)sender;
            } else if (args.length == 3) {
                if (this.plugin.getServer().getPlayer(args[2]) == null) {
                    sender.sendMessage(ChatColor.RED + "There is no player with that name online!");
                } else {
                    target = this.plugin.getServer().getPlayer(args[2]);
                }
            } else {
                sender.sendMessage(ChatColor.RED + "Incorrect command usage!");
                sender.sendMessage(ChatColor.YELLOW + "Usage: /scroll give <scroll> (name)");
                return true;
            }
            ItemStack itemStack = scroll.getItemStack();
            target.getInventory().addItem(new ItemStack[]{itemStack});
            target.sendMessage(ChatColor.GREEN + "You have been given a " + ChatColor.GOLD + scroll.getDisplayName());
            if (args.length == 3 && !target.getName().equalsIgnoreCase(sender.getName())) {
                sender.sendMessage(ChatColor.GREEN + "You have given " + ChatColor.GOLD + target.getName() + ChatColor.GREEN + " a " + ChatColor.GOLD + scroll.getDisplayName());
            }
            return true;
        }
        sender.sendMessage(ChatColor.RED + "Command not recognised!");
        sender.sendMessage(ChatColor.YELLOW + "Type '/scroll help' for a list of commands.");
        return true;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String s, String[] strings) {
        if (strings.length == 2) {
            return this.plugin.getScrollStorage().getLoadedScrolls().stream().map(Scroll::getInternalName).filter(scrollName -> scrollName.toLowerCase().startsWith(strings[1].toLowerCase())).collect(Collectors.toList());
        }
        if (strings.length == 3) {
            return this.plugin.getServer().getOnlinePlayers().stream().map(Player::getDisplayName).collect(Collectors.toList());
        }
        return null;
    }
}

