/*
 * Decompiled with CFR 0.152.
 */
package me.staartvin.scrollteleportation.commands;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.staartvin.scrollteleportation.ScrollTeleportation;
import me.staartvin.scrollteleportation.commands.CreateCommand;
import me.staartvin.scrollteleportation.commands.GiveCommand;
import me.staartvin.scrollteleportation.commands.HelpCommand;
import me.staartvin.scrollteleportation.commands.ReloadCommand;
import me.staartvin.scrollteleportation.commands.SetCommand;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class CommandHandler
implements CommandExecutor,
TabCompleter {
    private ScrollTeleportation plugin;
    private Map<String, CommandExecutor> commands = new HashMap<String, CommandExecutor>();

    public CommandHandler(ScrollTeleportation instance) {
        this.plugin = instance;
        this.commands.put("give", new GiveCommand(this.plugin));
        this.commands.put("reload", new ReloadCommand(this.plugin));
        this.commands.put("create", new CreateCommand(this.plugin));
        this.commands.put("set", new SetCommand(this.plugin));
        this.commands.put("help", new HelpCommand(this.plugin));
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage(ChatColor.BLUE + "-----------------------------------------------------");
            sender.sendMessage(ChatColor.GOLD + "Developed by: " + ChatColor.GRAY + "Staartvin");
            sender.sendMessage(ChatColor.GOLD + "Version: " + ChatColor.GRAY + this.plugin.getDescription().getVersion());
            sender.sendMessage(ChatColor.YELLOW + "Type /scroll help for a list of commands.");
            return true;
        }
        CommandExecutor executor = this.commands.get(args[0].toLowerCase().trim());
        if (executor != null) {
            executor.onCommand(sender, cmd, label, args);
        } else {
            sender.sendMessage(ChatColor.RED + "Command not recognised!");
            sender.sendMessage(ChatColor.YELLOW + "Type '/scroll help' for a list of commands.");
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String s, String[] strings) {
        TabCompleter completer;
        if (strings.length == 1) {
            return this.commands.keySet().stream().sorted().collect(Collectors.toList());
        }
        if (strings.length >= 2 && (completer = (TabCompleter)this.commands.get(strings[0].toLowerCase().trim())) != null) {
            return completer.onTabComplete(commandSender, command, s, strings);
        }
        return null;
    }
}

