/*
 * Decompiled with CFR 0.152.
 */
package me.staartvin.scrollteleportation;

import me.staartvin.scrollteleportation.commands.CommandHandler;
import me.staartvin.scrollteleportation.files.MainConfig;
import me.staartvin.scrollteleportation.listeners.ActivateScrollListener;
import me.staartvin.scrollteleportation.listeners.PlayerInvOpenListener;
import me.staartvin.scrollteleportation.listeners.PlayerMoveListener;
import me.staartvin.scrollteleportation.storage.ScrollStorage;
import me.staartvin.scrollteleportation.teleporthandler.TeleportHandler;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ScrollTeleportation
extends JavaPlugin {
    private MainConfig config = new MainConfig(this);
    private TeleportHandler teleHandler = new TeleportHandler(this);
    private ScrollStorage scrollStorage = new ScrollStorage(this);

    public void onEnable() {
        this.config.loadConfiguration();
        this.scrollStorage.loadScrollsFromConfig();
        this.registerListeners();
        this.getCommand("scroll").setExecutor((CommandExecutor)new CommandHandler(this));
        this.getLogger().info("Loaded " + this.scrollStorage.getLoadedScrolls().size() + " scrolls!");
        this.getLogger().info("Scroll Teleportation v" + this.getDescription().getVersion() + " has been enabled.");
    }

    public void onDisable() {
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        this.getLogger().info("Scroll Teleportation v" + this.getDescription().getVersion() + " has been disabled.");
    }

    private void registerListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new ActivateScrollListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerMoveListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerInvOpenListener(this), (Plugin)this);
    }

    public MainConfig getMainConfig() {
        return this.config;
    }

    public TeleportHandler getTeleportHandler() {
        return this.teleHandler;
    }

    public ScrollStorage getScrollStorage() {
        return this.scrollStorage;
    }

    public String fixName(String oldDisplayName) {
        return oldDisplayName.replace("\u00a70", "").replace("\u00a71", "").replace("\u00a72", "").replace("\u00a73", "").replace("\u00a74", "").replace("\u00a75", "").replace("\u00a76", "").replace("\u00a77", "").replace("\u00a78", "").replace("\u00a79", "").replace("\u00a7a", "").replace("\u00a7b", "").replace("\u00a7c", "").replace("\u00a7d", "").replace("\u00a7e", "").replace("\u00a7f", "");
    }
}

