/*
 * Decompiled with CFR 0.152.
 */
package to.epac.factorycraft.ScoreboardInjector.Utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitScheduler;
import to.epac.factorycraft.ScoreboardInjector.Main;

public class Utils {
    public static HashMap<Player, Integer> timerDB = new HashMap();
    static Long timer;

    public static String getPrefix() {
        String prefix = Main.getInstance().getConfig().getString("ScoreboardInjector.Prefix");
        prefix = ChatColor.translateAlternateColorCodes((char)'&', (String)prefix);
        return prefix;
    }

    public static String loadPlaceholders(Player player, String message) {
        String modified = PlaceholderAPI.setPlaceholders((Player)player, (String)message);
        return modified;
    }

    public static List<String> getDetectorList() {
        ArrayList<String> list = new ArrayList<String>();
        ConfigurationSection Detectors = Main.getInstance().getConfig().getConfigurationSection("ScoreboardInjector.Detector");
        for (String detector : Detectors.getKeys(false)) {
            list.add(detector);
        }
        return list;
    }

    public static List<String> getDetectorText(String name) {
        List textUncolored = Main.getInstance().getConfig().getStringList("ScoreboardInjector.Detector." + name + ".String");
        return textUncolored;
    }

    public static boolean isScoreboardTemplateLoadEnabled(String name) {
        boolean isEnabled = Main.getInstance().getConfig().getBoolean("ScoreboardInjector.Detector." + name + ".Action.ScoreboardTemplateLoad.Enabled");
        return isEnabled;
    }

    public static String getScoreboardTemplateLoad(String name) {
        String template = Main.getInstance().getConfig().getString("ScoreboardInjector.Detector." + name + ".Action.ScoreboardTemplateLoad.Template");
        return template;
    }

    public static long getScoreboardTemplateDuration(String name) {
        long duration = Main.getInstance().getConfig().getLong("ScoreboardInjector.Detector." + name + ".Action.ScoreboardTemplateLoad.Duration");
        return duration;
    }

    public static String getScoreboardTemplateTitle(String name) {
        String title = Main.getInstance().getConfig().getString("ScoreboardInjector.Template." + name + ".Title");
        title = ChatColor.translateAlternateColorCodes((char)'&', (String)title);
        return title;
    }

    public static List<String> getScoreboardTemplateText(String name) {
        List textUncolored = Main.getInstance().getConfig().getStringList("ScoreboardInjector.Template." + name + ".Text");
        ArrayList<String> textColored = new ArrayList<String>();
        for (String text : textUncolored) {
            textColored.add(ChatColor.translateAlternateColorCodes((char)'&', (String)text));
        }
        return textColored;
    }

    public static void startScoreboardTimer(final Player player, Long duration, final String board) {
        timer = duration;
        BukkitScheduler scheduler = Bukkit.getServer().getScheduler();
        int taskID = scheduler.scheduleSyncRepeatingTask(Main.getInstance(), new Runnable(){

            @Override
            public void run() {
                if (timer <= 0L) {
                    Utils.stopScoreboardTimer(player, board);
                    return;
                }
                timer = timer - 1L;
            }
        }, 0L, 20L);
        timerDB.put(player, taskID);
    }

    public static void stopScoreboardTimer(Player player, String board) {
        int taskID = timerDB.get(player);
        Bukkit.getScheduler().cancelTask(taskID);
        player.setScoreboard(Bukkit.getScoreboardManager().getNewScoreboard());
        timerDB.remove(player);
    }
}

