/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.util;

import java.util.List;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.janboerman.scalaloader.bytecode.TransformerRegistry;
import xyz.janboerman.scalaloader.compat.Migration;
import xyz.janboerman.scalaloader.compat.Platform;
import xyz.janboerman.scalaloader.configurationserializable.transform.ConfigurationSerializableError;
import xyz.janboerman.scalaloader.configurationserializable.transform.ConfigurationSerializableTransformations;
import xyz.janboerman.scalaloader.event.transform.EventError;
import xyz.janboerman.scalaloader.event.transform.EventTransformations;
import xyz.janboerman.scalaloader.libs.asm.ClassReader;
import xyz.janboerman.scalaloader.libs.asm.ClassVisitor;
import xyz.janboerman.scalaloader.libs.asm.ClassWriter;
import xyz.janboerman.scalaloader.plugin.ScalaPluginClassLoader;

public class ClassLoaderUtils {
    private ClassLoaderUtils() {
    }

    public static byte[] transform(String className, byte[] classBytes, final ClassLoader definer, TransformerRegistry registry, ScalaPluginClassLoader plugin, Logger logger) {
        ClassWriter classWriter;
        String path = className.replace('.', '/') + ".class";
        Platform platform = Platform.detect(plugin.getServer());
        try {
            classBytes = Migration.transform(classBytes, definer);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "An unexpected error occurred when updating bytecode to work with new references to classes that have been moved or otherwise refactored.", e);
        }
        try {
            classBytes = EventTransformations.transform(classBytes, definer);
        }
        catch (EventError e) {
            logger.log(Level.SEVERE, "Event class " + className + " is not valid", e);
        }
        try {
            classBytes = ConfigurationSerializableTransformations.transform(classBytes, definer, plugin);
        }
        catch (ConfigurationSerializableError e) {
            logger.log(Level.SEVERE, "ConfigurationSerializable class " + className + " is not valid", e);
        }
        ClassVisitor classVisitor = classWriter = new ClassWriter(0){

            @Override
            protected ClassLoader getClassLoader() {
                return definer;
            }
        };
        List<Function<ClassVisitor, ClassVisitor>> targetedTransformers = registry.byClassTransformers.get(className);
        if (targetedTransformers != null && !targetedTransformers.isEmpty()) {
            for (Function<ClassVisitor, ClassVisitor> transformer : targetedTransformers) {
                classVisitor = transformer.apply(classVisitor);
            }
        }
        if (classVisitor != classWriter) {
            ClassReader classreader = new ClassReader(classBytes);
            classreader.accept(classVisitor, 0);
            classBytes = classWriter.toByteArray();
        }
        try {
            classBytes = platform.transform(path, classBytes, plugin);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Server implementation could not transform class: " + path, e);
        }
        return classBytes;
    }
}

