/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.plugin.runtime;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.configuration.file.YamlConfiguration;
import xyz.janboerman.scalaloader.compat.Compat;
import xyz.janboerman.scalaloader.plugin.ScalaPlugin;
import xyz.janboerman.scalaloader.plugin.runtime.ClassFile;

public class PersistentClasses {
    private static final String FILE_NAME = "generated-classes.yml";
    private static final String CLASS_FILES = "class-files";
    private final ScalaPlugin plugin;
    private File saveFile;
    private final Set<ClassFile> classFiles = new HashSet<ClassFile>();

    public PersistentClasses(ScalaPlugin plugin) {
        assert (plugin != null) : "plugin cannot be null";
        this.plugin = plugin;
        this.saveFile = new File(plugin.getDataFolder(), FILE_NAME);
    }

    public void save(ClassFile classFile) {
        this.classFiles.add(classFile);
        if (!this.saveFile.exists()) {
            if (!this.plugin.getDataFolder().exists()) {
                this.plugin.getDataFolder().mkdirs();
            }
            try {
                this.saveFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.saveFile);
        List classFiles = (List)config.get(CLASS_FILES, Compat.emptyList());
        this.classFiles.addAll(classFiles);
        config.set(CLASS_FILES, Compat.listCopy(this.classFiles));
        try {
            config.save(this.saveFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Collection<ClassFile> load() {
        if (!this.saveFile.exists()) {
            return Compat.emptySet();
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.saveFile);
        List classFiles = (List)config.get(CLASS_FILES, Compat.emptyList());
        this.classFiles.addAll(classFiles);
        return classFiles;
    }
}

