/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.plugin.runtime;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.configuration.serialization.SerializableAs;
import xyz.janboerman.scalaloader.compat.Compat;
import xyz.janboerman.scalaloader.util.Base64;

@SerializableAs(value="ClassFile")
public final class ClassFile
implements ConfigurationSerializable {
    private final String className;
    private final byte[] byteCode;

    public static void register() {
        ConfigurationSerialization.registerClass(ClassFile.class, (String)"ClassFile");
    }

    public ClassFile(String className, byte[] byteCode) {
        assert (className != null) : "className cannot be null";
        assert (byteCode != null) : "byteCode cannot be null";
        this.className = className;
        this.byteCode = byteCode;
    }

    public String getClassName() {
        return this.className;
    }

    public byte[] getByteCode() {
        return this.getByteCode(true);
    }

    public byte[] getByteCode(boolean copy) {
        return copy ? Arrays.copyOf(this.byteCode, this.byteCode.length) : this.byteCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassFile)) {
            return false;
        }
        ClassFile that = (ClassFile)o;
        return Objects.equals(this.className, that.className);
    }

    public int hashCode() {
        return Objects.hashCode(this.className);
    }

    public String toString() {
        return this.className;
    }

    public Map<String, Object> serialize() {
        return Compat.mapOf(Compat.mapEntry("class-name", this.className), Compat.mapEntry("bytecode", Base64.encode(this.byteCode)));
    }

    public static ClassFile deserialize(Map<String, Object> map) {
        String className = (String)map.get("class-name");
        byte[] byteCode = Base64.decode((String)map.get("bytecode"));
        return new ClassFile(className, byteCode);
    }
}

