/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.plugin.description;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import xyz.janboerman.scalaloader.compat.Compat;

public final class ScalaVersion
extends Enum<ScalaVersion> {
    @Deprecated
    public static final /* enum */ ScalaVersion v2_11_12 = new ScalaVersion("2.11.12");
    public static final /* enum */ ScalaVersion v2_12_6 = new ScalaVersion("2.12.6");
    public static final /* enum */ ScalaVersion v2_12_7 = new ScalaVersion("2.12.7");
    public static final /* enum */ ScalaVersion v2_12_8 = new ScalaVersion("2.12.8");
    public static final /* enum */ ScalaVersion v2_12_9 = new ScalaVersion("2.12.9");
    public static final /* enum */ ScalaVersion v2_12_10 = new ScalaVersion("2.12.10");
    public static final /* enum */ ScalaVersion v2_12_11 = new ScalaVersion("2.12.11");
    public static final /* enum */ ScalaVersion v2_12_12 = new ScalaVersion("2.12.12");
    public static final /* enum */ ScalaVersion v2_12_13 = new ScalaVersion("2.12.13");
    public static final /* enum */ ScalaVersion v2_12_14 = new ScalaVersion("2.12.14");
    public static final /* enum */ ScalaVersion v2_12_15 = new ScalaVersion("2.12.15");
    public static final /* enum */ ScalaVersion v2_12_16 = new ScalaVersion("2.12.16");
    public static final /* enum */ ScalaVersion v2_12_17 = new ScalaVersion("2.12.17");
    public static final /* enum */ ScalaVersion v2_13_0 = new ScalaVersion("2.13.0");
    public static final /* enum */ ScalaVersion v2_13_1 = new ScalaVersion("2.13.1");
    public static final /* enum */ ScalaVersion v2_13_2 = new ScalaVersion("2.13.2");
    public static final /* enum */ ScalaVersion v2_13_3 = new ScalaVersion("2.13.3");
    public static final /* enum */ ScalaVersion v2_13_4 = new ScalaVersion("2.13.4");
    public static final /* enum */ ScalaVersion v2_13_5 = new ScalaVersion("2.13.5");
    public static final /* enum */ ScalaVersion v2_13_6 = new ScalaVersion("2.13.6");
    public static final /* enum */ ScalaVersion v2_13_7 = new ScalaVersion("2.13.7");
    public static final /* enum */ ScalaVersion v2_13_8 = new ScalaVersion("2.13.8");
    public static final /* enum */ ScalaVersion v2_13_9 = new ScalaVersion("2.13.9", false);
    public static final /* enum */ ScalaVersion v3_0_0 = new ScalaVersion("3.0.0");
    public static final /* enum */ ScalaVersion v3_0_1 = new ScalaVersion("3.0.1");
    public static final /* enum */ ScalaVersion v3_0_2 = new ScalaVersion("3.0.2");
    public static final /* enum */ ScalaVersion v3_1_0 = new ScalaVersion("3.1.0");
    public static final /* enum */ ScalaVersion v3_1_1 = new ScalaVersion("3.1.1");
    public static final /* enum */ ScalaVersion v3_1_2 = new ScalaVersion("3.1.2");
    public static final /* enum */ ScalaVersion v3_1_3 = new ScalaVersion("3.1.3");
    public static final /* enum */ ScalaVersion v3_2_0 = new ScalaVersion("3.2.0");
    private static Map<String, ScalaVersion> byVersion;
    private static final ScalaVersion latest_2_13;
    private final String version;
    private final boolean stable;
    private Map<String, String> urls;
    private static final /* synthetic */ ScalaVersion[] $VALUES;

    public static ScalaVersion[] values() {
        return (ScalaVersion[])$VALUES.clone();
    }

    public static ScalaVersion valueOf(String name) {
        return Enum.valueOf(ScalaVersion.class, name);
    }

    private ScalaVersion(String version) {
        this(version, true);
    }

    private ScalaVersion(String version, boolean stable) {
        this.version = version;
        this.stable = stable;
    }

    private static Map<String, String> urls(String scalaVersion) {
        if (scalaVersion.startsWith("2.")) {
            return Compat.mapOf(Compat.mapEntry("scala-reflect-url", ScalaVersion.mavenCentralSearchScalaReflect(scalaVersion)), Compat.mapEntry("scala-library-url", ScalaVersion.mavenCentralSearchScalaLibrary(scalaVersion)));
        }
        if (scalaVersion.startsWith("3.0.") || scalaVersion.startsWith("3.1.") || scalaVersion.startsWith("3.2.")) {
            return Compat.mapOf(Compat.mapEntry("scala-library-url", ScalaVersion.mavenCentralSearchScalaLibrary(latest_2_13.getVersion())), Compat.mapEntry("scala-reflect-url", ScalaVersion.mavenCentralSearchScalaReflect(latest_2_13.getVersion())), Compat.mapEntry("scala3-library-url", ScalaVersion.mavenCentralScala3LibraryAdditions(scalaVersion)), Compat.mapEntry("tasty-core-url", ScalaVersion.mavenCentralScala3TastyCoreAdditions(scalaVersion)));
        }
        assert (false) : "Scala 3.3+ not yet supported";
        return null;
    }

    public static ScalaVersion fromVersionString(String string) {
        return byVersion.get(string);
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, String> getUrls() {
        if (this.urls == null) {
            this.urls = ScalaVersion.urls(this.getVersion());
        }
        return Collections.unmodifiableMap(this.urls);
    }

    @Deprecated
    public String getScalaLibraryUrl() {
        return this.getUrls().get("scala-library-url");
    }

    @Deprecated
    public String getScalaReflectUrl() {
        return this.getUrls().get("scala-reflect-url");
    }

    public String toString() {
        return this.getVersion();
    }

    public boolean isStable() {
        return this.stable;
    }

    private static String mavenCentralSearchScalaLibrary(String scalaVersion) {
        return "https://search.maven.org/remotecontent?filepath=org/scala-lang/scala-library/" + scalaVersion + "/scala-library-" + scalaVersion + ".jar";
    }

    private static String mavenCentralSearchScalaReflect(String scalaVersion) {
        return "https://search.maven.org/remotecontent?filepath=org/scala-lang/scala-reflect/" + scalaVersion + "/scala-reflect-" + scalaVersion + ".jar";
    }

    private static String mavenCentralScala3LibraryAdditions(String scalaVersion) {
        if ("3.0.0".equals(scalaVersion)) {
            return "https://search.maven.org/remotecontent?filepath=org/scala-lang/scala3-library_" + scalaVersion + "-nonbootstrapped/" + scalaVersion + "/scala3-library_" + scalaVersion + "-nonbootstrapped-" + scalaVersion + ".jar";
        }
        return "https://search.maven.org/remotecontent?filepath=org/scala-lang/scala3-library_3/" + scalaVersion + "/scala3-library_3-" + scalaVersion + ".jar";
    }

    private static String mavenCentralScala3TastyCoreAdditions(String scalaVersion) {
        if ("3.0.0".equals(scalaVersion)) {
            return "https://search.maven.org/remotecontent?filepath=org/scala-lang/tasty-core_" + scalaVersion + "-nonbootstrapped/" + scalaVersion + "/tasty-core_" + scalaVersion + "-nonbootstrapped-" + scalaVersion + ".jar";
        }
        return "https://search.maven.org/remotecontent?filepath=org/scala-lang/tasty-core_3/" + scalaVersion + "/tasty-core_3-" + scalaVersion + ".jar";
    }

    private static /* synthetic */ ScalaVersion[] $values() {
        return new ScalaVersion[]{v2_11_12, v2_12_6, v2_12_7, v2_12_8, v2_12_9, v2_12_10, v2_12_11, v2_12_12, v2_12_13, v2_12_14, v2_12_15, v2_12_16, v2_12_17, v2_13_0, v2_13_1, v2_13_2, v2_13_3, v2_13_4, v2_13_5, v2_13_6, v2_13_7, v2_13_8, v2_13_9, v3_0_0, v3_0_1, v3_0_2, v3_1_0, v3_1_1, v3_1_2, v3_1_3, v3_2_0};
    }

    static {
        $VALUES = ScalaVersion.$values();
        byVersion = new HashMap<String, ScalaVersion>();
        ScalaVersion latest_2_13_version = null;
        for (ScalaVersion version : ScalaVersion.values()) {
            String ver = version.getVersion();
            byVersion.put(ver, version);
            if (!version.getVersion().startsWith("2.13.")) continue;
            latest_2_13_version = version;
        }
        assert (latest_2_13_version != null) : "latest Scala 2.13 version cannot be null";
        latest_2_13 = latest_2_13_version;
    }
}

