/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.plugin.description;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.plugin.java.JavaPlugin;
import xyz.janboerman.scalaloader.libs.asm.AnnotationVisitor;
import xyz.janboerman.scalaloader.libs.asm.ClassReader;
import xyz.janboerman.scalaloader.libs.asm.ClassVisitor;
import xyz.janboerman.scalaloader.libs.asm.FieldVisitor;
import xyz.janboerman.scalaloader.libs.asm.MethodVisitor;
import xyz.janboerman.scalaloader.libs.asm.Type;
import xyz.janboerman.scalaloader.plugin.PluginScalaVersion;
import xyz.janboerman.scalaloader.plugin.ScalaPlugin;
import xyz.janboerman.scalaloader.plugin.description.Api;
import xyz.janboerman.scalaloader.plugin.description.ApiVersion;
import xyz.janboerman.scalaloader.plugin.description.CustomScala;
import xyz.janboerman.scalaloader.plugin.description.Scala;
import xyz.janboerman.scalaloader.plugin.description.ScalaVersion;
import xyz.janboerman.scalaloader.plugin.description.Version;

public class DescriptionScanner
extends ClassVisitor {
    private static final int ASM_API = 589824;
    private static final String SCALAPLUGIN_CLASS_NAME = Type.getInternalName(ScalaPlugin.class);
    private static final String JAVAPLUGIN_CLASS_NAME = Type.getInternalName(JavaPlugin.class);
    private static final String JAVA_LANG_OBJECT_CLASS_NAME = Type.getInternalName(Object.class);
    private static final String SCALA_ANNOTATION_DESCRIPTOR = Type.getDescriptor(Scala.class);
    private static final String CUSTOMSCALA_ANNOTATION_DESCRIPTOR = Type.getDescriptor(CustomScala.class);
    private static final String VERSION_ANNOTATION_DESCRIPTOR = Type.getDescriptor(Version.class);
    private static final String API_ANNOTATION_DESCRIPTOR = Type.getDescriptor(Api.class);
    private static final String SCALALIBRARY_ANNOTATION_DESCRIPTOR = Type.getDescriptor(Version.ScalaLibrary.class);
    private String asmClassName;
    private String mainClassCandidate;
    private PluginScalaVersion scalaVersion;
    private ApiVersion bukkitApiVersion;
    private boolean extendsScalaPlugin;
    private boolean extendsJavaPlugin;
    private boolean extendsJavaLangObject;
    private boolean isAbstract;
    private boolean isModule;
    private boolean hasPublicNoArgsConstructor;
    private boolean isObject;

    private DescriptionScanner() {
        super(589824);
    }

    public DescriptionScanner(InputStream classBytes) throws IOException {
        this();
        ClassReader classReader = new ClassReader(classBytes);
        classReader.accept(this, 0);
    }

    public DescriptionScanner(byte[] classBytes) {
        this();
        ClassReader classReader = new ClassReader(classBytes);
        classReader.accept(this, 0);
    }

    public String toString() {
        return "Description{mainClassCandiate=" + this.mainClassCandidate + ",scalaVersion=" + this.scalaVersion + ",bukkitApiVersion=" + (Object)((Object)this.bukkitApiVersion) + ",extendsScalaPluginDirectly=" + this.extendsScalaPlugin + ",extendsJavaPluginDirectly=" + this.extendsJavaPlugin + ",extendsJavaLangObject=" + this.extendsJavaLangObject + ",isAbstract=" + this.isAbstract + ",isModule=" + this.isModule + ",isObject=" + this.isObject + ",hasSuitableConstructor" + this.hasPublicNoArgsConstructor + "}";
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.asmClassName = name;
        this.mainClassCandidate = this.asmClassName.replace('/', '.');
        this.isAbstract = (access & 0x400) == 1024;
        this.isModule = (access & 0x8000) == 32768;
        boolean bl = this.isObject = name.endsWith("$") && (access & 0x10) == 16;
        if (SCALAPLUGIN_CLASS_NAME.equals(superName)) {
            this.extendsScalaPlugin = true;
        } else if (JAVAPLUGIN_CLASS_NAME.equals(superName)) {
            this.extendsJavaPlugin = true;
        } else if (JAVA_LANG_OBJECT_CLASS_NAME.equals(superName)) {
            this.extendsJavaLangObject = true;
        }
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        boolean isPublic;
        boolean isConstructor = "<init>".equals(name);
        boolean isNoArgs = "()V".equals(descriptor);
        boolean bl = isPublic = (1 & access) == 1;
        if (isConstructor && isNoArgs && isPublic) {
            this.hasPublicNoArgsConstructor = true;
        }
        return null;
    }

    @Override
    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        if ("MODULE$".equals(name) && descriptor.equals("L" + this.asmClassName + ";")) {
            this.isObject &= (access & 8) == 8;
        }
        return null;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        if (SCALA_ANNOTATION_DESCRIPTOR.equals(descriptor)) {
            return new ScalaAnnotationVisitor();
        }
        if (CUSTOMSCALA_ANNOTATION_DESCRIPTOR.equals(descriptor)) {
            return new CustomScalaAnnotationVisitor();
        }
        if (API_ANNOTATION_DESCRIPTOR.equals(descriptor)) {
            return new ApiAnnotationVisitor();
        }
        return null;
    }

    public boolean hasClass() {
        return !this.isModule;
    }

    public String getClassName() {
        return this.mainClassCandidate;
    }

    public Optional<String> getMainClass() {
        return Optional.ofNullable(this.mainClassCandidate).filter(x -> !this.isModule).filter(x -> this.getScalaVersion().isPresent()).filter(x -> this.hasPublicNoArgsConstructor || this.isObject).filter(x -> !this.isAbstract).filter(x -> !this.extendsJavaLangObject);
    }

    public Optional<PluginScalaVersion> getScalaVersion() {
        return Optional.ofNullable(this.scalaVersion);
    }

    public Optional<ApiVersion> getBukkitApiVersion() {
        return Optional.ofNullable(this.bukkitApiVersion);
    }

    public boolean extendsScalaPlugin() {
        return this.extendsScalaPlugin;
    }

    public boolean extendsJavaPlugin() {
        return this.extendsJavaPlugin;
    }

    private class ScalaAnnotationVisitor
    extends AnnotationVisitor {
        private ScalaAnnotationVisitor() {
            super(589824);
        }

        @Override
        public void visitEnum(String name, String descriptor, String value) {
            DescriptionScanner.this.scalaVersion = PluginScalaVersion.fromScalaVersion(ScalaVersion.valueOf(value));
        }
    }

    private class CustomScalaAnnotationVisitor
    extends AnnotationVisitor {
        private String version;
        private final Map<String, String> urls;

        private CustomScalaAnnotationVisitor() {
            super(589824);
            this.urls = new HashMap<String, String>();
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, String descriptor) {
            return "value".equals(name) && VERSION_ANNOTATION_DESCRIPTOR.equals(descriptor) ? new AnnotationVisitor(589824){

                @Override
                public void visit(String name, Object value) {
                    switch (name) {
                        case "value": {
                            CustomScalaAnnotationVisitor.this.version = value.toString();
                            break;
                        }
                        case "scalaLibraryUrl": {
                            CustomScalaAnnotationVisitor.this.urls.put("scala-library-url", value.toString());
                            break;
                        }
                        case "scalaReflectUrl": {
                            CustomScalaAnnotationVisitor.this.urls.put("scala-reflect-url", value.toString());
                        }
                    }
                }

                @Override
                public AnnotationVisitor visitArray(String name) {
                    return "scalaLibs".equals(name) ? new AnnotationVisitor(589824){

                        @Override
                        public AnnotationVisitor visitAnnotation(String name, String descriptor) {
                            return SCALALIBRARY_ANNOTATION_DESCRIPTOR.equals(descriptor) ? new AnnotationVisitor(589824){
                                String name;
                                String url;
                                {
                                    this.name = null;
                                    this.url = null;
                                }

                                @Override
                                public void visit(String name, Object value) {
                                    if ("name".equals(name)) {
                                        this.name = (String)value;
                                    } else if ("url".equals(name)) {
                                        this.url = (String)value;
                                    }
                                }

                                @Override
                                public void visitEnd() {
                                    if (this.name != null && this.url != null) {
                                        CustomScalaAnnotationVisitor.this.urls.put(this.name, this.url);
                                    }
                                }
                            } : null;
                        }
                    } : null;
                }
            } : null;
        }

        @Override
        public void visitEnd() {
            DescriptionScanner.this.scalaVersion = new PluginScalaVersion(this.version, this.urls);
        }
    }

    private class ApiAnnotationVisitor
    extends AnnotationVisitor {
        private ApiAnnotationVisitor() {
            super(589824);
        }

        @Override
        public void visitEnum(String name, String descriptor, String value) {
            DescriptionScanner.this.bukkitApiVersion = ApiVersion.valueOf(value);
        }
    }
}

