/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.plugin;

import com.google.common.graph.MutableGraph;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BinaryOperator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.bukkit.Server;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginLoader;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.plugin.SimplePluginManager;
import org.bukkit.plugin.UnknownDependencyException;
import org.bukkit.plugin.java.JavaPlugin;
import org.yaml.snakeyaml.Yaml;
import xyz.janboerman.scalaloader.DebugSettings;
import xyz.janboerman.scalaloader.ScalaLibraryClassLoader;
import xyz.janboerman.scalaloader.ScalaLoader;
import xyz.janboerman.scalaloader.ScalaRelease;
import xyz.janboerman.scalaloader.bytecode.TransformerRegistry;
import xyz.janboerman.scalaloader.compat.Compat;
import xyz.janboerman.scalaloader.configurationserializable.runtime.RuntimeConversions;
import xyz.janboerman.scalaloader.configurationserializable.transform.AddVariantTransformer;
import xyz.janboerman.scalaloader.configurationserializable.transform.GlobalScanResult;
import xyz.janboerman.scalaloader.configurationserializable.transform.GlobalScanner;
import xyz.janboerman.scalaloader.configurationserializable.transform.PluginTransformer;
import xyz.janboerman.scalaloader.dependency.PluginYamlLibraryLoader;
import xyz.janboerman.scalaloader.event.EventBus;
import xyz.janboerman.scalaloader.event.plugin.ScalaPluginDisableEvent;
import xyz.janboerman.scalaloader.event.plugin.ScalaPluginEnableEvent;
import xyz.janboerman.scalaloader.libs.asm.ClassReader;
import xyz.janboerman.scalaloader.plugin.PluginJarScanResult;
import xyz.janboerman.scalaloader.plugin.PluginScalaVersion;
import xyz.janboerman.scalaloader.plugin.ScalaCompatMap;
import xyz.janboerman.scalaloader.plugin.ScalaPlugin;
import xyz.janboerman.scalaloader.plugin.ScalaPluginClassLoader;
import xyz.janboerman.scalaloader.plugin.ScalaPluginDescription;
import xyz.janboerman.scalaloader.plugin.ScalaPluginLoaderException;
import xyz.janboerman.scalaloader.plugin.description.ApiVersion;
import xyz.janboerman.scalaloader.plugin.description.DescriptionScanner;

public class ScalaPluginLoader
implements PluginLoader {
    private static ScalaPluginLoader INSTANCE;
    private final Server server;
    private ScalaLoader lazyScalaLoader;
    private PluginLoader lazyJavaPluginLoader;
    private static final Pattern[] pluginFileFilters;
    private final ConcurrentMap<ScalaRelease, ConcurrentMap<String, Class<?>>> sharedScalaPluginClasses = new ConcurrentHashMap();
    private final ConcurrentMap<ScalaRelease, CopyOnWriteArrayList<ScalaPluginClassLoader>> sharedScalaPluginClassLoaders = new ConcurrentHashMap<ScalaRelease, CopyOnWriteArrayList<ScalaPluginClassLoader>>();
    private final ScalaCompatMap scalaCompatMap = new ScalaCompatMap();
    private final Map<Path, PluginJarScanResult> preScannedPluginJars = new ConcurrentHashMap<Path, PluginJarScanResult>();
    private final Map<String, ScalaPlugin> scalaPlugins = new HashMap<String, ScalaPlugin>();
    private final Map<Path, ScalaPlugin> scalaPluginsByAbsolutePath = new HashMap<Path, ScalaPlugin>();
    private final Collection<ScalaPlugin> scalaPluginsView = Collections.unmodifiableCollection(this.scalaPlugins.values());
    private final Set<File> scalapluginsWaitingForDependencies = new LinkedHashSet<File>();
    private EventBus eventBus;
    private PluginYamlLibraryLoader pluginYamlLibraryLoader;
    private static final Comparator<DescriptionScanner> descriptionComparator;

    public ScalaPluginLoader(ScalaLoader scalaLoader) {
        this.lazyScalaLoader = scalaLoader;
        this.server = scalaLoader.getServer();
        this.init();
    }

    public ScalaPluginLoader(Server server) {
        this.server = Objects.requireNonNull(server, "Server cannot be null!");
        this.init();
    }

    private void init() {
        File[] pluginJarFiles;
        if (INSTANCE != null) {
            throw new IllegalStateException("The ScalaPluginLoader can only be instantiated once!");
        }
        INSTANCE = this;
        ScalaLoader scalaLoader = this.getScalaLoader();
        this.eventBus = new EventBus(this.server.getPluginManager());
        this.pluginYamlLibraryLoader = new PluginYamlLibraryLoader(scalaLoader.getLogger(), new File(scalaLoader.getDataFolder(), "libraries"));
        File pluginsFolder = scalaLoader.getScalaPluginsFolder();
        if (pluginsFolder.exists() && (pluginJarFiles = pluginsFolder.listFiles((dir, name) -> Arrays.stream(this.getPluginFileFilters()).anyMatch(pattern -> pattern.matcher(name).find()))) != null) {
            for (File pluginJarFile : pluginJarFiles) {
                try {
                    PluginJarScanResult scanResult = ScalaPluginLoader.scanJar(pluginJarFile);
                    if (scanResult.isJavaPluginExplicitly) continue;
                    this.preScannedPluginJars.put(pluginJarFile.toPath().toAbsolutePath(), scanResult);
                    scanResult.mainClassCandidate.getScalaVersion().ifPresent(this.scalaCompatMap::add);
                }
                catch (IOException e) {
                    this.getScalaLoader().getLogger().log(Level.SEVERE, "Could not read plugin jar file: " + pluginJarFile.getName(), e);
                }
            }
        }
    }

    public static ScalaPluginLoader getInstance() {
        return INSTANCE;
    }

    ScalaLoader getScalaLoader() {
        return this.lazyScalaLoader == null ? (this.lazyScalaLoader = (ScalaLoader)JavaPlugin.getPlugin(ScalaLoader.class)) : this.lazyScalaLoader;
    }

    PluginLoader getJavaPluginLoader() {
        return this.lazyJavaPluginLoader == null ? (this.lazyJavaPluginLoader = this.getScalaLoader().getPluginLoader()) : this.lazyJavaPluginLoader;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public Collection<ScalaPlugin> getScalaPlugins() {
        return this.scalaPluginsView;
    }

    public DebugSettings debugSettings() {
        return this.getScalaLoader().getDebugSettings();
    }

    private static PluginJarScanResult scanJar(File file) throws IOException {
        InputStream classBytesInputStream;
        DescriptionScanner yamlMainScanner;
        String yamlDefinedMainClassName;
        String mainClassEntry;
        JarEntry pluginYamlDefinedMainJarEntry;
        InputStream pluginYamlInputStream;
        Yaml yaml;
        Logger logger = ScalaPluginLoader.getInstance().getScalaLoader().getLogger();
        PluginJarScanResult result = new PluginJarScanResult();
        HashMap<String, Object> pluginYamlData = null;
        JarFile jarFile = Compat.jarFile(file);
        JarEntry pluginYmlEntry = jarFile.getJarEntry("plugin.yml");
        if (pluginYmlEntry != null && (pluginYamlData = (HashMap<String, Object>)(yaml = new Yaml()).loadAs(pluginYamlInputStream = jarFile.getInputStream(pluginYmlEntry), Map.class)).containsKey("main") && (pluginYamlDefinedMainJarEntry = jarFile.getJarEntry(mainClassEntry = (yamlDefinedMainClassName = pluginYamlData.get("main").toString()).replace('.', '/') + ".class")) != null && (yamlMainScanner = new DescriptionScanner(classBytesInputStream = jarFile.getInputStream(pluginYamlDefinedMainJarEntry))).extendsJavaPlugin()) {
            result.isJavaPluginExplicitly = true;
        }
        if (!result.isJavaPluginExplicitly) {
            TransformerRegistry transformerRegistry = new TransformerRegistry();
            DescriptionScanner mainClassCandidate = null;
            if (pluginYamlData == null) {
                pluginYamlData = new HashMap<String, Object>();
            }
            Enumeration<JarEntry> entryEnumeration = jarFile.entries();
            while (entryEnumeration.hasMoreElements()) {
                JarEntry jarEntry = entryEnumeration.nextElement();
                if (!jarEntry.getName().endsWith(".class")) continue;
                InputStream classBytesInputStream2 = jarFile.getInputStream(jarEntry);
                byte[] classBytes = Compat.readAllBytes(classBytesInputStream2);
                DescriptionScanner descriptionScanner = new DescriptionScanner(classBytes);
                if (descriptionScanner.extendsScalaPlugin() && !descriptionScanner.getScalaVersion().isPresent()) {
                    logger.warning("Class " + jarEntry.getName() + " extends ScalaPlugin but does not have the @Scala or @CustomScala annotation.");
                }
                mainClassCandidate = (DescriptionScanner)BinaryOperator.minBy(descriptionComparator).apply(mainClassCandidate, descriptionScanner);
                GlobalScanResult configSerResult = new GlobalScanner().scan(new ClassReader(classBytes));
                PluginTransformer.addTo(transformerRegistry, configSerResult);
                AddVariantTransformer.addTo(transformerRegistry, configSerResult);
            }
            result.mainClassCandidate = mainClassCandidate;
            result.transformerRegistry = transformerRegistry;
            result.pluginYaml = pluginYamlData;
        }
        return result;
    }

    public PluginDescriptionFile getPluginDescription(File file) throws InvalidDescriptionException {
        Path path = file.toPath().toAbsolutePath();
        ScalaPlugin alreadyPresent = this.scalaPluginsByAbsolutePath.get(path);
        if (alreadyPresent != null) {
            return alreadyPresent.getDescription();
        }
        if (this.scalaPluginsByAbsolutePath.containsKey(path)) {
            return this.getJavaPluginLoader().getPluginDescription(file);
        }
        PluginJarScanResult jarScanResult = this.preScannedPluginJars.get(path);
        if (jarScanResult == null) {
            try {
                jarScanResult = ScalaPluginLoader.scanJar(file);
                if (jarScanResult.isJavaPluginExplicitly) {
                    this.scalaPluginsByAbsolutePath.put(path, null);
                    return this.getJavaPluginLoader().getPluginDescription(file);
                }
            }
            catch (IOException e) {
                throw new InvalidDescriptionException((Throwable)e, "Could not read jar file " + file.getName());
            }
        }
        DescriptionScanner mainClassCandidate = jarScanResult.mainClassCandidate;
        Map<String, Object> pluginYamlData = jarScanResult.pluginYaml;
        TransformerRegistry transformerRegistry = jarScanResult.transformerRegistry;
        if (mainClassCandidate == null || !mainClassCandidate.getMainClass().isPresent()) {
            this.getScalaLoader().getLogger().warning("Could not find main class in file " + file.getName() + ". Did you annotate your main class with @Scala and is it public?");
            this.getScalaLoader().getLogger().warning("Delegating to JavaPluginLoader...");
            this.scalaPluginsByAbsolutePath.put(path, null);
            return this.getJavaPluginLoader().getPluginDescription(file);
        }
        assert (mainClassCandidate.getScalaVersion().isPresent()) : "Plugin main class is present without a PluginScalaVersion o.0";
        ApiVersion apiVersion = mainClassCandidate.getBukkitApiVersion().orElseGet(ApiVersion::latest);
        PluginScalaVersion scalaVersion = mainClassCandidate.getScalaVersion().get();
        try {
            String mainClass = mainClassCandidate.getMainClass().get();
            scalaVersion = this.scalaCompatMap.getLatestVersion(scalaVersion);
            ScalaLibraryClassLoader scalaLibraryClassLoader = this.getScalaLoader().loadOrGetScalaVersion(scalaVersion);
            Collection<File> dependencies = this.pluginYamlLibraryLoader.getJarFiles(pluginYamlData);
            ScalaPluginClassLoader scalaPluginClassLoader = new ScalaPluginClassLoader(this, new URL[]{file.toURI().toURL()}, scalaLibraryClassLoader, this.server, pluginYamlData, file, apiVersion, mainClass, transformerRegistry, dependencies);
            this.sharedScalaPluginClassLoaders.computeIfAbsent(scalaVersion.getCompatRelease(), v -> new CopyOnWriteArrayList()).add(scalaPluginClassLoader);
            ScalaPlugin plugin = scalaPluginClassLoader.getPlugin();
            if (this.scalaPlugins.putIfAbsent(plugin.getName().toLowerCase(), plugin) != null) {
                throw new InvalidDescriptionException("Duplicate plugin names found: " + plugin.getName());
            }
            this.scalaPluginsByAbsolutePath.put(path.toAbsolutePath(), plugin);
            return plugin.getDescription();
        }
        catch (ExceptionInInitializerError | NoClassDefFoundError e) {
            throw new InvalidDescriptionException((Throwable)e, "Your plugin's constructor, initializer or class initializer tried to access classes that were not yet loaded. Try to move stuff over to onLoad() or onEnable().");
        }
        catch (ScalaPluginLoaderException e) {
            throw new InvalidDescriptionException((Throwable)((Object)e), "Failed to create scala library classloader.");
        }
        catch (MalformedURLException e) {
            throw new InvalidDescriptionException((Throwable)e, "Invalid jar file location.");
        }
        catch (IOException e) {
            throw new InvalidDescriptionException((Throwable)e, "Failed to create scala plugin classloader.");
        }
    }

    public JarFile getJarFile(ScalaPlugin scalaPlugin) throws IOException {
        return Compat.jarFile(scalaPlugin.getClassLoader().getPluginJarFile());
    }

    private static void injectClassesIntoJavaPlugin(Stream<? extends Class<?>> classes, JavaPlugin javaPlugin) {
        ClassLoader javaPluginClassLoader = javaPlugin.getClass().getClassLoader();
        try {
            Field field = javaPluginClassLoader.getClass().getField("classes");
            field.setAccessible(true);
            Map classesMap = (Map)field.get(javaPluginClassLoader);
            classes.forEach(clazz -> classesMap.put(clazz.getName(), clazz));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public void openUpToJavaPlugin(ScalaPlugin scalaPlugin, JavaPlugin javaPlugin) {
        try {
            ScalaPluginLoader.injectClassesIntoJavaPlugin(this.getAllClasses(scalaPlugin), javaPlugin);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Stream<? extends Class<?>> getAllClasses(ScalaPlugin scalaPlugin) throws IOException {
        JarFile jarFile = this.getJarFile(scalaPlugin);
        return jarFile.stream().filter(jarEntry -> jarEntry.getName().endsWith(".class")).map(jarEntry -> {
            try {
                return jarFile.getInputStream((ZipEntry)jarEntry);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }).filter(Objects::nonNull).map(inputStream -> {
            try {
                return new DescriptionScanner((InputStream)inputStream);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }).filter(Objects::nonNull).filter(DescriptionScanner::hasClass).map(DescriptionScanner::getClassName).map(className -> {
            try {
                return Class.forName(className, false, scalaPlugin.getClassLoader());
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                e.printStackTrace();
                return null;
            }
        }).filter(Objects::nonNull);
    }

    @Deprecated
    public void forceLoadAllClasses(ScalaPlugin scalaPlugin) {
        try {
            this.getAllClasses(scalaPlugin).forEach(noop -> {});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Plugin loadPlugin(File file) throws InvalidPluginException, UnknownDependencyException {
        ScalaPlugin scalaPlugin;
        Path path = file.toPath().toAbsolutePath();
        ScalaPlugin plugin = scalaPlugin = this.scalaPluginsByAbsolutePath.get(path);
        if (scalaPlugin != null) {
            for (String dependency : scalaPlugin.getScalaDescription().getHardDependencies()) {
                boolean dependencyFound = this.server.getPluginManager().getPlugin(dependency) != null;
                if (dependencyFound) continue;
                throw new UnknownDependencyException("Dependency " + dependency + " not found while loading plugin " + scalaPlugin.getName());
            }
            scalaPlugin.getLogger().info("Loading " + scalaPlugin.getScalaDescription().getFullName());
            scalaPlugin.onLoad();
        } else if (this.scalaPluginsByAbsolutePath.containsKey(path)) {
            plugin = this.getJavaPluginLoader().loadPlugin(file);
        } else {
            try {
                this.getPluginDescription(file);
                assert (this.scalaPluginsByAbsolutePath.containsKey(path)) : "Expected an already-scanned jar on path: " + path;
                return this.loadPlugin(file);
            }
            catch (InvalidDescriptionException e) {
                throw new InvalidPluginException((Throwable)e);
            }
        }
        Iterator<File> fileIterator = this.scalapluginsWaitingForDependencies.iterator();
        while (fileIterator.hasNext()) {
            ScalaPluginDescription desc;
            File dependentFile = fileIterator.next();
            ScalaPlugin dependent = this.scalaPluginsByAbsolutePath.get(dependentFile.toPath().toAbsolutePath());
            if (dependent == null || !(desc = dependent.getScalaDescription()).getHardDependencies().contains(plugin.getName())) continue;
            try {
                desc.moveHardDependencyToSoftDependency(plugin.getName());
                ScalaPlugin lateScalaPlugin = (ScalaPlugin)this.loadPlugin(dependentFile);
                this.addPluginToPluginManager(lateScalaPlugin);
                fileIterator.remove();
            }
            catch (UnknownDependencyException unknownDependencyException) {}
        }
        return plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPluginToPluginManager(ScalaPlugin plugin) {
        PluginManager pluginManager = this.server.getPluginManager();
        synchronized (pluginManager) {
            try {
                Field pluginsField = SimplePluginManager.class.getDeclaredField("plugins");
                pluginsField.setAccessible(true);
                List plugins = (List)pluginsField.get(this.server.getPluginManager());
                plugins.add(plugin);
            }
            catch (Exception tooBad) {
                this.getScalaLoader().getLogger().severe("Could not register plugin to PluginManager: " + plugin.getName());
            }
            Set<String> provides = plugin.getScalaDescription().getProvides();
            if (!provides.isEmpty()) {
                try {
                    Field lookupNamesField = SimplePluginManager.class.getDeclaredField("lookupNames");
                    lookupNamesField.setAccessible(true);
                    Map lookupNames = (Map)lookupNamesField.get(this.server.getPluginManager());
                    lookupNames.put(plugin.getName(), plugin);
                    for (String provide : provides) {
                        lookupNames.putIfAbsent(provide, plugin);
                    }
                }
                catch (Exception tooBad) {
                    this.getScalaLoader().getLogger().severe("Could not register plugin lookupNames to PluginManager: " + plugin.getName());
                }
            }
            Set<String> hardDeps = plugin.getScalaDescription().getHardDependencies();
            Set<String> softDeps = plugin.getScalaDescription().getSoftDependencies();
            Set<String> inverseDeps = plugin.getScalaDescription().getInverseDependencies();
            if (!(hardDeps.isEmpty() && softDeps.isEmpty() && inverseDeps.isEmpty())) {
                try {
                    Field dependencyGraphField = SimplePluginManager.class.getDeclaredField("dependencyGraph");
                    dependencyGraphField.setAccessible(true);
                    MutableGraph dependencyGraph = (MutableGraph)dependencyGraphField.get(this.server.getPluginManager());
                    for (String hardDep : hardDeps) {
                        dependencyGraph.putEdge((Object)plugin.getName(), (Object)hardDep);
                    }
                    for (String softDep : softDeps) {
                        dependencyGraph.putEdge((Object)plugin.getName(), (Object)softDep);
                    }
                    for (String inverseDep : inverseDeps) {
                        dependencyGraph.putEdge((Object)inverseDep, (Object)plugin.getName());
                    }
                }
                catch (NoSuchFieldException dependencyGraphField) {
                }
                catch (Exception e) {
                    this.getScalaLoader().getLogger().severe("Could not register plugin dependencies to PluginManager: " + plugin.getName());
                }
            }
        }
    }

    public void loadWhenDependenciesComeAvailable(File file) {
        this.scalapluginsWaitingForDependencies.add(file);
    }

    public Set<File> getPluginsWaitingForDependencies() {
        return Collections.unmodifiableSet(this.scalapluginsWaitingForDependencies);
    }

    public void clearPluginsWaitingForDependencies() {
        this.scalapluginsWaitingForDependencies.clear();
    }

    public void enablePlugin(Plugin plugin) {
        if (plugin instanceof ScalaPlugin) {
            ScalaPlugin scalaPlugin = (ScalaPlugin)plugin;
            if (scalaPlugin.isEnabled()) {
                return;
            }
            ScalaPluginEnableEvent event = new ScalaPluginEnableEvent(scalaPlugin);
            this.server.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            plugin.getLogger().info("Enabling " + scalaPlugin.getScalaDescription().getFullName());
            scalaPlugin.setEnabled(true);
            scalaPlugin.onEnable();
        } else {
            this.getJavaPluginLoader().enablePlugin(plugin);
        }
    }

    public void disablePlugin(Plugin plugin) {
        if (plugin instanceof ScalaPlugin) {
            CopyOnWriteArrayList classLoaders;
            ScalaPlugin scalaPlugin = (ScalaPlugin)plugin;
            if (!scalaPlugin.isEnabled()) {
                return;
            }
            ScalaPluginDisableEvent event = new ScalaPluginDisableEvent(scalaPlugin);
            this.server.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            plugin.getLogger().info("Disabling " + scalaPlugin.getScalaDescription().getFullName());
            scalaPlugin.onDisable();
            scalaPlugin.setEnabled(false);
            ScalaPluginClassLoader scalaPluginClassLoader = scalaPlugin.getClassLoader();
            RuntimeConversions.clearCodecs(scalaPluginClassLoader);
            ScalaRelease scalaCompatRelease = scalaPluginClassLoader.getScalaRelease();
            Map classes = (Map)this.sharedScalaPluginClasses.get(scalaCompatRelease);
            if (classes != null) {
                scalaPluginClassLoader.getClasses().forEach((className, clazz) -> classes.remove(className, clazz));
                if (classes.isEmpty()) {
                    this.sharedScalaPluginClasses.remove(scalaCompatRelease);
                }
            }
            if ((classLoaders = (CopyOnWriteArrayList)this.sharedScalaPluginClassLoaders.get(scalaCompatRelease)) != null) {
                classLoaders.remove(scalaPluginClassLoader);
                this.sharedScalaPluginClassLoaders.remove(scalaCompatRelease, Compat.emptyList());
            }
            try {
                scalaPluginClassLoader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.getJavaPluginLoader().disablePlugin(plugin);
        }
    }

    public Pattern[] getPluginFileFilters() {
        Pattern[] patterns = this.getScalaLoader().getJavaPluginLoaderPatterns();
        if (patterns != null) {
            return patterns;
        }
        return (Pattern[])pluginFileFilters.clone();
    }

    public Map<Class<? extends Event>, Set<RegisteredListener>> createRegisteredListeners(Listener listener, Plugin plugin) {
        return this.getJavaPluginLoader().createRegisteredListeners(listener, plugin);
    }

    public boolean addClassGlobally(ScalaRelease scalaCompat, String className, Class<?> clazz) {
        if (clazz.getClassLoader() instanceof ScalaLibraryClassLoader) {
            return false;
        }
        return this.cacheClass(scalaCompat, className, clazz) == null;
    }

    protected boolean removeClassGlobally(ScalaRelease scalaCompat, String className, Class<?> clazz) {
        ConcurrentMap classesForThisVersion = (ConcurrentMap)this.sharedScalaPluginClasses.get(scalaCompat);
        if (classesForThisVersion == null) {
            return false;
        }
        return classesForThisVersion.remove(className, clazz);
    }

    private Class<?> cacheClass(ScalaRelease scalaRelease, String className, Class<?> clazz) {
        return this.sharedScalaPluginClasses.computeIfAbsent(scalaRelease, version -> new ConcurrentHashMap()).putIfAbsent(className, clazz);
    }

    protected Class<?> getScalaPluginClass(ScalaRelease scalaCompatRelease, String className) throws ClassNotFoundException {
        Class<?> found;
        Map scalaPluginClasses = (Map)this.sharedScalaPluginClasses.get(scalaCompatRelease);
        Class<?> clazz = found = scalaPluginClasses == null ? null : (Class<?>)scalaPluginClasses.get(className);
        if (found != null) {
            return found;
        }
        CopyOnWriteArrayList classLoaders = (CopyOnWriteArrayList)this.sharedScalaPluginClassLoaders.get(scalaCompatRelease);
        if (classLoaders != null) {
            for (ScalaPluginClassLoader scalaPluginClassLoader : classLoaders) {
                try {
                    found = scalaPluginClassLoader.findClass(className, false);
                    Class<?> classLoadedByOtherThread = this.cacheClass(scalaCompatRelease, className, found);
                    if (classLoadedByOtherThread != null) {
                        found = classLoadedByOtherThread;
                    }
                    return found;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        throw new ClassNotFoundException("Couldn't find class " + className + " in any of the loaded ScalaPlugins.");
    }

    static {
        pluginFileFilters = new Pattern[]{Pattern.compile("\\.jar$")};
        Comparator<Optional> optionalComparator = Comparator.comparing(optional -> !optional.isPresent());
        Comparator<String> packageComparator = Comparator.comparing(className -> className.split("\\."), Comparator.comparing(array -> ((String[])array).length));
        descriptionComparator = Comparator.nullsLast(Comparator.comparing(DescriptionScanner::getMainClass, optionalComparator).thenComparing(DescriptionScanner::extendsScalaPlugin).thenComparing(DescriptionScanner::getClassName, packageComparator).thenComparing(DescriptionScanner::getClassName));
    }
}

