/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.plugin;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginLoadOrder;
import org.yaml.snakeyaml.Yaml;
import xyz.janboerman.scalaloader.compat.Compat;

public class ScalaPluginDescription {
    private static final PermissionDefault PERMISSION_DEFAULT = org.bukkit.permissions.Permission.DEFAULT_PERMISSION;
    private final String pluginName;
    private final String pluginVersion;
    private String apiVersion;
    private String main;
    private Map<String, Object> addYaml;
    private String pluginDescription;
    private List<String> authors = new LinkedList<String>();
    private LinkedHashSet<String> contributors = new LinkedHashSet();
    private String prefix;
    private String website;
    private PluginLoadOrder loadOrder;
    private final LinkedHashSet<String> hardDependencies = new LinkedHashSet();
    private final LinkedHashSet<String> softDependencies = new LinkedHashSet();
    private final LinkedHashSet<String> inverseDependencies;
    private final LinkedHashSet<String> provides;
    private PermissionDefault permissionDefault;
    private final LinkedHashSet<Command> commands;
    private final LinkedHashSet<Permission> permissions;

    public ScalaPluginDescription(String pluginName, String pluginVersion) {
        this.addSoftDepend("ScalaLoader");
        this.inverseDependencies = new LinkedHashSet();
        this.provides = new LinkedHashSet();
        this.permissionDefault = PERMISSION_DEFAULT;
        this.commands = new LinkedHashSet();
        this.permissions = new LinkedHashSet();
        this.pluginName = Objects.requireNonNull(pluginName, "Plugin name cannot be null!");
        this.pluginVersion = Objects.requireNonNull(pluginVersion, "Plugin scalaVersion cannot be null!");
    }

    protected void setApiVersion(String bukkitApiVersion) {
        this.apiVersion = bukkitApiVersion;
    }

    protected void setMain(String mainClass) {
        this.main = mainClass;
    }

    protected void addYaml(Map<String, Object> yaml) {
        this.addYaml = yaml;
    }

    public String getName() {
        return this.pluginName;
    }

    public String getVersion() {
        return this.pluginVersion;
    }

    public String getFullName() {
        return this.getName() + " v" + this.getVersion();
    }

    public ScalaPluginDescription description(String pluginDescription) {
        this.pluginDescription = pluginDescription;
        return this;
    }

    public String getDescription() {
        return this.pluginDescription;
    }

    public ScalaPluginDescription authors(String ... authors) {
        this.authors = new ArrayList<String>(Compat.listOf(authors));
        return this;
    }

    public ScalaPluginDescription addAuthor(String author) {
        this.authors.add(author);
        return this;
    }

    public List<String> getAuthors() {
        return Collections.unmodifiableList(this.authors);
    }

    public ScalaPluginDescription contributors(String ... contributors) {
        this.contributors = new LinkedHashSet<String>(Compat.listOf(contributors));
        return this;
    }

    public ScalaPluginDescription addContributor(String contributor) {
        this.contributors.add(contributor);
        return this;
    }

    public Collection<String> getContributors() {
        return Collections.unmodifiableCollection(this.contributors);
    }

    public ScalaPluginDescription loadOrder(PluginLoadOrder loadOrder) {
        this.loadOrder = loadOrder;
        return this;
    }

    public PluginLoadOrder getLoadOrder() {
        return this.loadOrder;
    }

    public ScalaPluginDescription website(String website) {
        this.website = website;
        return this;
    }

    public String getWebsite() {
        return this.website;
    }

    public ScalaPluginDescription prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String getPrefix() {
        return this.prefix == null ? this.getName() : this.prefix;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public ScalaPluginDescription hardDepend(String ... dependencies) {
        this.hardDependencies.clear();
        Collections.addAll(this.hardDependencies, dependencies);
        return this;
    }

    public ScalaPluginDescription addHardDepend(String dependency) {
        this.hardDependencies.add(dependency);
        return this;
    }

    public Set<String> getHardDependencies() {
        return Collections.unmodifiableSet(this.hardDependencies);
    }

    public ScalaPluginDescription moveHardDependencyToSoftDependency(String dependency) {
        if (this.hardDependencies.remove(dependency)) {
            this.addSoftDepend(dependency);
        }
        return this;
    }

    public ScalaPluginDescription softDepend(String ... dependencies) {
        this.softDependencies.clear();
        this.softDependencies.add("ScalaLoader");
        Collections.addAll(this.softDependencies, dependencies);
        return this;
    }

    public ScalaPluginDescription addSoftDepend(String dependency) {
        this.softDependencies.add(dependency);
        return this;
    }

    public Set<String> getSoftDependencies() {
        return Collections.unmodifiableSet(this.softDependencies);
    }

    public ScalaPluginDescription loadBefore(String ... inverseDependencies) {
        this.inverseDependencies.clear();
        Collections.addAll(this.inverseDependencies, inverseDependencies);
        return this;
    }

    public ScalaPluginDescription addLoadBefore(String inverseDependency) {
        this.inverseDependencies.add(inverseDependency);
        return this;
    }

    public Set<String> getInverseDependencies() {
        return Collections.unmodifiableSet(this.inverseDependencies);
    }

    public ScalaPluginDescription provides(String ... pluginApis) {
        this.provides.clear();
        Collections.addAll(this.provides, pluginApis);
        return this;
    }

    public ScalaPluginDescription addProvides(String pluginApi) {
        this.provides.add(pluginApi);
        return this;
    }

    public Set<String> getProvides() {
        return Collections.unmodifiableSet(this.provides);
    }

    public ScalaPluginDescription permissionDefault(PermissionDefault permissionDefault) {
        this.permissionDefault = permissionDefault;
        return this;
    }

    public PermissionDefault getPermissionDefault() {
        return this.permissionDefault;
    }

    public ScalaPluginDescription commands(Command ... commands) {
        this.commands.clear();
        Collections.addAll(this.commands, commands);
        return this;
    }

    public ScalaPluginDescription addCommand(Command command) {
        this.commands.add(command);
        return this;
    }

    public Collection<Command> getCommands() {
        return Collections.unmodifiableSet(this.commands);
    }

    public ScalaPluginDescription permissions(Permission ... permissions) {
        this.permissions.clear();
        Collections.addAll(this.permissions, permissions);
        return this;
    }

    public ScalaPluginDescription addPermission(Permission permission) {
        this.permissions.add(permission);
        return this;
    }

    public Collection<Permission> getPermissions() {
        return Collections.unmodifiableSet(this.permissions);
    }

    public PluginDescriptionFile toPluginDescriptionFile() {
        HashMap<String, Object> pluginData = new HashMap<String, Object>();
        if (this.addYaml != null) {
            pluginData.putAll(this.addYaml);
        }
        pluginData.put("name", this.pluginName);
        pluginData.put("version", this.pluginVersion);
        pluginData.put("main", this.main);
        if (this.pluginDescription != null) {
            pluginData.put("description", this.pluginDescription);
        }
        if (this.authors != null && !this.authors.isEmpty()) {
            pluginData.put("authors", Compat.listCopy(this.authors));
        }
        if (this.contributors != null && !this.contributors.isEmpty()) {
            pluginData.put("contributors", Compat.listCopy(this.contributors));
        }
        if (this.website != null) {
            pluginData.put("website", this.getWebsite());
        }
        if (this.prefix != null) {
            pluginData.put("prefix", this.prefix);
        }
        if (this.apiVersion != null) {
            pluginData.put("api-version", this.apiVersion);
        }
        if (this.loadOrder != null) {
            pluginData.put("load", this.loadOrder.name());
        }
        if (this.permissionDefault != null) {
            pluginData.put("default-permission", this.permissionDefault.name());
        }
        if (!this.hardDependencies.isEmpty()) {
            pluginData.put("depend", Compat.listCopy(this.hardDependencies));
        }
        if (!this.softDependencies.isEmpty()) {
            pluginData.put("softdepend", Compat.listCopy(this.softDependencies));
        }
        if (!this.inverseDependencies.isEmpty()) {
            pluginData.put("loadbefore", Compat.listCopy(this.inverseDependencies));
        }
        if (!this.provides.isEmpty()) {
            pluginData.put("provides", Compat.listCopy(this.provides));
        }
        if (!this.commands.isEmpty()) {
            HashMap commandsMap = new HashMap();
            for (Command command : this.getCommands()) {
                HashMap<String, List<String>> currentCommand = new HashMap<String, List<String>>();
                command.getDescription().ifPresent(description -> currentCommand.put("description", (List<String>)description));
                command.getUsage().ifPresent(usage -> currentCommand.put("usage", (List<String>)usage));
                command.getPermission().ifPresent(permission -> currentCommand.put("permission", (List<String>)permission));
                command.getPermissionMessage().ifPresent(permissionMessage -> currentCommand.put("permission-message", (List<String>)permissionMessage));
                Collection<String> aliases = command.getAliases();
                if (!aliases.isEmpty()) {
                    currentCommand.put("aliases", Compat.listCopy(aliases));
                }
                commandsMap.put(command.getName(), currentCommand);
            }
            pluginData.put("commands", commandsMap);
        }
        if (!this.permissions.isEmpty()) {
            HashMap<String, Map<String, Object>> permissionsMap = new HashMap<String, Map<String, Object>>();
            for (Permission permission2 : this.getPermissions()) {
                Map<String, Object> currentPermission = ScalaPluginDescription.createPermissionMap(permission2, this.getPermissionDefault());
                permissionsMap.put(permission2.getName(), currentPermission);
            }
            pluginData.put("permissions", permissionsMap);
        }
        Yaml yaml = new Yaml();
        String pluginYaml = yaml.dump(pluginData);
        try {
            return new PluginDescriptionFile((Reader)new StringReader(pluginYaml));
        }
        catch (InvalidDescriptionException impossibru) {
            impossibru.printStackTrace();
            return null;
        }
    }

    private static Map<String, Object> createPermissionMap(Permission permission, PermissionDefault parentDefault) {
        HashMap<String, Object> currentPermission = new HashMap<String, Object>();
        permission.getDescription().ifPresent(description -> currentPermission.put("description", description));
        PermissionDefault permissionDefault = permission.getDefault().orElse(parentDefault);
        currentPermission.put("default", permissionDefault.name());
        Collection<Permission> children = permission.getChildren();
        if (!children.isEmpty()) {
            HashMap<String, Map<String, Object>> childrenMap = new HashMap<String, Map<String, Object>>();
            for (Permission child : children) {
                childrenMap.put(child.getName(), ScalaPluginDescription.createPermissionMap(child, permissionDefault));
            }
            currentPermission.put("children", childrenMap);
        }
        return currentPermission;
    }

    protected void readFromPluginYamlData(Map<String, Object> pluginYaml) {
        Map permissions;
        Map commands;
        List provides;
        List inverseDepend;
        List softDepend;
        List depend;
        String defaultPermissionDefault;
        Iterable contributors;
        Iterable authors;
        this.addYaml(pluginYaml);
        Object apiVersion = pluginYaml.get("api-version");
        if (apiVersion != null) {
            this.setApiVersion(String.valueOf(apiVersion));
        }
        this.description((String)pluginYaml.get("description"));
        String author = (String)pluginYaml.get("author");
        if (author != null) {
            this.addAuthor(author);
        }
        if ((authors = (Iterable)pluginYaml.get("authors")) != null) {
            for (Object auth : authors) {
                if (auth == null) continue;
                this.addAuthor(auth.toString());
            }
        }
        if ((contributors = (Iterable)pluginYaml.get("contributors")) != null) {
            for (Object contrib : contributors) {
                if (contrib == null) continue;
                this.addContributor(contrib.toString());
            }
        }
        this.website((String)pluginYaml.get("website"));
        this.prefix((String)pluginYaml.get("prefix"));
        String load = (String)pluginYaml.get("load");
        if (load != null) {
            this.loadOrder(PluginLoadOrder.valueOf((String)load));
        }
        if ((defaultPermissionDefault = (String)pluginYaml.get("default-permission")) != null) {
            this.permissionDefault(PermissionDefault.getByName((String)defaultPermissionDefault));
        }
        if ((depend = (List)pluginYaml.get("depend")) != null) {
            for (Object dep : depend) {
                if (dep == null) continue;
                this.addHardDepend((String)dep);
            }
        }
        if ((softDepend = (List)pluginYaml.get("softdepend")) != null) {
            for (Object softDep : softDepend) {
                if (softDep == null) continue;
                this.addSoftDepend((String)softDep);
            }
        }
        if ((inverseDepend = (List)pluginYaml.get("loadbefore")) != null) {
            for (String inverseDep : inverseDepend) {
                if (inverseDep == null) continue;
                this.addLoadBefore(inverseDep);
            }
        }
        if ((provides = (List)pluginYaml.get("provides")) != null) {
            this.provides(provides.toArray(new String[0]));
        }
        if ((commands = (Map)pluginYaml.get("commands")) != null) {
            for (Map.Entry entry : commands.entrySet()) {
                String cmdName = (String)entry.getKey();
                Map value = (Map)entry.getValue();
                Command cmd = new Command(cmdName);
                cmd.description((String)value.get("description"));
                cmd.usage((String)value.get("usage"));
                cmd.permission((String)value.get("permission"));
                cmd.permissionMessage((String)value.get("permission-message"));
                Iterable aliases = (Iterable)value.get("aliases");
                for (Object alias : aliases) {
                    cmd.addAlias(alias.toString());
                }
                this.addCommand(cmd);
            }
        }
        if ((permissions = (Map)pluginYaml.get("permissions")) != null) {
            for (Map.Entry entry : permissions.entrySet()) {
                String permissionName = (String)entry.getKey();
                Map properties = (Map)entry.getValue();
                Permission perm = ScalaPluginDescription.makePermission(permissionName, properties);
                this.addPermission(perm);
            }
        }
    }

    private static Permission makePermission(String name, Map<String, Object> properties) {
        Permission perm;
        block4: {
            Object children;
            block3: {
                perm = new Permission(name);
                perm.description((String)properties.get("description"));
                String def = (String)properties.get("default");
                if (def != null) {
                    perm.permissionDefault(PermissionDefault.getByName((String)def));
                }
                if (!((children = properties.get("children")) instanceof Iterable)) break block3;
                Iterable kids = (Iterable)children;
                for (Object kid : kids) {
                    perm.addChild(new Permission(kid.toString()));
                }
                break block4;
            }
            if (!(children instanceof Map)) break block4;
            Map kids = (Map)children;
            for (Map.Entry kid : kids.entrySet()) {
                perm.addChild(ScalaPluginDescription.makePermission((String)kid.getKey(), (Map)kid.getValue()));
            }
        }
        return perm;
    }

    public static class Command {
        private final String name;
        private String description;
        private String usage;
        private LinkedHashSet<String> aliases;
        private String permission;
        private String permissionMessage;

        public Command(String name) {
            this.name = Objects.requireNonNull(name, "Command name cannot be null");
        }

        public Command description(String description) {
            this.description = description;
            return this;
        }

        public Command usage(String usage) {
            this.usage = usage;
            return this;
        }

        public Command aliases(String ... aliases) {
            this.aliases = new LinkedHashSet<String>(Arrays.asList(aliases));
            return this;
        }

        public Command addAlias(String alias) {
            if (alias == null) {
                this.aliases = new LinkedHashSet();
            }
            this.aliases.add(alias);
            return this;
        }

        public Command permission(String permission) {
            this.permission = permission;
            return this;
        }

        public Command permissionMessage(String permissionMessage) {
            this.permissionMessage = permissionMessage;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Optional<String> getDescription() {
            return Optional.ofNullable(this.description);
        }

        public Optional<String> getUsage() {
            return Optional.ofNullable(this.usage);
        }

        public Collection<String> getAliases() {
            return this.aliases == null ? Compat.emptyList() : Collections.unmodifiableSet(this.aliases);
        }

        public Optional<String> getPermission() {
            return Optional.ofNullable(this.permission);
        }

        public Optional<String> getPermissionMessage() {
            return Optional.ofNullable(this.permissionMessage);
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof Command)) {
                return false;
            }
            Command that = (Command)other;
            return Objects.equals(this.getName(), that.getName());
        }

        public int hashCode() {
            return this.getName().hashCode();
        }
    }

    public static class Permission {
        private final String name;
        private String description;
        private PermissionDefault permissionDefault;
        private LinkedHashSet<Permission> children;

        public Permission(String name) {
            this.name = Objects.requireNonNull(name, "Permission name cannot be null");
        }

        public Permission description(String description) {
            this.description = description;
            return this;
        }

        public Permission permissionDefault(PermissionDefault permissionDefault) {
            this.permissionDefault = permissionDefault;
            return this;
        }

        public Permission children(Permission ... children) {
            this.children = new LinkedHashSet<Permission>(Arrays.asList(children));
            return this;
        }

        public Permission addChild(Permission child) {
            if (this.children == null) {
                this.children = new LinkedHashSet();
            }
            this.children.add(child);
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Optional<String> getDescription() {
            return Optional.ofNullable(this.description);
        }

        public Optional<PermissionDefault> getDefault() {
            return Optional.ofNullable(this.permissionDefault);
        }

        public Collection<Permission> getChildren() {
            return this.children == null ? Compat.emptySet() : Collections.unmodifiableSet(this.children);
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof Permission)) {
                return false;
            }
            Permission that = (Permission)other;
            return Objects.equals(this.getName(), that.getName());
        }

        public int hashCode() {
            return this.getName().hashCode();
        }
    }
}

