/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.plugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.plugin.PluginLoader;
import org.bukkit.plugin.java.JavaPluginLoader;
import xyz.janboerman.scalaloader.DebugSettings;
import xyz.janboerman.scalaloader.ScalaLibraryClassLoader;
import xyz.janboerman.scalaloader.ScalaRelease;
import xyz.janboerman.scalaloader.bytecode.Called;
import xyz.janboerman.scalaloader.bytecode.TransformerRegistry;
import xyz.janboerman.scalaloader.compat.Compat;
import xyz.janboerman.scalaloader.dependency.LibraryClassLoader;
import xyz.janboerman.scalaloader.libs.asm.ClassReader;
import xyz.janboerman.scalaloader.libs.asm.ClassVisitor;
import xyz.janboerman.scalaloader.libs.asm.ClassWriter;
import xyz.janboerman.scalaloader.libs.asm.util.ASMifier;
import xyz.janboerman.scalaloader.libs.asm.util.Printer;
import xyz.janboerman.scalaloader.libs.asm.util.Textifier;
import xyz.janboerman.scalaloader.libs.asm.util.TraceClassVisitor;
import xyz.janboerman.scalaloader.plugin.ScalaPlugin;
import xyz.janboerman.scalaloader.plugin.ScalaPluginLoader;
import xyz.janboerman.scalaloader.plugin.ScalaPluginLoaderException;
import xyz.janboerman.scalaloader.plugin.description.ApiVersion;
import xyz.janboerman.scalaloader.plugin.runtime.ClassDefineResult;
import xyz.janboerman.scalaloader.plugin.runtime.ClassFile;
import xyz.janboerman.scalaloader.plugin.runtime.ClassGenerator;
import xyz.janboerman.scalaloader.plugin.runtime.PersistentClasses;
import xyz.janboerman.scalaloader.util.ClassLoaderUtils;

@Called
public class ScalaPluginClassLoader
extends URLClassLoader {
    private final String scalaVersion;
    private final ScalaRelease scalaRelease;
    private final ScalaPluginLoader pluginLoader;
    private final Server server;
    private final Map<String, Object> extraPluginYaml;
    private final File pluginJarFile;
    private final JarFile jarFile;
    private final ApiVersion apiVersion;
    private final String mainClassName;
    private final TransformerRegistry transformerRegistry;
    private final ConcurrentMap<String, Class<?>> classes = new ConcurrentHashMap();
    private final ScalaPlugin plugin;
    private final PersistentClasses persistentClasses;
    private final LibraryClassLoader libraryLoader;
    private Boolean canInjectIntoJavaPluginLoaderScope;
    private Boolean scalaLoaderClassLoaderParallelCapable = null;

    protected ScalaPluginClassLoader(ScalaPluginLoader pluginLoader, URL[] urls, ScalaLibraryClassLoader parent, Server server, Map<String, Object> extraPluginYaml, File pluginJarFile, ApiVersion apiVersion, String mainClassName, TransformerRegistry transformerRegistry, Collection<File> dependencies) throws IOException, ScalaPluginLoaderException {
        super(urls, (ClassLoader)parent);
        this.pluginLoader = pluginLoader;
        this.scalaVersion = parent.getScalaVersion();
        this.scalaRelease = ScalaRelease.fromScalaVersion(this.scalaVersion);
        this.server = server;
        this.extraPluginYaml = extraPluginYaml;
        this.pluginJarFile = pluginJarFile;
        this.jarFile = Compat.jarFile(pluginJarFile);
        this.apiVersion = apiVersion;
        this.mainClassName = mainClassName;
        this.transformerRegistry = transformerRegistry;
        this.libraryLoader = new LibraryClassLoader(dependencies.toArray(new File[dependencies.size()]), parent, pluginLoader.getScalaLoader().getLogger(), this, transformerRegistry);
        try {
            this.plugin = ScalaPluginClassLoader.createPluginInstance(Class.forName(mainClassName, true, this));
        }
        catch (ClassNotFoundException e) {
            throw new ScalaPluginLoaderException("Could not find plugin's main class: " + mainClassName, e);
        }
        this.persistentClasses = new PersistentClasses(this.plugin);
        for (ClassFile classFile : this.persistentClasses.load()) {
            Class<?> clazz;
            ClassDefineResult cdr = this.getOrDefineClass(classFile.getClassName(), name -> classFile.getByteCode(false), false);
            if (!cdr.isNew() || !ConfigurationSerializable.class.isAssignableFrom(clazz = cdr.getClassDefinition())) continue;
            Class<?> cls = clazz;
            ConfigurationSerialization.registerClass(cls, (String)ConfigurationSerialization.getAlias(cls));
        }
    }

    public ScalaPlugin getPlugin() {
        return this.plugin;
    }

    public String getScalaVersion() {
        return this.scalaVersion;
    }

    public ScalaRelease getScalaRelease() {
        return this.scalaRelease;
    }

    public ScalaPluginLoader getPluginLoader() {
        return this.pluginLoader;
    }

    public Server getServer() {
        return this.server;
    }

    public Map<String, Object> getExtraPluginYaml() {
        return this.extraPluginYaml;
    }

    public File getPluginJarFile() {
        return this.pluginJarFile;
    }

    public ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public String getMainClassName() {
        return this.mainClassName;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> clazz;
        if (name.startsWith("scala.") || name.startsWith("dotty.")) {
            try {
                return this.getParent().loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        ClassNotFoundException fallback = new ClassNotFoundException(name);
        try {
            clazz = this.findClass(name, true);
            if (clazz != null) {
                return clazz;
            }
        }
        catch (ClassNotFoundException e) {
            fallback.addSuppressed(e);
        }
        try {
            if (name.startsWith("xyz.janboerman.scalaloader") && (name.startsWith("xyz.janboerman.scalaloader.bytecode") || name.startsWith("xyz.janboerman.scalaloader.configurationserializable.transform") || name.startsWith("xyz.janboerman.scalaloader.event.transform") || name.startsWith("xyz.janboerman.scalaloader.compat") || name.startsWith("xyz.janboerman.scalaloader.util") || name.startsWith("xyz.janboerman.scalaloader.commands") || name.startsWith("xyz.janboerman.scalaloader.dependency") || name.equals("xyz.janboerman.scalaloader.plugin.runtime.PersistentClasses"))) {
                throw new ClassNotFoundException("Can't access internal class: " + name);
            }
            clazz = this.getParent().loadClass(name);
            if (clazz != null) {
                return clazz;
            }
        }
        catch (ClassNotFoundException e) {
            fallback.addSuppressed(e);
        }
        throw fallback;
    }

    private void debugClass(String className, byte[] bytecode) {
        DebugSettings debugSettings = this.getPluginLoader().debugSettings();
        if (debugSettings.isDebuggingClassLoadOf(className)) {
            Printer debugPrinter;
            switch (debugSettings.getFormat()) {
                case "ASMified": {
                    debugPrinter = new ASMifier();
                    break;
                }
                default: {
                    debugPrinter = new Textifier();
                }
            }
            this.getPluginLoader().getScalaLoader().getLogger().info("[DEBUG] Dumping bytecode for class " + className);
            ClassReader debugReader = new ClassReader(bytecode);
            TraceClassVisitor traceClassVisitor = new TraceClassVisitor(null, debugPrinter, new PrintWriter(System.out));
            debugReader.accept(traceClassVisitor, 0);
        }
    }

    public Class<?> findClass(String name, boolean searchInScalaPluginLoader) throws ClassNotFoundException {
        Class<?> found;
        block26: {
            found = (Class<?>)this.classes.get(name);
            if (found != null) {
                return found;
            }
            try {
                String path = name.replace('.', '/') + ".class";
                JarEntry jarEntry = this.jarFile.getJarEntry(path);
                if (jarEntry == null) break block26;
                try (InputStream inputStream = this.jarFile.getInputStream(jarEntry);){
                    byte[] classBytes;
                    block27: {
                        String packageName;
                        ClassWriter classWriter;
                        classBytes = Compat.readAllBytes(inputStream);
                        classBytes = ClassLoaderUtils.transform(name, classBytes, this, this.transformerRegistry, this, this.getPluginLoader().getScalaLoader().getLogger());
                        ClassVisitor classVisitor = classWriter = new ClassWriter(0){

                            @Override
                            protected ClassLoader getClassLoader() {
                                return ScalaPluginClassLoader.this;
                            }
                        };
                        if (name.equals(this.mainClassName)) {
                            for (BiFunction<ClassVisitor, String, ClassVisitor> mainClassTransformer : this.transformerRegistry.mainClassTransformers) {
                                classVisitor = mainClassTransformer.apply(classVisitor, this.mainClassName);
                            }
                        }
                        if (classVisitor != classWriter) {
                            ClassReader classreader = new ClassReader(classBytes);
                            classreader.accept(classVisitor, 0);
                            classBytes = classWriter.toByteArray();
                        }
                        this.debugClass(name, classBytes);
                        int dotIndex = name.lastIndexOf(46);
                        if (dotIndex != -1 && this.getPackage(packageName = name.substring(0, dotIndex)) == null) {
                            try {
                                Manifest manifest = this.jarFile.getManifest();
                                if (manifest != null) {
                                    this.definePackage(packageName, manifest, this.getURLs()[0]);
                                } else {
                                    this.definePackage(packageName, null, null, null, null, null, null, null);
                                }
                            }
                            catch (IllegalArgumentException e) {
                                if (this.getPackage(packageName) != null) break block27;
                                throw new IllegalStateException("Cannot find package " + packageName);
                            }
                        }
                    }
                    CodeSigner[] codeSigners = jarEntry.getCodeSigners();
                    CodeSource codeSource = new CodeSource(this.getURLs()[0], codeSigners);
                    found = this.defineClass(name, classBytes, 0, classBytes.length, codeSource);
                }
                catch (IOException e) {
                    throw new ClassNotFoundException(name, e);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (found == null) {
            try {
                found = this.libraryLoader.findClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (found == null && searchInScalaPluginLoader) {
            try {
                found = this.pluginLoader.getScalaPluginClass(this.getScalaRelease(), name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (found == null) {
            throw new ClassNotFoundException(name);
        }
        found = this.addClass(found);
        return found;
    }

    public Class<?> addClass(Class<?> toAdd) {
        String name = toAdd.getName();
        Class<?> loadedConcurrently = this.classes.putIfAbsent(name, toAdd);
        if (loadedConcurrently == null) {
            if (this.pluginLoader.addClassGlobally(this.getScalaRelease(), name, toAdd) && this.canInjectIntoJavaPluginLoaderScope()) {
                this.injectIntoJavaPluginLoaderScope(name, toAdd);
            }
            return toAdd;
        }
        return loadedConcurrently;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassDefineResult getOrDefineClass(String className, ClassGenerator classGenerator, boolean persist) {
        boolean isNew;
        Class<?> clazz;
        Class oldClass = (Class)this.classes.get(className);
        if (oldClass != null) {
            return ClassDefineResult.oldClass(oldClass);
        }
        byte[] byteCode = classGenerator.generate(className);
        this.debugClass(className, byteCode);
        Object object = this.getClassLoadingLock(className);
        synchronized (object) {
            Class<?> existingClass = (Class<?>)this.classes.get(className);
            if (existingClass == null) {
                Class<?> definition = this.defineClass(className, byteCode, 0, byteCode.length);
                clazz = this.addClass(definition);
                isNew = true;
            } else {
                clazz = existingClass;
                isNew = false;
            }
        }
        if (isNew) {
            if (persist) {
                this.persistentClasses.save(new ClassFile(className, byteCode));
            }
            return ClassDefineResult.newClass(clazz);
        }
        return ClassDefineResult.oldClass(clazz);
    }

    @Override
    public URL getResource(String resourcePath) {
        return this.findResource(resourcePath);
    }

    @Override
    public Enumeration<URL> getResources(String resourcePath) throws IOException {
        return this.findResources(resourcePath);
    }

    protected final Map<String, Class<?>> getClasses() {
        return Collections.unmodifiableMap(this.classes);
    }

    private static <P extends ScalaPlugin> P createPluginInstance(Class<P> clazz) throws ScalaPluginLoaderException {
        boolean isObjectSingleton;
        boolean hasStaticFinalModule$;
        Field module$Field;
        boolean endsWithDollar = clazz.getName().endsWith("$");
        try {
            module$Field = clazz.getDeclaredField("MODULE$");
            int modifiers = module$Field.getModifiers();
            hasStaticFinalModule$ = module$Field.getType().equals(clazz) && (modifiers & 8) == 8 && (modifiers & 0x10) == 16;
        }
        catch (NoSuchFieldException e) {
            hasStaticFinalModule$ = false;
            module$Field = null;
        }
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        boolean hasPrivateConstructor = constructors.length == 1 && (constructors[0].getModifiers() & 2) == 2;
        boolean bl = isObjectSingleton = endsWithDollar && hasStaticFinalModule$ && hasPrivateConstructor;
        if (isObjectSingleton) {
            try {
                Object pluginInstance = module$Field.get(null);
                return (P)((ScalaPlugin)clazz.cast(pluginInstance));
            }
            catch (IllegalAccessException e) {
                throw new ScalaPluginLoaderException("Couldn't access static field MODULE$ in class " + clazz.getName(), e);
            }
        }
        try {
            Constructor<P> ctr = clazz.getConstructor(new Class[0]);
            P pluginInstance = ctr.newInstance(new Object[0]);
            return (P)((ScalaPlugin)clazz.cast(pluginInstance));
        }
        catch (IllegalAccessException e) {
            throw new ScalaPluginLoaderException("Could not access the NoArgsConstructor of " + clazz.getName() + ", please make it public", e);
        }
        catch (InvocationTargetException e) {
            throw new ScalaPluginLoaderException("Error instantiating class " + clazz.getName() + ", its constructor threw something at us", e);
        }
        catch (NoSuchMethodException e) {
            throw new ScalaPluginLoaderException("Could not find NoArgsConstructor in class " + clazz.getName(), e);
        }
        catch (InstantiationException e) {
            throw new ScalaPluginLoaderException("Could not instantiate class " + clazz.getName(), e);
        }
    }

    @Deprecated
    protected final void injectIntoJavaPluginLoaderScope(String className, Class<?> clazz) {
        PluginLoader likelyJavaPluginLoader = this.pluginLoader.getJavaPluginLoader();
        if (likelyJavaPluginLoader instanceof JavaPluginLoader) {
            JavaPluginLoader javaPluginLoader = (JavaPluginLoader)likelyJavaPluginLoader;
            Runnable setClass = () -> {
                try {
                    Method method = javaPluginLoader.getClass().getDeclaredMethod("setClass", String.class, Class.class);
                    method.setAccessible(true);
                    method.invoke((Object)javaPluginLoader, className, clazz);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            };
            if (this.javaPluginClassLoaderParallelCapable()) {
                setClass.run();
            } else {
                this.pluginLoader.getScalaLoader().runInMainThread(setClass);
            }
        }
    }

    @Deprecated
    protected final void removeFromJavaPluginLoaderScope(String className) {
        PluginLoader likelyJavaPluginLoader = this.pluginLoader.getJavaPluginLoader();
        if (likelyJavaPluginLoader instanceof JavaPluginLoader) {
            JavaPluginLoader javaPluginLoader = (JavaPluginLoader)likelyJavaPluginLoader;
            Runnable removeClass = () -> {
                try {
                    Method method = javaPluginLoader.getClass().getDeclaredMethod("removeClass", String.class);
                    method.setAccessible(true);
                    method.invoke((Object)javaPluginLoader, className);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            };
            if (this.javaPluginClassLoaderParallelCapable()) {
                removeClass.run();
            } else {
                this.getPluginLoader().getScalaLoader().runInMainThread(removeClass);
            }
        }
    }

    private boolean canInjectIntoJavaPluginLoaderScope() {
        if (this.canInjectIntoJavaPluginLoaderScope != null) {
            return this.canInjectIntoJavaPluginLoaderScope;
        }
        String bukkitVersion = Bukkit.getBukkitVersion();
        this.canInjectIntoJavaPluginLoaderScope = bukkitVersion.startsWith("1.15.2") || bukkitVersion.startsWith("1.16") || bukkitVersion.startsWith("1.17") && !bukkitVersion.startsWith("1.17.") ? Boolean.valueOf(false) : Boolean.valueOf(true);
        return this.canInjectIntoJavaPluginLoaderScope;
    }

    private boolean javaPluginClassLoaderParallelCapable() {
        if (this.scalaLoaderClassLoaderParallelCapable != null) {
            return this.scalaLoaderClassLoaderParallelCapable;
        }
        this.scalaLoaderClassLoaderParallelCapable = false;
        ClassLoader javaPluginClassLoader = ((Object)((Object)this.pluginLoader.getScalaLoader())).getClass().getClassLoader();
        try {
            Method method = javaPluginClassLoader.getClass().getMethod("isRegisteredAsParallelCapable", new Class[0]);
            this.scalaLoaderClassLoaderParallelCapable = (Boolean)method.invoke((Object)javaPluginClassLoader, new Object[0]);
        }
        catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException exception) {
            // empty catch block
        }
        return this.scalaLoaderClassLoaderParallelCapable;
    }

    @Deprecated
    public final void addUrl(URL url) {
        this.libraryLoader.addURL(url);
    }

    @Override
    @Deprecated
    protected void addURL(URL url) {
        this.addUrl(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        for (Map.Entry entry : this.classes.entrySet()) {
            Class clazz;
            String className = (String)entry.getKey();
            if (!this.pluginLoader.removeClassGlobally(this.scalaRelease, className, clazz = (Class)entry.getValue()) || !this.canInjectIntoJavaPluginLoaderScope()) continue;
            this.removeFromJavaPluginLoaderScope(className);
        }
        this.classes.clear();
        try {
            super.close();
        }
        finally {
            this.jarFile.close();
        }
    }

    static {
        ScalaPluginClassLoader.registerAsParallelCapable();
    }
}

