/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import xyz.janboerman.scalaloader.ScalaRelease;
import xyz.janboerman.scalaloader.event.EventBus;
import xyz.janboerman.scalaloader.plugin.ScalaPluginClassLoader;
import xyz.janboerman.scalaloader.plugin.ScalaPluginDescription;
import xyz.janboerman.scalaloader.plugin.ScalaPluginLoader;
import xyz.janboerman.scalaloader.plugin.ScalaPluginLogger;
import xyz.janboerman.scalaloader.plugin.description.CustomScala;
import xyz.janboerman.scalaloader.plugin.description.Scala;

public abstract class ScalaPlugin
implements Plugin {
    private final ScalaPluginDescription description;
    private PluginDescriptionFile lazyDescription;
    private ScalaPluginLogger lazyLogger;
    private File lazyDataFolder;
    private File lazyConfigFile;
    private Server server;
    private ScalaPluginLoader pluginLoader;
    private File file;
    private ScalaPluginClassLoader classLoader;
    private boolean naggable = true;
    private FileConfiguration config;
    private boolean enabled;

    protected ScalaPlugin(ScalaPluginDescription pluginDescription) {
        this.description = pluginDescription;
        this.description.setMain(this.getClass().getName());
        if (this.getClass().getClassLoader() instanceof ScalaPluginClassLoader) {
            this.classLoader = (ScalaPluginClassLoader)this.getClass().getClassLoader();
            this.server = this.classLoader.getServer();
            this.description.addYaml(this.classLoader.getExtraPluginYaml());
            this.description.setApiVersion(this.classLoader.getApiVersion().getVersionString());
            this.pluginLoader = this.classLoader.getPluginLoader();
            this.file = this.classLoader.getPluginJarFile();
        } else {
            this.getLogger().warning("ScalaPlugin got instantiated but was not loaded by a ScalaPluginClassLoader!");
            this.getLogger().warning("Many of ScalaPlugin's fields will remain uninitialised!");
        }
    }

    protected ScalaPlugin() {
        if (!(this.getClass().getClassLoader() instanceof ScalaPluginClassLoader)) {
            throw new IllegalStateException("ScalaPlugin nullary constructor can only be used when loaded by a " + ScalaPluginClassLoader.class.getSimpleName() + ".");
        }
        this.classLoader = (ScalaPluginClassLoader)this.getClass().getClassLoader();
        this.server = this.classLoader.getServer();
        this.pluginLoader = this.classLoader.getPluginLoader();
        this.file = this.classLoader.getPluginJarFile();
        Map<String, Object> pluginYaml = this.classLoader.getExtraPluginYaml();
        String name = Objects.requireNonNull(pluginYaml.get("name"), "name unspecified in plugin.yml").toString();
        String version = Objects.requireNonNull(pluginYaml.get("version"), "version unspecified in plugin.yml").toString();
        this.description = new ScalaPluginDescription(name, version);
        this.description.setMain(this.getClass().getName());
        this.description.setApiVersion(this.classLoader.getApiVersion().getVersionString());
        this.description.readFromPluginYamlData(pluginYaml);
    }

    protected ScalaPlugin(ScalaPluginDescription pluginDescription, Server server, File file) {
        this.description = pluginDescription;
        this.description.setMain(this.getClass().getName());
        this.server = server;
        this.file = file;
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public ScalaPluginClassLoader getClassLoader() {
        return this.classLoader;
    }

    public final EventBus getEventBus() {
        return this.getPluginLoader().getEventBus();
    }

    public final String getScalaVersion() {
        return this.getClassLoader().getScalaVersion();
    }

    public final ScalaRelease getScalaRelease() {
        return this.getClassLoader().getScalaRelease();
    }

    public final String getDeclaredScalaVersion() {
        Class<?> mainClass = this.getClass();
        Scala scala = mainClass.getDeclaredAnnotation(Scala.class);
        if (scala != null) {
            return scala.version().getVersion();
        }
        CustomScala customScala = mainClass.getDeclaredAnnotation(CustomScala.class);
        if (customScala != null) {
            return customScala.value().value();
        }
        assert (false) : "ScalaPlugin defined its Scala version, but not via the @Scala or @CustomScala annotation";
        return this.getScalaVersion();
    }

    public String getName() {
        return this.description.getName();
    }

    public File getDataFolder() {
        return this.lazyDataFolder == null ? (this.lazyDataFolder = new File(this.file.getParent(), this.getName())) : this.lazyDataFolder;
    }

    ScalaPluginDescription getScalaDescription() {
        return this.description;
    }

    public PluginDescriptionFile getDescription() {
        return this.lazyDescription == null ? (this.lazyDescription = this.description.toPluginDescriptionFile()) : this.lazyDescription;
    }

    public FileConfiguration getConfig() {
        if (this.config == null) {
            this.reloadConfig();
        }
        return this.config;
    }

    public InputStream getResource(String filename) {
        Objects.requireNonNull(filename, "Filename cannot be null");
        URL url = this.getClassLoader().getResource(filename);
        if (url == null) {
            return null;
        }
        try {
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            return connection.getInputStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    public File getConfigFile() {
        return this.lazyConfigFile == null ? (this.lazyConfigFile = new File(this.getDataFolder(), "config.yml")) : this.lazyConfigFile;
    }

    public void saveConfig() {
        try {
            this.getConfig().save(this.getConfigFile());
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Could not save config to " + this.getConfigFile(), e);
        }
    }

    public void saveDefaultConfig() {
        if (!this.getConfigFile().exists()) {
            this.saveResource("config.yml", false);
        }
    }

    public void saveResource(String resourcePath, boolean replace) {
        if (resourcePath == null || resourcePath.equals("")) {
            throw new IllegalArgumentException("ResourcePath cannot be null or empty");
        }
        InputStream in = this.getResource(resourcePath = resourcePath.replace('\\', '/'));
        if (in == null) {
            throw new IllegalArgumentException("The embedded resource '" + resourcePath + "' cannot be found in " + this.file);
        }
        File outFile = new File(this.getDataFolder(), resourcePath);
        int lastIndex = resourcePath.lastIndexOf(47);
        File outDir = new File(this.getDataFolder(), resourcePath.substring(0, lastIndex >= 0 ? lastIndex : 0));
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        try {
            if (!outFile.exists() || replace) {
                int len;
                FileOutputStream out = new FileOutputStream(outFile);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((OutputStream)out).close();
                in.close();
            } else {
                this.getLogger().log(Level.WARNING, "Could not save " + outFile.getName() + " to " + outFile + " because " + outFile.getName() + " already exists.");
            }
        }
        catch (IOException ex) {
            this.getLogger().log(Level.SEVERE, "Could not save " + outFile.getName() + " to " + outFile, ex);
        }
    }

    public void reloadConfig() {
        this.config = YamlConfiguration.loadConfiguration((File)this.getConfigFile());
        InputStream defConfigStream = this.getResource("config.yml");
        if (defConfigStream == null) {
            return;
        }
        this.config.setDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream, StandardCharsets.UTF_8)));
    }

    public ScalaPluginLoader getPluginLoader() {
        return this.pluginLoader;
    }

    public Server getServer() {
        return this.server;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void onDisable() {
    }

    public void onLoad() {
    }

    public void onEnable() {
    }

    public boolean isNaggable() {
        return this.naggable;
    }

    public void setNaggable(boolean canNag) {
        this.naggable = canNag;
    }

    public ChunkGenerator getDefaultWorldGenerator(String worldName, String id) {
        return null;
    }

    public BiomeProvider getDefaultBiomeProvider(String worldName, String id) {
        return null;
    }

    public Logger getLogger() {
        return this.lazyLogger == null ? (this.lazyLogger = new ScalaPluginLogger(this)) : this.lazyLogger;
    }

    protected final PluginCommand getCommand(String name) {
        return this.getServer().getPluginCommand(name);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        return null;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Plugin)) {
            return false;
        }
        Plugin that = (Plugin)other;
        return Objects.equals(this.getName(), that.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.getName();
    }

    protected static <P extends ScalaPlugin> P getPlugin(Class<P> pluginClass) {
        ClassLoader classLoader = pluginClass.getClassLoader();
        if (classLoader instanceof ScalaPluginClassLoader) {
            ScalaPlugin plugin = ((ScalaPluginClassLoader)classLoader).getPlugin();
            if (plugin != null) {
                return (P)((ScalaPlugin)pluginClass.cast(plugin));
            }
            throw new IllegalStateException("Can't call " + ScalaPlugin.class.getName() + ".getPlugin(java.lang.Class) from your plugin's constructor or initializer.");
        }
        throw new IllegalArgumentException(pluginClass.getName() + " is not loaded by a " + ScalaPluginClassLoader.class.getName() + ". Is it even a ScalaPlugin?");
    }
}

