/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.plugin;

import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import xyz.janboerman.scalaloader.ScalaRelease;
import xyz.janboerman.scalaloader.plugin.PluginScalaVersion;

class ScalaCompatMap {
    private final Map<ScalaRelease, String> compatReleaseToLatestVersionMap = new HashMap<ScalaRelease, String>();
    private final Map<String, PluginScalaVersion> scalaMap = new HashMap<String, PluginScalaVersion>();

    ScalaCompatMap() {
    }

    void add(PluginScalaVersion scalaVersion) {
        String versionString = scalaVersion.getScalaVersion();
        this.scalaMap.putIfAbsent(versionString, scalaVersion);
        ScalaRelease compatVersion = scalaVersion.getCompatRelease();
        this.compatReleaseToLatestVersionMap.compute(compatVersion, (cv, latest) -> {
            if (latest == null || ScalaRelease.VERSION_COMPARATOR.compare((String)latest, versionString) < 0) {
                return versionString;
            }
            return latest;
        });
        if (versionString.length() > 4) {
            switch (versionString.substring(0, 4)) {
                case "3.1.": {
                    this.compatReleaseToLatestVersionMap.compute(ScalaRelease.SCALA_3_0, (cv, latest) -> {
                        if (latest == null || ScalaRelease.VERSION_COMPARATOR.compare((String)latest, versionString) < 0) {
                            return versionString;
                        }
                        return latest;
                    });
                }
                case "3.0.": {
                    this.compatReleaseToLatestVersionMap.compute(ScalaRelease.SCALA_2_13, (cv, latest) -> {
                        if (latest == null || ScalaRelease.VERSION_COMPARATOR.compare((String)latest, versionString) < 0) {
                            return versionString;
                        }
                        return latest;
                    });
                }
            }
        }
    }

    PluginScalaVersion getLatestVersion(PluginScalaVersion scalaVersion) {
        PluginScalaVersion latest;
        String versionString = scalaVersion.getScalaVersion();
        ScalaRelease compatVersion = scalaVersion.getCompatRelease();
        String latestVersion = this.compatReleaseToLatestVersionMap.get(compatVersion);
        if (latestVersion == null) {
            latestVersion = versionString;
            this.compatReleaseToLatestVersionMap.put(compatVersion, versionString);
        }
        if ((latest = this.scalaMap.get(latestVersion)) == null || ScalaRelease.VERSION_COMPARATOR.compare(latest.getScalaVersion(), scalaVersion.getScalaVersion()) < 0) {
            latest = scalaVersion;
            this.scalaMap.put(versionString, scalaVersion);
        }
        return latest;
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(", ", "[", "]");
        for (Map.Entry<ScalaRelease, String> compatLatestEntry : this.compatReleaseToLatestVersionMap.entrySet()) {
            ScalaRelease compatVersion = compatLatestEntry.getKey();
            String latestVersionForCompat = compatLatestEntry.getValue();
            PluginScalaVersion latestScalaVersion = this.scalaMap.get(latestVersionForCompat);
            sj.add(compatVersion.getCompatVersion() + "->" + latestScalaVersion);
        }
        return sj.toString();
    }
}

