/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.plugin;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.configuration.serialization.SerializableAs;
import xyz.janboerman.scalaloader.ScalaRelease;
import xyz.janboerman.scalaloader.compat.Compat;
import xyz.janboerman.scalaloader.plugin.description.ScalaVersion;

@SerializableAs(value="ScalaVersion")
public final class PluginScalaVersion
implements ConfigurationSerializable {
    private static final String SCALA_VERSION = "scala-version";
    public static final String SCALA2_REFLECT_URL = "scala-reflect-url";
    public static final String SCALA2_LIBRARY_URL = "scala-library-url";
    public static final String SCALA3_LIBRARY_URL = "scala3-library-url";
    public static final String TASTY_CORE_URL = "tasty-core-url";
    private final String scalaVersion;
    private final Map<String, String> urls;

    public static void register() {
        ConfigurationSerialization.registerClass(PluginScalaVersion.class, (String)"ScalaVersion");
    }

    @Deprecated
    public PluginScalaVersion(String scalaVersion, String libraryUrl, String reflectUrl) {
        Objects.requireNonNull(scalaVersion, "scalaVersion cannot be null!");
        Objects.requireNonNull(libraryUrl, "scala standard library url cannot be null!");
        Objects.requireNonNull(reflectUrl, "scala reflection library url cannot be null!");
        this.scalaVersion = scalaVersion;
        this.urls = Compat.mapOf(Compat.mapEntry(SCALA2_LIBRARY_URL, libraryUrl), Compat.mapEntry(SCALA2_REFLECT_URL, reflectUrl));
    }

    public PluginScalaVersion(String scalaVersion, Map<String, String> urls) {
        Objects.requireNonNull(scalaVersion, "scalaVersion cannot be null!");
        Objects.requireNonNull(urls, "urls cannot be null!");
        this.scalaVersion = scalaVersion;
        this.urls = Compat.mapCopy(urls);
    }

    public String getScalaVersion() {
        return this.scalaVersion;
    }

    public Map<String, String> getUrls() {
        return Collections.unmodifiableMap(this.urls);
    }

    @Deprecated
    public String getScalaLibraryUrl() {
        return this.urls.get(SCALA2_LIBRARY_URL);
    }

    @Deprecated
    public String getScalaReflectUrl() {
        return this.urls.get(SCALA2_REFLECT_URL);
    }

    public ScalaRelease getCompatRelease() {
        return ScalaRelease.fromScalaVersion(this.getScalaVersion());
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof PluginScalaVersion)) {
            return false;
        }
        PluginScalaVersion that = (PluginScalaVersion)other;
        return Objects.equals(this.scalaVersion, that.scalaVersion);
    }

    public int hashCode() {
        return this.scalaVersion.hashCode();
    }

    public String toString() {
        return this.scalaVersion;
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(SCALA_VERSION, this.getScalaVersion());
        for (Map.Entry<String, String> urlEntry : this.urls.entrySet()) {
            map.put(urlEntry.getKey(), urlEntry.getValue());
        }
        return map;
    }

    public static PluginScalaVersion deserialize(Map<String, Object> map) {
        map.remove("==");
        String scalaVersion = map.remove(SCALA_VERSION).toString();
        HashMap<String, String> urls = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            urls.put(entry.getKey(), entry.getValue().toString());
        }
        return new PluginScalaVersion(scalaVersion, urls);
    }

    public static PluginScalaVersion fromScalaVersion(ScalaVersion scalaVersion) {
        return new PluginScalaVersion(scalaVersion.getVersion(), scalaVersion.getUrls());
    }
}

