/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.libs.eclipse.aether.util.graph.selector;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import xyz.janboerman.scalaloader.libs.eclipse.aether.collection.DependencyCollectionContext;
import xyz.janboerman.scalaloader.libs.eclipse.aether.collection.DependencySelector;
import xyz.janboerman.scalaloader.libs.eclipse.aether.graph.Dependency;

public final class AndDependencySelector
implements DependencySelector {
    private final Set<? extends DependencySelector> selectors;
    private int hashCode;

    public AndDependencySelector(DependencySelector ... selectors) {
        this.selectors = selectors != null && selectors.length > 0 ? new LinkedHashSet<DependencySelector>(Arrays.asList(selectors)) : Collections.emptySet();
    }

    public AndDependencySelector(Collection<? extends DependencySelector> selectors) {
        this.selectors = selectors != null && !selectors.isEmpty() ? new LinkedHashSet<DependencySelector>(selectors) : Collections.emptySet();
    }

    private AndDependencySelector(Set<DependencySelector> selectors) {
        this.selectors = selectors != null && !selectors.isEmpty() ? selectors : Collections.emptySet();
    }

    public static DependencySelector newInstance(DependencySelector selector1, DependencySelector selector2) {
        if (selector1 == null) {
            return selector2;
        }
        if (selector2 == null || selector2.equals(selector1)) {
            return selector1;
        }
        return new AndDependencySelector(selector1, selector2);
    }

    @Override
    public boolean selectDependency(Dependency dependency) {
        for (DependencySelector dependencySelector : this.selectors) {
            if (dependencySelector.selectDependency(dependency)) continue;
            return false;
        }
        return true;
    }

    @Override
    public DependencySelector deriveChildSelector(DependencyCollectionContext context) {
        int seen = 0;
        LinkedHashSet<DependencySelector> childSelectors = null;
        for (DependencySelector dependencySelector : this.selectors) {
            DependencySelector childSelector = dependencySelector.deriveChildSelector(context);
            if (childSelectors != null) {
                if (childSelector == null) continue;
                childSelectors.add(childSelector);
                continue;
            }
            if (dependencySelector != childSelector) {
                childSelectors = new LinkedHashSet<DependencySelector>();
                if (seen > 0) {
                    for (DependencySelector dependencySelector2 : this.selectors) {
                        if (childSelectors.size() >= seen) break;
                        childSelectors.add(dependencySelector2);
                    }
                }
                if (childSelector == null) continue;
                childSelectors.add(childSelector);
                continue;
            }
            ++seen;
        }
        if (childSelectors == null) {
            return this;
        }
        if (childSelectors.size() <= 1) {
            if (childSelectors.isEmpty()) {
                return null;
            }
            return (DependencySelector)childSelectors.iterator().next();
        }
        return new AndDependencySelector((Set<DependencySelector>)childSelectors);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        AndDependencySelector that = (AndDependencySelector)obj;
        return this.selectors.equals(that.selectors);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int hash = 17;
            this.hashCode = hash = hash * 31 + this.selectors.hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append(this.getClass().getSimpleName()).append('(');
        Iterator<? extends DependencySelector> iterator = this.selectors.iterator();
        while (iterator.hasNext()) {
            DependencySelector selector = iterator.next();
            builder.append(selector.toString());
            if (!iterator.hasNext()) continue;
            builder.append(" && ");
        }
        return builder.append(')').toString();
    }
}

