/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.libs.eclipse.aether.transport.http;

import xyz.janboerman.scalaloader.libs.apache.http.HttpHost;
import xyz.janboerman.scalaloader.libs.apache.http.auth.AuthScope;
import xyz.janboerman.scalaloader.libs.apache.http.auth.Credentials;
import xyz.janboerman.scalaloader.libs.apache.http.client.CredentialsProvider;

final class DemuxCredentialsProvider
implements CredentialsProvider {
    private final CredentialsProvider serverCredentialsProvider;
    private final CredentialsProvider proxyCredentialsProvider;
    private final HttpHost proxy;

    DemuxCredentialsProvider(CredentialsProvider serverCredentialsProvider, CredentialsProvider proxyCredentialsProvider, HttpHost proxy) {
        this.serverCredentialsProvider = serverCredentialsProvider;
        this.proxyCredentialsProvider = proxyCredentialsProvider;
        this.proxy = proxy;
    }

    private CredentialsProvider getDelegate(AuthScope authScope) {
        if (this.proxy.getPort() == authScope.getPort() && this.proxy.getHostName().equalsIgnoreCase(authScope.getHost())) {
            return this.proxyCredentialsProvider;
        }
        return this.serverCredentialsProvider;
    }

    @Override
    public Credentials getCredentials(AuthScope authScope) {
        return this.getDelegate(authScope).getCredentials(authScope);
    }

    @Override
    public void setCredentials(AuthScope authScope, Credentials credentials) {
        this.getDelegate(authScope).setCredentials(authScope, credentials);
    }

    @Override
    public void clear() {
        this.serverCredentialsProvider.clear();
        this.proxyCredentialsProvider.clear();
    }
}

