/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.libs.eclipse.aether.internal.impl.collect;

import java.util.HashMap;
import java.util.Map;
import xyz.janboerman.scalaloader.libs.eclipse.aether.RepositorySystemSession;
import xyz.janboerman.scalaloader.libs.eclipse.aether.artifact.ArtifactType;
import xyz.janboerman.scalaloader.libs.eclipse.aether.artifact.ArtifactTypeRegistry;

class CachingArtifactTypeRegistry
implements ArtifactTypeRegistry {
    private final ArtifactTypeRegistry delegate;
    private final Map<String, ArtifactType> types;

    public static ArtifactTypeRegistry newInstance(RepositorySystemSession session) {
        return CachingArtifactTypeRegistry.newInstance(session.getArtifactTypeRegistry());
    }

    public static ArtifactTypeRegistry newInstance(ArtifactTypeRegistry delegate) {
        return delegate != null ? new CachingArtifactTypeRegistry(delegate) : null;
    }

    private CachingArtifactTypeRegistry(ArtifactTypeRegistry delegate) {
        this.delegate = delegate;
        this.types = new HashMap<String, ArtifactType>();
    }

    @Override
    public ArtifactType get(String typeId) {
        ArtifactType type = this.types.get(typeId);
        if (type == null) {
            type = this.delegate.get(typeId);
            this.types.put(typeId, type);
        }
        return type;
    }
}

