/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.libs.apache.maven.repository.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import xyz.janboerman.scalaloader.libs.apache.maven.repository.internal.VersionsMetadata;
import xyz.janboerman.scalaloader.libs.eclipse.aether.RepositorySystemSession;
import xyz.janboerman.scalaloader.libs.eclipse.aether.artifact.Artifact;
import xyz.janboerman.scalaloader.libs.eclipse.aether.deployment.DeployRequest;
import xyz.janboerman.scalaloader.libs.eclipse.aether.impl.MetadataGenerator;
import xyz.janboerman.scalaloader.libs.eclipse.aether.installation.InstallRequest;
import xyz.janboerman.scalaloader.libs.eclipse.aether.metadata.Metadata;

class VersionsMetadataGenerator
implements MetadataGenerator {
    private Map<Object, VersionsMetadata> versions = new LinkedHashMap<Object, VersionsMetadata>();
    private Map<Object, VersionsMetadata> processedVersions = new LinkedHashMap<Object, VersionsMetadata>();

    VersionsMetadataGenerator(RepositorySystemSession session, InstallRequest request) {
        this(session, request.getMetadata());
    }

    VersionsMetadataGenerator(RepositorySystemSession session, DeployRequest request) {
        this(session, request.getMetadata());
    }

    private VersionsMetadataGenerator(RepositorySystemSession session, Collection<? extends Metadata> metadatas) {
        Iterator<? extends Metadata> it = metadatas.iterator();
        while (it.hasNext()) {
            Metadata metadata = it.next();
            if (!(metadata instanceof VersionsMetadata)) continue;
            it.remove();
            VersionsMetadata versionsMetadata = (VersionsMetadata)metadata;
            this.processedVersions.put(versionsMetadata.getKey(), versionsMetadata);
        }
    }

    @Override
    public Collection<? extends Metadata> prepare(Collection<? extends Artifact> artifacts) {
        return Collections.emptyList();
    }

    @Override
    public Artifact transformArtifact(Artifact artifact) {
        return artifact;
    }

    @Override
    public Collection<? extends Metadata> finish(Collection<? extends Artifact> artifacts) {
        for (Artifact artifact : artifacts) {
            VersionsMetadata versionsMetadata;
            Object key = VersionsMetadata.getKey(artifact);
            if (this.processedVersions.get(key) != null || (versionsMetadata = this.versions.get(key)) != null) continue;
            versionsMetadata = new VersionsMetadata(artifact);
            this.versions.put(key, versionsMetadata);
        }
        return this.versions.values();
    }
}

