/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.libs.apache.maven.repository.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import xyz.janboerman.scalaloader.libs.apache.maven.model.Dependency;
import xyz.janboerman.scalaloader.libs.apache.maven.model.Parent;
import xyz.janboerman.scalaloader.libs.apache.maven.model.Repository;
import xyz.janboerman.scalaloader.libs.apache.maven.model.building.FileModelSource;
import xyz.janboerman.scalaloader.libs.apache.maven.model.building.ModelSource;
import xyz.janboerman.scalaloader.libs.apache.maven.model.resolution.InvalidRepositoryException;
import xyz.janboerman.scalaloader.libs.apache.maven.model.resolution.ModelResolver;
import xyz.janboerman.scalaloader.libs.apache.maven.model.resolution.UnresolvableModelException;
import xyz.janboerman.scalaloader.libs.apache.maven.repository.internal.ArtifactDescriptorUtils;
import xyz.janboerman.scalaloader.libs.eclipse.aether.RepositorySystemSession;
import xyz.janboerman.scalaloader.libs.eclipse.aether.RequestTrace;
import xyz.janboerman.scalaloader.libs.eclipse.aether.artifact.Artifact;
import xyz.janboerman.scalaloader.libs.eclipse.aether.artifact.DefaultArtifact;
import xyz.janboerman.scalaloader.libs.eclipse.aether.impl.ArtifactResolver;
import xyz.janboerman.scalaloader.libs.eclipse.aether.impl.RemoteRepositoryManager;
import xyz.janboerman.scalaloader.libs.eclipse.aether.impl.VersionRangeResolver;
import xyz.janboerman.scalaloader.libs.eclipse.aether.repository.RemoteRepository;
import xyz.janboerman.scalaloader.libs.eclipse.aether.resolution.ArtifactRequest;
import xyz.janboerman.scalaloader.libs.eclipse.aether.resolution.ArtifactResolutionException;
import xyz.janboerman.scalaloader.libs.eclipse.aether.resolution.VersionRangeRequest;
import xyz.janboerman.scalaloader.libs.eclipse.aether.resolution.VersionRangeResolutionException;
import xyz.janboerman.scalaloader.libs.eclipse.aether.resolution.VersionRangeResult;

class DefaultModelResolver
implements ModelResolver {
    private final RepositorySystemSession session;
    private final RequestTrace trace;
    private final String context;
    private List<RemoteRepository> repositories;
    private final List<RemoteRepository> externalRepositories;
    private final ArtifactResolver resolver;
    private final VersionRangeResolver versionRangeResolver;
    private final RemoteRepositoryManager remoteRepositoryManager;
    private final Set<String> repositoryIds;

    DefaultModelResolver(RepositorySystemSession session, RequestTrace trace, String context, ArtifactResolver resolver, VersionRangeResolver versionRangeResolver, RemoteRepositoryManager remoteRepositoryManager, List<RemoteRepository> repositories) {
        this.session = session;
        this.trace = trace;
        this.context = context;
        this.resolver = resolver;
        this.versionRangeResolver = versionRangeResolver;
        this.remoteRepositoryManager = remoteRepositoryManager;
        this.repositories = repositories;
        this.externalRepositories = Collections.unmodifiableList(new ArrayList<RemoteRepository>(repositories));
        this.repositoryIds = new HashSet<String>();
    }

    private DefaultModelResolver(DefaultModelResolver original) {
        this.session = original.session;
        this.trace = original.trace;
        this.context = original.context;
        this.resolver = original.resolver;
        this.versionRangeResolver = original.versionRangeResolver;
        this.remoteRepositoryManager = original.remoteRepositoryManager;
        this.repositories = new ArrayList<RemoteRepository>(original.repositories);
        this.externalRepositories = original.externalRepositories;
        this.repositoryIds = new HashSet<String>(original.repositoryIds);
    }

    @Override
    public void addRepository(Repository repository) throws InvalidRepositoryException {
        this.addRepository(repository, false);
    }

    @Override
    public void addRepository(Repository repository, boolean replace) throws InvalidRepositoryException {
        if (this.session.isIgnoreArtifactDescriptorRepositories()) {
            return;
        }
        if (!this.repositoryIds.add(repository.getId())) {
            if (!replace) {
                return;
            }
            DefaultModelResolver.removeMatchingRepository(this.repositories, repository.getId());
        }
        List<RemoteRepository> newRepositories = Collections.singletonList(ArtifactDescriptorUtils.toRemoteRepository(repository));
        this.repositories = this.remoteRepositoryManager.aggregateRepositories(this.session, this.repositories, newRepositories, true);
    }

    private static void removeMatchingRepository(Iterable<RemoteRepository> repositories, String id) {
        Iterator<RemoteRepository> iterator = repositories.iterator();
        while (iterator.hasNext()) {
            RemoteRepository remoteRepository = iterator.next();
            if (!remoteRepository.getId().equals(id)) continue;
            iterator.remove();
        }
    }

    @Override
    public ModelResolver newCopy() {
        return new DefaultModelResolver(this);
    }

    @Override
    public ModelSource resolveModel(String groupId, String artifactId, String version) throws UnresolvableModelException {
        Artifact pomArtifact = new DefaultArtifact(groupId, artifactId, "", "pom", version);
        try {
            ArtifactRequest request = new ArtifactRequest(pomArtifact, this.repositories, this.context);
            request.setTrace(this.trace);
            pomArtifact = this.resolver.resolveArtifact(this.session, request).getArtifact();
        }
        catch (ArtifactResolutionException e) {
            throw new UnresolvableModelException(e.getMessage(), groupId, artifactId, version, e);
        }
        File pomFile = pomArtifact.getFile();
        return new FileModelSource(pomFile);
    }

    @Override
    public ModelSource resolveModel(Parent parent) throws UnresolvableModelException {
        try {
            DefaultArtifact artifact = new DefaultArtifact(parent.getGroupId(), parent.getArtifactId(), "", "pom", parent.getVersion());
            VersionRangeRequest versionRangeRequest = new VersionRangeRequest(artifact, this.repositories, this.context);
            versionRangeRequest.setTrace(this.trace);
            VersionRangeResult versionRangeResult = this.versionRangeResolver.resolveVersionRange(this.session, versionRangeRequest);
            if (versionRangeResult.getHighestVersion() == null) {
                throw new UnresolvableModelException(String.format("No versions matched the requested parent version range '%s'", parent.getVersion()), parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
            }
            if (versionRangeResult.getVersionConstraint() != null && versionRangeResult.getVersionConstraint().getRange() != null && versionRangeResult.getVersionConstraint().getRange().getUpperBound() == null) {
                throw new UnresolvableModelException(String.format("The requested parent version range '%s' does not specify an upper bound", parent.getVersion()), parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
            }
            parent.setVersion(versionRangeResult.getHighestVersion().toString());
            return this.resolveModel(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
        }
        catch (VersionRangeResolutionException e) {
            throw new UnresolvableModelException(e.getMessage(), parent.getGroupId(), parent.getArtifactId(), parent.getVersion(), e);
        }
    }

    @Override
    public ModelSource resolveModel(Dependency dependency) throws UnresolvableModelException {
        try {
            DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), "", "pom", dependency.getVersion());
            VersionRangeRequest versionRangeRequest = new VersionRangeRequest(artifact, this.repositories, this.context);
            versionRangeRequest.setTrace(this.trace);
            VersionRangeResult versionRangeResult = this.versionRangeResolver.resolveVersionRange(this.session, versionRangeRequest);
            if (versionRangeResult.getHighestVersion() == null) {
                throw new UnresolvableModelException(String.format("No versions matched the requested dependency version range '%s'", dependency.getVersion()), dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
            }
            if (versionRangeResult.getVersionConstraint() != null && versionRangeResult.getVersionConstraint().getRange() != null && versionRangeResult.getVersionConstraint().getRange().getUpperBound() == null) {
                throw new UnresolvableModelException(String.format("The requested dependency version range '%s' does not specify an upper bound", dependency.getVersion()), dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
            }
            dependency.setVersion(versionRangeResult.getHighestVersion().toString());
            return this.resolveModel(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
        }
        catch (VersionRangeResolutionException e) {
            throw new UnresolvableModelException(e.getMessage(), dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), e);
        }
    }
}

