/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.libs.apache.maven.repository.internal;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import xyz.janboerman.scalaloader.libs.apache.maven.model.DistributionManagement;
import xyz.janboerman.scalaloader.libs.apache.maven.model.Model;
import xyz.janboerman.scalaloader.libs.apache.maven.model.Relocation;
import xyz.janboerman.scalaloader.libs.apache.maven.model.building.DefaultModelBuilderFactory;
import xyz.janboerman.scalaloader.libs.apache.maven.model.building.DefaultModelBuildingRequest;
import xyz.janboerman.scalaloader.libs.apache.maven.model.building.FileModelSource;
import xyz.janboerman.scalaloader.libs.apache.maven.model.building.ModelBuilder;
import xyz.janboerman.scalaloader.libs.apache.maven.model.building.ModelBuildingException;
import xyz.janboerman.scalaloader.libs.apache.maven.model.building.ModelProblem;
import xyz.janboerman.scalaloader.libs.apache.maven.model.resolution.UnresolvableModelException;
import xyz.janboerman.scalaloader.libs.apache.maven.repository.internal.ArtifactDescriptorReaderDelegate;
import xyz.janboerman.scalaloader.libs.apache.maven.repository.internal.ArtifactDescriptorUtils;
import xyz.janboerman.scalaloader.libs.apache.maven.repository.internal.DefaultModelCache;
import xyz.janboerman.scalaloader.libs.apache.maven.repository.internal.DefaultModelResolver;
import xyz.janboerman.scalaloader.libs.apache.maven.repository.internal.MavenWorkspaceReader;
import xyz.janboerman.scalaloader.libs.apache.maven.repository.internal.RelocatedArtifact;
import xyz.janboerman.scalaloader.libs.eclipse.aether.RepositoryEvent;
import xyz.janboerman.scalaloader.libs.eclipse.aether.RepositoryException;
import xyz.janboerman.scalaloader.libs.eclipse.aether.RepositorySystemSession;
import xyz.janboerman.scalaloader.libs.eclipse.aether.RequestTrace;
import xyz.janboerman.scalaloader.libs.eclipse.aether.artifact.Artifact;
import xyz.janboerman.scalaloader.libs.eclipse.aether.impl.ArtifactDescriptorReader;
import xyz.janboerman.scalaloader.libs.eclipse.aether.impl.ArtifactResolver;
import xyz.janboerman.scalaloader.libs.eclipse.aether.impl.RemoteRepositoryManager;
import xyz.janboerman.scalaloader.libs.eclipse.aether.impl.RepositoryEventDispatcher;
import xyz.janboerman.scalaloader.libs.eclipse.aether.impl.VersionRangeResolver;
import xyz.janboerman.scalaloader.libs.eclipse.aether.impl.VersionResolver;
import xyz.janboerman.scalaloader.libs.eclipse.aether.repository.WorkspaceReader;
import xyz.janboerman.scalaloader.libs.eclipse.aether.repository.WorkspaceRepository;
import xyz.janboerman.scalaloader.libs.eclipse.aether.resolution.ArtifactDescriptorException;
import xyz.janboerman.scalaloader.libs.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import xyz.janboerman.scalaloader.libs.eclipse.aether.resolution.ArtifactDescriptorPolicyRequest;
import xyz.janboerman.scalaloader.libs.eclipse.aether.resolution.ArtifactDescriptorRequest;
import xyz.janboerman.scalaloader.libs.eclipse.aether.resolution.ArtifactDescriptorResult;
import xyz.janboerman.scalaloader.libs.eclipse.aether.resolution.ArtifactRequest;
import xyz.janboerman.scalaloader.libs.eclipse.aether.resolution.ArtifactResolutionException;
import xyz.janboerman.scalaloader.libs.eclipse.aether.resolution.ArtifactResult;
import xyz.janboerman.scalaloader.libs.eclipse.aether.resolution.VersionRequest;
import xyz.janboerman.scalaloader.libs.eclipse.aether.resolution.VersionResolutionException;
import xyz.janboerman.scalaloader.libs.eclipse.aether.resolution.VersionResult;
import xyz.janboerman.scalaloader.libs.eclipse.aether.spi.locator.Service;
import xyz.janboerman.scalaloader.libs.eclipse.aether.spi.locator.ServiceLocator;
import xyz.janboerman.scalaloader.libs.eclipse.aether.transfer.ArtifactNotFoundException;

@Named
@Singleton
public class DefaultArtifactDescriptorReader
implements ArtifactDescriptorReader,
Service {
    private RemoteRepositoryManager remoteRepositoryManager;
    private VersionResolver versionResolver;
    private VersionRangeResolver versionRangeResolver;
    private ArtifactResolver artifactResolver;
    private RepositoryEventDispatcher repositoryEventDispatcher;
    private ModelBuilder modelBuilder;

    public DefaultArtifactDescriptorReader() {
    }

    @Inject
    DefaultArtifactDescriptorReader(RemoteRepositoryManager remoteRepositoryManager, VersionResolver versionResolver, VersionRangeResolver versionRangeResolver, ArtifactResolver artifactResolver, ModelBuilder modelBuilder, RepositoryEventDispatcher repositoryEventDispatcher) {
        this.setRemoteRepositoryManager(remoteRepositoryManager);
        this.setVersionResolver(versionResolver);
        this.setVersionRangeResolver(versionRangeResolver);
        this.setArtifactResolver(artifactResolver);
        this.setModelBuilder(modelBuilder);
        this.setRepositoryEventDispatcher(repositoryEventDispatcher);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setRemoteRepositoryManager(locator.getService(RemoteRepositoryManager.class));
        this.setVersionResolver(locator.getService(VersionResolver.class));
        this.setVersionRangeResolver(locator.getService(VersionRangeResolver.class));
        this.setArtifactResolver(locator.getService(ArtifactResolver.class));
        this.modelBuilder = locator.getService(ModelBuilder.class);
        if (this.modelBuilder == null) {
            this.setModelBuilder(new DefaultModelBuilderFactory().newInstance());
        }
        this.setRepositoryEventDispatcher(locator.getService(RepositoryEventDispatcher.class));
    }

    public DefaultArtifactDescriptorReader setRemoteRepositoryManager(RemoteRepositoryManager remoteRepositoryManager) {
        this.remoteRepositoryManager = Objects.requireNonNull(remoteRepositoryManager, "remoteRepositoryManager cannot be null");
        return this;
    }

    public DefaultArtifactDescriptorReader setVersionResolver(VersionResolver versionResolver) {
        this.versionResolver = Objects.requireNonNull(versionResolver, "versionResolver cannot be null");
        return this;
    }

    public DefaultArtifactDescriptorReader setVersionRangeResolver(VersionRangeResolver versionRangeResolver) {
        this.versionRangeResolver = Objects.requireNonNull(versionRangeResolver, "versionRangeResolver cannot be null");
        return this;
    }

    public DefaultArtifactDescriptorReader setArtifactResolver(ArtifactResolver artifactResolver) {
        this.artifactResolver = Objects.requireNonNull(artifactResolver, "artifactResolver cannot be null");
        return this;
    }

    public DefaultArtifactDescriptorReader setRepositoryEventDispatcher(RepositoryEventDispatcher repositoryEventDispatcher) {
        this.repositoryEventDispatcher = Objects.requireNonNull(repositoryEventDispatcher, "repositoryEventDispatcher cannot be null");
        return this;
    }

    public DefaultArtifactDescriptorReader setModelBuilder(ModelBuilder modelBuilder) {
        this.modelBuilder = Objects.requireNonNull(modelBuilder, "modelBuilder cannot be null");
        return this;
    }

    @Override
    public ArtifactDescriptorResult readArtifactDescriptor(RepositorySystemSession session, ArtifactDescriptorRequest request) throws ArtifactDescriptorException {
        ArtifactDescriptorResult result = new ArtifactDescriptorResult(request);
        Model model = this.loadPom(session, request, result);
        if (model != null) {
            Map<String, Object> config = session.getConfigProperties();
            ArtifactDescriptorReaderDelegate delegate = (ArtifactDescriptorReaderDelegate)config.get(ArtifactDescriptorReaderDelegate.class.getName());
            if (delegate == null) {
                delegate = new ArtifactDescriptorReaderDelegate();
            }
            delegate.populateResult(session, result, model);
        }
        return result;
    }

    private Model loadPom(RepositorySystemSession session, ArtifactDescriptorRequest request, ArtifactDescriptorResult result) throws ArtifactDescriptorException {
        Model model;
        RequestTrace trace = RequestTrace.newChild(request.getTrace(), request);
        LinkedHashSet<String> visited = new LinkedHashSet<String>();
        Artifact a = request.getArtifact();
        while (true) {
            ArtifactResult resolveResult;
            Artifact pomArtifact = ArtifactDescriptorUtils.toPomArtifact(a);
            try {
                VersionRequest versionRequest = new VersionRequest(a, request.getRepositories(), request.getRequestContext());
                versionRequest.setTrace(trace);
                VersionResult versionResult = this.versionResolver.resolveVersion(session, versionRequest);
                a = a.setVersion(versionResult.getVersion());
                versionRequest = new VersionRequest(pomArtifact, request.getRepositories(), request.getRequestContext());
                versionRequest.setTrace(trace);
                versionResult = this.versionResolver.resolveVersion(session, versionRequest);
                pomArtifact = pomArtifact.setVersion(versionResult.getVersion());
            }
            catch (VersionResolutionException e) {
                result.addException(e);
                throw new ArtifactDescriptorException(result);
            }
            if (!visited.add(a.getGroupId() + ':' + a.getArtifactId() + ':' + a.getBaseVersion())) {
                RepositoryException exception = new RepositoryException("Artifact relocations form a cycle: " + visited);
                this.invalidDescriptor(session, trace, a, exception);
                if ((this.getPolicy(session, a, request) & 2) != 0) {
                    return null;
                }
                result.addException(exception);
                throw new ArtifactDescriptorException(result);
            }
            try {
                ArtifactRequest resolveRequest = new ArtifactRequest(pomArtifact, request.getRepositories(), request.getRequestContext());
                resolveRequest.setTrace(trace);
                resolveResult = this.artifactResolver.resolveArtifact(session, resolveRequest);
                pomArtifact = resolveResult.getArtifact();
                result.setRepository(resolveResult.getRepository());
            }
            catch (ArtifactResolutionException e) {
                if (e.getCause() instanceof ArtifactNotFoundException) {
                    this.missingDescriptor(session, trace, a, (Exception)e.getCause());
                    if ((this.getPolicy(session, a, request) & 1) != 0) {
                        return null;
                    }
                }
                result.addException(e);
                throw new ArtifactDescriptorException(result);
            }
            WorkspaceReader workspace = session.getWorkspaceReader();
            if (workspace instanceof MavenWorkspaceReader && (model = ((MavenWorkspaceReader)workspace).findModel(pomArtifact)) != null) {
                return model;
            }
            try {
                DefaultModelBuildingRequest modelRequest = new DefaultModelBuildingRequest();
                modelRequest.setValidationLevel(0);
                modelRequest.setProcessPlugins(false);
                modelRequest.setTwoPhaseBuilding(false);
                modelRequest.setSystemProperties(this.toProperties(session.getUserProperties(), session.getSystemProperties()));
                modelRequest.setModelCache(DefaultModelCache.newInstance(session));
                modelRequest.setModelResolver(new DefaultModelResolver(session, trace.newChild(modelRequest), request.getRequestContext(), this.artifactResolver, this.versionRangeResolver, this.remoteRepositoryManager, request.getRepositories()));
                if (resolveResult.getRepository() instanceof WorkspaceRepository) {
                    modelRequest.setPomFile(pomArtifact.getFile());
                } else {
                    modelRequest.setModelSource(new FileModelSource(pomArtifact.getFile()));
                }
                model = this.modelBuilder.build(modelRequest).getEffectiveModel();
            }
            catch (ModelBuildingException e) {
                for (ModelProblem problem : e.getProblems()) {
                    if (!(problem.getException() instanceof UnresolvableModelException)) continue;
                    result.addException(problem.getException());
                    throw new ArtifactDescriptorException(result);
                }
                this.invalidDescriptor(session, trace, a, e);
                if ((this.getPolicy(session, a, request) & 2) != 0) {
                    return null;
                }
                result.addException(e);
                throw new ArtifactDescriptorException(result);
            }
            Relocation relocation = this.getRelocation(model);
            if (relocation == null) break;
            result.addRelocation(a);
            a = new RelocatedArtifact(a, relocation.getGroupId(), relocation.getArtifactId(), relocation.getVersion());
            result.setArtifact(a);
        }
        return model;
    }

    private Properties toProperties(Map<String, String> dominant, Map<String, String> recessive) {
        Properties props = new Properties();
        if (recessive != null) {
            props.putAll(recessive);
        }
        if (dominant != null) {
            props.putAll(dominant);
        }
        return props;
    }

    private Relocation getRelocation(Model model) {
        Relocation relocation = null;
        DistributionManagement distMgmt = model.getDistributionManagement();
        if (distMgmt != null) {
            relocation = distMgmt.getRelocation();
        }
        return relocation;
    }

    private void missingDescriptor(RepositorySystemSession session, RequestTrace trace, Artifact artifact, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.ARTIFACT_DESCRIPTOR_MISSING);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setException(exception);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void invalidDescriptor(RepositorySystemSession session, RequestTrace trace, Artifact artifact, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.ARTIFACT_DESCRIPTOR_INVALID);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setException(exception);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private int getPolicy(RepositorySystemSession session, Artifact a, ArtifactDescriptorRequest request) {
        ArtifactDescriptorPolicy policy = session.getArtifactDescriptorPolicy();
        if (policy == null) {
            return 0;
        }
        return policy.getPolicy(session, new ArtifactDescriptorPolicyRequest(a, request.getRequestContext()));
    }
}

