/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.libs.apache.maven.repository.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import xyz.janboerman.scalaloader.libs.apache.maven.model.DependencyManagement;
import xyz.janboerman.scalaloader.libs.apache.maven.model.DistributionManagement;
import xyz.janboerman.scalaloader.libs.apache.maven.model.Exclusion;
import xyz.janboerman.scalaloader.libs.apache.maven.model.License;
import xyz.janboerman.scalaloader.libs.apache.maven.model.Model;
import xyz.janboerman.scalaloader.libs.apache.maven.model.Prerequisites;
import xyz.janboerman.scalaloader.libs.apache.maven.model.Repository;
import xyz.janboerman.scalaloader.libs.apache.maven.repository.internal.ArtifactDescriptorUtils;
import xyz.janboerman.scalaloader.libs.eclipse.aether.RepositorySystemSession;
import xyz.janboerman.scalaloader.libs.eclipse.aether.artifact.Artifact;
import xyz.janboerman.scalaloader.libs.eclipse.aether.artifact.ArtifactType;
import xyz.janboerman.scalaloader.libs.eclipse.aether.artifact.ArtifactTypeRegistry;
import xyz.janboerman.scalaloader.libs.eclipse.aether.artifact.DefaultArtifact;
import xyz.janboerman.scalaloader.libs.eclipse.aether.artifact.DefaultArtifactType;
import xyz.janboerman.scalaloader.libs.eclipse.aether.graph.Dependency;
import xyz.janboerman.scalaloader.libs.eclipse.aether.resolution.ArtifactDescriptorResult;

public class ArtifactDescriptorReaderDelegate {
    public void populateResult(RepositorySystemSession session, ArtifactDescriptorResult result, Model model) {
        ArtifactTypeRegistry stereotypes = session.getArtifactTypeRegistry();
        for (Repository repository : model.getRepositories()) {
            result.addRepository(ArtifactDescriptorUtils.toRemoteRepository(repository));
        }
        for (xyz.janboerman.scalaloader.libs.apache.maven.model.Dependency dependency : model.getDependencies()) {
            result.addDependency(this.convert(dependency, stereotypes));
        }
        DependencyManagement mgmt = model.getDependencyManagement();
        if (mgmt != null) {
            for (xyz.janboerman.scalaloader.libs.apache.maven.model.Dependency dependency : mgmt.getDependencies()) {
                result.addManagedDependency(this.convert(dependency, stereotypes));
            }
        }
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        Prerequisites prerequisites = model.getPrerequisites();
        if (prerequisites != null) {
            linkedHashMap.put("prerequisites.maven", prerequisites.getMaven());
        }
        List<License> licenses = model.getLicenses();
        linkedHashMap.put("license.count", licenses.size());
        for (int i = 0; i < licenses.size(); ++i) {
            License license = licenses.get(i);
            linkedHashMap.put("license." + i + ".name", license.getName());
            linkedHashMap.put("license." + i + ".url", license.getUrl());
            linkedHashMap.put("license." + i + ".comments", license.getComments());
            linkedHashMap.put("license." + i + ".distribution", license.getDistribution());
        }
        result.setProperties(linkedHashMap);
        this.setArtifactProperties(result, model);
    }

    private Dependency convert(xyz.janboerman.scalaloader.libs.apache.maven.model.Dependency dependency, ArtifactTypeRegistry stereotypes) {
        ArtifactType stereotype = stereotypes.get(dependency.getType());
        if (stereotype == null) {
            stereotype = new DefaultArtifactType(dependency.getType());
        }
        boolean system = dependency.getSystemPath() != null && dependency.getSystemPath().length() > 0;
        Map<String, String> props = null;
        if (system) {
            props = Collections.singletonMap("localPath", dependency.getSystemPath());
        }
        DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), null, dependency.getVersion(), props, stereotype);
        ArrayList<xyz.janboerman.scalaloader.libs.eclipse.aether.graph.Exclusion> exclusions = new ArrayList<xyz.janboerman.scalaloader.libs.eclipse.aether.graph.Exclusion>(dependency.getExclusions().size());
        for (Exclusion exclusion : dependency.getExclusions()) {
            exclusions.add(this.convert(exclusion));
        }
        Dependency result = new Dependency((Artifact)artifact, dependency.getScope(), dependency.getOptional() != null ? Boolean.valueOf(dependency.isOptional()) : null, exclusions);
        return result;
    }

    private xyz.janboerman.scalaloader.libs.eclipse.aether.graph.Exclusion convert(Exclusion exclusion) {
        return new xyz.janboerman.scalaloader.libs.eclipse.aether.graph.Exclusion(exclusion.getGroupId(), exclusion.getArtifactId(), "*", "*");
    }

    private void setArtifactProperties(ArtifactDescriptorResult result, Model model) {
        String downloadUrl = null;
        DistributionManagement distMgmt = model.getDistributionManagement();
        if (distMgmt != null) {
            downloadUrl = distMgmt.getDownloadUrl();
        }
        if (downloadUrl != null && downloadUrl.length() > 0) {
            Artifact artifact = result.getArtifact();
            HashMap<String, String> props = new HashMap<String, String>(artifact.getProperties());
            props.put("downloadUrl", downloadUrl);
            result.setArtifact(artifact.setProperties(props));
        }
    }
}

