/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.libs.apache.maven.model.plugin;

import javax.inject.Named;
import javax.inject.Singleton;
import xyz.janboerman.scalaloader.libs.apache.maven.model.Model;
import xyz.janboerman.scalaloader.libs.apache.maven.model.ReportPlugin;
import xyz.janboerman.scalaloader.libs.apache.maven.model.ReportSet;
import xyz.janboerman.scalaloader.libs.apache.maven.model.Reporting;
import xyz.janboerman.scalaloader.libs.apache.maven.model.building.ModelBuildingRequest;
import xyz.janboerman.scalaloader.libs.apache.maven.model.building.ModelProblemCollector;
import xyz.janboerman.scalaloader.libs.apache.maven.model.plugin.ReportConfigurationExpander;
import xyz.janboerman.scalaloader.libs.codehaus.plexus.util.xml.Xpp3Dom;

@Named
@Singleton
public class DefaultReportConfigurationExpander
implements ReportConfigurationExpander {
    @Override
    public void expandPluginConfiguration(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        Reporting reporting = model.getReporting();
        if (reporting != null) {
            for (ReportPlugin reportPlugin : reporting.getPlugins()) {
                Xpp3Dom parentDom = (Xpp3Dom)reportPlugin.getConfiguration();
                if (parentDom == null) continue;
                for (ReportSet execution : reportPlugin.getReportSets()) {
                    Xpp3Dom childDom = (Xpp3Dom)execution.getConfiguration();
                    childDom = Xpp3Dom.mergeXpp3Dom(childDom, new Xpp3Dom(parentDom));
                    execution.setConfiguration(childDom);
                }
            }
        }
    }
}

