/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.libs.apache.maven.model.plugin;

import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import xyz.janboerman.scalaloader.libs.apache.maven.model.Build;
import xyz.janboerman.scalaloader.libs.apache.maven.model.Model;
import xyz.janboerman.scalaloader.libs.apache.maven.model.Plugin;
import xyz.janboerman.scalaloader.libs.apache.maven.model.PluginExecution;
import xyz.janboerman.scalaloader.libs.apache.maven.model.PluginManagement;
import xyz.janboerman.scalaloader.libs.apache.maven.model.building.ModelBuildingRequest;
import xyz.janboerman.scalaloader.libs.apache.maven.model.building.ModelProblemCollector;
import xyz.janboerman.scalaloader.libs.apache.maven.model.plugin.PluginConfigurationExpander;
import xyz.janboerman.scalaloader.libs.codehaus.plexus.util.xml.Xpp3Dom;

@Named
@Singleton
public class DefaultPluginConfigurationExpander
implements PluginConfigurationExpander {
    @Override
    public void expandPluginConfiguration(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        Build build = model.getBuild();
        if (build != null) {
            this.expand(build.getPlugins());
            PluginManagement pluginManagement = build.getPluginManagement();
            if (pluginManagement != null) {
                this.expand(pluginManagement.getPlugins());
            }
        }
    }

    private void expand(List<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            Xpp3Dom pluginConfiguration = (Xpp3Dom)plugin.getConfiguration();
            if (pluginConfiguration == null) continue;
            for (PluginExecution execution : plugin.getExecutions()) {
                Xpp3Dom executionConfiguration = (Xpp3Dom)execution.getConfiguration();
                executionConfiguration = Xpp3Dom.mergeXpp3Dom(executionConfiguration, new Xpp3Dom(pluginConfiguration));
                execution.setConfiguration(executionConfiguration);
            }
        }
    }
}

