/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.libs.apache.http.protocol;

import java.io.IOException;
import java.net.InetAddress;
import xyz.janboerman.scalaloader.libs.apache.http.HttpConnection;
import xyz.janboerman.scalaloader.libs.apache.http.HttpException;
import xyz.janboerman.scalaloader.libs.apache.http.HttpHost;
import xyz.janboerman.scalaloader.libs.apache.http.HttpInetConnection;
import xyz.janboerman.scalaloader.libs.apache.http.HttpRequest;
import xyz.janboerman.scalaloader.libs.apache.http.HttpRequestInterceptor;
import xyz.janboerman.scalaloader.libs.apache.http.HttpVersion;
import xyz.janboerman.scalaloader.libs.apache.http.ProtocolException;
import xyz.janboerman.scalaloader.libs.apache.http.ProtocolVersion;
import xyz.janboerman.scalaloader.libs.apache.http.annotation.Contract;
import xyz.janboerman.scalaloader.libs.apache.http.annotation.ThreadingBehavior;
import xyz.janboerman.scalaloader.libs.apache.http.protocol.HttpContext;
import xyz.janboerman.scalaloader.libs.apache.http.protocol.HttpCoreContext;
import xyz.janboerman.scalaloader.libs.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestTargetHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        HttpCoreContext coreContext = HttpCoreContext.adapt(context);
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT") && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            HttpHost targetHost = coreContext.getTargetHost();
            if (targetHost == null) {
                HttpConnection conn = coreContext.getConnection();
                if (conn instanceof HttpInetConnection) {
                    InetAddress address = ((HttpInetConnection)conn).getRemoteAddress();
                    int port = ((HttpInetConnection)conn).getRemotePort();
                    if (address != null) {
                        targetHost = new HttpHost(address.getHostName(), port);
                    }
                }
                if (targetHost == null) {
                    if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            request.addHeader("Host", targetHost.toHostString());
        }
    }
}

