/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.libs.apache.http.protocol;

import java.io.IOException;
import xyz.janboerman.scalaloader.libs.apache.http.HttpEntity;
import xyz.janboerman.scalaloader.libs.apache.http.HttpEntityEnclosingRequest;
import xyz.janboerman.scalaloader.libs.apache.http.HttpException;
import xyz.janboerman.scalaloader.libs.apache.http.HttpRequest;
import xyz.janboerman.scalaloader.libs.apache.http.HttpRequestInterceptor;
import xyz.janboerman.scalaloader.libs.apache.http.HttpVersion;
import xyz.janboerman.scalaloader.libs.apache.http.ProtocolVersion;
import xyz.janboerman.scalaloader.libs.apache.http.annotation.Contract;
import xyz.janboerman.scalaloader.libs.apache.http.annotation.ThreadingBehavior;
import xyz.janboerman.scalaloader.libs.apache.http.protocol.HttpContext;
import xyz.janboerman.scalaloader.libs.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    private final boolean activeByDefault;

    @Deprecated
    public RequestExpectContinue() {
        this(false);
    }

    public RequestExpectContinue(boolean activeByDefault) {
        this.activeByDefault = activeByDefault;
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            boolean active;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (active = request.getParams().getBooleanParameter("http.protocol.expect-continue", this.activeByDefault))) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

