/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.libs.apache.http.impl.cookie;

import xyz.janboerman.scalaloader.libs.apache.http.annotation.Contract;
import xyz.janboerman.scalaloader.libs.apache.http.annotation.ThreadingBehavior;
import xyz.janboerman.scalaloader.libs.apache.http.cookie.ClientCookie;
import xyz.janboerman.scalaloader.libs.apache.http.cookie.CommonCookieAttributeHandler;
import xyz.janboerman.scalaloader.libs.apache.http.cookie.Cookie;
import xyz.janboerman.scalaloader.libs.apache.http.cookie.CookieOrigin;
import xyz.janboerman.scalaloader.libs.apache.http.cookie.CookieRestrictionViolationException;
import xyz.janboerman.scalaloader.libs.apache.http.cookie.MalformedCookieException;
import xyz.janboerman.scalaloader.libs.apache.http.cookie.SetCookie;
import xyz.janboerman.scalaloader.libs.apache.http.cookie.SetCookie2;
import xyz.janboerman.scalaloader.libs.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RFC2965VersionAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        int version = -1;
        try {
            version = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            version = -1;
        }
        if (version < 0) {
            throw new MalformedCookieException("Invalid cookie version.");
        }
        cookie.setVersion(version);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie instanceof SetCookie2 && cookie instanceof ClientCookie && !((ClientCookie)cookie).containsAttribute("version")) {
            throw new CookieRestrictionViolationException("Violates RFC 2965. Version attribute is required.");
        }
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        return true;
    }

    @Override
    public String getAttributeName() {
        return "version";
    }
}

