/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.libs.apache.http.impl.cookie;

import java.util.Date;
import xyz.janboerman.scalaloader.libs.apache.http.annotation.Contract;
import xyz.janboerman.scalaloader.libs.apache.http.annotation.ThreadingBehavior;
import xyz.janboerman.scalaloader.libs.apache.http.client.utils.DateUtils;
import xyz.janboerman.scalaloader.libs.apache.http.cookie.CommonCookieAttributeHandler;
import xyz.janboerman.scalaloader.libs.apache.http.cookie.MalformedCookieException;
import xyz.janboerman.scalaloader.libs.apache.http.cookie.SetCookie;
import xyz.janboerman.scalaloader.libs.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import xyz.janboerman.scalaloader.libs.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicExpiresHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    private final String[] datepatterns;

    public BasicExpiresHandler(String[] datepatterns) {
        Args.notNull(datepatterns, "Array of date patterns");
        this.datepatterns = datepatterns;
    }

    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for 'expires' attribute");
        }
        Date expiry = DateUtils.parseDate(value, this.datepatterns);
        if (expiry == null) {
            throw new MalformedCookieException("Invalid 'expires' attribute: " + value);
        }
        cookie.setExpiryDate(expiry);
    }

    @Override
    public String getAttributeName() {
        return "expires";
    }
}

