/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.libs.apache.http.impl.auth;

import xyz.janboerman.scalaloader.libs.apache.http.annotation.Contract;
import xyz.janboerman.scalaloader.libs.apache.http.annotation.ThreadingBehavior;
import xyz.janboerman.scalaloader.libs.apache.http.auth.AuthScheme;
import xyz.janboerman.scalaloader.libs.apache.http.auth.AuthSchemeFactory;
import xyz.janboerman.scalaloader.libs.apache.http.auth.AuthSchemeProvider;
import xyz.janboerman.scalaloader.libs.apache.http.impl.auth.KerberosScheme;
import xyz.janboerman.scalaloader.libs.apache.http.params.HttpParams;
import xyz.janboerman.scalaloader.libs.apache.http.protocol.HttpContext;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class KerberosSchemeFactory
implements AuthSchemeFactory,
AuthSchemeProvider {
    private final boolean stripPort;
    private final boolean useCanonicalHostname;

    public KerberosSchemeFactory(boolean stripPort, boolean useCanonicalHostname) {
        this.stripPort = stripPort;
        this.useCanonicalHostname = useCanonicalHostname;
    }

    public KerberosSchemeFactory(boolean stripPort) {
        this.stripPort = stripPort;
        this.useCanonicalHostname = true;
    }

    public KerberosSchemeFactory() {
        this(true, true);
    }

    public boolean isStripPort() {
        return this.stripPort;
    }

    public boolean isUseCanonicalHostname() {
        return this.useCanonicalHostname;
    }

    @Override
    public AuthScheme newInstance(HttpParams params) {
        return new KerberosScheme(this.stripPort, this.useCanonicalHostname);
    }

    @Override
    public AuthScheme create(HttpContext context) {
        return new KerberosScheme(this.stripPort, this.useCanonicalHostname);
    }
}

