/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.libs.apache.http.impl;

import java.util.Locale;
import xyz.janboerman.scalaloader.libs.apache.http.HttpResponse;
import xyz.janboerman.scalaloader.libs.apache.http.HttpResponseFactory;
import xyz.janboerman.scalaloader.libs.apache.http.ProtocolVersion;
import xyz.janboerman.scalaloader.libs.apache.http.ReasonPhraseCatalog;
import xyz.janboerman.scalaloader.libs.apache.http.StatusLine;
import xyz.janboerman.scalaloader.libs.apache.http.annotation.Contract;
import xyz.janboerman.scalaloader.libs.apache.http.annotation.ThreadingBehavior;
import xyz.janboerman.scalaloader.libs.apache.http.impl.EnglishReasonPhraseCatalog;
import xyz.janboerman.scalaloader.libs.apache.http.message.BasicHttpResponse;
import xyz.janboerman.scalaloader.libs.apache.http.message.BasicStatusLine;
import xyz.janboerman.scalaloader.libs.apache.http.protocol.HttpContext;
import xyz.janboerman.scalaloader.libs.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseFactory
implements HttpResponseFactory {
    public static final DefaultHttpResponseFactory INSTANCE = new DefaultHttpResponseFactory();
    protected final ReasonPhraseCatalog reasonCatalog;

    public DefaultHttpResponseFactory(ReasonPhraseCatalog catalog) {
        this.reasonCatalog = Args.notNull(catalog, "Reason phrase catalog");
    }

    public DefaultHttpResponseFactory() {
        this(EnglishReasonPhraseCatalog.INSTANCE);
    }

    @Override
    public HttpResponse newHttpResponse(ProtocolVersion ver, int status, HttpContext context) {
        Args.notNull(ver, "HTTP version");
        Locale loc = this.determineLocale(context);
        String reason = this.reasonCatalog.getReason(status, loc);
        BasicStatusLine statusline = new BasicStatusLine(ver, status, reason);
        return new BasicHttpResponse(statusline, this.reasonCatalog, loc);
    }

    @Override
    public HttpResponse newHttpResponse(StatusLine statusline, HttpContext context) {
        Args.notNull(statusline, "Status line");
        return new BasicHttpResponse(statusline, this.reasonCatalog, this.determineLocale(context));
    }

    protected Locale determineLocale(HttpContext context) {
        return Locale.getDefault();
    }
}

