/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.libs.apache.http.client.protocol;

import java.io.IOException;
import xyz.janboerman.scalaloader.libs.apache.commons.logging.Log;
import xyz.janboerman.scalaloader.libs.apache.commons.logging.LogFactory;
import xyz.janboerman.scalaloader.libs.apache.http.HttpException;
import xyz.janboerman.scalaloader.libs.apache.http.HttpRequest;
import xyz.janboerman.scalaloader.libs.apache.http.HttpRequestInterceptor;
import xyz.janboerman.scalaloader.libs.apache.http.annotation.Contract;
import xyz.janboerman.scalaloader.libs.apache.http.annotation.ThreadingBehavior;
import xyz.janboerman.scalaloader.libs.apache.http.client.protocol.HttpClientContext;
import xyz.janboerman.scalaloader.libs.apache.http.conn.routing.RouteInfo;
import xyz.janboerman.scalaloader.libs.apache.http.protocol.HttpContext;
import xyz.janboerman.scalaloader.libs.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestClientConnControl
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String PROXY_CONN_DIRECTIVE = "Proxy-Connection";

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            request.setHeader(PROXY_CONN_DIRECTIVE, "Keep-Alive");
            return;
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RouteInfo route = clientContext.getHttpRoute();
        if (route == null) {
            this.log.debug("Connection route not set in the context");
            return;
        }
        if ((route.getHopCount() == 1 || route.isTunnelled()) && !request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
        if (route.getHopCount() == 2 && !route.isTunnelled() && !request.containsHeader(PROXY_CONN_DIRECTIVE)) {
            request.addHeader(PROXY_CONN_DIRECTIVE, "Keep-Alive");
        }
    }
}

