/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.event.transform;

import xyz.janboerman.scalaloader.event.transform.CancellableTransformer;
import xyz.janboerman.scalaloader.event.transform.EventBusUserTransformer;
import xyz.janboerman.scalaloader.event.transform.EventError;
import xyz.janboerman.scalaloader.event.transform.EventExecutorTransformer;
import xyz.janboerman.scalaloader.event.transform.EventScanner;
import xyz.janboerman.scalaloader.event.transform.EventTransformer;
import xyz.janboerman.scalaloader.event.transform.EventUserTransformer;
import xyz.janboerman.scalaloader.event.transform.ScanResult;
import xyz.janboerman.scalaloader.libs.asm.ClassReader;
import xyz.janboerman.scalaloader.libs.asm.ClassVisitor;
import xyz.janboerman.scalaloader.libs.asm.ClassWriter;

public class EventTransformations {
    static final int ASM_API = 589824;
    static final String BUKKIT_EVENT_DESCRIPTOR = "Lorg/bukkit/event/Event;";
    static final String BUKKIT_CANCELLABLE_DESCRIPTOR = "Lorg/bukkit/event/Cancellable;";
    static final String BUKKIT_EVENTEXECUTOR_DESCRIPTOR = "Lorg/bukkit/plugin/EventExecutor;";
    static final String BUKKIT_EVENT_NAME = "org/bukkit/event/Event";
    static final String BUKKIT_CANCELLABLE_NAME = "org/bukkit/event/Cancellable";
    static final String BUKKIT_EVENTEXECUTOR_NAME = "org/bukkit/plugin/EventExecutor";
    static final String BUKKIT_EVENT_CLASS = "org.bukkit.event.Event";
    static final String BUKKIT_CANCELLABLE_CLASS = "org.bukkit.event.Cancellable";
    static final String BUKKIT_EVENTEXECUTOR_CLASS = "org.bukkit.plugin.EventExecutor";
    static final String HANDLERLIST_DESCRIPTOR = "Lorg/bukkit/event/HandlerList;";
    static final String GETHANDLERLIST_DESCRIPTOR = "()Lorg/bukkit/event/HandlerList;";
    static final String GETHANDLERS_DESCRIPTOR = "()Lorg/bukkit/event/HandlerList;";
    static final String HANDLERLIST_NAME = "org/bukkit/event/HandlerList";
    static final String GETHANDLERLIST_METHODNAME = "getHandlerList";
    static final String GETHANDLERS_METHODNAME = "getHandlers";
    static final String SCALALOADER_EVENT_DESCRIPTOR = "Lxyz/janboerman/scalaloader/event/Event;";
    static final String SCALALOADER_CANCELLABLE_DESCRIPTOR = "Lxyz/janboerman/scalaloader/event/Cancellable;";
    static final String SCALALOADER_EVENTEXECUTOR_DESCRIPTOR = "Lxyz/janboerman/scalaloader/event/EventExecutor;";
    static final String SCALALOADER_EVENT_NAME = "xyz/janboerman/scalaloader/event/Event";
    static final String SCALALOADER_CANCELLABLE_NAME = "xyz/janboerman/scalaloader/event/Cancellable";
    static final String SCALALOADER_EVENTEXECUTOR_NAME = "xyz/janboerman/scalaloader/event/EventExecutor";
    static final String SCALALOADER_EVENT_CLASS = "xyz.janboerman.scalaloader.event.Event";
    static final String SCALALOADER_CANCELLABLE_CLASS = "xyz.janboerman.scalaloader.event.Cancellable";
    static final String SCALALOADER_EVENTEXECUTOR_CLASS = "xyz.janboerman.scalaloader.event.EventExecutor";
    static final String SETCANCELLED_NAME = "setCancelled";
    static final String ISCANCELLED_NAME = "isCancelled";
    static final String EXECUTE_NAME = "execute";
    static final String SETCANCELLED_DESCRIPTOR = "(Z)V";
    static final String ISCANCELLED_DESCRIPTOR = "()Z";
    static final String SCALALOADER_EXECUTE_DESCRIPTOR = "(Lorg/bukkit/event/Listener;Ljava/lang/Object;)V";
    static final String BUKKIT_EXECUTE_DESCRIPTOR = "(Lorg/bukkit/event/Listener;Lorg/bukkit/event/Event;)V";
    static final String FALLBACK_HANDLERLIST_FIELD_NAME = "$HANDLERS";
    static final String FALLBACK_CANCEL_FIELD_NAME = "$cancel";

    private EventTransformations() {
    }

    public static byte[] transform(byte[] clazz, final ClassLoader pluginClassLoader) throws EventError {
        ClassWriter classWriter;
        ScanResult eventResult = new EventScanner().scan(new ClassReader(clazz));
        ClassVisitor combinedTransformer = classWriter = new ClassWriter(0){

            @Override
            protected ClassLoader getClassLoader() {
                return pluginClassLoader;
            }
        };
        if (eventResult.extendsScalaLoaderEvent) {
            combinedTransformer = new EventTransformer(eventResult, combinedTransformer);
        }
        if (eventResult.implementsScalaLoaderCancellable) {
            combinedTransformer = new CancellableTransformer(eventResult, combinedTransformer);
        }
        if (eventResult.implementsScalaLoaderEventExecutor) {
            combinedTransformer = new EventExecutorTransformer(combinedTransformer);
        }
        combinedTransformer = new EventBusUserTransformer(combinedTransformer);
        combinedTransformer = new EventUserTransformer(combinedTransformer);
        new ClassReader(clazz).accept(combinedTransformer, 8);
        return classWriter.toByteArray();
    }
}

