/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.dependency;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.janboerman.scalaloader.compat.Compat;
import xyz.janboerman.scalaloader.libs.apache.maven.repository.internal.MavenRepositorySystemUtils;
import xyz.janboerman.scalaloader.libs.eclipse.aether.DefaultRepositorySystemSession;
import xyz.janboerman.scalaloader.libs.eclipse.aether.RepositorySystem;
import xyz.janboerman.scalaloader.libs.eclipse.aether.RepositorySystemSession;
import xyz.janboerman.scalaloader.libs.eclipse.aether.artifact.DefaultArtifact;
import xyz.janboerman.scalaloader.libs.eclipse.aether.collection.CollectRequest;
import xyz.janboerman.scalaloader.libs.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import xyz.janboerman.scalaloader.libs.eclipse.aether.graph.Dependency;
import xyz.janboerman.scalaloader.libs.eclipse.aether.impl.DefaultServiceLocator;
import xyz.janboerman.scalaloader.libs.eclipse.aether.repository.LocalRepository;
import xyz.janboerman.scalaloader.libs.eclipse.aether.repository.RemoteRepository;
import xyz.janboerman.scalaloader.libs.eclipse.aether.resolution.ArtifactResult;
import xyz.janboerman.scalaloader.libs.eclipse.aether.resolution.DependencyRequest;
import xyz.janboerman.scalaloader.libs.eclipse.aether.resolution.DependencyResolutionException;
import xyz.janboerman.scalaloader.libs.eclipse.aether.resolution.DependencyResult;
import xyz.janboerman.scalaloader.libs.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import xyz.janboerman.scalaloader.libs.eclipse.aether.spi.connector.transport.TransporterFactory;
import xyz.janboerman.scalaloader.libs.eclipse.aether.transfer.AbstractTransferListener;
import xyz.janboerman.scalaloader.libs.eclipse.aether.transfer.TransferCancelledException;
import xyz.janboerman.scalaloader.libs.eclipse.aether.transfer.TransferEvent;
import xyz.janboerman.scalaloader.libs.eclipse.aether.transport.http.HttpTransporterFactory;
import xyz.janboerman.scalaloader.plugin.ScalaPluginLoaderException;

public class PluginYamlLibraryLoader {
    private static final RemoteRepository MAVEN_CENTRAL = new RemoteRepository.Builder("central", "default", "https://repo.maven.apache.org/maven2").build();
    private static final RemoteRepository CODE_MC = new RemoteRepository.Builder("CodeMC", "default", "https://repo.codemc.org/repository/maven-public/").build();
    private final Logger logger;
    private final RepositorySystem system;
    private final RepositorySystemSession session;
    private final List<RemoteRepository> repositories;

    public PluginYamlLibraryLoader(Logger logger, File localRepoDir) {
        this.logger = logger;
        this.system = PluginYamlLibraryLoader.getRepositorySystem();
        this.session = PluginYamlLibraryLoader.getSession(this.system, logger, localRepoDir);
        this.repositories = this.system.newResolutionRepositories(this.session, Compat.listOf(MAVEN_CENTRAL, CODE_MC));
    }

    public Collection<File> getJarFiles(Map<String, Object> pluginYaml) throws ScalaPluginLoaderException {
        Object o = pluginYaml.get("libraries");
        if (!(o instanceof List)) {
            return Compat.emptySet();
        }
        List list = (List)o;
        if (list.isEmpty()) {
            return Compat.emptySet();
        }
        int size = list.size();
        this.logger.log(Level.INFO, "Loading {0} libraries... please wait", size);
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>(size);
        for (Object item : list) {
            if (!(item instanceof String)) continue;
            String library = (String)item;
            DefaultArtifact artifact = new DefaultArtifact(library);
            Dependency dependency = new Dependency(artifact, "compile");
            dependencies.add(dependency);
        }
        if (dependencies.isEmpty()) {
            return Compat.emptySet();
        }
        try {
            CollectRequest collectRequest = new CollectRequest((Dependency)null, dependencies, this.repositories);
            DependencyRequest request = new DependencyRequest(collectRequest, null);
            DependencyResult result = this.system.resolveDependencies(this.session, request);
            ArrayList<File> jarFiles = new ArrayList<File>(dependencies.size());
            for (ArtifactResult artifactResult : result.getArtifactResults()) {
                jarFiles.add(artifactResult.getArtifact().getFile());
            }
            return jarFiles;
        }
        catch (DependencyResolutionException e) {
            throw new ScalaPluginLoaderException("Can't download dependencies", e);
        }
    }

    private static RepositorySystemSession getSession(RepositorySystem system, final Logger logger, File localRepoDir) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        session.setChecksumPolicy("fail");
        session.setLocalRepositoryManager(system.newLocalRepositoryManager(session, new LocalRepository(localRepoDir)));
        session.setTransferListener(new AbstractTransferListener(){

            @Override
            public void transferStarted(TransferEvent event) throws TransferCancelledException {
                logger.log(Level.INFO, "Downloading {0}", event.getResource().getRepositoryUrl() + event.getResource().getResourceName());
            }
        });
        session.setReadOnly();
        return session;
    }

    private static RepositorySystem getRepositorySystem() {
        DefaultServiceLocator serviceLocator = MavenRepositorySystemUtils.newServiceLocator();
        serviceLocator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        serviceLocator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        return serviceLocator.getService(RepositorySystem.class);
    }
}

