/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.dependency;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.janboerman.scalaloader.ScalaLibraryClassLoader;
import xyz.janboerman.scalaloader.bytecode.TransformerRegistry;
import xyz.janboerman.scalaloader.compat.Compat;
import xyz.janboerman.scalaloader.plugin.ScalaPluginClassLoader;
import xyz.janboerman.scalaloader.util.ClassLoaderUtils;

public class LibraryClassLoader
extends URLClassLoader {
    private final ConcurrentHashMap<String, Class<?>> classes = new ConcurrentHashMap();
    private final File[] jarFiles;
    private final Logger logger;
    private final ScalaPluginClassLoader plugin;
    private final TransformerRegistry transformerRegistry;

    public LibraryClassLoader(File[] jarFiles, ScalaLibraryClassLoader parent, Logger logger, ScalaPluginClassLoader plugin, TransformerRegistry transformerRegistry) {
        super(LibraryClassLoader.urls(jarFiles), (ClassLoader)parent);
        this.jarFiles = jarFiles;
        this.logger = logger;
        this.plugin = plugin;
        this.transformerRegistry = transformerRegistry;
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> found = this.classes.get(name);
        if (found != null) {
            return found;
        }
        String path = name.replace('.', '/') + ".class";
        for (File file : this.jarFiles) {
            Class clazz;
            block18: {
                JarFile jarFile = Compat.jarFile(file);
                JarEntry jarEntry = jarFile.getJarEntry(path);
                if (jarEntry == null) continue;
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                try {
                    URL url;
                    byte[] classBytes;
                    block17: {
                        String packageName;
                        classBytes = Compat.readAllBytes(inputStream);
                        url = file.toURI().toURL();
                        classBytes = ClassLoaderUtils.transform(name, classBytes, this, this.transformerRegistry, this.plugin, this.logger);
                        int dotIndex = name.lastIndexOf(46);
                        if (dotIndex != -1 && this.getPackage(packageName = name.substring(0, dotIndex)) == null) {
                            try {
                                Manifest manifest = jarFile.getManifest();
                                if (manifest != null) {
                                    this.definePackage(packageName, manifest, url);
                                } else {
                                    this.definePackage(packageName, null, null, null, null, null, null, null);
                                }
                            }
                            catch (IllegalArgumentException e) {
                                if (this.getPackage(packageName) != null) break block17;
                                throw new IllegalStateException("Cannot find package " + packageName);
                            }
                        }
                    }
                    CodeSigner[] codeSigners = jarEntry.getCodeSigners();
                    CodeSource codeSource = new CodeSource(url, codeSigners);
                    Class<?> newClass = found = this.defineClass(name, classBytes, 0, classBytes.length, codeSource);
                    clazz = this.classes.computeIfAbsent(name, k -> newClass);
                    if (inputStream == null) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        this.logger.log(Level.SEVERE, "File " + file + ", is not a valid jar file", e);
                    }
                }
                inputStream.close();
            }
            return clazz;
        }
        try {
            super.findClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        throw new ClassNotFoundException(name);
    }

    private static URL[] urls(File[] files) {
        URL[] urls = new URL[files.length];
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            try {
                urls[i] = file.toURI().toURL();
                continue;
            }
            catch (MalformedURLException impossibru) {
                throw new RuntimeException("jar file " + file + " has a malformed url", impossibru);
            }
        }
        return urls;
    }

    static {
        LibraryClassLoader.registerAsParallelCapable();
    }
}

