/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.configurationserializable.transform;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import xyz.janboerman.scalaloader.bytecode.FieldDeclaration;
import xyz.janboerman.scalaloader.bytecode.LocalCounter;
import xyz.janboerman.scalaloader.bytecode.LocalVariable;
import xyz.janboerman.scalaloader.bytecode.LocalVariableTable;
import xyz.janboerman.scalaloader.bytecode.MethodHeader;
import xyz.janboerman.scalaloader.bytecode.OperandStack;
import xyz.janboerman.scalaloader.configurationserializable.DeserializationMethod;
import xyz.janboerman.scalaloader.configurationserializable.InjectionPoint;
import xyz.janboerman.scalaloader.configurationserializable.Scan;
import xyz.janboerman.scalaloader.configurationserializable.transform.ConfigurationSerializableError;
import xyz.janboerman.scalaloader.configurationserializable.transform.ConfigurationSerializableTransformations;
import xyz.janboerman.scalaloader.configurationserializable.transform.Conversions;
import xyz.janboerman.scalaloader.configurationserializable.transform.LocalScanResult;
import xyz.janboerman.scalaloader.configurationserializable.transform.UnapplyParamCounter;
import xyz.janboerman.scalaloader.libs.asm.AnnotationVisitor;
import xyz.janboerman.scalaloader.libs.asm.ClassVisitor;
import xyz.janboerman.scalaloader.libs.asm.FieldVisitor;
import xyz.janboerman.scalaloader.libs.asm.Label;
import xyz.janboerman.scalaloader.libs.asm.MethodVisitor;
import xyz.janboerman.scalaloader.libs.asm.Type;
import xyz.janboerman.scalaloader.libs.asm.signature.SignatureReader;
import xyz.janboerman.scalaloader.plugin.ScalaPluginClassLoader;
import xyz.janboerman.scalaloader.util.Pair;

class SerializableTransformer
extends ClassVisitor {
    private final LocalScanResult result;
    private final ScalaPluginClassLoader pluginClassLoader;
    private String className;
    private String classDescriptor;
    private String superType;
    private String classSignature;
    private boolean classIsInterface;
    private boolean alreadyHasSerializeMethod;
    private boolean alreadyHasDeserializeMethod;
    private boolean alreadyHasValueOfMethod;
    private boolean alreadyHasDeserializationConstructor;
    private boolean alreadyHasNullaryConstructor;
    private boolean alreadyHasClassInitializer;
    private boolean alreadyHasModule$;
    private final Map<MethodHeader, List<String>> applyHeaders = new HashMap<MethodHeader, List<String>>(0);
    private final List<MethodHeader> unapplyHeaders = new ArrayList<MethodHeader>(0);
    private final Scan.Type scanType;
    private String serializableAs;
    private DeserializationMethod constructUsing = null;
    private InjectionPoint registerAt = InjectionPoint.PLUGIN_ONENABLE;
    private final Map<String, MethodHeader> propertyGetters = new LinkedHashMap<String, MethodHeader>();
    private final Map<String, MethodHeader> propertySetters = new LinkedHashMap<String, MethodHeader>();
    private final Map<String, FieldDeclaration> propertyFields = new LinkedHashMap<String, FieldDeclaration>();
    private final Set<FieldDeclaration> allInstanceFields = new HashSet<FieldDeclaration>();

    SerializableTransformer(ClassVisitor classVisitor, LocalScanResult scanResult, ScalaPluginClassLoader pluginClassLoader) {
        super(589824, classVisitor);
        this.result = scanResult;
        this.pluginClassLoader = pluginClassLoader;
        this.scanType = scanResult.scanType;
        assert (this.scanType != null && this.scanType != Scan.Type.AUTO_DETECT) : "unknown scan type";
    }

    private DeserializationMethod constructUsing() {
        if (this.constructUsing == null) {
            assert (this.scanType != null && this.scanType != Scan.Type.AUTO_DETECT) : "unknown scan type";
            switch (this.scanType) {
                case FIELDS: 
                case GETTER_SETTER_METHODS: {
                    this.constructUsing = DeserializationMethod.MAP_CONSTRUCTOR;
                    break;
                }
                default: {
                    this.constructUsing = DeserializationMethod.DESERIALIZE;
                }
            }
        }
        return this.constructUsing;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (this.result.annotatedByConfigurationSerializable) {
            this.className = name;
            this.classDescriptor = 'L' + name + ';';
            this.classSignature = signature;
            this.superType = superName;
            this.classIsInterface = (access & 0x200) == 512;
            access = (access | 1) & 0xFFFFFFF9;
            if (!this.result.implementsConfigurationSerializable) {
                String[] newInterfaces = new String[interfaces.length + 1];
                System.arraycopy(interfaces, 0, newInterfaces, 0, interfaces.length);
                newInterfaces[interfaces.length] = ConfigurationSerializableTransformations.BUKKIT_CONFIGURATIONSERIALIZABLE_NAME;
                interfaces = newInterfaces;
            }
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        AnnotationVisitor superVisitor = super.visitAnnotation(descriptor, visible);
        if (ConfigurationSerializableTransformations.SCALALOADER_CONFIGURATIONSERIALIZABLE_DESCRIPTOR.equals(descriptor)) {
            return new AnnotationVisitor(589824, superVisitor){
                boolean setAlias;
                {
                    this.setAlias = false;
                }

                @Override
                public void visit(String name, Object value) {
                    if ("as".equals(name)) {
                        SerializableTransformer.this.serializableAs = (String)value;
                        this.setAlias = true;
                    }
                    super.visit(name, value);
                }

                @Override
                public void visitEnum(String name, String descriptor, String value) {
                    if ("constructUsing".equals(name) && ConfigurationSerializableTransformations.SCALALOADER_DESERIALIZATIONMETHOD_DESCRIPTOR.equals(descriptor)) {
                        SerializableTransformer.this.constructUsing = DeserializationMethod.valueOf(value);
                    } else if ("registerAt".equals(name) && ConfigurationSerializableTransformations.SCALALOADER_INJECTIONPOINT_DESCRIPTOR.equals(descriptor)) {
                        SerializableTransformer.this.registerAt = InjectionPoint.valueOf(value);
                    }
                    super.visit(name, value);
                }

                @Override
                public void visitEnd() {
                    super.visitEnd();
                    if (this.setAlias && !((SerializableTransformer)SerializableTransformer.this).result.annotatedBySerializableAs) {
                        AnnotationVisitor av = SerializableTransformer.this.visitAnnotation(ConfigurationSerializableTransformations.BUKKIT_SERIALIZABLEAS_DESCRIPTOR, true);
                        av.visit("value", SerializableTransformer.this.serializableAs);
                        av.visitEnd();
                    }
                }
            };
        }
        if (ConfigurationSerializableTransformations.BUKKIT_SERIALIZABLEAS_DESCRIPTOR.equals(descriptor)) {
            return new AnnotationVisitor(589824, superVisitor){

                @Override
                public void visit(String name, Object value) {
                    if ("value".equals(name)) {
                        SerializableTransformer.this.serializableAs = (String)value;
                    }
                    super.visit(name, value);
                }
            };
        }
        return superVisitor;
    }

    @Override
    public FieldVisitor visitField(int access, final String fieldName, final String fieldDescriptor, final String fieldSignature, Object value) {
        if ("MODULE$".equals(fieldName) && (access & 8) == 8 && fieldDescriptor.equals(this.classDescriptor)) {
            this.alreadyHasModule$ = true;
        }
        if ((access & 8) == 0) {
            this.allInstanceFields.add(new FieldDeclaration(access, fieldName, fieldDescriptor, fieldSignature));
        }
        if (this.result.annotatedByConfigurationSerializable && (access & 8) == 0 && (access & 0x80) == 0 && (this.scanType == Scan.Type.FIELDS || this.scanType == Scan.Type.RECORD)) {
            final int finalAccess = this.scanType == Scan.Type.FIELDS ? access & 0xFFFFFFEF : access;
            return new FieldVisitor(589824, super.visitField(finalAccess, fieldName, fieldDescriptor, fieldSignature, value)){
                String property;
                boolean include;
                boolean exclude;
                {
                    super(api, fieldVisitor);
                    this.property = fieldName;
                }

                @Override
                public AnnotationVisitor visitAnnotation(String annDescriptor, boolean visible) {
                    AnnotationVisitor superVisitor = super.visitAnnotation(annDescriptor, visible);
                    if (ConfigurationSerializableTransformations.SCALALOADER_INCLUDEPROPERTY_DESCRIPTOR.equals(annDescriptor)) {
                        this.include = true;
                        return new AnnotationVisitor(589824, superVisitor){

                            @Override
                            public void visit(String name, Object value) {
                                if ("value".equals(name)) {
                                    property = (String)value;
                                }
                                super.visit(name, value);
                            }
                        };
                    }
                    if (ConfigurationSerializableTransformations.SCALALOADER_EXCLUDEPROPERTY_DESCRIPTOR.equals(annDescriptor)) {
                        this.exclude = true;
                        this.property = null;
                        return superVisitor;
                    }
                    return superVisitor;
                }

                @Override
                public void visitEnd() {
                    FieldDeclaration existingFieldDeclaration;
                    if (this.include && this.exclude) {
                        throw new ConfigurationSerializableError("Can't annotate field " + fieldName + " with both @" + Scan.IncludeProperty.class.getSimpleName() + " and @" + Scan.ExcludeProperty.class.getSimpleName() + ", please remove one of the two!");
                    }
                    if (this.property != null && (existingFieldDeclaration = SerializableTransformer.this.propertyFields.put(this.property, new FieldDeclaration(finalAccess, fieldName, fieldDescriptor, fieldSignature))) != null) {
                        throw new ConfigurationSerializableError("Duplicate field for property: " + this.property);
                    }
                    super.visitEnd();
                }
            };
        }
        return super.visitField(access, fieldName, fieldDescriptor, fieldSignature, value);
    }

    @Override
    public MethodVisitor visitMethod(int access, final String methodName, final String methodDescriptor, final String methodSignature, final String[] exceptions) {
        MethodVisitor superVisitor = super.visitMethod(access, methodName, methodDescriptor, methodSignature, exceptions);
        if (this.result.annotatedByConfigurationSerializable) {
            boolean isSetter;
            boolean isStatic;
            boolean bl = isStatic = (access & 8) == 8;
            if (!isStatic && "serialize".equals(methodName) && "()Ljava/util/Map;".equals(methodDescriptor)) {
                this.alreadyHasSerializeMethod = true;
                access = (access | 1) & 0xFFFFFFF9;
            } else if (!isStatic && "<init>".equals(methodName) && "()V".equals(methodDescriptor)) {
                this.alreadyHasNullaryConstructor = true;
            } else if (!isStatic && "<init>".equals(methodName) && ConfigurationSerializableTransformations.DESERIALIZATION_CONSTRUCTOR_DESCRIPTOR.equals(methodDescriptor)) {
                this.alreadyHasDeserializationConstructor = true;
                access = (access | 1) & 0xFFFFFFF9;
            } else if (isStatic && "deserialize".equals(methodName) && ConfigurationSerializableTransformations.deserializationDescriptor(this.classDescriptor).equals(methodDescriptor)) {
                this.alreadyHasDeserializeMethod = true;
                access = (access | 1) & 0xFFFFFFF9;
            } else if (isStatic && "valueOf".equals(methodName) && ConfigurationSerializableTransformations.deserializationDescriptor(this.classDescriptor).equals(methodDescriptor)) {
                this.alreadyHasValueOfMethod = true;
                access = (access | 1) & 0xFFFFFFF9;
            } else if (isStatic && "<clinit>".equals(methodName) && "()V".equals(methodDescriptor)) {
                this.alreadyHasClassInitializer = true;
                if (this.registerAt == InjectionPoint.CLASS_INITIALIZER) {
                    return new MethodVisitor(589824, superVisitor){

                        @Override
                        public void visitCode() {
                            this.visitMethodInsn(184, SerializableTransformer.this.className, "$registerWithConfigurationSerialization", "()V", SerializableTransformer.this.classIsInterface);
                            super.visitCode();
                        }
                    };
                }
            } else {
                if (isStatic && "apply".equals(methodName)) {
                    MethodHeader mh = new MethodHeader(access, methodName, methodDescriptor, methodSignature, exceptions);
                    final ArrayList paramNames = new ArrayList(2);
                    this.applyHeaders.put(mh, paramNames);
                    return new MethodVisitor(589824, superVisitor){

                        @Override
                        public void visitParameter(String name, int access) {
                            paramNames.add(name);
                        }
                    };
                }
                if (isStatic && "unapply".equals(methodName)) {
                    this.unapplyHeaders.add(new MethodHeader(access, methodName, methodDescriptor, methodSignature, exceptions));
                }
            }
            final int methodAccess = access;
            Type methodType = Type.getMethodType(methodDescriptor);
            Type[] argumentTypes = methodType.getArgumentTypes();
            Type returnType = methodType.getReturnType();
            final boolean isGetter = !isStatic && argumentTypes.length == 0 && !returnType.equals(Type.VOID_TYPE);
            boolean bl2 = isSetter = !isStatic && argumentTypes.length == 1 && (returnType.equals(Type.VOID_TYPE) || returnType.equals(Type.getType(this.classDescriptor)));
            if (isGetter || isSetter) {
                return new MethodVisitor(589824, superVisitor){

                    @Override
                    public AnnotationVisitor visitAnnotation(String annDescriptor, boolean visible) {
                        if (ConfigurationSerializableTransformations.SCALALOADER_INCLUDEPROPERTY_DESCRIPTOR.equals(annDescriptor)) {
                            return new AnnotationVisitor(589824, super.visitAnnotation(annDescriptor, visible)){
                                String propertyKey;
                                boolean adaptBeanOrScalaConventions;
                                {
                                    this.propertyKey = methodName;
                                    this.adaptBeanOrScalaConventions = true;
                                }

                                @Override
                                public void visit(String name, Object value) {
                                    if ("value".equals(name)) {
                                        this.propertyKey = (String)value;
                                        this.adaptBeanOrScalaConventions = false;
                                    } else if ("adapt".equals(name) && value.equals(false)) {
                                        this.adaptBeanOrScalaConventions = false;
                                    }
                                    super.visit(name, value);
                                }

                                @Override
                                public void visitEnd() {
                                    if (isSetter) {
                                        MethodHeader existingSetter;
                                        if (this.adaptBeanOrScalaConventions) {
                                            if (this.propertyKey.startsWith("set") && this.propertyKey.length() > 3) {
                                                this.propertyKey = Character.toLowerCase(this.propertyKey.charAt(3)) + this.propertyKey.substring(4);
                                            } else if (this.propertyKey.endsWith("_$eq")) {
                                                this.propertyKey = this.propertyKey.substring(0, this.propertyKey.length() - 4);
                                            }
                                        }
                                        if ((existingSetter = SerializableTransformer.this.propertySetters.put(this.propertyKey, new MethodHeader(methodAccess, methodName, methodDescriptor, methodSignature, exceptions))) != null) {
                                            throw new ConfigurationSerializableError("Duplicate setter for property: " + this.propertyKey);
                                        }
                                    } else if (isGetter) {
                                        MethodHeader existingGetter;
                                        if (this.adaptBeanOrScalaConventions) {
                                            if (this.propertyKey.startsWith("get") && this.propertyKey.length() > 3) {
                                                this.propertyKey = Character.toLowerCase(this.propertyKey.charAt(3)) + this.propertyKey.substring(4);
                                            } else if (this.propertyKey.startsWith("is") && this.propertyKey.length() > 2) {
                                                this.propertyKey = Character.toLowerCase(this.propertyKey.charAt(2)) + this.propertyKey.substring(3);
                                            }
                                        }
                                        if ((existingGetter = SerializableTransformer.this.propertyGetters.put(this.propertyKey, new MethodHeader(methodAccess, methodName, methodDescriptor, methodSignature, exceptions))) != null) {
                                            throw new ConfigurationSerializableError("Duplicate getter for property: " + this.propertyKey);
                                        }
                                    }
                                    super.visitEnd();
                                }
                            };
                        }
                        return super.visitAnnotation(annDescriptor, visible);
                    }
                };
            }
        }
        return superVisitor;
    }

    @Override
    public void visitEnd() {
        if (this.result.annotatedByConfigurationSerializable && (this.scanType != Scan.Type.SINGLETON_OBJECT || this.alreadyHasModule$)) {
            LocalVariableTable localVariableTable;
            int n;
            boolean hasDeserizalizationMethod;
            boolean bl = hasDeserizalizationMethod = this.alreadyHasDeserializationConstructor || this.alreadyHasValueOfMethod || this.alreadyHasDeserializeMethod;
            if (!this.alreadyHasSerializeMethod && !hasDeserizalizationMethod && this.scanType == Scan.Type.GETTER_SETTER_METHODS) {
                Object getter;
                if (!this.propertyGetters.keySet().equals(this.propertySetters.keySet())) {
                    HashSet<String> getterProperties = new HashSet<String>(this.propertyGetters.keySet());
                    HashSet<String> hashSet = new HashSet<String>(this.propertySetters.keySet());
                    Iterator iterator = getterProperties.iterator();
                    while (iterator.hasNext()) {
                        getter = (String)iterator.next();
                        if (hashSet.remove(getter)) continue;
                        throw new ConfigurationSerializableError("Missing setter method for property: " + (String)getter);
                    }
                    for (String setter : hashSet) {
                        if (getterProperties.remove(setter)) continue;
                        throw new ConfigurationSerializableError("Missing getter method for property: " + setter);
                    }
                } else {
                    for (Map.Entry entry : this.propertyGetters.entrySet()) {
                        String setterDescriptor;
                        String setterSignature;
                        String property = (String)entry.getKey();
                        getter = (MethodHeader)entry.getValue();
                        MethodHeader setter = this.propertySetters.get(property);
                        String getterSignature = ((MethodHeader)getter).getReturnSignature();
                        if (getterSignature != null && (setterSignature = setter.getParameterSignature(0)) != null && !getterSignature.equals(setterSignature)) {
                            throw new ConfigurationSerializableError("Incompatible getter/setter combination for property: " + property);
                        }
                        String getterDescriptor = ((MethodHeader)getter).getReturnDescriptor();
                        if (getterDescriptor.equals(setterDescriptor = setter.getParameterDescriptor(0))) continue;
                        throw new ConfigurationSerializableError("Incompatible getter/setter combination for property: " + property);
                    }
                }
            }
            MethodHeader unapplyHeader = null;
            boolean bl2 = false;
            MethodHeader applyHeader = null;
            List<String> applyParamNames = null;
            if (this.scanType == Scan.Type.CASE_CLASS) {
                Optional<Pair> unapply = this.unapplyHeaders.stream().map(header -> {
                    int paramCount;
                    String returnSignature = header.getReturnSignature();
                    if (returnSignature == null) {
                        paramCount = 0;
                    } else {
                        UnapplyParamCounter counter = new UnapplyParamCounter();
                        SignatureReader reader = new SignatureReader(returnSignature);
                        reader.accept(counter);
                        paramCount = counter.getParamCount();
                    }
                    return new Pair<MethodHeader, Integer>((MethodHeader)header, paramCount);
                }).max(Comparator.comparingInt(Pair::getSecond));
                if (!unapply.isPresent()) {
                    throw new ConfigurationSerializableError("using serialization method CASE_CLASS but unapply method does not exist");
                }
                Pair unApp = unapply.get();
                unapplyHeader = (MethodHeader)unApp.getFirst();
                n = (Integer)unApp.getSecond();
                boolean matchingApply = false;
                for (Map.Entry<MethodHeader, List<String>> entry : this.applyHeaders.entrySet()) {
                    applyHeader = entry.getKey();
                    applyParamNames = entry.getValue();
                    if (Type.getMethodType(applyHeader.descriptor).getArgumentTypes().length != n) continue;
                    matchingApply = true;
                    if (applyParamNames.size() == n) break;
                    applyParamNames = IntStream.range(0, n).mapToObj(i -> "property" + i).collect(Collectors.toList());
                    break;
                }
                if (!matchingApply) {
                    throw new ConfigurationSerializableError("using serialization method CASE_CLASS but there is no matching apply method for " + unapplyHeader.name);
                }
            }
            if (!this.alreadyHasSerializeMethod) {
                OperandStack operandStack = new OperandStack();
                localVariableTable = new LocalVariableTable();
                LocalCounter localCounter = new LocalCounter();
                int thisTableSlot = localCounter.getSlotIndex();
                int thisFrameIndex = localCounter.getFrameIndex();
                localCounter.add(Type.getType(this.classDescriptor));
                int mapTableSlot = localCounter.getSlotIndex();
                int mapFrameIndex = localCounter.getFrameIndex();
                localCounter.add(Type.getType("Ljava/util/Map;"));
                MethodVisitor methodVisitor = this.visitMethod(1, "serialize", "()Ljava/util/Map;", "()Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;", null);
                methodVisitor.visitCode();
                Label label0 = new Label();
                methodVisitor.visitLabel(label0);
                methodVisitor.visitTypeInsn(187, "java/util/HashMap");
                operandStack.push(ConfigurationSerializableTransformations.HASHMAP_TYPE);
                methodVisitor.visitInsn(89);
                operandStack.push(ConfigurationSerializableTransformations.HASHMAP_TYPE);
                methodVisitor.visitMethodInsn(183, "java/util/HashMap", "<init>", "()V", false);
                operandStack.pop();
                methodVisitor.visitVarInsn(58, mapTableSlot);
                operandStack.pop();
                Object label1 = new Label();
                methodVisitor.visitLabel((Label)label1);
                Label veryLastLabel = new Label();
                LocalVariable thisDef = new LocalVariable("this", this.classDescriptor, this.classSignature, label0, veryLastLabel, thisTableSlot, thisFrameIndex);
                Iterator<Object> mapDef = new LocalVariable("map", "Ljava/util/Map;", "Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;", (Label)label1, veryLastLabel, mapTableSlot, mapFrameIndex);
                localVariableTable.add(new LocalVariable[]{thisDef, mapDef});
                switch (this.scanType) {
                    case FIELDS: {
                        for (Map.Entry<String, FieldDeclaration> entry : this.propertyFields.entrySet()) {
                            String property = entry.getKey();
                            FieldDeclaration field = entry.getValue();
                            methodVisitor.visitVarInsn(25, mapTableSlot);
                            operandStack.push(ConfigurationSerializableTransformations.MAP_TYPE);
                            methodVisitor.visitLdcInsn(property);
                            operandStack.push(ConfigurationSerializableTransformations.STRING_TYPE);
                            methodVisitor.visitVarInsn(25, thisTableSlot);
                            operandStack.push(Type.getType(this.classDescriptor));
                            methodVisitor.visitFieldInsn(180, this.className, field.name, field.descriptor);
                            operandStack.replaceTop(Type.getType(field.descriptor));
                            Label newLabel = new Label();
                            Conversions.toSerializedType(this.pluginClassLoader, methodVisitor, field.descriptor, field.signature, localCounter, localVariableTable, operandStack);
                            methodVisitor.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true);
                            operandStack.replaceTop(3, ConfigurationSerializableTransformations.OBJECT_TYPE);
                            methodVisitor.visitInsn(87);
                            operandStack.pop();
                            methodVisitor.visitLabel(newLabel);
                        }
                        methodVisitor.visitVarInsn(25, mapTableSlot);
                        operandStack.push(ConfigurationSerializableTransformations.MAP_TYPE);
                        methodVisitor.visitInsn(176);
                        operandStack.pop();
                        break;
                    }
                    case GETTER_SETTER_METHODS: {
                        for (Map.Entry<String, MethodHeader> entry : this.propertyGetters.entrySet()) {
                            String property = entry.getKey();
                            MethodHeader methodHeader = entry.getValue();
                            methodVisitor.visitVarInsn(25, mapTableSlot);
                            operandStack.push(ConfigurationSerializableTransformations.MAP_TYPE);
                            methodVisitor.visitLdcInsn(property);
                            operandStack.push(ConfigurationSerializableTransformations.STRING_TYPE);
                            methodVisitor.visitVarInsn(25, thisTableSlot);
                            operandStack.push(Type.getType(this.classDescriptor));
                            int INVOKE = (methodHeader.access & 2) == 2 ? 183 : 182;
                            methodVisitor.visitMethodInsn(INVOKE, this.className, methodHeader.name, methodHeader.descriptor, false);
                            operandStack.replaceTop(1, Type.getType(methodHeader.getReturnDescriptor()));
                            Label newLabel = new Label();
                            Conversions.toSerializedType(this.pluginClassLoader, methodVisitor, methodHeader.getReturnDescriptor(), methodHeader.getReturnSignature(), localCounter, localVariableTable, operandStack);
                            methodVisitor.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true);
                            operandStack.replaceTop(3, ConfigurationSerializableTransformations.OBJECT_TYPE);
                            methodVisitor.visitInsn(87);
                            operandStack.pop();
                            methodVisitor.visitLabel(newLabel);
                        }
                        methodVisitor.visitVarInsn(25, mapTableSlot);
                        operandStack.push(ConfigurationSerializableTransformations.MAP_TYPE);
                        methodVisitor.visitInsn(176);
                        operandStack.pop();
                        break;
                    }
                    case RECORD: {
                        for (Map.Entry<String, FieldDeclaration> entry : this.propertyFields.entrySet()) {
                            String property = entry.getKey();
                            FieldDeclaration fieldDeclaration = entry.getValue();
                            methodVisitor.visitVarInsn(25, mapTableSlot);
                            operandStack.push(ConfigurationSerializableTransformations.MAP_TYPE);
                            methodVisitor.visitLdcInsn(property);
                            operandStack.push(ConfigurationSerializableTransformations.STRING_TYPE);
                            methodVisitor.visitVarInsn(25, thisTableSlot);
                            operandStack.push(Type.getType(this.classDescriptor));
                            methodVisitor.visitMethodInsn(182, this.className, property, "()" + fieldDeclaration.descriptor, false);
                            operandStack.replaceTop(Type.getType(fieldDeclaration.descriptor));
                            Label newLabel = new Label();
                            Conversions.toSerializedType(this.pluginClassLoader, methodVisitor, fieldDeclaration.descriptor, fieldDeclaration.signature, localCounter, localVariableTable, operandStack);
                            methodVisitor.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true);
                            operandStack.replaceTop(3, ConfigurationSerializableTransformations.OBJECT_TYPE);
                            methodVisitor.visitInsn(87);
                            operandStack.pop();
                            methodVisitor.visitLabel(newLabel);
                        }
                        methodVisitor.visitVarInsn(25, mapTableSlot);
                        operandStack.push(ConfigurationSerializableTransformations.MAP_TYPE);
                        methodVisitor.visitInsn(176);
                        operandStack.pop();
                        break;
                    }
                    case CASE_CLASS: {
                        Label definedTrueLabel;
                        Label beforeIsDefinedLabel;
                        assert (applyHeader != null) : "applyHeader is null when trying to generate code for serialize() method for ScanType CASE_CLASS";
                        assert (unapplyHeader != null) : "unapplyHeader is null when trying to generate code for seralize() method for ScanType CASE_CLASS";
                        if (n == 0) {
                            methodVisitor.visitVarInsn(25, thisTableSlot);
                            operandStack.push(Type.getType(this.classDescriptor));
                            methodVisitor.visitMethodInsn(184, this.className, "unapply", unapplyHeader.descriptor, this.classIsInterface);
                            operandStack.replaceTop(ConfigurationSerializableTransformations.BOOLEAN_TYPE);
                            Label label = new Label();
                            methodVisitor.visitJumpInsn(153, label);
                            operandStack.pop();
                            methodVisitor.visitVarInsn(25, mapTableSlot);
                            operandStack.push(ConfigurationSerializableTransformations.MAP_TYPE);
                            methodVisitor.visitInsn(176);
                            operandStack.pop();
                            methodVisitor.visitLabel(label);
                            methodVisitor.visitFrame(1, 1, new Object[]{"java/util/Map"}, 0, null);
                            methodVisitor.visitInsn(1);
                            operandStack.push(ConfigurationSerializableTransformations.MAP_TYPE);
                            methodVisitor.visitInsn(176);
                            operandStack.pop();
                            break;
                        }
                        if (n == 1) {
                            methodVisitor.visitVarInsn(25, thisTableSlot);
                            operandStack.push(Type.getType(this.classDescriptor));
                            methodVisitor.visitMethodInsn(184, this.className, "unapply", unapplyHeader.descriptor, this.classIsInterface);
                            operandStack.replaceTop(ConfigurationSerializableTransformations.OPTION_TYPE);
                            Label label = new Label();
                            int n2 = localCounter.getFrameIndex();
                            int testFrameIndex = localCounter.getFrameIndex();
                            localVariableTable.add(new LocalVariable("test", "Lscala/Option;", "Lscala/Option<Ljava/lang/Object;>;", (Label)label1, label, n2, testFrameIndex));
                            localCounter.add(Type.getType("Lscala/Option;"));
                            methodVisitor.visitVarInsn(58, n2);
                            operandStack.pop();
                            beforeIsDefinedLabel = new Label();
                            methodVisitor.visitLabel(beforeIsDefinedLabel);
                            methodVisitor.visitVarInsn(25, n2);
                            operandStack.push(ConfigurationSerializableTransformations.OPTION_TYPE);
                            methodVisitor.visitMethodInsn(182, "scala/Option", "isDefined", "()Z", false);
                            operandStack.replaceTop(ConfigurationSerializableTransformations.BOOLEAN_TYPE);
                            Label definedFalseJumpTarget = new Label();
                            methodVisitor.visitJumpInsn(153, definedFalseJumpTarget);
                            operandStack.pop();
                            definedTrueLabel = new Label();
                            methodVisitor.visitLabel(definedTrueLabel);
                            String propertyName = applyParamNames.get(0);
                            String paramSignature = applyHeader.getParameterSignature(0);
                            String paramDescriptor = applyHeader.getParameterDescriptor(0);
                            String paramType = Type.getType(paramDescriptor).getInternalName();
                            methodVisitor.visitVarInsn(25, mapTableSlot);
                            operandStack.push(ConfigurationSerializableTransformations.MAP_TYPE);
                            methodVisitor.visitLdcInsn(propertyName);
                            operandStack.push(ConfigurationSerializableTransformations.STRING_TYPE);
                            methodVisitor.visitVarInsn(25, n2);
                            operandStack.push(ConfigurationSerializableTransformations.OPTION_TYPE);
                            methodVisitor.visitMethodInsn(182, "scala/Option", "get", "()Ljava/lang/Object;", false);
                            operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
                            methodVisitor.visitTypeInsn(192, Conversions.boxedType(paramType));
                            Conversions.toSerializedType(this.pluginClassLoader, methodVisitor, Conversions.boxedDescriptor(paramDescriptor), paramSignature, localCounter, localVariableTable, operandStack);
                            methodVisitor.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true);
                            operandStack.replaceTop(3, ConfigurationSerializableTransformations.OBJECT_TYPE);
                            methodVisitor.visitInsn(87);
                            operandStack.pop();
                            methodVisitor.visitLabel(label);
                            methodVisitor.visitVarInsn(25, mapTableSlot);
                            operandStack.push(ConfigurationSerializableTransformations.MAP_TYPE);
                            methodVisitor.visitInsn(176);
                            operandStack.pop();
                            methodVisitor.visitLabel(definedFalseJumpTarget);
                            methodVisitor.visitFrame(1, 2, new Object[]{"java/util/Map", "scala/Option"}, 0, null);
                            methodVisitor.visitInsn(1);
                            operandStack.push(ConfigurationSerializableTransformations.MAP_TYPE);
                            methodVisitor.visitInsn(176);
                            operandStack.pop();
                            break;
                        }
                        methodVisitor.visitVarInsn(25, thisTableSlot);
                        operandStack.push(Type.getType(this.classDescriptor));
                        methodVisitor.visitMethodInsn(184, this.className, "unapply", unapplyHeader.descriptor, this.classIsInterface);
                        operandStack.replaceTop(ConfigurationSerializableTransformations.OPTION_TYPE);
                        Label label = new Label();
                        int n3 = localCounter.getSlotIndex();
                        int testFrameIndex = localCounter.getFrameIndex();
                        localVariableTable.add(new LocalVariable("test", "Lscala/Option;", "Lscala/Option<Ljava/lang/Object;>;", (Label)label1, label, n3, testFrameIndex));
                        localCounter.add(Type.getType("Lscala/Option;"));
                        methodVisitor.visitVarInsn(58, n3);
                        operandStack.pop();
                        beforeIsDefinedLabel = new Label();
                        methodVisitor.visitLabel(beforeIsDefinedLabel);
                        methodVisitor.visitVarInsn(25, n3);
                        operandStack.push(ConfigurationSerializableTransformations.OPTION_TYPE);
                        methodVisitor.visitMethodInsn(182, "scala/Option", "isDefined", "()Z", false);
                        operandStack.replaceTop(ConfigurationSerializableTransformations.BOOLEAN_TYPE);
                        Label definedFalseJumpTarget = new Label();
                        methodVisitor.visitJumpInsn(153, definedFalseJumpTarget);
                        operandStack.pop();
                        definedTrueLabel = new Label();
                        methodVisitor.visitLabel(definedTrueLabel);
                        String tupleName = "scala/Tuple" + n;
                        String tupleDescriptor = 'L' + tupleName + ';';
                        int tupleTableSlot = localCounter.getSlotIndex();
                        int tupleFrameIndex = localCounter.getFrameIndex();
                        localVariableTable.add(new LocalVariable("tup", tupleDescriptor, null, definedTrueLabel, label, tupleTableSlot, tupleFrameIndex));
                        localCounter.add(Type.getType(tupleDescriptor));
                        methodVisitor.visitVarInsn(25, n3);
                        operandStack.push(ConfigurationSerializableTransformations.OPTION_TYPE);
                        methodVisitor.visitMethodInsn(182, "scala/Option", "get", "()Ljava/lang/Object;", false);
                        operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
                        methodVisitor.visitTypeInsn(192, tupleName);
                        methodVisitor.visitVarInsn(58, tupleTableSlot);
                        operandStack.pop();
                        for (int paramIndex = 0; paramIndex < n; ++paramIndex) {
                            String propertyName = applyParamNames.get(paramIndex);
                            String paramSignature = applyHeader.getParameterSignature(paramIndex);
                            String paramDescriptor = applyHeader.getParameterDescriptor(paramIndex);
                            String paramType = Type.getType(paramDescriptor).getInternalName();
                            String indexMethod = "_" + (paramIndex + 1);
                            methodVisitor.visitVarInsn(25, mapTableSlot);
                            operandStack.push(ConfigurationSerializableTransformations.MAP_TYPE);
                            methodVisitor.visitLdcInsn(propertyName);
                            operandStack.push(ConfigurationSerializableTransformations.STRING_TYPE);
                            methodVisitor.visitVarInsn(25, 3);
                            operandStack.push(Type.getType(tupleDescriptor));
                            methodVisitor.visitMethodInsn(182, tupleName, indexMethod, "()Ljava/lang/Object;", false);
                            operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
                            methodVisitor.visitTypeInsn(192, Conversions.boxedType(paramType));
                            Conversions.toSerializedType(this.pluginClassLoader, methodVisitor, Conversions.boxedDescriptor(paramDescriptor), paramSignature, localCounter, localVariableTable, operandStack);
                            methodVisitor.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true);
                            operandStack.replaceTop(3, ConfigurationSerializableTransformations.OBJECT_TYPE);
                            methodVisitor.visitInsn(87);
                            operandStack.pop();
                        }
                        methodVisitor.visitLabel(label);
                        methodVisitor.visitVarInsn(25, mapTableSlot);
                        operandStack.push(ConfigurationSerializableTransformations.MAP_TYPE);
                        methodVisitor.visitInsn(176);
                        operandStack.pop();
                        methodVisitor.visitLabel(definedFalseJumpTarget);
                        methodVisitor.visitFrame(1, 2, new Object[]{"java/util/Map", "scala/Option"}, 0, null);
                        methodVisitor.visitInsn(1);
                        operandStack.push(ConfigurationSerializableTransformations.MAP_TYPE);
                        methodVisitor.visitInsn(176);
                        operandStack.pop();
                        break;
                    }
                    case ENUM: {
                        methodVisitor.visitVarInsn(25, mapTableSlot);
                        operandStack.push(ConfigurationSerializableTransformations.MAP_TYPE);
                        methodVisitor.visitLdcInsn("name");
                        operandStack.push(ConfigurationSerializableTransformations.STRING_TYPE);
                        methodVisitor.visitVarInsn(25, thisTableSlot);
                        operandStack.push(Type.getType(this.classDescriptor));
                        methodVisitor.visitMethodInsn(182, this.className, "name", "()Ljava/lang/String;", false);
                        operandStack.replaceTop(ConfigurationSerializableTransformations.STRING_TYPE);
                        methodVisitor.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true);
                        operandStack.replaceTop(3, ConfigurationSerializableTransformations.OBJECT_TYPE);
                        methodVisitor.visitInsn(87);
                        operandStack.pop();
                        Label label = new Label();
                        methodVisitor.visitLabel(label);
                        methodVisitor.visitVarInsn(25, mapTableSlot);
                        operandStack.push(ConfigurationSerializableTransformations.MAP_TYPE);
                        methodVisitor.visitInsn(176);
                        operandStack.pop();
                        break;
                    }
                    case SINGLETON_OBJECT: {
                        assert (this.alreadyHasModule$) : "scanType SINGELTON_OBJECT without a MODULE$ static field";
                        methodVisitor.visitVarInsn(25, mapTableSlot);
                        operandStack.push(ConfigurationSerializableTransformations.MAP_TYPE);
                        methodVisitor.visitInsn(176);
                        operandStack.pop();
                    }
                }
                methodVisitor.visitLabel(veryLastLabel);
                for (LocalVariable localVariable : localVariableTable) {
                    methodVisitor.visitLocalVariable(localVariable.name, localVariable.descriptor, localVariable.signature, localVariable.startLabel, localVariable.endLabel, localVariable.tableSlot);
                }
                methodVisitor.visitMaxs(operandStack.maxStack(), localVariableTable.maxLocals());
                methodVisitor.visitEnd();
            }
            if (!hasDeserizalizationMethod) {
                MethodVisitor methodVisitor;
                String theMethodName;
                MethodVisitor methodVisitor2;
                Label label0;
                LocalCounter localCounter = new LocalCounter();
                localVariableTable = new LocalVariableTable();
                OperandStack operandStack = new OperandStack();
                if (this.scanType == Scan.Type.FIELDS || this.scanType == Scan.Type.GETTER_SETTER_METHODS) {
                    Object newLabel;
                    boolean thisFirstThenMap;
                    if (!this.alreadyHasNullaryConstructor) {
                        MethodVisitor methodVisitor22 = this.visitMethod(2, "<init>", "()V", null, null);
                        methodVisitor22.visitCode();
                        label0 = new Label();
                        methodVisitor22.visitVarInsn(25, 0);
                        methodVisitor22.visitMethodInsn(183, this.superType, "<init>", "()V", false);
                        Label label1 = new Label();
                        int category = 0;
                        for (FieldDeclaration instanceField : this.allInstanceFields) {
                            methodVisitor22.visitVarInsn(25, 0);
                            switch (instanceField.descriptor) {
                                case "B": {
                                    methodVisitor22.visitInsn(3);
                                    methodVisitor22.visitInsn(145);
                                    category = Math.max(category, 1);
                                    break;
                                }
                                case "S": {
                                    methodVisitor22.visitInsn(3);
                                    methodVisitor22.visitInsn(147);
                                    category = Math.max(category, 1);
                                    break;
                                }
                                case "C": {
                                    methodVisitor22.visitInsn(3);
                                    methodVisitor22.visitInsn(146);
                                    category = Math.max(category, 1);
                                    break;
                                }
                                case "I": 
                                case "Z": {
                                    methodVisitor22.visitInsn(3);
                                    category = Math.max(category, 1);
                                    break;
                                }
                                case "J": {
                                    methodVisitor22.visitInsn(9);
                                    category = Math.max(category, 2);
                                    break;
                                }
                                case "F": {
                                    methodVisitor22.visitInsn(11);
                                    category = Math.max(category, 1);
                                    break;
                                }
                                case "D": {
                                    methodVisitor22.visitInsn(14);
                                    category = Math.max(category, 2);
                                    break;
                                }
                                default: {
                                    methodVisitor22.visitInsn(1);
                                    category = Math.max(category, 1);
                                }
                            }
                            methodVisitor22.visitFieldInsn(181, this.className, instanceField.name, instanceField.descriptor);
                        }
                        methodVisitor22.visitLabel(label1);
                        methodVisitor22.visitInsn(177);
                        Label label2 = new Label();
                        methodVisitor22.visitLabel(label2);
                        methodVisitor22.visitLocalVariable("this", this.classDescriptor, this.classSignature, label0, label2, 0);
                        methodVisitor22.visitMaxs(1 + category, 1);
                        methodVisitor22.visitEnd();
                    }
                    Label label02 = new Label();
                    switch (this.constructUsing()) {
                        case MAP_CONSTRUCTOR: {
                            thisFirstThenMap = true;
                            methodVisitor2 = this.visitMethod(1, "<init>", ConfigurationSerializableTransformations.DESERIALIZATION_CONSTRUCTOR_DESCRIPTOR, ConfigurationSerializableTransformations.DESERIALIZATION_CONSTRUCTOR_SIGNATURE, null);
                            methodVisitor2.visitCode();
                            methodVisitor2.visitLabel(label02);
                            methodVisitor2.visitVarInsn(25, 0);
                            operandStack.push(Type.getType(this.classDescriptor));
                            methodVisitor2.visitMethodInsn(183, this.className, "<init>", "()V", false);
                            operandStack.pop();
                            break;
                        }
                        case DESERIALIZE: 
                        case VALUE_OF: {
                            thisFirstThenMap = false;
                            methodVisitor2 = this.visitMethod(9, this.constructUsing() == DeserializationMethod.VALUE_OF ? "valueOf" : "deserialize", ConfigurationSerializableTransformations.deserializationDescriptor(this.classDescriptor), ConfigurationSerializableTransformations.deserializationSignature(this.classDescriptor), null);
                            methodVisitor2.visitCode();
                            methodVisitor2.visitLabel(label02);
                            methodVisitor2.visitTypeInsn(187, this.className);
                            operandStack.push(Type.getType(this.classDescriptor));
                            methodVisitor2.visitInsn(89);
                            operandStack.push(Type.getType(this.classDescriptor));
                            methodVisitor2.visitMethodInsn(183, this.className, "<init>", "()V", false);
                            operandStack.pop();
                            methodVisitor2.visitVarInsn(58, 1);
                            operandStack.pop();
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unreachable, got constructUsing " + DeserializationMethod.class.getSimpleName() + "." + this.constructUsing().name());
                        }
                    }
                    Label veryLastLabel = new Label();
                    int thisIndex = thisFirstThenMap ? 0 : 1;
                    int mapIndex = thisFirstThenMap ? 1 : 0;
                    LocalVariable localVariableThis = new LocalVariable("this", this.classDescriptor, this.classSignature, label02, veryLastLabel, thisIndex, thisIndex);
                    LocalVariable localVariableMap = new LocalVariable("map", "Ljava/util/Map;", "Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;", label02, veryLastLabel, mapIndex, mapIndex);
                    localCounter.add(Type.getType(this.classDescriptor));
                    localCounter.add(Type.getType("Ljava/util/Map;"));
                    localVariableTable.add(localVariableThis, localVariableMap);
                    Label label1 = new Label();
                    methodVisitor2.visitLabel(label1);
                    if (this.scanType == Scan.Type.FIELDS) {
                        for (Map.Entry<String, MethodHeader> entry : this.propertyFields.entrySet()) {
                            String string = entry.getKey();
                            FieldDeclaration field = (FieldDeclaration)((Object)entry.getValue());
                            methodVisitor2.visitVarInsn(25, thisIndex);
                            operandStack.push(Type.getType(this.classDescriptor));
                            methodVisitor2.visitVarInsn(25, mapIndex);
                            operandStack.push(ConfigurationSerializableTransformations.MAP_TYPE);
                            newLabel = new Label();
                            methodVisitor2.visitLdcInsn(string);
                            operandStack.push(ConfigurationSerializableTransformations.STRING_TYPE);
                            methodVisitor2.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
                            operandStack.replaceTop(2, ConfigurationSerializableTransformations.OBJECT_TYPE);
                            Conversions.toLiveType(this.pluginClassLoader, methodVisitor2, field.descriptor, field.signature, localCounter, localVariableTable, operandStack);
                            methodVisitor2.visitFieldInsn(181, this.className, field.name, field.descriptor);
                            operandStack.pop(2);
                            methodVisitor2.visitLabel((Label)newLabel);
                        }
                    } else if (this.scanType == Scan.Type.GETTER_SETTER_METHODS) {
                        for (Map.Entry<String, MethodHeader> entry : this.propertySetters.entrySet()) {
                            String string = entry.getKey();
                            MethodHeader method = entry.getValue();
                            methodVisitor2.visitVarInsn(25, thisIndex);
                            operandStack.push(Type.getType(this.classDescriptor));
                            methodVisitor2.visitVarInsn(25, mapIndex);
                            operandStack.push(ConfigurationSerializableTransformations.MAP_TYPE);
                            newLabel = new Label();
                            methodVisitor2.visitLdcInsn(string);
                            operandStack.push(ConfigurationSerializableTransformations.STRING_TYPE);
                            methodVisitor2.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
                            operandStack.replaceTop(2, ConfigurationSerializableTransformations.OBJECT_TYPE);
                            Conversions.toLiveType(this.pluginClassLoader, methodVisitor2, method.getParameterDescriptor(0), method.getParameterSignature(0), localCounter, localVariableTable, operandStack);
                            int INVOKE = (method.access & 2) == 2 ? 183 : 182;
                            methodVisitor2.visitMethodInsn(INVOKE, this.className, method.name, method.descriptor, false);
                            operandStack.replaceTop(2, Type.getType(method.getReturnDescriptor()));
                            String methodReturnDescriptor = method.getReturnDescriptor();
                            if ("D".equals(methodReturnDescriptor) || "J".equals(methodReturnDescriptor)) {
                                methodVisitor2.visitInsn(88);
                                operandStack.pop();
                            } else if (!"V".equals(methodReturnDescriptor)) {
                                methodVisitor2.visitInsn(87);
                                operandStack.pop();
                            }
                            methodVisitor2.visitLabel((Label)newLabel);
                        }
                    }
                    if (thisFirstThenMap) {
                        methodVisitor2.visitInsn(177);
                    } else {
                        methodVisitor2.visitVarInsn(25, thisIndex);
                        operandStack.push(Type.getType(this.classDescriptor));
                        methodVisitor2.visitInsn(176);
                        operandStack.pop();
                    }
                    methodVisitor2.visitLabel(veryLastLabel);
                    for (LocalVariable localVariable : localVariableTable) {
                        methodVisitor2.visitLocalVariable(localVariable.name, localVariable.descriptor, localVariable.signature, localVariable.startLabel, localVariable.endLabel, localVariable.tableSlot);
                    }
                    methodVisitor2.visitMaxs(operandStack.maxStack(), localVariableTable.maxLocals());
                    methodVisitor2.visitEnd();
                } else if (this.scanType == Scan.Type.RECORD) {
                    label0 = new Label();
                    Label endLabel = new Label();
                    StringJoiner stringJoiner = new StringJoiner("", "(", ")V");
                    for (FieldDeclaration propertyField : this.propertyFields.values()) {
                        stringJoiner.add(propertyField.descriptor);
                    }
                    String constructorDescriptor = stringJoiner.toString();
                    int recordWidth = this.propertyFields.size();
                    switch (this.constructUsing()) {
                        case MAP_CONSTRUCTOR: {
                            methodVisitor2 = this.visitMethod(1, "<init>", ConfigurationSerializableTransformations.DESERIALIZATION_CONSTRUCTOR_DESCRIPTOR, ConfigurationSerializableTransformations.DESERIALIZATION_CONSTRUCTOR_SIGNATURE, null);
                            methodVisitor2.visitCode();
                            methodVisitor2.visitLabel(label0);
                            int thisTableSlot = localCounter.getSlotIndex();
                            int thisFrameIndex = localCounter.getFrameIndex();
                            localCounter.add(Type.getType(this.classDescriptor));
                            int mapTableSlot = localCounter.getSlotIndex();
                            int mapFrameIndex = localCounter.getFrameIndex();
                            localCounter.add(Type.getType("Ljava/util/Map;"));
                            LocalVariable localVariable = new LocalVariable("this", this.classDescriptor, this.classSignature, label0, endLabel, thisTableSlot, thisFrameIndex);
                            LocalVariable localVariable2 = new LocalVariable("map", "Ljava/util/Map;", "Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;", label0, endLabel, mapTableSlot, mapFrameIndex);
                            localVariableTable.add(localVariable, localVariable2);
                            methodVisitor2.visitVarInsn(25, 0);
                            operandStack.push(Type.getType(this.classDescriptor));
                            Label endLoopLabel = new Label();
                            for (Map.Entry<String, FieldDeclaration> entry : this.propertyFields.entrySet()) {
                                String property = entry.getKey();
                                FieldDeclaration fieldDeclaration = entry.getValue();
                                methodVisitor2.visitVarInsn(25, 1);
                                operandStack.push(ConfigurationSerializableTransformations.MAP_TYPE);
                                methodVisitor2.visitLdcInsn(property);
                                operandStack.push(ConfigurationSerializableTransformations.STRING_TYPE);
                                methodVisitor2.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
                                operandStack.replaceTop(2, ConfigurationSerializableTransformations.OBJECT_TYPE);
                                Conversions.toLiveType(this.pluginClassLoader, methodVisitor2, fieldDeclaration.descriptor, fieldDeclaration.signature, localCounter, localVariableTable, operandStack);
                            }
                            methodVisitor2.visitLabel(endLoopLabel);
                            methodVisitor2.visitMethodInsn(183, this.className, "<init>", constructorDescriptor, false);
                            operandStack.pop(recordWidth);
                            methodVisitor2.visitInsn(177);
                            operandStack.pop();
                            methodVisitor2.visitLabel(endLabel);
                            for (LocalVariable local : localVariableTable) {
                                methodVisitor2.visitLocalVariable(local.name, local.descriptor, local.signature, local.startLabel, local.endLabel, local.tableSlot);
                            }
                            methodVisitor2.visitMaxs(operandStack.maxStack(), localVariableTable.maxLocals());
                            methodVisitor2.visitEnd();
                            break;
                        }
                        case DESERIALIZE: 
                        case VALUE_OF: {
                            methodVisitor2 = this.visitMethod(9, this.constructUsing() == DeserializationMethod.VALUE_OF ? "valueOf" : "deserialize", ConfigurationSerializableTransformations.deserializationDescriptor(this.classDescriptor), ConfigurationSerializableTransformations.deserializationSignature(this.classDescriptor), null);
                            methodVisitor2.visitCode();
                            methodVisitor2.visitLabel(label0);
                            int thisSlot = localCounter.getSlotIndex();
                            int thisFrame = localCounter.getFrameIndex();
                            localCounter.add(Type.getType(this.classDescriptor));
                            int mapSlot = localCounter.getSlotIndex();
                            int mapFrame = localCounter.getFrameIndex();
                            localCounter.add(Type.getType("Ljava/util/Map;"));
                            LocalVariable localVariable = new LocalVariable("map", "Ljava/util/Map;", "Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;", label0, endLabel, thisSlot, thisFrame);
                            LocalVariable localVariable3 = new LocalVariable("this", this.classDescriptor, this.classSignature, label0, endLabel, mapSlot, mapFrame);
                            localVariableTable.add(localVariable, localVariable3);
                            methodVisitor2.visitVarInsn(25, localVariable.tableSlot);
                            operandStack.push(ConfigurationSerializableTransformations.MAP_TYPE);
                            Label notNullLabel = new Label();
                            methodVisitor2.visitJumpInsn(199, notNullLabel);
                            operandStack.pop();
                            methodVisitor2.visitInsn(1);
                            operandStack.push(Type.getType(this.classDescriptor));
                            methodVisitor2.visitInsn(176);
                            operandStack.pop();
                            methodVisitor2.visitLabel(notNullLabel);
                            methodVisitor2.visitFrame(3, 0, null, 0, null);
                            methodVisitor2.visitTypeInsn(187, this.className);
                            operandStack.push(Type.getType(this.classDescriptor));
                            methodVisitor2.visitInsn(89);
                            operandStack.push(Type.getType(this.classDescriptor));
                            Label beforeLoopLabel = new Label();
                            Label afterLoopLabel = new Label();
                            methodVisitor2.visitLabel(beforeLoopLabel);
                            for (Map.Entry<String, FieldDeclaration> entry : this.propertyFields.entrySet()) {
                                String property = entry.getKey();
                                FieldDeclaration fieldDeclaration = entry.getValue();
                                methodVisitor2.visitVarInsn(25, 0);
                                operandStack.push(ConfigurationSerializableTransformations.MAP_TYPE);
                                methodVisitor2.visitLdcInsn(property);
                                operandStack.push(ConfigurationSerializableTransformations.STRING_TYPE);
                                methodVisitor2.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
                                operandStack.replaceTop(2, ConfigurationSerializableTransformations.OBJECT_TYPE);
                                Conversions.toLiveType(this.pluginClassLoader, methodVisitor2, fieldDeclaration.descriptor, fieldDeclaration.signature, localCounter, localVariableTable, operandStack);
                            }
                            methodVisitor2.visitLabel(afterLoopLabel);
                            methodVisitor2.visitMethodInsn(183, this.className, "<init>", constructorDescriptor, false);
                            operandStack.pop(recordWidth);
                            methodVisitor2.visitInsn(176);
                            operandStack.pop();
                            methodVisitor2.visitLabel(endLabel);
                            for (LocalVariable local : localVariableTable) {
                                methodVisitor2.visitLocalVariable(local.name, local.descriptor, local.signature, local.startLabel, local.endLabel, local.tableSlot);
                            }
                            methodVisitor2.visitMaxs(operandStack.maxStack(), localVariableTable.maxLocals());
                            methodVisitor2.visitEnd();
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unreachable, got constructUsing " + DeserializationMethod.class.getSimpleName() + "." + this.constructUsing().name());
                        }
                    }
                } else if (this.scanType == Scan.Type.CASE_CLASS) {
                    switch (this.constructUsing()) {
                        case MAP_CONSTRUCTOR: {
                            throw new ConfigurationSerializableError("Can't construct using " + DeserializationMethod.MAP_CONSTRUCTOR.name() + " for scan type " + Scan.Type.CASE_CLASS.name() + ".");
                        }
                        case DESERIALIZE: 
                        case VALUE_OF: {
                            theMethodName = this.constructUsing() == DeserializationMethod.VALUE_OF ? "valueOf" : "deserialize";
                            Label endLabel = new Label();
                            MethodVisitor methodVisitor3 = this.visitMethod(9, theMethodName, ConfigurationSerializableTransformations.deserializationDescriptor(this.classDescriptor), null, null);
                            methodVisitor3.visitCode();
                            Label label03 = new Label();
                            methodVisitor3.visitLabel(label03);
                            int thisTableSlot = localCounter.getSlotIndex();
                            int thisTableFrame = localCounter.getFrameIndex();
                            localCounter.add(Type.getType("Ljava/util/Map;"));
                            int mapTableSlot = localCounter.getSlotIndex();
                            int mapTableFrame = localCounter.getFrameIndex();
                            LocalVariable mapDefinition = new LocalVariable("map", "Ljava/util/Map;", "Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;", label03, endLabel, thisTableSlot, thisTableFrame);
                            LocalVariable thisDefinition = new LocalVariable("this", this.classDescriptor, this.classSignature, label03, endLabel, mapTableSlot, mapTableFrame);
                            localVariableTable.add(mapDefinition, thisDefinition);
                            Label label = new Label();
                            methodVisitor3.visitVarInsn(25, mapDefinition.tableSlot);
                            operandStack.push(ConfigurationSerializableTransformations.MAP_TYPE);
                            methodVisitor3.visitJumpInsn(199, label);
                            operandStack.pop();
                            Label label2 = new Label();
                            methodVisitor3.visitLabel(label2);
                            methodVisitor3.visitInsn(1);
                            operandStack.push(Type.getType(this.classDescriptor));
                            methodVisitor3.visitInsn(176);
                            operandStack.pop();
                            methodVisitor3.visitLabel(label);
                            methodVisitor3.visitFrame(3, 0, null, 0, null);
                            Label applyLabel = new Label();
                            for (int i2 = 0; i2 < n; ++i2) {
                                String property = applyParamNames.get(i2);
                                String paramDescriptor = applyHeader.getParameterDescriptor(i2);
                                String paramSignature = applyHeader.getParameterSignature(i2);
                                methodVisitor3.visitVarInsn(25, mapDefinition.tableSlot);
                                operandStack.push(ConfigurationSerializableTransformations.MAP_TYPE);
                                methodVisitor3.visitLdcInsn(property);
                                operandStack.push(ConfigurationSerializableTransformations.STRING_TYPE);
                                methodVisitor3.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
                                operandStack.replaceTop(2, ConfigurationSerializableTransformations.OBJECT_TYPE);
                                Conversions.toLiveType(this.pluginClassLoader, methodVisitor3, paramDescriptor, paramSignature, localCounter, localVariableTable, operandStack);
                            }
                            methodVisitor3.visitLabel(applyLabel);
                            methodVisitor3.visitMethodInsn(184, this.className, "apply", applyHeader.descriptor, this.classIsInterface);
                            operandStack.replaceTop(n, Type.getType(this.classDescriptor));
                            methodVisitor3.visitInsn(176);
                            operandStack.pop();
                            methodVisitor3.visitLabel(endLabel);
                            for (LocalVariable local : localVariableTable) {
                                methodVisitor3.visitLocalVariable(local.name, local.descriptor, local.signature, local.startLabel, local.endLabel, local.tableSlot);
                            }
                            methodVisitor3.visitMaxs(operandStack.maxStack(), localVariableTable.maxLocals());
                            methodVisitor3.visitEnd();
                        }
                    }
                } else if (this.scanType == Scan.Type.SINGLETON_OBJECT) {
                    String deserializationMethodName;
                    assert (this.alreadyHasModule$) : "scanType SINGELTON_OBJECT without a MODULE$ static field";
                    switch (this.constructUsing()) {
                        case MAP_CONSTRUCTOR: {
                            throw new ConfigurationSerializableError("Can't generate a deserialization constructor for singleton objects, it would violate the object model!");
                        }
                        case DESERIALIZE: {
                            deserializationMethodName = "deserialize";
                            break;
                        }
                        case VALUE_OF: {
                            deserializationMethodName = "valueOf";
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unreachable, got constructUsing " + DeserializationMethod.class.getSimpleName() + "." + this.constructUsing().name());
                        }
                    }
                    methodVisitor = this.visitMethod(9, deserializationMethodName, ConfigurationSerializableTransformations.deserializationDescriptor(this.classDescriptor), ConfigurationSerializableTransformations.deserializationSignature(this.classDescriptor), null);
                    methodVisitor.visitCode();
                    Label startLabel = new Label();
                    methodVisitor.visitLabel(startLabel);
                    methodVisitor.visitFieldInsn(178, this.className, "MODULE$", this.classDescriptor);
                    methodVisitor.visitInsn(176);
                    Label endLabel = new Label();
                    methodVisitor.visitLabel(endLabel);
                    methodVisitor.visitLocalVariable("map", "Ljava/util/Map;", "Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;", startLabel, endLabel, 0);
                    methodVisitor.visitMaxs(1, 1);
                    methodVisitor.visitEnd();
                } else if (this.scanType == Scan.Type.ENUM) {
                    switch (this.constructUsing()) {
                        case MAP_CONSTRUCTOR: {
                            throw new ConfigurationSerializableError("Can't construct using " + DeserializationMethod.MAP_CONSTRUCTOR.name() + " for scan type " + Scan.Type.ENUM.name() + ".");
                        }
                        case DESERIALIZE: 
                        case VALUE_OF: {
                            theMethodName = this.constructUsing() == DeserializationMethod.VALUE_OF ? "valueOf" : "deserialize";
                            methodVisitor = this.visitMethod(9, theMethodName, ConfigurationSerializableTransformations.deserializationDescriptor(this.classDescriptor), ConfigurationSerializableTransformations.deserializationSignature(this.classDescriptor), null);
                            methodVisitor.visitCode();
                            Label startLabel = new Label();
                            methodVisitor.visitLabel(startLabel);
                            methodVisitor.visitVarInsn(25, 0);
                            Label notNullLabel = new Label();
                            methodVisitor.visitJumpInsn(199, notNullLabel);
                            methodVisitor.visitInsn(1);
                            methodVisitor.visitInsn(176);
                            methodVisitor.visitLabel(notNullLabel);
                            methodVisitor.visitFrame(3, 0, null, 0, null);
                            methodVisitor.visitVarInsn(25, 0);
                            methodVisitor.visitLdcInsn("name");
                            methodVisitor.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
                            methodVisitor.visitTypeInsn(192, "java/lang/String");
                            methodVisitor.visitMethodInsn(184, this.className, "valueOf", "(Ljava/lang/String;)" + this.classDescriptor, this.classIsInterface);
                            methodVisitor.visitInsn(176);
                            Label endLabel = new Label();
                            methodVisitor.visitLabel(endLabel);
                            methodVisitor.visitLocalVariable("map", "Ljava/util/Map;", "Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;", startLabel, endLabel, 0);
                            methodVisitor.visitMaxs(2, 1);
                            methodVisitor.visitEnd();
                        }
                    }
                }
            }
            boolean noAlias = this.serializableAs == null || this.serializableAs.isEmpty();
            MethodVisitor methodVisitor = this.visitMethod(9, "$registerWithConfigurationSerialization", "()V", null, null);
            methodVisitor.visitCode();
            Label label0 = new Label();
            methodVisitor.visitLabel(label0);
            methodVisitor.visitLdcInsn(Type.getType(this.classDescriptor));
            if (noAlias) {
                methodVisitor.visitMethodInsn(184, "org/bukkit/configuration/serialization/ConfigurationSerialization", "registerClass", "(Ljava/lang/Class;)V", false);
            } else {
                methodVisitor.visitLdcInsn(this.serializableAs);
                methodVisitor.visitMethodInsn(184, "org/bukkit/configuration/serialization/ConfigurationSerialization", "registerClass", "(Ljava/lang/Class;Ljava/lang/String;)V", false);
            }
            Label label1 = new Label();
            methodVisitor.visitLabel(label1);
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(noAlias ? 1 : 2, 0);
            methodVisitor.visitEnd();
            if (!this.alreadyHasClassInitializer && this.registerAt == InjectionPoint.CLASS_INITIALIZER) {
                MethodVisitor mvStaticInit = this.visitMethod(8, "<clinit>", "()V", null, null);
                mvStaticInit.visitCode();
                mvStaticInit.visitMethodInsn(184, this.className, "$registerWithConfigurationSerialization", "()V", this.classIsInterface);
                mvStaticInit.visitInsn(177);
                mvStaticInit.visitMaxs(0, 0);
                mvStaticInit.visitEnd();
            }
        }
        super.visitEnd();
    }
}

