/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.configurationserializable.transform;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import xyz.janboerman.scalaloader.bytecode.LocalCounter;
import xyz.janboerman.scalaloader.bytecode.LocalVariable;
import xyz.janboerman.scalaloader.bytecode.LocalVariableTable;
import xyz.janboerman.scalaloader.bytecode.OperandStack;
import xyz.janboerman.scalaloader.bytecode.TypeSignature;
import xyz.janboerman.scalaloader.configurationserializable.runtime.types.NumericRange;
import xyz.janboerman.scalaloader.configurationserializable.transform.ConfigurationSerializableTransformations;
import xyz.janboerman.scalaloader.configurationserializable.transform.Conversions;
import xyz.janboerman.scalaloader.libs.asm.Label;
import xyz.janboerman.scalaloader.libs.asm.MethodVisitor;
import xyz.janboerman.scalaloader.libs.asm.Type;
import xyz.janboerman.scalaloader.plugin.ScalaPluginClassLoader;
import xyz.janboerman.scalaloader.util.ArrayOps;

class ScalaConversions {
    private static final String STRING = ConfigurationSerializableTransformations.STRING_TYPE.getInternalName();
    private static final String STRING_DESCRIPTOR = ConfigurationSerializableTransformations.STRING_TYPE.getDescriptor();
    private static final String CLASSTAG = "scala/reflect/ClassTag";
    private static final String CLASSTAG_COMPANION = "scala/reflect/ClassTag$";
    private static final String CLASSTAG_DESCRIPTOR = "Lscala/reflect/ClassTag;";
    private static final String CLASSTAG_COMPANION_DESCRIPTOR = "Lscala/reflect/ClassTag$;";
    private static final String MODULE$ = "MODULE$";
    private static final String BYTE_TAG_DESCRIPTOR = "Lscala/reflect/ManifestFactory$ByteManifest;";
    private static final String SHORT_TAG_DESCRIPTOR = "Lscala/reflect/ManifestFactory$ShortManifest;";
    private static final String INT_TAG_DESCRIPTOR = "Lscala/reflect/ManifestFactory$IntManifest;";
    private static final String LONG_TAG_DESCRIPTOR = "Lscala/reflect/ManifestFactory$LongManifest;";
    private static final String FLOAT_TAG_DESCRIPTOR = "Lscala/reflect/ManifestFactory$FloatManifest;";
    private static final String DOUBLE_TAG_DESCRIPTOR = "Lscala/reflect/ManifestFactory$DoubleManifest;";
    private static final String CHAR_TAG_DESCRIPTOR = "Lscala/reflect/ManifestFactory$CharManifest;";
    private static final String BOOLEAN_TAG_DESCRIPTOR = "Lscala/reflect/ManifestFactory$BooleanManifest;";
    private static final String UNIT_TAG_DESCRIPTOR = "Lscala/reflect/ManifestFactory$UnitManifest;";
    private static final String NOTHING_TAG_DESCRIPTOR = "Lscala/reflect/ClassTag;";
    private static final String NULL_TAG_DESCRIPTOR = "Lscala/reflect/ClassTag;";
    private static final String ANY_TAG_DESCRIPTOR = "Lscala/reflect/ClassTag;";
    private static final String ANYREF_TAG_DESCRIPTOR = "Lscala/reflect/ClassTag;";
    private static final String ANYVAL_TAG_DESCRIPTOR = "Lscala/reflect/ClassTag;";
    private static final String OBJECT_TAG_DESCRIPTOR = "Lscala/reflect/ClassTag;";
    private static final Type CLASSTAG_TYPE = Type.getObjectType("scala/reflect/ClassTag");
    private static final Type CLASSTAG_COMPANION_TYPE = Type.getObjectType("scala/reflect/ClassTag$");
    private static final String ITERABLE = "scala/collection/Iterable";
    private static final String ITERATOR = "scala/collection/Iterator";
    private static final Type ITERABLE_TYPE = Type.getObjectType("scala/collection/Iterable");
    private static final Type ITERATOR_TYPE = Type.getObjectType("scala/collection/Iterator");
    private static final String ITERABLE_DESCRIPTOR = ITERABLE_TYPE.getDescriptor();
    private static final String ITERATOR_DESCRIPTOR = ITERATOR_TYPE.getDescriptor();
    private static final String BUILDER = "scala/collection/mutable/Builder";
    private static final Type BUILDER_TYPE = Type.getObjectType("scala/collection/mutable/Builder");
    private static final String ORDERING = "scala/math/Ordering";
    private static final Type ORDERING_TYPE = Type.getObjectType("scala/math/Ordering");
    private static final String GROWABLE = "scala/collection/mutable/Growable";
    private static final Type GROWABLE_TYPE = Type.getObjectType("scala/collection/mutable/Growable");
    private static final String WRAPPED_STRING = "scala/collection/immutable/WrappedString";
    private static final Type WRAPPED_STRING_TYPE = Type.getObjectType("scala/collection/immutable/WrappedString");
    private static final String WRAPPED_STRING_DESCRIPTOR = "Lscala/collection/immutable/WrappedString;";
    private static final String RANGE = "scala/collection/immutable/Range";
    private static final Type RANGE_TYPE = Type.getObjectType("scala/collection/immutable/Range");
    private static final String RANGE_DESCRIPTOR = RANGE_TYPE.getDescriptor();
    private static final String NUMERIC_RANGE = "scala/collection/immutable/NumericRange";
    private static final Type NUMERIC_RANGE_TYPE = Type.getObjectType("scala/collection/immutable/NumericRange");
    private static final String NUMERIC_RANGE_DESCRIPTOR = NUMERIC_RANGE_TYPE.getDescriptor();
    private static final String ARRAY_BUILDER = "scala/collection/mutable/ArrayBuilder";
    private static final Type ARRAY_BUILDER_TYPE = Type.getObjectType("scala/collection/mutable/ArrayBuilder");
    private static final String ARRAY_BUILDER_DESCRIPTOR = ARRAY_BUILDER_TYPE.getDescriptor();
    private static final Type SCALALOADER_NUMERICRANGE_OFINTEGER_TYPE = Type.getType(NumericRange.OfInteger.class);
    private static final String SCALALOADER_NUMERICRANGE_OFINTEGER = SCALALOADER_NUMERICRANGE_OFINTEGER_TYPE.getInternalName();
    private static final String SCALALOADER_NUMERICRANGE_OFINTEGER_DESCRIPTOR = SCALALOADER_NUMERICRANGE_OFINTEGER_TYPE.getDescriptor();
    private static final String RANGE_COMPANION = "scala/collection/immutable/Range$";
    private static final String RANGE_COMPANION_DESCRIPTOR = "Lscala/collection/immutable/Range$;";
    private static final Type RANGE_COMPANION_TYPE = Type.getObjectType("scala/collection/immutable/Range$");
    private static final String RANGE_INCLUSIVE = "scala/collection/immutable/Range$Inclusive";
    private static final String RANGE_EXCLUSIVE = "scala/collection/immutable/Range$Exclusive";
    private static final String RANGE_INCLUSIVE_DESCRIPTOR = "Lscala/collection/immutable/Range$Inclusive;";
    private static final String RANGE_EXCLUSIVE_DESCRIPTOR = "Lscala/collection/immutable/Range$Exclusive;";
    private static final String NUMERIC_RANGE_COMPANION = "scala/collection/immutable/NumericRange$";
    private static final Type NUMERIC_RANGE_COMPANION_TYPE = Type.getObjectType("scala/collection/immutable/NumericRange$");
    private static final String NUMERIC_RANGE_COMPANION_DESCRIPTOR = NUMERIC_RANGE_COMPANION_TYPE.getDescriptor();
    private static final String NUMERIC_RANGE_INCLUSIVE = "scala/collection/immutable/NumericRange$Inclusive";
    private static final String NUMERIC_RANGE_EXCLUSIVE = "scala/collection/immutable/NumericRange$Exclusive";
    private static final String NUMERIC_RANGE_INCLUSIVE_DESCRIPTOR = "Lscala/collection/immutable/NumericRange$Inclusive;";
    private static final String NUMERIC_RANGE_EXCLUSIVE_DESCRIPTOR = "Lscala/collection/immutable/NumericRange$Exclusive;";
    private static final Type NUMERIC_RANGE_INCLUSIVE_TYPE = Type.getType("Lscala/collection/immutable/NumericRange$Inclusive;");
    private static final Type NUMERIC_RANGE_EXCLUSIVE_TYPE = Type.getType("Lscala/collection/immutable/NumericRange$Exclusive;");
    private static final String BIGINT = "scala/math/BigInt";
    private static final Type BIGINT_TYPE = Type.getObjectType("scala/math/BigInt");
    private static final String BIGINT_DESCRIPTOR = BIGINT_TYPE.getDescriptor();
    private static final String BIGINTEGER = ConfigurationSerializableTransformations.BIGINTEGER_TYPE.getInternalName();
    private static final String BIGINTEGER_DESCRIPTOR = ConfigurationSerializableTransformations.BIGINTEGER_TYPE.getDescriptor();
    private static final String BIGINT_COMPANION = "scala/math/BigInt$";
    private static final Type BIGINT_COMPANION_TYPE = Type.getObjectType("scala/math/BigInt$");
    private static final String BIGINT_COMPANION_DESCRIPTOR = BIGINT_COMPANION_TYPE.getDescriptor();
    private static final Type SCALALOADER_NUMERICRANGE_TYPE = Type.getType(NumericRange.class);
    private static final String SCALALOADER_NUMERICRANGE = SCALALOADER_NUMERICRANGE_TYPE.getInternalName();
    private static final String SCALALOADER_NUMERICRANGE_DESCRIPTOR = SCALALOADER_NUMERICRANGE_TYPE.getDescriptor();
    private static final Type SCALALOADER_NUMERICRANGE_OFBYTE_TYPE = Type.getType(NumericRange.OfByte.class);
    private static final String SCALALOADER_NUMERICRANGE_OFBYTE = SCALALOADER_NUMERICRANGE_OFBYTE_TYPE.getInternalName();
    private static final String SCALALOADER_NUMERICRANGE_OFBYTE_DESCRIPTOR = SCALALOADER_NUMERICRANGE_OFBYTE_TYPE.getDescriptor();
    private static final Type SCALALOADER_NUMERICRANGE_OFSHORT_TYPE = Type.getType(NumericRange.OfShort.class);
    private static final String SCALALOADER_NUMERICRANGE_OFSHORT = SCALALOADER_NUMERICRANGE_OFSHORT_TYPE.getInternalName();
    private static final String SCALALOADER_NUMERICRANGE_OFSHORT_DESCRIPTOR = SCALALOADER_NUMERICRANGE_OFSHORT_TYPE.getDescriptor();
    private static final Type SCALALOADER_NUMERICRANGE_OFLONG_TYPE = Type.getType(NumericRange.OfLong.class);
    private static final String SCALALOADER_NUMERICRANGE_OFLONG = SCALALOADER_NUMERICRANGE_OFLONG_TYPE.getInternalName();
    private static final String SCALALOADER_NUMERICRANGE_OFLONG_DESCRIPTOR = SCALALOADER_NUMERICRANGE_OFLONG_TYPE.getDescriptor();
    private static final Type SCALALOADER_NUMERICRANGE_OFBIGINTEGER_TYPE = Type.getType(NumericRange.OfBigInteger.class);
    private static final String SCALALOADER_NUMERICRANGE_OFBIGINTEGER = SCALALOADER_NUMERICRANGE_OFBIGINTEGER_TYPE.getInternalName();
    private static final String SCALALOADER_NUMERICRANGE_OFBIGINTEGER_DESCRIPTOR = SCALALOADER_NUMERICRANGE_OFBIGINTEGER_TYPE.getDescriptor();
    private static final String NUMERIC = "scala/math/Numeric";
    private static final String INTEGRAL = "scala/math/Integral";

    private ScalaConversions() {
    }

    static boolean isScalaCollection(TypeSignature typeSignature, ClassLoader pluginClassLoader) {
        String typeName;
        switch (typeName = typeSignature.internalName()) {
            case "scala/collection/AbstractIterable": 
            case "scala/collection/AbstractSeq": 
            case "scala/collection/AbstractSet": 
            case "scala/collection/BitSet": 
            case "scala/collection/IndexedSeq": 
            case "scala/collection/Iterable": 
            case "scala/collection/IterableOnce": 
            case "scala/collection/LinearSeq": 
            case "scala/collection/Seq": 
            case "scala/collection/Set": 
            case "scala/collection/SortedSet": 
            case "scala/collection/immutable/AbstractSeq": 
            case "scala/collection/immutable/AbstractSet": 
            case "scala/collection/immutable/ArraySeq": 
            case "scala/collection/immutable/BitSet": 
            case "scala/collection/immutable/HashSet": 
            case "scala/collection/immutable/IndexedSeq": 
            case "scala/collection/immutable/Iterable": 
            case "scala/collection/immutable/LazyList": 
            case "scala/collection/immutable/LinearSeq": 
            case "scala/collection/immutable/List": 
            case "scala/collection/immutable/ListSet": 
            case "scala/collection/immutable/NumericRange": 
            case "scala/collection/immutable/Queue": 
            case "scala/collection/immutable/Range": 
            case "scala/collection/immutable/Seq": 
            case "scala/collection/immutable/Set": 
            case "scala/collection/immutable/SortedSet": 
            case "scala/collection/immutable/Stream": 
            case "scala/collection/immutable/TreeSet": 
            case "scala/collection/immutable/Vector": 
            case "scala/collection/immutable/WrappedString": 
            case "scala/collection/mutable/AbstractBuffer": 
            case "scala/collection/mutable/AbstractIterable": 
            case "scala/collection/mutable/AbstractSeq": 
            case "scala/collection/mutable/AbstractSet": 
            case "scala/collection/mutable/ArrayBuffer": 
            case "scala/collection/mutable/ArrayBuilder": 
            case "scala/collection/mutable/ArrayDeque": 
            case "scala/collection/mutable/ArraySeq": 
            case "scala/collection/mutable/BitSet": 
            case "scala/collection/mutable/Buffer": 
            case "scala/collection/mutable/Builder": 
            case "scala/collection/mutable/HashSet": 
            case "scala/collection/mutable/IndexedBuffer": 
            case "scala/collection/mutable/IndexedSeq": 
            case "scala/collection/mutable/Iterable": 
            case "scala/collection/mutable/LinkedHashSet": 
            case "scala/collection/mutable/ListBuffer": 
            case "scala/collection/mutable/PriorityQueue": 
            case "scala/collection/mutable/Queue": 
            case "scala/collection/mutable/Seq": 
            case "scala/collection/mutable/Set": 
            case "scala/collection/mutable/SortedSet": 
            case "scala/collection/mutable/Stack": 
            case "scala/collection/mutable/StringBuilder": 
            case "scala/collection/mutable/TreeSet": 
            case "scala/collection/mutable/UnrolledBuffer": {
                return true;
            }
        }
        try {
            Class<?> daClass = Class.forName(typeName.replace('/', '.'), false, pluginClassLoader);
            Class<?> seqClass = Class.forName("scala.collection.Seq", false, pluginClassLoader);
            Class<?> setClass = Class.forName("scala.collection.Set", false, pluginClassLoader);
            if (seqClass.isAssignableFrom(daClass) || setClass.isAssignableFrom(daClass)) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    static boolean isScalaMap(TypeSignature typeSignature, ClassLoader pluginClassLoader) {
        String typeName;
        switch (typeName = typeSignature.getTypeName()) {
            case "scala/collection/AbstractMap": 
            case "scala/collection/DefaultMap": 
            case "scala/collection/Map": 
            case "scala/collection/SortedMap": 
            case "scala/collection/immutable/AbstractMap": 
            case "scala/collection/immutable/HashMap": 
            case "scala/collection/immutable/IntMap": 
            case "scala/collection/immutable/ListMap": 
            case "scala/collection/immutable/LongMap": 
            case "scala/collection/immutable/Map": 
            case "scala/collection/immutable/SeqMap": 
            case "scala/collection/immutable/SortedMap": 
            case "scala/collection/immutable/TreeMap": 
            case "scala/collection/immutable/TreeSeqMap": 
            case "scala/collection/immutable/VectorMap": 
            case "scala/collection/mutable/AbstractMap": 
            case "scala/collection/mutable/AnyRefMap": 
            case "scala/collection/mutable/HashMap": 
            case "scala/collection/mutable/LinkedHashMap": 
            case "scala/collection/mutable/LongMap": 
            case "scala/collection/mutable/Map": 
            case "scala/collection/mutable/MultiMap": 
            case "scala/collection/mutable/OpenHashMap": 
            case "scala/collection/mutable/SeqMap": 
            case "scala/collection/mutable/SortedMap": 
            case "scala/collection/mutable/TreeMap": 
            case "scala/collection/mutable/WeakHashMap": 
            case "scala/collection/concurrent/Map": 
            case "scala/collection/concurrent/TrieMap": {
                return true;
            }
        }
        try {
            Class<?> daClass = Class.forName(typeName.replace('/', '.'), false, pluginClassLoader);
            Class<?> mapClass = Class.forName("scala.collection.Map", false, pluginClassLoader);
            if (mapClass.isAssignableFrom(daClass)) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    static void serializeCollection(ScalaPluginClassLoader classLoader, MethodVisitor methodVisitor, TypeSignature typeSignature, LocalCounter localCounter, LocalVariableTable localVariableTable, OperandStack operandStack) {
        switch (typeSignature.getTypeName()) {
            case "scala/collection/immutable/WrappedString": {
                Label startLabel = new Label();
                Label endLabel = new Label();
                methodVisitor.visitTypeInsn(192, WRAPPED_STRING);
                operandStack.replaceTop(WRAPPED_STRING_TYPE);
                int wrappedStringIndex = localCounter.getSlotIndex();
                int wrappedStringFrameIndex = localCounter.getFrameIndex();
                LocalVariable wrappedString = new LocalVariable("wrappedString", WRAPPED_STRING_DESCRIPTOR, null, startLabel, endLabel, wrappedStringIndex, wrappedStringFrameIndex);
                localVariableTable.add(wrappedString);
                localCounter.add(WRAPPED_STRING_TYPE);
                methodVisitor.visitVarInsn(58, wrappedStringIndex);
                operandStack.pop();
                methodVisitor.visitLabel(startLabel);
                methodVisitor.visitFieldInsn(178, "scala/collection/immutable/WrappedString$UnwrapOp$", MODULE$, "Lscala/collection/immutable/WrappedString$UnwrapOp$;");
                operandStack.push(Type.getType("Lscala/collection/immutable/WrappedString$UnwrapOp$;"));
                methodVisitor.visitFieldInsn(178, "scala/collection/immutable/WrappedString$", MODULE$, "Lscala/collection/immutable/WrappedString$;");
                operandStack.push(Type.getType("Lscala/collection/immutable/WrappedString$;"));
                methodVisitor.visitVarInsn(25, wrappedStringIndex);
                operandStack.push(WRAPPED_STRING_TYPE);
                methodVisitor.visitMethodInsn(182, "scala/collection/immutable/WrappedString$", "UnwrapOp", "(Lscala/collection/immutable/WrappedString;)Lscala/collection/immutable/WrappedString;", false);
                operandStack.replaceTop(2, WRAPPED_STRING_TYPE);
                methodVisitor.visitMethodInsn(182, "scala/collection/immutable/WrappedString$UnwrapOp$", "unwrap$extension", "(Lscala/collection/immutable/WrappedString;)Ljava/lang/String;", false);
                operandStack.replaceTop(2, ConfigurationSerializableTransformations.STRING_TYPE);
                methodVisitor.visitLabel(endLabel);
                localVariableTable.removeFramesFromIndex(wrappedStringFrameIndex);
                localCounter.reset(wrappedStringIndex, wrappedStringFrameIndex);
                return;
            }
            case "scala/collection/immutable/Range": {
                methodVisitor.visitTypeInsn(192, RANGE);
                operandStack.replaceTop(RANGE_TYPE);
                Label rangeStartLabel = new Label();
                Label rangeEndLabel = new Label();
                int rangeIndex = localCounter.getSlotIndex();
                int rangeFrameIndex = localCounter.getFrameIndex();
                LocalVariable range = new LocalVariable("range", RANGE_DESCRIPTOR, null, rangeStartLabel, rangeEndLabel, rangeIndex, rangeFrameIndex);
                methodVisitor.visitVarInsn(58, rangeIndex);
                operandStack.pop();
                localVariableTable.add(range);
                localCounter.add(RANGE_TYPE);
                methodVisitor.visitLabel(rangeStartLabel);
                methodVisitor.visitTypeInsn(187, SCALALOADER_NUMERICRANGE_OFINTEGER);
                operandStack.push(SCALALOADER_NUMERICRANGE_OFINTEGER_TYPE);
                methodVisitor.visitInsn(89);
                operandStack.push(SCALALOADER_NUMERICRANGE_OFINTEGER_TYPE);
                methodVisitor.visitVarInsn(25, rangeIndex);
                operandStack.push(RANGE_TYPE);
                methodVisitor.visitMethodInsn(182, RANGE, "start", "()I", false);
                operandStack.replaceTop(Type.INT_TYPE);
                methodVisitor.visitVarInsn(25, rangeIndex);
                operandStack.push(RANGE_TYPE);
                methodVisitor.visitMethodInsn(182, RANGE, "step", "()I", false);
                operandStack.replaceTop(Type.INT_TYPE);
                methodVisitor.visitVarInsn(25, rangeIndex);
                operandStack.push(RANGE_TYPE);
                methodVisitor.visitMethodInsn(182, RANGE, "end", "()I", false);
                operandStack.replaceTop(Type.INT_TYPE);
                methodVisitor.visitVarInsn(25, rangeIndex);
                operandStack.push(RANGE_TYPE);
                methodVisitor.visitMethodInsn(182, RANGE, "isInclusive", "()Z", false);
                operandStack.replaceTop(Type.BOOLEAN_TYPE);
                methodVisitor.visitMethodInsn(183, SCALALOADER_NUMERICRANGE_OFINTEGER, "<init>", "(IIIZ)V", false);
                operandStack.pop(5);
                methodVisitor.visitLabel(rangeEndLabel);
                localVariableTable.removeFramesFromIndex(rangeFrameIndex);
                localCounter.reset(rangeIndex, rangeFrameIndex);
                return;
            }
            case "scala/collection/immutable/NumericRange": {
                methodVisitor.visitTypeInsn(192, NUMERIC_RANGE);
                operandStack.replaceTop(NUMERIC_RANGE_TYPE);
                Label numericRangeStartLabel = new Label();
                Label numericRangeEndLabel = new Label();
                int numericRangeIndex = localCounter.getSlotIndex();
                int numericRangeFrameIndex = localCounter.getFrameIndex();
                LocalVariable numericRange = new LocalVariable("numericRange", NUMERIC_RANGE_DESCRIPTOR, null, numericRangeStartLabel, numericRangeEndLabel, numericRangeIndex, numericRangeFrameIndex);
                methodVisitor.visitVarInsn(58, numericRangeIndex);
                operandStack.pop();
                localVariableTable.add(numericRange);
                localCounter.add(NUMERIC_RANGE_TYPE);
                methodVisitor.visitLabel(numericRangeStartLabel);
                Object[] localsFrame = localVariableTable.frame();
                Object[] stackFrame = operandStack.frame();
                Label byteLabel = new Label();
                Label shortLabel = new Label();
                Label integerLabel = new Label();
                Label longLabel = new Label();
                Label bigIntLabel = new Label();
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(NUMERIC_RANGE_TYPE);
                methodVisitor.visitMethodInsn(182, NUMERIC_RANGE, "start", "Ljava/lang/Object;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
                methodVisitor.visitTypeInsn(193, "java/lang/Byte");
                operandStack.replaceTop(Type.BOOLEAN_TYPE);
                methodVisitor.visitJumpInsn(154, byteLabel);
                operandStack.pop();
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(NUMERIC_RANGE_TYPE);
                methodVisitor.visitMethodInsn(182, NUMERIC_RANGE, "start", "Ljava/lang/Object;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
                methodVisitor.visitTypeInsn(193, "java/lang/Short");
                operandStack.replaceTop(Type.BOOLEAN_TYPE);
                methodVisitor.visitJumpInsn(154, shortLabel);
                operandStack.pop();
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(NUMERIC_RANGE_TYPE);
                methodVisitor.visitMethodInsn(182, NUMERIC_RANGE, "start", "Ljava/lang/Object;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
                methodVisitor.visitTypeInsn(193, "java/lang/Integer");
                operandStack.replaceTop(Type.BOOLEAN_TYPE);
                methodVisitor.visitJumpInsn(154, integerLabel);
                operandStack.pop();
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(NUMERIC_RANGE_TYPE);
                methodVisitor.visitMethodInsn(182, NUMERIC_RANGE, "start", "Ljava/lang/Object;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
                methodVisitor.visitTypeInsn(193, "java/lang/Long");
                operandStack.replaceTop(Type.BOOLEAN_TYPE);
                methodVisitor.visitJumpInsn(154, longLabel);
                operandStack.pop();
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(NUMERIC_RANGE_TYPE);
                methodVisitor.visitMethodInsn(182, NUMERIC_RANGE, "start", "Ljava/lang/Object;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
                methodVisitor.visitTypeInsn(193, BIGINT);
                operandStack.replaceTop(BIGINT_TYPE);
                methodVisitor.visitJumpInsn(154, bigIntLabel);
                operandStack.pop();
                assert (Arrays.equals(localsFrame, localVariableTable.frame()));
                assert (Arrays.equals(stackFrame, operandStack.frame()));
                Label joinLabel = new Label();
                methodVisitor.visitLabel(byteLabel);
                methodVisitor.visitFrame(0, localsFrame.length, localsFrame, stackFrame.length, stackFrame);
                methodVisitor.visitTypeInsn(187, SCALALOADER_NUMERICRANGE_OFBYTE);
                operandStack.push(SCALALOADER_NUMERICRANGE_OFBYTE_TYPE);
                methodVisitor.visitInsn(89);
                operandStack.push(SCALALOADER_NUMERICRANGE_OFBYTE_TYPE);
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(NUMERIC_RANGE_TYPE);
                methodVisitor.visitMethodInsn(182, NUMERIC_RANGE, "start", "()Ljava/lang/Object;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
                methodVisitor.visitTypeInsn(192, "java/lang/Byte");
                operandStack.replaceTop(Type.getType(Byte.class));
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(NUMERIC_RANGE_TYPE);
                methodVisitor.visitMethodInsn(182, NUMERIC_RANGE, "step", "()Ljava/lang/Object;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
                methodVisitor.visitTypeInsn(192, "java/lang/Byte");
                operandStack.replaceTop(Type.getType(Byte.class));
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(NUMERIC_RANGE_TYPE);
                methodVisitor.visitMethodInsn(182, NUMERIC_RANGE, "end", "()Ljava/lang/Object;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
                methodVisitor.visitTypeInsn(192, "java/lang/Byte");
                operandStack.replaceTop(Type.getType(Byte.class));
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(NUMERIC_RANGE_TYPE);
                methodVisitor.visitMethodInsn(182, NUMERIC_RANGE, "isInclusive", "()Z", false);
                operandStack.replaceTop(Type.BOOLEAN_TYPE);
                methodVisitor.visitMethodInsn(183, SCALALOADER_NUMERICRANGE_OFBYTE, "<init>", "(Ljava/lang/Byte;Ljava/lang/Byte;Ljava/lang/Byte;Z)V", false);
                operandStack.pop(5);
                methodVisitor.visitTypeInsn(192, SCALALOADER_NUMERICRANGE);
                operandStack.replaceTop(SCALALOADER_NUMERICRANGE_TYPE);
                methodVisitor.visitJumpInsn(167, joinLabel);
                methodVisitor.visitLabel(shortLabel);
                methodVisitor.visitFrame(0, localsFrame.length, localsFrame, stackFrame.length, stackFrame);
                methodVisitor.visitTypeInsn(187, SCALALOADER_NUMERICRANGE_OFSHORT);
                operandStack.push(SCALALOADER_NUMERICRANGE_OFSHORT_TYPE);
                methodVisitor.visitInsn(89);
                operandStack.push(SCALALOADER_NUMERICRANGE_OFSHORT_TYPE);
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(NUMERIC_RANGE_TYPE);
                methodVisitor.visitMethodInsn(182, NUMERIC_RANGE, "start", "()Ljava/lang/Object;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
                methodVisitor.visitTypeInsn(192, "java/lang/Short");
                operandStack.replaceTop(Type.getType(Short.class));
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(NUMERIC_RANGE_TYPE);
                methodVisitor.visitMethodInsn(182, NUMERIC_RANGE, "step", "()Ljava/lang/Object;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
                methodVisitor.visitTypeInsn(192, "java/lang/Short");
                operandStack.replaceTop(Type.getType(Short.class));
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(NUMERIC_RANGE_TYPE);
                methodVisitor.visitMethodInsn(182, NUMERIC_RANGE, "end", "()Ljava/lang/Object;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
                methodVisitor.visitTypeInsn(192, "java/lang/Short");
                operandStack.replaceTop(Type.getType(Short.class));
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(NUMERIC_RANGE_TYPE);
                methodVisitor.visitMethodInsn(182, NUMERIC_RANGE, "isInclusive", "()Z", false);
                operandStack.replaceTop(Type.BOOLEAN_TYPE);
                methodVisitor.visitMethodInsn(183, SCALALOADER_NUMERICRANGE_OFSHORT, "<init>", "(Ljava/lang/Short;Ljava/lang/Short;Ljava/lang/Short;Z)V", false);
                operandStack.pop(5);
                methodVisitor.visitTypeInsn(192, SCALALOADER_NUMERICRANGE);
                operandStack.replaceTop(SCALALOADER_NUMERICRANGE_TYPE);
                methodVisitor.visitJumpInsn(167, joinLabel);
                methodVisitor.visitLabel(integerLabel);
                methodVisitor.visitFrame(0, localsFrame.length, localsFrame, stackFrame.length, stackFrame);
                methodVisitor.visitTypeInsn(187, SCALALOADER_NUMERICRANGE_OFINTEGER);
                operandStack.push(SCALALOADER_NUMERICRANGE_OFINTEGER_TYPE);
                methodVisitor.visitInsn(89);
                operandStack.push(SCALALOADER_NUMERICRANGE_OFINTEGER_TYPE);
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(NUMERIC_RANGE_TYPE);
                methodVisitor.visitMethodInsn(182, NUMERIC_RANGE, "start", "()Ljava/lang/Object;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
                methodVisitor.visitTypeInsn(192, "java/lang/Integer");
                operandStack.replaceTop(Type.getType(Integer.class));
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(NUMERIC_RANGE_TYPE);
                methodVisitor.visitMethodInsn(182, NUMERIC_RANGE, "step", "()Ljava/lang/Object;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
                methodVisitor.visitTypeInsn(192, "java/lang/Integer");
                operandStack.replaceTop(Type.getType(Integer.class));
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(NUMERIC_RANGE_TYPE);
                methodVisitor.visitMethodInsn(182, NUMERIC_RANGE, "end", "()Ljava/lang/Object;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
                methodVisitor.visitTypeInsn(192, "java/lang/Integer");
                operandStack.replaceTop(Type.getType(Integer.class));
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(NUMERIC_RANGE_TYPE);
                methodVisitor.visitMethodInsn(182, NUMERIC_RANGE, "isInclusive", "()Z", false);
                operandStack.replaceTop(Type.BOOLEAN_TYPE);
                methodVisitor.visitMethodInsn(183, SCALALOADER_NUMERICRANGE_OFINTEGER, "<init>", "(Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Z)V", false);
                operandStack.pop(5);
                methodVisitor.visitTypeInsn(192, SCALALOADER_NUMERICRANGE);
                operandStack.replaceTop(SCALALOADER_NUMERICRANGE_TYPE);
                methodVisitor.visitJumpInsn(167, joinLabel);
                methodVisitor.visitLabel(longLabel);
                methodVisitor.visitFrame(0, localsFrame.length, localsFrame, stackFrame.length, stackFrame);
                methodVisitor.visitTypeInsn(187, SCALALOADER_NUMERICRANGE_OFLONG);
                operandStack.push(SCALALOADER_NUMERICRANGE_OFLONG_TYPE);
                methodVisitor.visitInsn(89);
                operandStack.push(SCALALOADER_NUMERICRANGE_OFLONG_TYPE);
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(NUMERIC_RANGE_TYPE);
                methodVisitor.visitMethodInsn(182, NUMERIC_RANGE, "start", "()Ljava/lang/Object;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
                methodVisitor.visitTypeInsn(192, "java/lang/Long");
                operandStack.replaceTop(Type.getType(Long.class));
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(NUMERIC_RANGE_TYPE);
                methodVisitor.visitMethodInsn(182, NUMERIC_RANGE, "step", "()Ljava/lang/Object;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
                methodVisitor.visitTypeInsn(192, "java/lang/Long");
                operandStack.replaceTop(Type.getType(Long.class));
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(NUMERIC_RANGE_TYPE);
                methodVisitor.visitMethodInsn(182, NUMERIC_RANGE, "end", "()Ljava/lang/Object;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
                methodVisitor.visitTypeInsn(192, "java/lang/Long");
                operandStack.replaceTop(Type.getType(Long.class));
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(NUMERIC_RANGE_TYPE);
                methodVisitor.visitMethodInsn(182, NUMERIC_RANGE, "isInclusive", "()Z", false);
                operandStack.replaceTop(Type.BOOLEAN_TYPE);
                methodVisitor.visitMethodInsn(183, SCALALOADER_NUMERICRANGE_OFLONG, "<init>", "(Ljava/lang/Long;Ljava/lang/Long;Ljava/lang/Long;Z)V", false);
                operandStack.pop(5);
                methodVisitor.visitTypeInsn(192, SCALALOADER_NUMERICRANGE);
                operandStack.replaceTop(SCALALOADER_NUMERICRANGE_TYPE);
                methodVisitor.visitJumpInsn(167, joinLabel);
                methodVisitor.visitLabel(longLabel);
                methodVisitor.visitFrame(0, localsFrame.length, localsFrame, stackFrame.length, stackFrame);
                methodVisitor.visitTypeInsn(187, SCALALOADER_NUMERICRANGE_OFBIGINTEGER);
                operandStack.push(SCALALOADER_NUMERICRANGE_OFBIGINTEGER_TYPE);
                methodVisitor.visitInsn(89);
                operandStack.push(SCALALOADER_NUMERICRANGE_OFBIGINTEGER_TYPE);
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(NUMERIC_RANGE_TYPE);
                methodVisitor.visitMethodInsn(182, NUMERIC_RANGE, "start", "()Ljava/lang/Object;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
                methodVisitor.visitTypeInsn(192, BIGINT);
                operandStack.replaceTop(BIGINT_TYPE);
                methodVisitor.visitMethodInsn(182, BIGINT, "bigInteger", "()Ljava/math/BigInteger;", false);
                operandStack.replaceTop(Type.getType(BigInteger.class));
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(NUMERIC_RANGE_TYPE);
                methodVisitor.visitMethodInsn(182, NUMERIC_RANGE, "step", "()Ljava/lang/Object;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
                methodVisitor.visitTypeInsn(192, BIGINT);
                operandStack.replaceTop(BIGINT_TYPE);
                methodVisitor.visitMethodInsn(182, BIGINT, "bigInteger", "()Ljava/math/BigInteger;", false);
                operandStack.replaceTop(Type.getType(BigInteger.class));
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(NUMERIC_RANGE_TYPE);
                methodVisitor.visitMethodInsn(182, NUMERIC_RANGE, "end", "()Ljava/lang/Object;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
                methodVisitor.visitTypeInsn(192, BIGINT);
                operandStack.replaceTop(BIGINT_TYPE);
                methodVisitor.visitMethodInsn(182, BIGINT, "bigInteger", "()Ljava/math/BigInteger;", false);
                operandStack.replaceTop(Type.getType(BigInteger.class));
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(NUMERIC_RANGE_TYPE);
                methodVisitor.visitMethodInsn(182, NUMERIC_RANGE, "isInclusive", "()Z", false);
                operandStack.replaceTop(Type.BOOLEAN_TYPE);
                methodVisitor.visitMethodInsn(183, SCALALOADER_NUMERICRANGE_OFBIGINTEGER, "<init>", "(Ljava/math/BigInteger;Ljava/math/BigInteger;Ljava/math/BigInteger;)V", false);
                operandStack.pop(5);
                methodVisitor.visitJumpInsn(167, joinLabel);
                Object[] newStackFrame = ArrayOps.append(stackFrame, SCALALOADER_NUMERICRANGE);
                assert (Arrays.equals(localsFrame, localVariableTable.frame()));
                assert (Arrays.equals(newStackFrame, operandStack.frame()));
                methodVisitor.visitLabel(joinLabel);
                methodVisitor.visitFrame(0, localsFrame.length, localsFrame, newStackFrame.length, newStackFrame);
                methodVisitor.visitLabel(numericRangeEndLabel);
                localVariableTable.removeFramesFromIndex(numericRangeFrameIndex);
                localCounter.reset(numericRangeIndex, numericRangeFrameIndex);
                return;
            }
        }
        TypeSignature elementTypeSignature = typeSignature.hasTypeArguments() ? typeSignature.getTypeArgument(0) : TypeSignature.OBJECT_TYPE_SIGNATURE;
        Label startLabel = new Label();
        Label endLabel = new Label();
        int iteratorIndex = localCounter.getSlotIndex();
        int iteratorFrameIndex = localCounter.getFrameIndex();
        LocalVariable iterator = new LocalVariable("iterator", ITERATOR_DESCRIPTOR, "Ljava/util/Iterator<" + elementTypeSignature.toSignature() + ">;", startLabel, endLabel, iteratorIndex, iteratorFrameIndex);
        methodVisitor.visitTypeInsn(192, ITERABLE);
        operandStack.replaceTop(ITERABLE_TYPE);
        methodVisitor.visitMethodInsn(185, ITERABLE, "iterator", "()Lscala/collection/Iterator;", true);
        operandStack.replaceTop(ITERATOR_TYPE);
        methodVisitor.visitVarInsn(58, iteratorIndex);
        operandStack.pop();
        localVariableTable.add(iterator);
        localCounter.add(ITERATOR_TYPE);
        methodVisitor.visitLabel(startLabel);
        Label javaListLabel = new Label();
        int javaListIndex = localCounter.getSlotIndex();
        int javaListFrameIndex = localCounter.getFrameIndex();
        LocalVariable javaList = new LocalVariable("list", "Ljava/util/ArrayList;", null, javaListLabel, endLabel, javaListIndex, javaListFrameIndex);
        methodVisitor.visitTypeInsn(187, "java/util/ArrayList");
        operandStack.push(Type.getType(ArrayList.class));
        methodVisitor.visitInsn(89);
        operandStack.push(Type.getType(ArrayList.class));
        methodVisitor.visitMethodInsn(183, "java/util/ArrayList", "<init>", "()V", false);
        operandStack.pop();
        methodVisitor.visitVarInsn(58, javaListIndex);
        operandStack.pop();
        localVariableTable.add(javaList);
        localCounter.add(Type.getType(ArrayList.class));
        methodVisitor.visitLabel(javaListLabel);
        Label jumpBackTarget = javaListLabel;
        Label endLoopLabel = new Label();
        Object[] localsFrame = localVariableTable.frame();
        Object[] stackFrame = operandStack.frame();
        methodVisitor.visitFrame(0, localsFrame.length, localsFrame, stackFrame.length, stackFrame);
        methodVisitor.visitVarInsn(25, iteratorIndex);
        operandStack.push(ITERATOR_TYPE);
        methodVisitor.visitMethodInsn(185, ITERATOR, "hasNext", "()Z", true);
        operandStack.replaceTop(ConfigurationSerializableTransformations.BOOLEAN_TYPE);
        methodVisitor.visitJumpInsn(153, endLoopLabel);
        operandStack.pop();
        methodVisitor.visitVarInsn(25, javaListIndex);
        operandStack.push(Type.getType(ArrayList.class));
        methodVisitor.visitVarInsn(25, iteratorIndex);
        operandStack.push(ITERATOR_TYPE);
        methodVisitor.visitMethodInsn(185, ITERATOR, "next", "()Ljava/lang/Object;", true);
        operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
        Conversions.toSerializedType(classLoader, methodVisitor, elementTypeSignature.toDescriptor(), elementTypeSignature.toSignature(), localCounter, localVariableTable, operandStack);
        methodVisitor.visitMethodInsn(182, "java/util/ArrayList", "add", "(Ljava/lang/Object;)Z", false);
        operandStack.replaceTop(2, ConfigurationSerializableTransformations.BOOLEAN_TYPE);
        methodVisitor.visitInsn(87);
        operandStack.pop();
        methodVisitor.visitJumpInsn(167, jumpBackTarget);
        methodVisitor.visitLabel(endLoopLabel);
        localVariableTable.removeFramesFromIndex(localCounter.getFrameIndex());
        assert (Arrays.equals(localsFrame, localVariableTable.frame())) : "local variables differ!";
        assert (Arrays.equals(stackFrame, operandStack.frame())) : "stack operands differ!";
        methodVisitor.visitFrame(0, localsFrame.length, localsFrame, stackFrame.length, stackFrame);
        methodVisitor.visitVarInsn(25, javaListIndex);
        operandStack.push(ConfigurationSerializableTransformations.ARRAYLIST_TYPE);
        methodVisitor.visitLabel(endLabel);
        localVariableTable.removeFramesFromIndex(iteratorFrameIndex);
        localCounter.reset(iteratorIndex, iteratorFrameIndex);
    }

    static void deserializeCollection(ScalaPluginClassLoader classLoader, MethodVisitor methodVisitor, TypeSignature typeSignature, LocalCounter localCounter, LocalVariableTable localVariableTable, OperandStack operandStack) {
        switch (typeSignature.getTypeName()) {
            case "scala/collection/immutable/WrappedString": {
                methodVisitor.visitTypeInsn(192, STRING);
                operandStack.replaceTop(ConfigurationSerializableTransformations.STRING_TYPE);
                methodVisitor.visitTypeInsn(187, WRAPPED_STRING);
                operandStack.push(WRAPPED_STRING_TYPE);
                methodVisitor.visitInsn(90);
                operandStack.pop(2);
                operandStack.push(WRAPPED_STRING_TYPE, ConfigurationSerializableTransformations.STRING_TYPE, WRAPPED_STRING_TYPE);
                methodVisitor.visitInsn(95);
                operandStack.pop(2);
                operandStack.push(WRAPPED_STRING_TYPE, ConfigurationSerializableTransformations.STRING_TYPE);
                methodVisitor.visitMethodInsn(183, WRAPPED_STRING, "<init>", "(" + STRING_DESCRIPTOR + ")V", false);
                operandStack.pop(2);
                return;
            }
            case "scala/collection/immutable/Range": {
                Label rangeStartLabel = new Label();
                Label rangeEndLabel = new Label();
                methodVisitor.visitTypeInsn(192, SCALALOADER_NUMERICRANGE_OFINTEGER);
                operandStack.replaceTop(SCALALOADER_NUMERICRANGE_OFINTEGER_TYPE);
                int rangeIndex = localCounter.getSlotIndex();
                int rangeFrameIndex = localCounter.getFrameIndex();
                LocalVariable range = new LocalVariable("range", SCALALOADER_NUMERICRANGE_OFINTEGER_DESCRIPTOR, null, rangeStartLabel, rangeEndLabel, rangeIndex, rangeFrameIndex);
                methodVisitor.visitVarInsn(58, rangeIndex);
                operandStack.pop();
                localVariableTable.add(range);
                localCounter.add(SCALALOADER_NUMERICRANGE_OFINTEGER_TYPE);
                methodVisitor.visitLabel(rangeStartLabel);
                methodVisitor.visitFieldInsn(178, RANGE_COMPANION, MODULE$, RANGE_COMPANION_DESCRIPTOR);
                operandStack.push(RANGE_COMPANION_TYPE);
                methodVisitor.visitVarInsn(25, rangeIndex);
                operandStack.push(SCALALOADER_NUMERICRANGE_OFINTEGER_TYPE);
                methodVisitor.visitMethodInsn(182, SCALALOADER_NUMERICRANGE_OFINTEGER, "start", "()I", false);
                operandStack.replaceTop(Type.INT_TYPE);
                methodVisitor.visitVarInsn(25, rangeIndex);
                operandStack.push(SCALALOADER_NUMERICRANGE_OFINTEGER_TYPE);
                methodVisitor.visitMethodInsn(182, SCALALOADER_NUMERICRANGE_OFINTEGER, "end", "()I", false);
                operandStack.replaceTop(Type.INT_TYPE);
                methodVisitor.visitVarInsn(25, rangeIndex);
                operandStack.push(SCALALOADER_NUMERICRANGE_OFINTEGER_TYPE);
                methodVisitor.visitMethodInsn(182, SCALALOADER_NUMERICRANGE_OFINTEGER, "step", "()I", false);
                operandStack.replaceTop(Type.INT_TYPE);
                methodVisitor.visitVarInsn(25, rangeIndex);
                operandStack.push(SCALALOADER_NUMERICRANGE_OFINTEGER_TYPE);
                methodVisitor.visitMethodInsn(182, SCALALOADER_NUMERICRANGE_OFINTEGER, "isInclusive", "()Z", false);
                operandStack.replaceTop(Type.BOOLEAN_TYPE);
                Label exclusiveLabel = new Label();
                Label joinLabel = new Label();
                methodVisitor.visitJumpInsn(153, exclusiveLabel);
                operandStack.pop();
                Object[] localFrame = localVariableTable.frame();
                Object[] stackFrame = operandStack.frame();
                methodVisitor.visitMethodInsn(182, RANGE_COMPANION, "inclusive", "(III)Lscala/collection/immutable/Range$Inclusive;", false);
                methodVisitor.visitJumpInsn(167, joinLabel);
                methodVisitor.visitLabel(exclusiveLabel);
                methodVisitor.visitFrame(0, localFrame.length, localFrame, stackFrame.length, stackFrame);
                methodVisitor.visitMethodInsn(182, RANGE_COMPANION, "apply", "(III)Lscala/collection/immutable/Range$Exclusive;", false);
                operandStack.replaceTop(4, RANGE_TYPE);
                methodVisitor.visitLabel(joinLabel);
                stackFrame = operandStack.frame();
                methodVisitor.visitFrame(0, localFrame.length, localFrame, stackFrame.length, stackFrame);
                localVariableTable.removeFramesFromIndex(rangeFrameIndex);
                localCounter.reset(rangeIndex, rangeFrameIndex);
                methodVisitor.visitLabel(rangeEndLabel);
                return;
            }
            case "scala/collection/immutable/NumericRange": {
                methodVisitor.visitTypeInsn(192, SCALALOADER_NUMERICRANGE);
                operandStack.replaceTop(SCALALOADER_NUMERICRANGE_TYPE);
                Label numericRangeStartLabel = new Label();
                Label numericRangeEndLabel = new Label();
                int numericRangeIndex = localCounter.getSlotIndex();
                int numericRangeFrameIndex = localCounter.getFrameIndex();
                LocalVariable numericRange = new LocalVariable("numericRange", SCALALOADER_NUMERICRANGE_DESCRIPTOR, null, numericRangeStartLabel, numericRangeEndLabel, numericRangeIndex, numericRangeFrameIndex);
                methodVisitor.visitVarInsn(58, numericRangeIndex);
                operandStack.pop();
                localVariableTable.add(numericRange);
                localCounter.add(SCALALOADER_NUMERICRANGE_TYPE);
                methodVisitor.visitLabel(numericRangeStartLabel);
                Label byteLabel = new Label();
                Label shortLabel = new Label();
                Label integerLabel = new Label();
                Label longLabel = new Label();
                Label bigIntegerLabel = new Label();
                Object[] nrBaseLocalFrame = localVariableTable.frame();
                Object[] nrBaseStackFrame = operandStack.frame();
                methodVisitor.visitFieldInsn(178, NUMERIC_RANGE_COMPANION, MODULE$, NUMERIC_RANGE_COMPANION_DESCRIPTOR);
                operandStack.push(NUMERIC_RANGE_COMPANION_TYPE);
                Object[] localFrame = localVariableTable.frame();
                Object[] stackFrame = operandStack.frame();
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(SCALALOADER_NUMERICRANGE_TYPE);
                methodVisitor.visitTypeInsn(193, SCALALOADER_NUMERICRANGE_OFBYTE);
                operandStack.replaceTop(Type.BOOLEAN_TYPE);
                methodVisitor.visitJumpInsn(154, byteLabel);
                operandStack.pop();
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(SCALALOADER_NUMERICRANGE_TYPE);
                methodVisitor.visitTypeInsn(193, SCALALOADER_NUMERICRANGE_OFSHORT);
                operandStack.replaceTop(Type.BOOLEAN_TYPE);
                methodVisitor.visitJumpInsn(154, shortLabel);
                operandStack.pop();
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(SCALALOADER_NUMERICRANGE_TYPE);
                methodVisitor.visitTypeInsn(193, SCALALOADER_NUMERICRANGE_OFINTEGER);
                operandStack.replaceTop(Type.BOOLEAN_TYPE);
                methodVisitor.visitJumpInsn(154, integerLabel);
                operandStack.pop();
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(SCALALOADER_NUMERICRANGE_TYPE);
                methodVisitor.visitTypeInsn(193, SCALALOADER_NUMERICRANGE_OFLONG);
                operandStack.replaceTop(Type.BOOLEAN_TYPE);
                methodVisitor.visitJumpInsn(154, longLabel);
                operandStack.pop();
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(SCALALOADER_NUMERICRANGE_TYPE);
                methodVisitor.visitTypeInsn(193, SCALALOADER_NUMERICRANGE_OFLONG);
                operandStack.replaceTop(Type.BOOLEAN_TYPE);
                methodVisitor.visitJumpInsn(154, bigIntegerLabel);
                operandStack.pop();
                assert (Arrays.equals(localFrame, localVariableTable.frame()));
                assert (Arrays.equals(stackFrame, operandStack.frame()));
                String inclusiveMethodDescriptor = "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lscala/math/Integral;)Lscala/collection/immutable/NumericRange$Inclusive;";
                String exclusiveMethodDescriptor = "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lscala/math/Integral;)Lscala/collection/immutable/NumericRange$Exclusive;";
                Label numericRangeJoinLabel = new Label();
                methodVisitor.visitLabel(byteLabel);
                methodVisitor.visitFrame(0, localFrame.length, localFrame, stackFrame.length, stackFrame);
                Label byteExclusiveLabel = new Label();
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(SCALALOADER_NUMERICRANGE_TYPE);
                methodVisitor.visitMethodInsn(182, SCALALOADER_NUMERICRANGE, "getStart", "()Ljava/lang/Object;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(SCALALOADER_NUMERICRANGE_TYPE);
                methodVisitor.visitMethodInsn(182, SCALALOADER_NUMERICRANGE, "getEnd", "()Ljava/lang/Object;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(SCALALOADER_NUMERICRANGE_TYPE);
                methodVisitor.visitMethodInsn(182, SCALALOADER_NUMERICRANGE, "getStep", "()Ljava/lang/Object;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(SCALALOADER_NUMERICRANGE_TYPE);
                methodVisitor.visitFieldInsn(178, "scala/math/Numeric$ByteIsIntegral$", MODULE$, "Lscala/math/Numeric$ByteIsIntegral$;");
                operandStack.push(Type.getObjectType("scala/math/Numeric$ByteIsIntegral$"));
                methodVisitor.visitMethodInsn(182, SCALALOADER_NUMERICRANGE, "isInclusive", "()Z", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.BOOLEAN_TYPE);
                methodVisitor.visitJumpInsn(153, byteExclusiveLabel);
                operandStack.pop();
                Object[] byteLocalFrame = localVariableTable.frame();
                Object[] byteStackFrame = operandStack.frame();
                Label joinByteLabel = new Label();
                methodVisitor.visitMethodInsn(182, NUMERIC_RANGE_COMPANION, "inclusive", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lscala/math/Integral;)Lscala/collection/immutable/NumericRange$Inclusive;", false);
                operandStack.replaceTop(5, NUMERIC_RANGE_INCLUSIVE_TYPE);
                methodVisitor.visitJumpInsn(167, joinByteLabel);
                methodVisitor.visitLabel(byteExclusiveLabel);
                methodVisitor.visitFrame(0, byteLocalFrame.length, byteLocalFrame, byteStackFrame.length, byteStackFrame);
                methodVisitor.visitMethodInsn(182, NUMERIC_RANGE_COMPANION, "apply", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lscala/math/Integral;)Lscala/collection/immutable/NumericRange$Exclusive;", false);
                operandStack.replaceTop(5, NUMERIC_RANGE_EXCLUSIVE_TYPE);
                methodVisitor.visitLabel(joinByteLabel);
                stackFrame = operandStack.frame();
                methodVisitor.visitFrame(0, localFrame.length, localFrame, stackFrame.length, stackFrame);
                methodVisitor.visitTypeInsn(192, NUMERIC_RANGE);
                operandStack.replaceTop(NUMERIC_RANGE_TYPE);
                assert (Arrays.equals(ArrayOps.append(nrBaseStackFrame, NUMERIC_RANGE), operandStack.frame()));
                methodVisitor.visitJumpInsn(167, numericRangeJoinLabel);
                methodVisitor.visitLabel(shortLabel);
                methodVisitor.visitFrame(0, localFrame.length, localFrame, stackFrame.length, stackFrame);
                Label shortExclusiveLabel = new Label();
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(SCALALOADER_NUMERICRANGE_TYPE);
                methodVisitor.visitMethodInsn(182, SCALALOADER_NUMERICRANGE, "getStart", "()Ljava/lang/Object;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(SCALALOADER_NUMERICRANGE_TYPE);
                methodVisitor.visitMethodInsn(182, SCALALOADER_NUMERICRANGE, "getEnd", "()Ljava/lang/Object;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(SCALALOADER_NUMERICRANGE_TYPE);
                methodVisitor.visitMethodInsn(182, SCALALOADER_NUMERICRANGE, "getStep", "()Ljava/lang/Object;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
                methodVisitor.visitFieldInsn(178, "scala/math/Numeric$ShortIsIntegral$", MODULE$, "Lscala/math/Numeric$ShortIsIntegral$;");
                operandStack.push(Type.getObjectType("scala/math/Numeric$ShortIsIntegral$"));
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(SCALALOADER_NUMERICRANGE_TYPE);
                methodVisitor.visitMethodInsn(182, SCALALOADER_NUMERICRANGE, "isInclusive", "()Z", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.BOOLEAN_TYPE);
                methodVisitor.visitJumpInsn(153, shortExclusiveLabel);
                operandStack.pop();
                Object[] shortLocalFrame = localVariableTable.frame();
                Object[] shortStackFrame = operandStack.frame();
                Label joinShortLabel = new Label();
                methodVisitor.visitMethodInsn(182, NUMERIC_RANGE_COMPANION, "inclusive", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lscala/math/Integral;)Lscala/collection/immutable/NumericRange$Inclusive;", false);
                operandStack.replaceTop(5, NUMERIC_RANGE_INCLUSIVE_TYPE);
                methodVisitor.visitJumpInsn(167, joinShortLabel);
                methodVisitor.visitLabel(shortExclusiveLabel);
                methodVisitor.visitFrame(0, shortLocalFrame.length, shortLocalFrame, shortStackFrame.length, shortStackFrame);
                methodVisitor.visitMethodInsn(182, NUMERIC_RANGE_COMPANION, "apply", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lscala/math/Integral;)Lscala/collection/immutable/NumericRange$Exclusive;", false);
                operandStack.replaceTop(5, NUMERIC_RANGE_EXCLUSIVE_TYPE);
                methodVisitor.visitLabel(joinShortLabel);
                stackFrame = operandStack.frame();
                methodVisitor.visitFrame(0, localFrame.length, localFrame, stackFrame.length, stackFrame);
                methodVisitor.visitTypeInsn(192, NUMERIC_RANGE);
                operandStack.replaceTop(NUMERIC_RANGE_TYPE);
                assert (Arrays.equals(ArrayOps.append(nrBaseStackFrame, NUMERIC_RANGE), operandStack.frame()));
                methodVisitor.visitJumpInsn(167, numericRangeJoinLabel);
                methodVisitor.visitLabel(integerLabel);
                methodVisitor.visitFrame(0, localFrame.length, localFrame, stackFrame.length, stackFrame);
                Label integerExclusiveLabel = new Label();
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(SCALALOADER_NUMERICRANGE_TYPE);
                methodVisitor.visitMethodInsn(182, SCALALOADER_NUMERICRANGE, "getStart", "()Ljava/lang/Object;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(SCALALOADER_NUMERICRANGE_TYPE);
                methodVisitor.visitMethodInsn(182, SCALALOADER_NUMERICRANGE, "getEnd", "()Ljava/lang/Object;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(SCALALOADER_NUMERICRANGE_TYPE);
                methodVisitor.visitMethodInsn(182, SCALALOADER_NUMERICRANGE, "getStep", "()Ljava/lang/Object;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
                methodVisitor.visitFieldInsn(178, "scala/math/Numeric$IntIsIntegral$", MODULE$, "Lscala/math/Numeric$IntIsIntegral$;");
                operandStack.push(Type.getObjectType("scala/math/Numeric$IntIsIntegral$"));
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(SCALALOADER_NUMERICRANGE_TYPE);
                methodVisitor.visitMethodInsn(182, SCALALOADER_NUMERICRANGE, "isInclusive", "()Z", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.BOOLEAN_TYPE);
                methodVisitor.visitJumpInsn(153, integerExclusiveLabel);
                operandStack.pop();
                Object[] intLocalFrame = localVariableTable.frame();
                Object[] intStackFrame = operandStack.frame();
                Label joinIntegerLabel = new Label();
                methodVisitor.visitMethodInsn(182, NUMERIC_RANGE_COMPANION, "inclusive", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lscala/math/Integral;)Lscala/collection/immutable/NumericRange$Inclusive;", false);
                operandStack.replaceTop(5, NUMERIC_RANGE_INCLUSIVE_TYPE);
                methodVisitor.visitJumpInsn(167, joinIntegerLabel);
                methodVisitor.visitLabel(integerExclusiveLabel);
                methodVisitor.visitFrame(0, intLocalFrame.length, intLocalFrame, intStackFrame.length, intStackFrame);
                methodVisitor.visitMethodInsn(182, NUMERIC_RANGE_COMPANION, "apply", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lscala/math/Integral;)Lscala/collection/immutable/NumericRange$Exclusive;", false);
                operandStack.replaceTop(5, NUMERIC_RANGE_EXCLUSIVE_TYPE);
                methodVisitor.visitLabel(joinIntegerLabel);
                stackFrame = operandStack.frame();
                methodVisitor.visitFrame(0, localFrame.length, localFrame, stackFrame.length, stackFrame);
                methodVisitor.visitTypeInsn(192, NUMERIC_RANGE);
                operandStack.replaceTop(NUMERIC_RANGE_TYPE);
                assert (Arrays.equals(ArrayOps.append(nrBaseStackFrame, NUMERIC_RANGE), operandStack.frame()));
                methodVisitor.visitJumpInsn(167, numericRangeJoinLabel);
                methodVisitor.visitLabel(longLabel);
                methodVisitor.visitFrame(0, localFrame.length, localFrame, stackFrame.length, stackFrame);
                Label longExclusiveLabel = new Label();
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(SCALALOADER_NUMERICRANGE_TYPE);
                methodVisitor.visitMethodInsn(182, SCALALOADER_NUMERICRANGE, "getStart", "()Ljava/lang/Object;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(SCALALOADER_NUMERICRANGE_TYPE);
                methodVisitor.visitMethodInsn(182, SCALALOADER_NUMERICRANGE, "getEnd", "()Ljava/lang/Object;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(SCALALOADER_NUMERICRANGE_TYPE);
                methodVisitor.visitMethodInsn(182, SCALALOADER_NUMERICRANGE, "getStep", "()Ljava/lang/Object;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
                methodVisitor.visitFieldInsn(178, "scala/math/Numeric$LongIsIntegral$", MODULE$, "Lscala/math/Numeric$LongIsIntegral$;");
                operandStack.push(Type.getObjectType("scala/math/Numeric$LongIsIntegral$"));
                methodVisitor.visitMethodInsn(182, SCALALOADER_NUMERICRANGE, "isInclusive", "()Z", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.BOOLEAN_TYPE);
                methodVisitor.visitJumpInsn(153, longExclusiveLabel);
                operandStack.pop();
                Object[] longLocalFrame = localVariableTable.frame();
                Object[] longStackFrame = operandStack.frame();
                Label joinLongLabel = new Label();
                methodVisitor.visitMethodInsn(182, NUMERIC_RANGE_COMPANION, "inclusive", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lscala/math/Integral;)Lscala/collection/immutable/NumericRange$Inclusive;", false);
                operandStack.replaceTop(5, NUMERIC_RANGE_INCLUSIVE_TYPE);
                methodVisitor.visitJumpInsn(167, joinLongLabel);
                methodVisitor.visitLabel(longExclusiveLabel);
                methodVisitor.visitFrame(0, longLocalFrame.length, longLocalFrame, longStackFrame.length, longStackFrame);
                methodVisitor.visitMethodInsn(182, NUMERIC_RANGE_COMPANION, "apply", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lscala/math/Integral;)Lscala/collection/immutable/NumericRange$Exclusive;", false);
                operandStack.replaceTop(5, NUMERIC_RANGE_EXCLUSIVE_TYPE);
                methodVisitor.visitLabel(joinLongLabel);
                stackFrame = operandStack.frame();
                methodVisitor.visitFrame(0, localFrame.length, localFrame, stackFrame.length, stackFrame);
                methodVisitor.visitTypeInsn(192, NUMERIC_RANGE);
                operandStack.replaceTop(NUMERIC_RANGE_TYPE);
                assert (Arrays.equals(ArrayOps.append(nrBaseStackFrame, NUMERIC_RANGE), operandStack.frame()));
                methodVisitor.visitJumpInsn(167, numericRangeJoinLabel);
                methodVisitor.visitLabel(bigIntegerLabel);
                methodVisitor.visitFrame(0, localFrame.length, localFrame, stackFrame.length, stackFrame);
                Label bigIntegerExclusiveLabel = new Label();
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(SCALALOADER_NUMERICRANGE_TYPE);
                methodVisitor.visitMethodInsn(182, SCALALOADER_NUMERICRANGE, "getStart", "()Ljava/lang/Object;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
                methodVisitor.visitTypeInsn(192, BIGINTEGER);
                operandStack.replaceTop(ConfigurationSerializableTransformations.BIGINTEGER_TYPE);
                methodVisitor.visitFieldInsn(178, BIGINT_COMPANION, MODULE$, BIGINT_COMPANION_DESCRIPTOR);
                operandStack.push(BIGINT_COMPANION_TYPE);
                methodVisitor.visitMethodInsn(182, BIGINT_COMPANION, "apply", "(" + BIGINTEGER_DESCRIPTOR + ")" + BIGINT_DESCRIPTOR, false);
                operandStack.replaceTop(2, BIGINT_TYPE);
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(SCALALOADER_NUMERICRANGE_TYPE);
                methodVisitor.visitMethodInsn(182, SCALALOADER_NUMERICRANGE, "getEnd", "()Ljava/lang/Object;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
                methodVisitor.visitTypeInsn(192, BIGINTEGER);
                operandStack.replaceTop(ConfigurationSerializableTransformations.BIGINTEGER_TYPE);
                methodVisitor.visitFieldInsn(178, BIGINT_COMPANION, MODULE$, BIGINT_COMPANION_DESCRIPTOR);
                operandStack.push(BIGINT_COMPANION_TYPE);
                methodVisitor.visitMethodInsn(182, BIGINT_COMPANION, "apply", "(" + BIGINTEGER_DESCRIPTOR + ")" + BIGINT_DESCRIPTOR, false);
                operandStack.replaceTop(2, BIGINT_TYPE);
                methodVisitor.visitVarInsn(25, numericRangeIndex);
                operandStack.push(SCALALOADER_NUMERICRANGE_TYPE);
                methodVisitor.visitMethodInsn(182, SCALALOADER_NUMERICRANGE, "getStep", "()Ljava/lang/Object;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
                methodVisitor.visitTypeInsn(192, BIGINTEGER);
                operandStack.replaceTop(ConfigurationSerializableTransformations.BIGINTEGER_TYPE);
                methodVisitor.visitFieldInsn(178, BIGINT_COMPANION, MODULE$, BIGINT_COMPANION_DESCRIPTOR);
                operandStack.push(BIGINT_COMPANION_TYPE);
                methodVisitor.visitMethodInsn(182, BIGINT_COMPANION, "apply", "(" + BIGINTEGER_DESCRIPTOR + ")" + BIGINT_DESCRIPTOR, false);
                operandStack.replaceTop(2, BIGINT_TYPE);
                methodVisitor.visitFieldInsn(178, "scala/math/Numeric$BigIntIsIntegral$", MODULE$, "Lscala/math/Numeric$BigIntIsIntegral$;");
                operandStack.push(Type.getObjectType("scala/math/Numeric$BigIntIsIntegral$"));
                methodVisitor.visitMethodInsn(182, SCALALOADER_NUMERICRANGE, "isInclusive", "()Z", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.BOOLEAN_TYPE);
                methodVisitor.visitJumpInsn(153, bigIntegerExclusiveLabel);
                operandStack.pop();
                Object[] bigIntLocalFrame = localVariableTable.frame();
                Object[] bigIntStackFrame = operandStack.frame();
                Label joinBigIntLabel = new Label();
                methodVisitor.visitMethodInsn(182, NUMERIC_RANGE_COMPANION, "inclusive", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lscala/math/Integral;)Lscala/collection/immutable/NumericRange$Inclusive;", false);
                operandStack.replaceTop(5, NUMERIC_RANGE_INCLUSIVE_TYPE);
                methodVisitor.visitJumpInsn(167, joinBigIntLabel);
                methodVisitor.visitLabel(bigIntegerExclusiveLabel);
                methodVisitor.visitFrame(0, bigIntLocalFrame.length, bigIntLocalFrame, bigIntStackFrame.length, bigIntStackFrame);
                methodVisitor.visitMethodInsn(182, NUMERIC_RANGE_COMPANION, "apply", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lscala/math/Integral;)Lscala/collection/immutable/NumericRange$Exclusive;", false);
                operandStack.replaceTop(5, NUMERIC_RANGE_EXCLUSIVE_TYPE);
                methodVisitor.visitLabel(joinBigIntLabel);
                stackFrame = operandStack.frame();
                methodVisitor.visitFrame(0, localFrame.length, localFrame, stackFrame.length, stackFrame);
                methodVisitor.visitTypeInsn(192, NUMERIC_RANGE);
                operandStack.replaceTop(NUMERIC_RANGE_TYPE);
                assert (Arrays.equals(ArrayOps.append(nrBaseStackFrame, NUMERIC_RANGE), operandStack.frame()));
                methodVisitor.visitJumpInsn(167, numericRangeJoinLabel);
                methodVisitor.visitLabel(numericRangeJoinLabel);
                assert (Arrays.equals(nrBaseLocalFrame, localVariableTable.frame()));
                assert (Arrays.equals(ArrayOps.append(nrBaseStackFrame, NUMERIC_RANGE), operandStack.frame()));
                stackFrame = operandStack.frame();
                methodVisitor.visitFrame(0, nrBaseLocalFrame.length, nrBaseLocalFrame, stackFrame.length, stackFrame);
                localVariableTable.removeFramesFromIndex(numericRangeFrameIndex);
                localCounter.reset(numericRangeIndex, numericRangeFrameIndex);
                methodVisitor.visitLabel(numericRangeEndLabel);
                return;
            }
        }
        TypeSignature elementTypeSignature = typeSignature.hasTypeArguments() ? typeSignature.getTypeArgument(0) : TypeSignature.OBJECT_TYPE_SIGNATURE;
        String liveTypeName = typeSignature.internalName();
        Label startLabel = new Label();
        Label endLabel = new Label();
        int iteratorIndex = localCounter.getSlotIndex();
        int iteratorFrameIndex = localCounter.getFrameIndex();
        LocalVariable iterator = new LocalVariable("iterator", "Ljava/util/Iterator;", null, startLabel, endLabel, iteratorIndex, iteratorFrameIndex);
        localVariableTable.add(iterator);
        localCounter.add(Type.getType(Iterator.class));
        methodVisitor.visitTypeInsn(192, "java/util/List");
        operandStack.replaceTop(Type.getType(List.class));
        methodVisitor.visitMethodInsn(185, "java/util/List", "iterator", "()Ljava/util/Iterator;", true);
        operandStack.replaceTop(Type.getType(Iterator.class));
        methodVisitor.visitVarInsn(58, iteratorIndex);
        operandStack.pop();
        methodVisitor.visitLabel(startLabel);
        Label builderLabel = new Label();
        int builderIndex = localCounter.getSlotIndex();
        int builderFrameIndex = localCounter.getFrameIndex();
        LocalVariable builder = new LocalVariable("builder", BUILDER_TYPE.getDescriptor(), null, builderLabel, endLabel, builderIndex, builderFrameIndex);
        localVariableTable.add(builder);
        localCounter.add(BUILDER_TYPE);
        ScalaConversions.generateNewBuilderCall(classLoader, methodVisitor, typeSignature, localCounter, localVariableTable, operandStack);
        methodVisitor.visitVarInsn(58, builderIndex);
        operandStack.pop();
        methodVisitor.visitLabel(builderLabel);
        Label jumpBackTarget = builderLabel;
        Label endOfLoopLabel = new Label();
        Object[] localsFrame = localVariableTable.frame();
        Object[] stackFrame = operandStack.frame();
        methodVisitor.visitFrame(0, localsFrame.length, localsFrame, stackFrame.length, stackFrame);
        methodVisitor.visitVarInsn(25, iteratorIndex);
        operandStack.push(Type.getObjectType("java/util/Iterator"));
        methodVisitor.visitMethodInsn(185, "java/util/Iterator", "hasNext", "()Z", true);
        operandStack.replaceTop(ConfigurationSerializableTransformations.BOOLEAN_TYPE);
        methodVisitor.visitJumpInsn(153, endOfLoopLabel);
        operandStack.pop();
        methodVisitor.visitVarInsn(25, builderIndex);
        operandStack.push(BUILDER_TYPE);
        methodVisitor.visitVarInsn(25, iteratorIndex);
        operandStack.push(Type.getObjectType("java/util/Iterator"));
        methodVisitor.visitMethodInsn(185, "java/util/Iterator", "next", "()Ljava/lang/Object;", true);
        operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
        Conversions.toLiveType(classLoader, methodVisitor, elementTypeSignature.toDescriptor(), elementTypeSignature.toSignature(), localCounter, localVariableTable, operandStack);
        methodVisitor.visitMethodInsn(185, GROWABLE, "addOne", "(Ljava/lang/Object;)" + GROWABLE_TYPE.getDescriptor(), true);
        operandStack.replaceTop(2, GROWABLE_TYPE);
        methodVisitor.visitInsn(87);
        operandStack.pop();
        methodVisitor.visitJumpInsn(167, jumpBackTarget);
        localVariableTable.removeFramesFromIndex(localCounter.getFrameIndex());
        assert (Arrays.equals(localsFrame, localVariableTable.frame())) : "local variables differ!";
        assert (Arrays.equals(stackFrame, operandStack.frame())) : "stack operands differ!";
        methodVisitor.visitLabel(endOfLoopLabel);
        methodVisitor.visitFrame(0, localsFrame.length, localsFrame, stackFrame.length, stackFrame);
        methodVisitor.visitVarInsn(25, builderIndex);
        operandStack.push(BUILDER_TYPE);
        methodVisitor.visitMethodInsn(185, BUILDER, "result", "()Ljava/lang/Object;", true);
        operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
        methodVisitor.visitTypeInsn(192, liveTypeName);
        operandStack.replaceTop(Type.getObjectType(liveTypeName));
        methodVisitor.visitLabel(endLabel);
        localVariableTable.removeFramesFromIndex(iteratorFrameIndex);
        localCounter.reset(iteratorIndex, iteratorFrameIndex);
    }

    private static void generateNewBuilderCall(ScalaPluginClassLoader classLoader, MethodVisitor methodVisitor, TypeSignature typeSignature, LocalCounter localCounter, LocalVariableTable localVariableTable, OperandStack operandStack) {
        String companion = typeSignature.getTypeName() + '$';
        methodVisitor.visitFieldInsn(178, companion, MODULE$, "L" + companion + ";");
        operandStack.push(Type.getObjectType(companion));
        switch (typeSignature.getTypeName()) {
            case "scala/collection/immutable/SortedMap": 
            case "scala/collection/immutable/SortedSet": 
            case "scala/collection/immutable/TreeMap": 
            case "scala/collection/immutable/TreeSet": 
            case "scala/collection/mutable/CollisionProofHashMap": 
            case "scala/collection/mutable/PriorityQueue": 
            case "scala/collection/mutable/SortedMap": 
            case "scala/collection/mutable/SortedSet": 
            case "scala/collection/mutable/TreeMap": 
            case "scala/collection/mutable/TreeSet": 
            case "scala/collection/SortedMap": 
            case "scala/collection/SortedSet": {
                ScalaConversions.generateOrdering(classLoader, methodVisitor, typeSignature.getTypeArgument(0), localCounter, localVariableTable, operandStack);
                methodVisitor.visitMethodInsn(182, companion, "newBuilder", "(Lscala/math/Ordering;)Lscala/collection/mutable/Builder;", false);
                operandStack.replaceTop(2, BUILDER_TYPE);
                break;
            }
            case "scala/collection/immutable/ArraySeq": 
            case "scala/collection/mutable/ArraySeq": {
                ScalaConversions.generateClassTag(classLoader, methodVisitor, typeSignature.getTypeArgument(0), localCounter, localVariableTable, operandStack);
                methodVisitor.visitMethodInsn(182, companion, "newBuilder", "(Lscala/reflect/ClassTag;)Lscala/collection/mutable/Builder;", false);
                operandStack.replaceTop(2, BUILDER_TYPE);
                break;
            }
            default: {
                methodVisitor.visitMethodInsn(182, companion, "newBuilder", "()Lscala/collection/mutable/Builder;", false);
                operandStack.replaceTop(1, BUILDER_TYPE);
            }
        }
    }

    private static void generateOrdering(ScalaPluginClassLoader classLoader, MethodVisitor methodVisitor, TypeSignature elementType, LocalCounter localCounter, LocalVariableTable localVariableTable, OperandStack operandStack) {
        switch (elementType.internalName()) {
            case "B": {
                methodVisitor.visitFieldInsn(178, "scala/math/Ordering$Byte$", MODULE$, "Lscala/math/Ordering$Byte$;");
                break;
            }
            case "S": {
                methodVisitor.visitFieldInsn(178, "scala/math/Ordering$Short$", MODULE$, "Lscala/math/Ordering$Short$;");
                break;
            }
            case "I": {
                methodVisitor.visitFieldInsn(178, "scala/math/Ordering$Int$", MODULE$, "Lscala/math/Ordering$Int$;");
                break;
            }
            case "J": {
                methodVisitor.visitFieldInsn(178, "scala/math/Ordering$Long$", MODULE$, "Lscala/math/Ordering$Long$;");
                break;
            }
            case "F": {
                methodVisitor.visitFieldInsn(178, "scala/math/Ordering$DeprecatedFloatOrdering$", MODULE$, "Lscala/math/Ordering$DeprecatedFloatOrdering$;");
                break;
            }
            case "D": {
                methodVisitor.visitFieldInsn(178, "scala/math/Ordering$DeprecatedDoubleOrdering$", MODULE$, "Lscala/math/Ordering$DeprecatedDoubleOrdering$;");
                break;
            }
            case "Z": {
                methodVisitor.visitFieldInsn(178, "scala/math/Ordering$Boolean$", MODULE$, "Lscala/math/Ordering$Boolean$;");
                break;
            }
            case "C": {
                methodVisitor.visitFieldInsn(178, "scala/math/Ordering$Char$", MODULE$, "Lscala/math/Ordering$Char$;");
                break;
            }
            case "scala/Unit": {
                methodVisitor.visitFieldInsn(178, "scala/math/Ordering$Unit$", MODULE$, "Lscala/math/Ordering$Unit$;");
                break;
            }
            case "scala/Null": {
                methodVisitor.visitFieldInsn(178, "scala/math/Ordering$", MODULE$, "Lscala/math/Ordering$;");
                operandStack.push(Type.getObjectType("scala/math/Ordering$"));
                methodVisitor.visitFieldInsn(178, "scala/Predef$", MODULE$, "Lscala/Predef$;");
                operandStack.push(Type.getObjectType("scala/Predef$"));
                methodVisitor.visitMethodInsn(182, "scala/Predef$", "$conforms", "()Lscala/Function1;", false);
                operandStack.replaceTop(Type.getObjectType("scala/Function1"));
                methodVisitor.visitMethodInsn(182, "scala/math/Ordering$", "ordered", "(Lscala/Function1;)Lscala/math/Ordering;", false);
                operandStack.pop();
                break;
            }
            case "java/lang/String": {
                methodVisitor.visitFieldInsn(178, "scala/math/Ordering$String$", MODULE$, "Lscala/math/Ordering$String$;");
                break;
            }
            case "scala/math/BigDecimal": {
                methodVisitor.visitFieldInsn(178, "scala/math/Ordering$BigDecimal$", MODULE$, "Lscala/math/Ordering$BigDecimal$;");
                break;
            }
            case "scala/math/BigInt": {
                methodVisitor.visitFieldInsn(178, "scala/math/Ordering$BigInt$", MODULE$, "Lscala/math/Ordering$BigInt$;");
                break;
            }
            case "scala/Option": {
                methodVisitor.visitFieldInsn(178, "scala/math/Ordering$", MODULE$, "Lscala/math/Ordering$;");
                operandStack.push(Type.getObjectType("scala/math/Ordering$"));
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(0), localCounter, localVariableTable, operandStack);
                methodVisitor.visitMethodInsn(182, "scala/math/Ordering$", "Option", "(Lscala/math/Ordering;)Lscala/math/Ordering;", false);
                operandStack.pop();
                break;
            }
            case "scala/Tuple2": {
                methodVisitor.visitFieldInsn(178, "scala/math/Ordering$", MODULE$, "Lscala/math/Ordering$;");
                operandStack.push(Type.getObjectType("scala/math/Ordering$"));
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(0), localCounter, localVariableTable, operandStack);
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(1), localCounter, localVariableTable, operandStack);
                methodVisitor.visitMethodInsn(182, "scala/math/Ordering$", "Tuple2", "(Lscala/math/Ordering;Lscala/math/Ordering;)Lscala/math/Ordering;", false);
                operandStack.pop(2);
                break;
            }
            case "scala/Tuple3": {
                methodVisitor.visitFieldInsn(178, "scala/math/Ordering$", MODULE$, "Lscala/math/Ordering$;");
                operandStack.push(Type.getObjectType("scala/math/Ordering$"));
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(0), localCounter, localVariableTable, operandStack);
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(1), localCounter, localVariableTable, operandStack);
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(2), localCounter, localVariableTable, operandStack);
                methodVisitor.visitMethodInsn(182, "scala/math/Ordering$", "Tuple3", "(Lscala/math/Ordering;Lscala/math/Ordering;Lscala/math/Ordering;)Lscala/math/Ordering;", false);
                operandStack.pop(3);
                break;
            }
            case "scala/Tuple4": {
                methodVisitor.visitFieldInsn(178, "scala/math/Ordering$", MODULE$, "Lscala/math/Ordering$;");
                operandStack.push(Type.getObjectType("scala/math/Ordering$"));
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(0), localCounter, localVariableTable, operandStack);
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(1), localCounter, localVariableTable, operandStack);
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(2), localCounter, localVariableTable, operandStack);
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(3), localCounter, localVariableTable, operandStack);
                methodVisitor.visitMethodInsn(182, "scala/math/Ordering$", "Tuple4", "(Lscala/math/Ordering;Lscala/math/Ordering;Lscala/math/Ordering;Lscala/math/Ordering;)Lscala/math/Ordering;", false);
                operandStack.pop(4);
                break;
            }
            case "scala/Tuple5": {
                methodVisitor.visitFieldInsn(178, "scala/math/Ordering$", MODULE$, "Lscala/math/Ordering$;");
                operandStack.push(Type.getObjectType("scala/math/Ordering$"));
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(0), localCounter, localVariableTable, operandStack);
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(1), localCounter, localVariableTable, operandStack);
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(2), localCounter, localVariableTable, operandStack);
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(3), localCounter, localVariableTable, operandStack);
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(4), localCounter, localVariableTable, operandStack);
                methodVisitor.visitMethodInsn(182, "scala/math/Ordering$", "Tuple5", "(Lscala/math/Ordering;Lscala/math/Ordering;Lscala/math/Ordering;Lscala/math/Ordering;Lscala/math/Ordering;)Lscala/math/Ordering;", false);
                operandStack.pop(5);
                break;
            }
            case "scala/Tuple6": {
                methodVisitor.visitFieldInsn(178, "scala/math/Ordering$", MODULE$, "Lscala/math/Ordering$;");
                operandStack.push(Type.getObjectType("scala/math/Ordering$"));
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(0), localCounter, localVariableTable, operandStack);
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(1), localCounter, localVariableTable, operandStack);
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(2), localCounter, localVariableTable, operandStack);
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(3), localCounter, localVariableTable, operandStack);
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(4), localCounter, localVariableTable, operandStack);
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(5), localCounter, localVariableTable, operandStack);
                methodVisitor.visitMethodInsn(182, "scala/math/Ordering$", "Tuple6", "(Lscala/math/Ordering;Lscala/math/Ordering;Lscala/math/Ordering;Lscala/math/Ordering;Lscala/math/Ordering;Lscala/math/Ordering;)Lscala/math/Ordering;", false);
                operandStack.pop(6);
                break;
            }
            case "scala/Tuple7": {
                methodVisitor.visitFieldInsn(178, "scala/math/Ordering$", MODULE$, "Lscala/math/Ordering$;");
                operandStack.push(Type.getObjectType("scala/math/Ordering$"));
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(0), localCounter, localVariableTable, operandStack);
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(1), localCounter, localVariableTable, operandStack);
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(2), localCounter, localVariableTable, operandStack);
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(3), localCounter, localVariableTable, operandStack);
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(4), localCounter, localVariableTable, operandStack);
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(5), localCounter, localVariableTable, operandStack);
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(6), localCounter, localVariableTable, operandStack);
                methodVisitor.visitMethodInsn(182, "scala/math/Ordering$", "Tuple7", "(Lscala/math/Ordering;Lscala/math/Ordering;Lscala/math/Ordering;Lscala/math/Ordering;Lscala/math/Ordering;Lscala/math/Ordering;Lscala/math/Ordering;)Lscala/math/Ordering;", false);
                operandStack.pop(7);
                break;
            }
            case "scala/Tuple8": {
                methodVisitor.visitFieldInsn(178, "scala/math/Ordering$", MODULE$, "Lscala/math/Ordering$;");
                operandStack.push(Type.getObjectType("scala/math/Ordering$"));
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(0), localCounter, localVariableTable, operandStack);
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(1), localCounter, localVariableTable, operandStack);
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(2), localCounter, localVariableTable, operandStack);
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(3), localCounter, localVariableTable, operandStack);
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(4), localCounter, localVariableTable, operandStack);
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(5), localCounter, localVariableTable, operandStack);
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(6), localCounter, localVariableTable, operandStack);
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(7), localCounter, localVariableTable, operandStack);
                methodVisitor.visitMethodInsn(182, "scala/math/Ordering$", "Tuple8", "(Lscala/math/Ordering;Lscala/math/Ordering;Lscala/math/Ordering;Lscala/math/Ordering;Lscala/math/Ordering;Lscala/math/Ordering;Lscala/math/Ordering;Lscala/math/Ordering;)Lscala/math/Ordering;", false);
                operandStack.pop(8);
                break;
            }
            case "scala/Tuple9": {
                methodVisitor.visitFieldInsn(178, "scala/math/Ordering$", MODULE$, "Lscala/math/Ordering$;");
                operandStack.push(Type.getObjectType("scala/math/Ordering$"));
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(0), localCounter, localVariableTable, operandStack);
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(1), localCounter, localVariableTable, operandStack);
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(2), localCounter, localVariableTable, operandStack);
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(3), localCounter, localVariableTable, operandStack);
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(4), localCounter, localVariableTable, operandStack);
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(5), localCounter, localVariableTable, operandStack);
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(6), localCounter, localVariableTable, operandStack);
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(7), localCounter, localVariableTable, operandStack);
                ScalaConversions.generateOrdering(classLoader, methodVisitor, elementType.getTypeArgument(8), localCounter, localVariableTable, operandStack);
                methodVisitor.visitMethodInsn(182, "scala/math/Ordering$", "Tuple9", "(Lscala/math/Ordering;Lscala/math/Ordering;Lscala/math/Ordering;Lscala/math/Ordering;Lscala/math/Ordering;Lscala/math/Ordering;Lscala/math/Ordering;Lscala/math/Ordering;Lscala/math/Ordering;)Lscala/math/Ordering;", false);
                operandStack.pop(9);
                break;
            }
        }
        operandStack.push(ORDERING_TYPE);
    }

    private static final void generateClassTag(ScalaPluginClassLoader classLoader, MethodVisitor methodVisitor, TypeSignature elementType, LocalCounter localCounter, LocalVariableTable localVariableTable, OperandStack operandStack) {
        String internalName;
        methodVisitor.visitFieldInsn(178, CLASSTAG_COMPANION, MODULE$, CLASSTAG_COMPANION_DESCRIPTOR);
        operandStack.push(CLASSTAG_COMPANION_TYPE);
        switch (internalName = elementType.internalName()) {
            case "B": {
                methodVisitor.visitMethodInsn(182, CLASSTAG_COMPANION, "Byte", "()Lscala/reflect/ManifestFactory$ByteManifest;", false);
                operandStack.replaceTop(CLASSTAG_TYPE);
                break;
            }
            case "S": {
                methodVisitor.visitMethodInsn(182, CLASSTAG_COMPANION, "Short", "()Lscala/reflect/ManifestFactory$ShortManifest;", false);
                operandStack.replaceTop(CLASSTAG_TYPE);
                break;
            }
            case "I": {
                methodVisitor.visitMethodInsn(182, CLASSTAG_COMPANION, "Int", "()Lscala/reflect/ManifestFactory$IntManifest;", false);
                operandStack.replaceTop(CLASSTAG_TYPE);
                break;
            }
            case "J": {
                methodVisitor.visitMethodInsn(182, CLASSTAG_COMPANION, "Long", "()Lscala/reflect/ManifestFactory$LongManifest;", false);
                operandStack.replaceTop(CLASSTAG_TYPE);
                break;
            }
            case "F": {
                methodVisitor.visitMethodInsn(182, CLASSTAG_COMPANION, "Float", "()Lscala/reflect/ManifestFactory$FloatManifest;", false);
                operandStack.replaceTop(CLASSTAG_TYPE);
                break;
            }
            case "D": {
                methodVisitor.visitMethodInsn(182, CLASSTAG_COMPANION, "Double", "()Lscala/reflect/ManifestFactory$DoubleManifest;", false);
                operandStack.replaceTop(CLASSTAG_TYPE);
                break;
            }
            case "C": {
                methodVisitor.visitMethodInsn(182, CLASSTAG_COMPANION, "Char", "()Lscala/reflect/ManifestFactory$CharManifest;", false);
                operandStack.replaceTop(CLASSTAG_TYPE);
                break;
            }
            case "Z": {
                methodVisitor.visitMethodInsn(182, CLASSTAG_COMPANION, "Boolean", "()Lscala/reflect/ManifestFactory$BooleanManifest;", false);
                operandStack.replaceTop(CLASSTAG_TYPE);
                break;
            }
            case "scala/Unit": {
                methodVisitor.visitMethodInsn(182, CLASSTAG_COMPANION, "Unit", "()Lscala/reflect/ManifestFactory$UnitManifest;", false);
                operandStack.replaceTop(CLASSTAG_TYPE);
                break;
            }
            case "scala/Nothing": {
                methodVisitor.visitMethodInsn(182, CLASSTAG_COMPANION, "Nothing", "()Lscala/reflect/ClassTag;", false);
                operandStack.replaceTop(CLASSTAG_TYPE);
                break;
            }
            case "scala/Null": {
                methodVisitor.visitMethodInsn(182, CLASSTAG_COMPANION, "Null", "()Lscala/reflect/ClassTag;", false);
                operandStack.replaceTop(CLASSTAG_TYPE);
                break;
            }
            case "scala/Any": {
                methodVisitor.visitMethodInsn(182, CLASSTAG_COMPANION, "Any", "()Lscala/reflect/ClassTag;", false);
                operandStack.replaceTop(CLASSTAG_TYPE);
                break;
            }
            case "scala/AnyRef": {
                methodVisitor.visitMethodInsn(182, CLASSTAG_COMPANION, "AnyRef", "()Lscala/reflect/ClassTag;", false);
                operandStack.replaceTop(CLASSTAG_TYPE);
                break;
            }
            case "scala/AnyVal": {
                methodVisitor.visitMethodInsn(182, CLASSTAG_COMPANION, "AnyVal", "()Lscala/reflect/ClassTag;", false);
                operandStack.replaceTop(CLASSTAG_TYPE);
                break;
            }
            case "java/lang/Object": {
                methodVisitor.visitMethodInsn(182, CLASSTAG_COMPANION, "Object", "()Lscala/reflect/ClassTag;", false);
                operandStack.replaceTop(CLASSTAG_TYPE);
                break;
            }
            default: {
                methodVisitor.visitLdcInsn(Type.getObjectType(internalName));
                operandStack.push(Type.getType(Class.class));
                methodVisitor.visitMethodInsn(182, CLASSTAG_COMPANION, "apply", "(Ljava/lang/Class;)Lscala/reflect/ClassTag;", false);
                operandStack.replaceTop(2, CLASSTAG_TYPE);
            }
        }
    }
}

