/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.configurationserializable.transform;

import xyz.janboerman.scalaloader.bytecode.TransformerRegistry;
import xyz.janboerman.scalaloader.configurationserializable.InjectionPoint;
import xyz.janboerman.scalaloader.configurationserializable.transform.GlobalScanResult;
import xyz.janboerman.scalaloader.libs.asm.ClassVisitor;
import xyz.janboerman.scalaloader.libs.asm.MethodVisitor;

public class PluginTransformer
extends ClassVisitor {
    private final InjectionPoint injectionPoint;
    private final String configurationSerializableClassName;
    private final boolean serializableClassIsInterface;
    private boolean hasOnEnable;
    private boolean hasOnLoad;
    private boolean hasConstructor;
    private boolean hasClassInitializer;

    PluginTransformer(ClassVisitor delegate, InjectionPoint injectionPoint, String configSerType, boolean configSerIsInterface) {
        super(589824, delegate);
        this.injectionPoint = injectionPoint;
        this.configurationSerializableClassName = configSerType;
        this.serializableClassIsInterface = configSerIsInterface;
    }

    public static void addTo(TransformerRegistry transformerRegistry, GlobalScanResult scanResult) {
        if (scanResult.annotatedByConfigurationSerializable || scanResult.annotatedByDelegateSerialization) {
            switch (scanResult.registerAt) {
                case PLUGIN_CLASS_INTIALIZER: 
                case PLUGIN_CONSTRUCTOR: 
                case PLUGIN_ONLOAD: 
                case PLUGIN_ONENABLE: {
                    transformerRegistry.addMainClassTransformer((delegate, mainClassName) -> new PluginTransformer((ClassVisitor)delegate, scanResult.registerAt, scanResult.className, scanResult.isInterface));
                }
            }
        }
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        MethodVisitor superVisitor = super.visitMethod(access, name, descriptor, signature, exceptions);
        if ("onEnable".equals(name) && "()V".equals(descriptor)) {
            this.hasOnEnable = true;
            if (this.injectionPoint == InjectionPoint.PLUGIN_ONENABLE) {
                return new MethodVisitor(589824, superVisitor){

                    @Override
                    public void visitCode() {
                        this.visitMethodInsn(184, PluginTransformer.this.configurationSerializableClassName, "$registerWithConfigurationSerialization", "()V", PluginTransformer.this.serializableClassIsInterface);
                        super.visitCode();
                    }
                };
            }
        } else if ("onLoad".equals(name) && "()V".equals(descriptor)) {
            this.hasOnLoad = true;
            if (this.injectionPoint == InjectionPoint.PLUGIN_ONLOAD) {
                return new MethodVisitor(589824, superVisitor){

                    @Override
                    public void visitCode() {
                        this.visitMethodInsn(184, PluginTransformer.this.configurationSerializableClassName, "$registerWithConfigurationSerialization", "()V", PluginTransformer.this.serializableClassIsInterface);
                        super.visitCode();
                    }
                };
            }
        } else if ("<init>".equals(name)) {
            this.hasConstructor = true;
            if (this.injectionPoint == InjectionPoint.PLUGIN_CONSTRUCTOR) {
                return new MethodVisitor(589824, superVisitor){

                    @Override
                    public void visitCode() {
                        this.visitMethodInsn(184, PluginTransformer.this.configurationSerializableClassName, "$registerWithConfigurationSerialization", "()V", PluginTransformer.this.serializableClassIsInterface);
                        super.visitCode();
                    }
                };
            }
        } else if ("<clinit>".equals(name)) {
            this.hasClassInitializer = true;
            if (this.injectionPoint == InjectionPoint.PLUGIN_CLASS_INTIALIZER) {
                return new MethodVisitor(589824, superVisitor){

                    @Override
                    public void visitCode() {
                        this.visitMethodInsn(184, PluginTransformer.this.configurationSerializableClassName, "$registerWithConfigurationSerialization", "()V", PluginTransformer.this.serializableClassIsInterface);
                        super.visitCode();
                    }
                };
            }
        }
        return superVisitor;
    }

    @Override
    public void visitEnd() {
        MethodVisitor methodVisitor = null;
        if (this.injectionPoint == InjectionPoint.PLUGIN_ONENABLE && !this.hasOnEnable) {
            methodVisitor = super.visitMethod(1, "onEnable", "()V", null, null);
        } else if (this.injectionPoint == InjectionPoint.PLUGIN_ONLOAD && !this.hasOnLoad) {
            methodVisitor = super.visitMethod(1, "onLoad", "()V", null, null);
        } else if (this.injectionPoint == InjectionPoint.PLUGIN_CONSTRUCTOR && !this.hasConstructor) {
            methodVisitor = super.visitMethod(1, "<init>", "()V", null, null);
        } else if (this.injectionPoint == InjectionPoint.PLUGIN_CLASS_INTIALIZER && !this.hasClassInitializer) {
            methodVisitor = super.visitMethod(9, "<clinit>", "()V", null, null);
        }
        if (methodVisitor != null) {
            methodVisitor.visitCode();
            methodVisitor.visitMethodInsn(184, this.configurationSerializableClassName, "$registerWithConfigurationSerialization", "()V", this.serializableClassIsInterface);
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }
        super.visitEnd();
    }
}

