/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.configurationserializable.transform;

import xyz.janboerman.scalaloader.configurationserializable.DeserializationMethod;
import xyz.janboerman.scalaloader.configurationserializable.Scan;
import xyz.janboerman.scalaloader.configurationserializable.transform.ConfigurationSerializableError;
import xyz.janboerman.scalaloader.configurationserializable.transform.ConfigurationSerializableTransformations;
import xyz.janboerman.scalaloader.configurationserializable.transform.LocalScanResult;
import xyz.janboerman.scalaloader.configurationserializable.transform.UnapplyParamCounter;
import xyz.janboerman.scalaloader.libs.asm.AnnotationVisitor;
import xyz.janboerman.scalaloader.libs.asm.ClassReader;
import xyz.janboerman.scalaloader.libs.asm.ClassVisitor;
import xyz.janboerman.scalaloader.libs.asm.FieldVisitor;
import xyz.janboerman.scalaloader.libs.asm.MethodVisitor;
import xyz.janboerman.scalaloader.libs.asm.Type;
import xyz.janboerman.scalaloader.libs.asm.signature.SignatureReader;

class LocalScanner
extends ClassVisitor {
    private final LocalScanResult result = new LocalScanResult();
    private String className;
    private String classDescriptor;
    private boolean classIsInterface;
    private boolean hasModule$;
    private Scan.Type scanType;
    private boolean isEnum;
    private boolean isRecord;
    private boolean fieldProperties;
    private boolean methodProperties;
    private boolean hasStaticApply;
    private boolean hasStaticUnapply;
    private int applyParamCount;
    private int unapplyParamCount;

    LocalScanner() {
        super(589824);
    }

    LocalScanResult scan(ClassReader classReader) throws ConfigurationSerializableError {
        classReader.accept(this, 0);
        if (this.result.annotatedByConfigurationSerializable && this.result.annotatedByDelegateSerialization) {
            throw new ConfigurationSerializableError(this.className.replace('/', '.') + " is annotated by both @ConfigurationSerializable and @DelegateSerialization");
        }
        if (this.scanType == null || this.scanType == Scan.Type.AUTO_DETECT) {
            this.scanType = this.hasModule$ ? Scan.Type.SINGLETON_OBJECT : (this.isEnum ? Scan.Type.ENUM : (this.isRecord ? Scan.Type.RECORD : (this.fieldProperties ? Scan.Type.FIELDS : (this.methodProperties ? Scan.Type.GETTER_SETTER_METHODS : (this.hasStaticUnapply && this.hasStaticApply && this.applyParamCount == this.unapplyParamCount ? Scan.Type.CASE_CLASS : Scan.Type.FIELDS)))));
        }
        if (this.result.annotatedByConfigurationSerializable && this.classIsInterface && this.scanType != Scan.Type.CASE_CLASS && this.scanType != Scan.Type.SINGLETON_OBJECT) {
            throw new ConfigurationSerializableError("Can't use @ConfigurationSerializable on interfaces that are not singletons and non-case classes!");
        }
        this.result.scanType = this.scanType;
        return this.result;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        this.classDescriptor = 'L' + name + ';';
        this.classIsInterface = (access & 0x200) == 512;
        this.isEnum = (access & 0x4000) == 16384;
        boolean bl = this.isRecord = (access & 0x10000) == 65536;
        if (interfaces != null) {
            for (String itf : interfaces) {
                if (!ConfigurationSerializableTransformations.BUKKIT_CONFIGURATIONSERIALIZABLE_NAME.equals(itf)) continue;
                this.result.implementsConfigurationSerializable = true;
                break;
            }
        }
    }

    @Override
    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        if (ConfigurationSerializableTransformations.SCALALOADER_CONFIGURATIONSERIALIZABLE_DESCRIPTOR.equals(descriptor)) {
            this.result.annotatedByConfigurationSerializable = true;
            return new AnnotationVisitor(589824){

                @Override
                public AnnotationVisitor visitAnnotation(String name, String descriptor) {
                    if ("scan".equals(name) && ConfigurationSerializableTransformations.SCALALOADER_SCAN_DESCRIPTOR.equals(descriptor)) {
                        return new AnnotationVisitor(589824){

                            @Override
                            public void visitEnum(String name, String descriptor, String value) {
                                if ("value".equals(name) && ConfigurationSerializableTransformations.SCALALOADER_SCANTYPE_DESCRIPTOR.equals(descriptor)) {
                                    LocalScanner.this.scanType = Scan.Type.valueOf(value);
                                }
                            }
                        };
                    }
                    return null;
                }
            };
        }
        if (ConfigurationSerializableTransformations.SCALALOADER_DELEGATESERIALIZATION_DESCRIPTOR.equals(descriptor)) {
            this.result.annotatedByDelegateSerialization = true;
            return new AnnotationVisitor(589824){

                @Override
                public void visitEnum(String name, String descriptor, String value) {
                    if ("constructUsing".equals(name) && ConfigurationSerializableTransformations.SCALALOADER_DESERIALIZATIONMETHOD_DESCRIPTOR.equals(descriptor) && DeserializationMethod.MAP_CONSTRUCTOR.name().equals(value)) {
                        throw new ConfigurationSerializableError("Can't use the MAP_CONSTRUCTOR deserialization method when using @DelegateSerialization");
                    }
                }
            };
        }
        if (ConfigurationSerializableTransformations.BUKKIT_SERIALIZABLEAS_DESCRIPTOR.equals(descriptor)) {
            this.result.annotatedBySerializableAs = true;
        }
        return null;
    }

    @Override
    public FieldVisitor visitField(int access, final String name, String descriptor, String signature, Object value) {
        boolean isStatic;
        boolean bl = isStatic = (access & 8) == 8;
        if ("MODULE$".equals(name) && isStatic && this.classDescriptor.equals(descriptor)) {
            this.hasModule$ = true;
        }
        return new FieldVisitor(589824){
            boolean include;
            boolean exclude;

            @Override
            public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                if (ConfigurationSerializableTransformations.SCALALOADER_INCLUDEPROPERTY_DESCRIPTOR.equals(descriptor)) {
                    if (isStatic) {
                        throw new ConfigurationSerializableError("Can't use @" + Scan.IncludeProperty.class.getSimpleName() + " on static fields.");
                    }
                    LocalScanner.this.fieldProperties = true;
                    this.include = true;
                } else if (ConfigurationSerializableTransformations.SCALALOADER_EXCLUDEPROPERTY_DESCRIPTOR.equals(descriptor)) {
                    if (isStatic) {
                        throw new ConfigurationSerializableError("Can't use @" + Scan.ExcludeProperty.class.getSimpleName() + " on static fields.");
                    }
                    LocalScanner.this.fieldProperties = true;
                    this.exclude = true;
                }
                return null;
            }

            @Override
            public void visitEnd() {
                if (this.include && this.exclude) {
                    throw new ConfigurationSerializableError("Field " + name + " in class " + LocalScanner.this.className.replace('/', '.') + " is annotated by both " + Scan.IncludeProperty.class.getSimpleName() + " and " + Scan.ExcludeProperty.class.getSimpleName() + ". Please remove one of the two.");
                }
            }
        };
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        final boolean isStatic = (access & 8) == 8;
        String returnTypeName = Type.getReturnType(descriptor).getInternalName();
        if ("apply".equals(name) && isStatic && (access & 1) == 1 && this.className.equals(returnTypeName)) {
            this.hasStaticApply = true;
            this.applyParamCount = Type.getArgumentTypes(descriptor).length;
        }
        Type[] argumentTypes = Type.getArgumentTypes(descriptor);
        if ("unapply".equals(name) && (access & 8) == 8 && (access & 1) == 1 && argumentTypes.length == 1 && this.className.equals(argumentTypes[0].getInternalName())) {
            this.hasStaticUnapply = true;
            if (signature == null) {
                this.unapplyParamCount = 1;
            } else {
                UnapplyParamCounter counter = new UnapplyParamCounter();
                SignatureReader reader = new SignatureReader(signature);
                reader.accept(counter);
                this.unapplyParamCount = counter.getParamCount();
            }
        }
        return new MethodVisitor(589824){

            @Override
            public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                if (ConfigurationSerializableTransformations.SCALALOADER_INCLUDEPROPERTY_DESCRIPTOR.equals(descriptor)) {
                    if (isStatic) {
                        throw new ConfigurationSerializableError("Can't use @" + Scan.IncludeProperty.class.getSimpleName() + " on static methods.");
                    }
                    LocalScanner.this.methodProperties = true;
                }
                return null;
            }
        };
    }

    @Override
    public void visitEnd() {
        if (this.scanType == Scan.Type.SINGLETON_OBJECT && !this.hasModule$) {
            this.result.annotatedByConfigurationSerializable = false;
            this.result.annotatedByDelegateSerialization = false;
        } else if (this.scanType != Scan.Type.SINGLETON_OBJECT && this.hasModule$) {
            this.result.annotatedByConfigurationSerializable = false;
            this.result.annotatedByDelegateSerialization = false;
        }
    }
}

